/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Math;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Graphics2D;

public class RectangularGrid
implements Java2D_PaintableInterface {
    protected float[][] m_data;
    protected float m_dataMax = Float.MIN_VALUE;
    protected float m_dataMin = Float.MAX_VALUE;
    protected boolean m_dataRangeDirty = true;
    protected int m_numX;
    protected int m_numY;
    protected double m_originX = 0.0;
    protected double m_originY = 0.0;
    protected double m_sizeX = 1.0;
    protected double m_sizeY = 1.0;
    public boolean ImageDirty = true;

    public RectangularGrid(float[][] data) throws Exception {
        try {
            this.m_numX = data.length;
            this.m_numY = data[0].length;
            this.m_data = new float[this.m_numX][this.m_numY];
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    this.m_data[x][y] = data[x][y];
                    this.m_dataMax = Math.max(this.m_dataMax, this.m_data[x][y]);
                    this.m_dataMin = Math.min(this.m_dataMin, this.m_data[x][y]);
                }
            }
            this.m_dataRangeDirty = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void setSize(double x, double y) {
        this.m_sizeX = x;
        this.m_sizeY = y;
    }

    public void setOrigin(double x, double y) {
        this.m_originX = x;
        this.m_originY = y;
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return this.ImageDirty;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 0;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            if (this.m_data == null) {
                return;
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            int sizeX = 1 + (int)(0.5 + this.m_sizeX * scaleX);
            int sizeY = 2 + (int)Math.abs(0.5 + this.m_sizeY * scaleY);
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    double x = this.m_originX - 0.5 * this.m_sizeX + (double)ix * this.m_sizeX;
                    double y = this.m_originY + 0.5 * this.m_sizeY + (double)iy * this.m_sizeY;
                    int px = (int)(shiftX + scaleX * x);
                    int py = (int)(shiftY + scaleY * y);
                    if (!colorWrapper.valueOK(this.m_data[ix][iy])) continue;
                    g2d.setColor(colorWrapper.colorUsingValue(this.m_data[ix][iy]));
                    g2d.fillRect(px, py, sizeX, sizeY);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
        try {
            if (this.m_dataRangeDirty) {
                this.m_dataMax = Float.MIN_VALUE;
                this.m_dataMin = Float.MAX_VALUE;
                for (int x = 0; x < this.m_numX; ++x) {
                    for (int y = 0; y < this.m_numY; ++y) {
                        this.m_dataMax = Math.max(this.m_dataMax, this.m_data[x][y]);
                        this.m_dataMin = Math.min(this.m_dataMin, this.m_data[x][y]);
                    }
                }
                this.m_dataRangeDirty = false;
            }
            rangeC.expandRange(this.m_dataMax);
            rangeC.expandRange(this.m_dataMin);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            if (this.m_data == null) {
                return;
            }
            rangeX.expandRange(this.m_originX - 0.5 * this.m_sizeX);
            rangeX.expandRange(this.m_originX + 0.5 * this.m_sizeX + (double)(this.m_numX - 1) * this.m_sizeX);
            rangeY.expandRange(this.m_originY - 0.5 * this.m_sizeY);
            rangeY.expandRange(this.m_originY + 0.5 * this.m_sizeY + (double)(this.m_numY - 1) * this.m_sizeY);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

