/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Math;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Graphics2D;

public class InverseSquareGrid
implements Java2D_PaintableInterface {
    protected double[] m_inputX;
    protected double[] m_inputY;
    protected double[] m_inputZ;
    protected double m_gridMinX;
    protected double m_gridMinY;
    protected double m_gridSize;
    protected double[][] m_grid = null;
    protected Range_Double m_rangeGrid = new Range_Double();
    protected boolean ImageDirty = true;

    public void createGrid(double buffer, double gridSize) {
        try {
            this.m_grid = null;
            double minX = Double.MAX_VALUE;
            double maxX = Double.MIN_VALUE;
            double minY = Double.MAX_VALUE;
            double maxY = Double.MIN_VALUE;
            for (int n = 0; n < this.m_inputX.length; ++n) {
                minX = Math.min(minX, this.m_inputX[n] - buffer);
                maxX = Math.max(maxX, this.m_inputX[n] + buffer);
                minY = Math.min(minY, this.m_inputY[n] - buffer);
                maxY = Math.max(maxY, this.m_inputY[n] + buffer);
            }
            this.createGrid(minX, minY, maxX, maxY, gridSize);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void createGrid(double minX, double minY, double maxX, double maxY, double gridSize) {
        try {
            this.ImageDirty = true;
            this.m_rangeGrid.clearRange();
            this.m_grid = null;
            this.m_gridSize = gridSize;
            if (this.m_inputX == null) {
                return;
            }
            if (this.m_inputX.length < 2) {
                return;
            }
            int nx = 1 + (int)((maxX - minX) / gridSize);
            int ny = 1 + (int)((maxY - minY) / gridSize);
            this.m_gridMinX = minX;
            this.m_gridMinY = minY;
            this.m_grid = new double[nx][ny];
            for (int i = 0; i < nx; ++i) {
                for (int j = 0; j < ny; ++j) {
                    double x = this.m_gridMinX + (double)i * this.m_gridSize;
                    double y = this.m_gridMinY + (double)j * this.m_gridSize;
                    this.m_grid[i][j] = this.interpolate(x, y);
                    this.m_rangeGrid.expandRange(this.m_grid[i][j]);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setInputData(double[] x, double[] y, double[] z) {
        try {
            this.ImageDirty = true;
            if (x == null) {
                this.m_inputX = null;
                this.m_inputY = null;
                this.m_inputZ = null;
                return;
            }
            this.m_inputX = new double[x.length];
            this.m_inputY = new double[x.length];
            this.m_inputZ = new double[x.length];
            System.arraycopy(x, 0, this.m_inputX, 0, x.length);
            System.arraycopy(y, 0, this.m_inputY, 0, x.length);
            System.arraycopy(z, 0, this.m_inputZ, 0, x.length);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public double interpolate(double x, double y) {
        try {
            int N = this.m_inputX.length;
            double sum1 = 0.0;
            double sum2 = 1.0E-60;
            for (int i = 0; i < N; ++i) {
                double dx = x - this.m_inputX[i];
                double dy = y - this.m_inputY[i];
                double w = 1.0 / (1.0 + dx * dx + dy * dy);
                sum1 += w * this.m_inputZ[i];
                sum2 += w;
            }
            return sum1 / sum2;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0.0;
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return this.ImageDirty;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 0;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            this.ImageDirty = true;
            if (this.m_inputX == null) {
                return;
            }
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            if (this.m_grid != null) {
                int pixPerGrid = 1 + (int)(this.m_gridSize * scaleX);
                int half = pixPerGrid / 2;
                for (int i = 0; i < this.m_grid.length; ++i) {
                    for (int j = 0; j < this.m_grid[0].length; ++j) {
                        double x = this.m_gridMinX + (double)i * this.m_gridSize;
                        double y = this.m_gridMinY + (double)j * this.m_gridSize;
                        int ix = (int)(scaleX * x + shiftX);
                        int iy = (int)(scaleY * y + shiftY);
                        g2d.setColor(colorWrapper.colorUsingValue(this.m_grid[i][j]));
                        g2d.fillRect(ix - half, iy - half, pixPerGrid, pixPerGrid);
                    }
                }
            }
            g2d.setColor(Color.black);
            for (int n = 0; n < this.m_inputX.length; ++n) {
                int ix = (int)(scaleX * this.m_inputX[n] + shiftX);
                int iy = (int)(scaleY * this.m_inputY[n] + shiftY);
                g2d.drawOval(ix - 7, iy - 7, 14, 14);
            }
            this.ImageDirty = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            if (this.m_inputX == null) {
                return;
            }
            if (this.m_grid == null) {
                for (int n = 0; n < this.m_inputX.length; ++n) {
                    rangeX.expandRange(this.m_inputX[n]);
                    rangeY.expandRange(this.m_inputY[n]);
                }
            } else {
                rangeX.expandRange(this.m_gridMinX);
                rangeX.expandRange(this.m_gridMinX + (double)this.m_grid.length * this.m_gridSize);
                rangeY.expandRange(this.m_gridMinY);
                rangeY.expandRange(this.m_gridMinY + (double)this.m_grid[0].length * this.m_gridSize);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
        try {
            if (this.m_grid != null) {
                rangeC.expandRange(this.m_rangeGrid);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

