/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Math;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Math.AxisGrid;

public class InterpolationGrids {
    public AxisGrid WeightGrid;
    public AxisGrid ValueGrid;

    public InterpolationGrids(Table_Abstract table, String colNameX, String colNameY, String colNameV, Range_Double rx, Range_Double ry, double gridSize, double buffer) throws Exception {
        try {
            int nx = (int)((2.0 * buffer + rx.range()) / gridSize);
            int ny = (int)((2.0 * buffer + ry.range()) / gridSize);
            double originX = rx.rangeMin() - buffer;
            double originY = ry.rangeMin() - buffer;
            this.WeightGrid = new AxisGrid(originX, originY, gridSize, gridSize, nx, ny);
            this.ValueGrid = new AxisGrid(originX, originY, gridSize, gridSize, nx, ny);
            this.ValueGrid.setToValue(0.0f);
            this.WeightGrid.setToValue(0.0f);
            float[][] gridW = this.WeightGrid.grid();
            float[][] gridV = this.ValueGrid.grid();
            int indexX = table.column_indexOfColumn(colNameX);
            int indexY = table.column_indexOfColumn(colNameY);
            int indexV = table.column_indexOfColumn(colNameV);
            for (int ix = 0; ix < nx; ++ix) {
                for (int iy = 0; iy < ny; ++iy) {
                    double gx = originX + gridSize * (double)ix;
                    double gy = originY + gridSize * (double)iy;
                    double sumWeight = 1.0E-20;
                    double sumValue = 0.0;
                    for (int row = 0; row < table.row_count(); ++row) {
                        double vx = table.getDouble(row, indexX);
                        double vy = table.getDouble(row, indexY);
                        double value = table.getDouble(row, indexV);
                        double dx = gx - vx;
                        double dy = gy - vy;
                        double distanceSquared = dx * dx + dy * dy;
                        double weight = 1000.0 * (gridSize * gridSize) / (gridSize * gridSize + distanceSquared);
                        sumWeight += (double)((float)weight);
                        sumValue += (double)((float)(weight * value));
                    }
                    gridW[ix][iy] = (float)sumWeight;
                    gridV[ix][iy] = (float)(sumValue / sumWeight);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }
}

