/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Math.Filter;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Math.Filter.FilterResponse_Abstract;

public class ZeroPhaseFilter_TimeDomain {
    protected boolean m_filterValid = false;
    protected FilterResponse_Abstract m_response = null;
    protected boolean m_dirty = true;
    protected float m_digi = 4.0f;
    protected int m_filterLength = 1;
    protected float[] m_filter = new float[1];
    protected float[] m_temp = new float[300];

    public void applySimpleLP(float[] input, int length) {
        try {
            int n;
            if (input == null) {
                return;
            }
            if ((length = Math.min(length, input.length)) < 10) {
                return;
            }
            if (length > this.m_temp.length) {
                this.m_temp = new float[length + 100];
            }
            for (n = 0; n < length; ++n) {
                float sum = 0.5f * input[n];
                int index = n - 1;
                if (index >= 0) {
                    sum += 0.25f * input[index];
                }
                if ((index = n + 1) < length) {
                    sum += 0.25f * input[index];
                }
                this.m_temp[n] = sum;
            }
            for (n = 0; n < length; ++n) {
                input[n] = this.m_temp[n];
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void apply(float[] input, int length) {
        try {
            int n;
            if (this.m_response == null) {
                return;
            }
            if (input == null) {
                return;
            }
            if ((length = Math.min(length, input.length)) < 10) {
                return;
            }
            if (this.m_response.responseModified() || this.m_dirty || !this.m_filterValid) {
                this.computeFilter();
            }
            if (!this.m_filterValid) {
                return;
            }
            if (length > this.m_temp.length) {
                this.m_temp = new float[length + 100];
            }
            for (n = 0; n < length; ++n) {
                float sum = this.m_filter[0] * input[n];
                for (int k = 1; k < this.m_filter.length; ++k) {
                    int index = n - k;
                    if (index >= 0) {
                        sum += this.m_filter[k] * input[index];
                    }
                    if ((index = n + k) >= length) continue;
                    sum += this.m_filter[k] * input[index];
                }
                this.m_temp[n] = sum;
            }
            for (n = 0; n < length; ++n) {
                input[n] = this.m_temp[n];
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void computeFilter() {
        try {
            this.m_filterValid = false;
            this.m_dirty = true;
            if (this.m_response == null) {
                return;
            }
            int upperIndex = this.m_filterLength / 2;
            float ffac = 1000.0f / (this.m_digi * (float)this.m_filterLength);
            for (int n = 0; n < this.m_filter.length; ++n) {
                float temp = (float)Math.PI * 2 * (float)n / (float)this.m_filterLength;
                float sum = this.m_response.response(0.0f);
                for (int k = 1; k <= upperIndex; ++k) {
                    float frequency = ffac * (float)k;
                    float response = this.m_response.response(frequency);
                    sum += 2.0f * response * (float)Math.cos(temp * (float)k);
                }
                this.m_filter[n] = sum;
            }
            this.m_response.clearResponseModified();
            this.m_filterValid = true;
            this.m_dirty = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setResponse(FilterResponse_Abstract resp) {
        try {
            this.m_response = resp;
            this.m_dirty = true;
            this.m_filterValid = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setDigi(float digi) {
        try {
            float diff = Math.abs(digi - this.m_digi);
            if (diff < 0.001f) {
                return;
            }
            this.m_dirty = true;
            this.m_filterValid = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setFilterLength(int len) {
        try {
            if (this.m_filterLength == len) {
                return;
            }
            this.m_dirty = true;
            this.m_filterValid = false;
            this.m_filterLength = Math.max(11, len);
            this.m_filterLength = Math.min(121, len);
            if (this.m_filterLength % 2 == 0) {
                ++this.m_filterLength;
            }
            int arrayLen = 1 + this.m_filterLength / 2;
            this.m_filter = new float[arrayLen];
            this.m_filter[0] = 1.0f;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

