/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Math.Filter;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.FFT.FFT_1D_Wrapper;

public class FrequencyDomainFilter {
    protected FilterType m_type = FilterType.Butterworth;
    protected FFT_1D_Wrapper m_fft = new FFT_1D_Wrapper(10);
    protected float[] m_filter = new float[3];
    protected boolean m_dirty = true;
    protected float m_sampleInterval = 1.0f;
    protected float m_buttFreq1 = 0.0f;
    protected float m_buttFreq2 = 0.0f;
    protected float[] m_temp = new float[2];

    public FrequencyDomainFilter() {
        this.setButterworth(20.0f, 25.0f);
    }

    public void setButterworth(float f1, float f2) {
        this.m_type = FilterType.Butterworth;
        this.m_dirty = true;
        this.m_buttFreq1 = f1;
        this.m_buttFreq2 = Math.max(this.m_buttFreq1 + 0.01f, f2);
    }

    public void apply(Ensemble e) {
        try {
            for (int n = 0; n < e.traceCount(); ++n) {
                EnsembleTrace t = e.trace(n);
                int len = t.data().length();
                if (len != this.m_temp.length) {
                    this.m_temp = new float[len];
                }
                t.data().copyToArray(this.m_temp);
                this.apply(this.m_temp, t.data().getSampleInterval());
                t.data().insertArray(this.m_temp, this.m_temp.length);
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void apply(float[] data, float sampleInterval) {
        try {
            this.m_fft.forward(data);
            int len = this.m_fft.getPowerOfTwo();
            if (len != this.m_filter.length || this.m_dirty || (double)Math.abs(sampleInterval - this.m_sampleInterval) > 0.001) {
                this.recomputeFilter(len, sampleInterval);
            }
            float[] re = this.m_fft.real();
            float[] im = this.m_fft.imag();
            for (int n = 0; n < len; ++n) {
                int n2 = n;
                re[n2] = re[n2] * this.m_filter[n];
                int n3 = n;
                im[n3] = im[n3] * this.m_filter[n];
            }
            this.m_fft.inverse(data);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected void recomputeFilter(int len, float sampleInterval) {
        try {
            this.m_dirty = false;
            this.m_sampleInterval = sampleInterval;
            this.m_filter = new float[len];
            int mid = len / 2;
            this.m_filter[mid] = 0.0f;
            if (this.m_type == FilterType.Butterworth) {
                this.m_filter[0] = 1.0f;
                for (int n = 1; n < mid; ++n) {
                    this.m_filter[n] = 0.0f;
                    float period = 0.001f * sampleInterval * (float)len / (float)n;
                    float frequency = 1.0f / period;
                    if (frequency <= this.m_buttFreq1) {
                        this.m_filter[n] = 1.0f;
                    }
                    if (frequency >= this.m_buttFreq1 && frequency <= this.m_buttFreq2) {
                        this.m_filter[n] = (this.m_buttFreq2 - frequency) / (this.m_buttFreq2 - this.m_buttFreq1);
                    }
                    this.m_filter[len - n] = this.m_filter[n];
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public static enum FilterType {
        Butterworth;

    }
}

