/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Math.Filter;

import com.PecosLibrary.Math.Filter.FilterResponse_Abstract;

public class FilterResponse_BandPass
extends FilterResponse_Abstract {
    protected float m_corner1 = 10.0f;
    protected float m_corner2 = 15.0f;
    protected float m_corner3 = 35.0f;
    protected float m_corner4 = 45.0f;

    public void setCorners(float c1, float c2, float c3, float c4) {
        float diff1 = Math.abs(c1 - this.m_corner1);
        float diff2 = Math.abs(c2 - this.m_corner2);
        float diff3 = Math.abs(c3 - this.m_corner3);
        float diff4 = Math.abs(c4 - this.m_corner4);
        if (diff1 < 0.001f && diff2 < 0.001f && diff3 < 0.001f && diff4 < 0.001f) {
            return;
        }
        this.m_corner1 = c1;
        this.m_corner1 = Math.max(1.0E-5f, this.m_corner1);
        this.m_corner2 = c2;
        this.m_corner2 = Math.max(this.m_corner1 + 1.0E-4f, this.m_corner2);
        this.m_corner3 = c3;
        this.m_corner3 = Math.max(this.m_corner2 + 1.0E-4f, this.m_corner3);
        this.m_corner4 = c4;
        this.m_corner4 = Math.max(this.m_corner3 + 1.0E-4f, this.m_corner4);
        this.m_modified = true;
    }

    @Override
    public float response(float frequency) {
        if (frequency <= this.m_corner1) {
            return 0.0f;
        }
        if (frequency >= this.m_corner1 && frequency <= this.m_corner2) {
            return (frequency - this.m_corner1) / (this.m_corner2 - this.m_corner1);
        }
        if (frequency >= this.m_corner2 && frequency <= this.m_corner3) {
            return 1.0f;
        }
        if (frequency >= this.m_corner3 && frequency <= this.m_corner4) {
            return (this.m_corner4 - frequency) / (this.m_corner4 - this.m_corner3);
        }
        return 0.0f;
    }
}

