/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Math.Delauney;

import com.PecosCore.Shared.ExceptionMonitor;

public class DelaunayPoint {
    public double X;
    public double Y;
    public double V;
    public double Count;
    public double Ray_MinimumS;
    public double Ray_X;
    public double Ray_Y;
    public double Ray_Distance;

    public DelaunayPoint(double x, double y, double v) {
        this.X = x;
        this.Y = y;
        this.V = v;
        this.Count = 1.0;
    }

    public DelaunayPoint clone() {
        return new DelaunayPoint(this.X, this.Y, this.V);
    }

    public boolean isWithinRadius(double x, double y, double radius) {
        double dx = x - this.X;
        double dy = y - this.Y;
        double distance = Math.sqrt(1.0E-80 + dx * dx + dy * dy);
        return distance < radius;
    }

    public void mergePoint(double x, double y, double v) {
        this.X = (this.Count * this.X + x) / (this.Count + 1.0);
        this.Y = (this.Count * this.Y + y) / (this.Count + 1.0);
        this.V = (this.Count * this.V + v) / (this.Count + 1.0);
        this.Count += 1.0;
    }

    public void prepareRayInfo(double x, double y, double cos, double sin) throws Exception {
        try {
            this.Ray_MinimumS = (this.X - x) * cos + (this.Y - y) * sin;
            this.Ray_X = x + cos * this.Ray_MinimumS;
            this.Ray_Y = x + sin * this.Ray_MinimumS;
            double dx = this.Ray_X - this.X;
            double dy = this.Ray_Y - this.Y;
            this.Ray_Distance = Math.sqrt(1.0E-60 + dx * dx + dy * dy);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }
}

