/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Math;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Math.AxisGrid;
import com.PecosLibrary.Math.AxisGrid_Interpolator;
import com.PecosLibrary.Math.AxisGrid_PathNode;
import java.util.ArrayList;

public class AxisGridBase {
    public static final String Suffix = ".grid3d";
    protected double m_originX = 0.0;
    protected double m_originY = 0.0;
    protected double m_cellSizeX = 100.0;
    protected double m_cellSizeY = 100.0;
    protected int m_numCellsX = 1;
    protected int m_numCellsY = 1;
    public double TempWorldX = 0.0;
    public double TempWorldY = 0.0;
    public int TempIndexX = 0;
    public int TempIndexY = 0;
    public ArrayList<AxisGrid_PathNode> PathNodeList = new ArrayList();
    public int PathNodeCount = 0;
    public double PathSegmentLength = 10.0;
    public double PathAzimuth;
    public double PathLength;

    public AxisGrid_Interpolator createAxisGrid_Interpolator() throws Exception {
        try {
            return new AxisGrid_Interpolator(this.m_originX, this.m_originY, this.m_cellSizeX, this.m_numCellsX, this.m_numCellsY);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected int minIndexX(int x, int N) {
        int min = x - N;
        min = Math.max(0, min);
        min = Math.min(this.m_numCellsX - 1, min);
        return min;
    }

    protected int maxIndexX(int x, int N) {
        int max = x + N;
        max = Math.max(0, max);
        max = Math.min(this.m_numCellsX - 1, max);
        return max;
    }

    protected int minIndexY(int y, int N) {
        int min = y - N;
        min = Math.max(0, min);
        min = Math.min(this.m_numCellsY - 1, min);
        return min;
    }

    protected int maxIndexY(int y, int N) {
        int max = y + N;
        max = Math.max(0, max);
        max = Math.min(this.m_numCellsY - 1, max);
        return max;
    }

    public AxisGrid createAxisGrid(int binsPerBlob) throws Exception {
        try {
            binsPerBlob = Math.max(binsPerBlob, 1);
            int nx = this.m_numCellsX / binsPerBlob;
            if (this.m_numCellsX % binsPerBlob != 0) {
                ++nx;
            }
            int ny = this.m_numCellsY / binsPerBlob;
            if (this.m_numCellsY % binsPerBlob != 0) {
                ++ny;
            }
            double sx = (double)binsPerBlob * this.m_cellSizeX;
            double sy = (double)binsPerBlob * this.m_cellSizeY;
            double ox = this.m_originX + ((double)binsPerBlob / 2.0 - 0.5) * this.m_cellSizeX;
            double oy = this.m_originY + ((double)binsPerBlob / 2.0 - 0.5) * this.m_cellSizeY;
            return new AxisGrid(ox, oy, sx, sy, nx, ny);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public double originY() {
        return this.m_originY;
    }

    public double cellSizeY() {
        return this.m_cellSizeY;
    }

    public int numCellsY() {
        return this.m_numCellsY;
    }

    public double originX() {
        return this.m_originX;
    }

    public double cellSizeX() {
        return this.m_cellSizeX;
    }

    public int numCellsX() {
        return this.m_numCellsX;
    }

    public void prepInternalIndex(double x, double y) throws Exception {
        try {
            this.TempWorldX = x;
            this.TempWorldY = y;
            double gridX = (x - this.m_originX) / this.m_cellSizeX;
            this.TempIndexX = (int)Math.round(gridX);
            this.TempIndexX = Math.max(this.TempIndexX, 0);
            this.TempIndexX = Math.min(this.TempIndexX, this.m_numCellsX - 1);
            double gridY = (y - this.m_originY) / this.m_cellSizeY;
            this.TempIndexY = (int)Math.round(gridY);
            this.TempIndexY = Math.max(this.TempIndexY, 0);
            this.TempIndexY = Math.min(this.TempIndexY, this.m_numCellsY - 1);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void prep_path_nodes(double sx, double sy, double rx, double ry) throws Exception {
        try {
            double dx = rx - sx;
            double dy = ry - sy;
            this.PathAzimuth = Math.atan2(dy, dx);
            this.PathLength = Math.sqrt(dx * dx + dy * dy);
            this.PathNodeCount = 4 + (int)(this.PathLength / this.m_cellSizeX);
            this.PathSegmentLength = this.PathLength / (double)(this.PathNodeCount - 1);
            dx /= (double)(this.PathNodeCount - 1);
            dy /= (double)(this.PathNodeCount - 1);
            while (this.PathNodeList.size() <= this.PathNodeCount) {
                this.PathNodeList.add(new AxisGrid_PathNode());
            }
            for (int n = 0; n < this.PathNodeCount; ++n) {
                AxisGrid_PathNode node = this.PathNodeList.get(n);
                node.Index = n;
                node.WorldX = sx + dx * (double)n;
                node.WorldY = sy + dy * (double)n;
                this.prepInternalIndex(node.WorldX, node.WorldY);
                node.IndexX = this.TempIndexX;
                node.IndexY = this.TempIndexY;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public boolean compare(AxisGridBase grid) throws Exception {
        try {
            return grid.compare(this.m_originX, this.m_originY, this.m_cellSizeX, this.m_cellSizeY, this.m_numCellsY, this.m_numCellsY);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public boolean compare(double ox, double oy, double sx, double sy, int nx, int ny) throws Exception {
        try {
            if (nx != this.m_numCellsX) {
                return false;
            }
            if (ny != this.m_numCellsY) {
                return false;
            }
            if (Math.abs(this.m_cellSizeX - sx) > 0.01) {
                return false;
            }
            if (Math.abs(this.m_cellSizeY - sy) > 0.01) {
                return false;
            }
            if (Math.abs(this.m_originX - ox) > 1.0) {
                return false;
            }
            return !(Math.abs(this.m_originY - oy) > 1.0);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }
}

