/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Job;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Job.JobManager;
import com.PecosLibrary.Job.JobState;
import com.PecosLibrary.Job.Worker_Base;
import java.io.File;

public class Worker_TestA
extends Worker_Base {
    public static void prepareScratchDirectory(Worker_TestA worker) {
        try {
            String sScratchDirectory = JobManager.singleton().getTemporaryScratchDirectory();
            String sTempDatabaseFile = sScratchDirectory + File.separator + "test.dat";
            JobState testJobState = new JobState();
            JobState.writeJobState(sTempDatabaseFile, testJobState);
            worker.getParameterTree().string_put("Scratch", sTempDatabaseFile);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public ParameterTree getParameterTree() {
        try {
            this.m_parameterTree.int_put("Outer", 2000);
            this.m_parameterTree.int_put("Inner", 1000000);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        return this.m_parameterTree;
    }

    @Override
    public String getDescription() {
        return "TestA";
    }

    @Override
    public void work() throws Exception {
        int numOuterLoop = this.m_parameterTree.int_get("Outer", 2000);
        int numInnerLoop = this.m_parameterTree.int_get("Inner", 1000000);
        double sum1 = 0.0;
        double sum2 = 0.0;
        for (int n = 1; n <= numOuterLoop; ++n) {
            if (this.m_bIsHalted) {
                return;
            }
            for (int m = 1; m < numInnerLoop; ++m) {
                double v1 = Math.log(1.0 + (double)n + (double)m);
                double v2 = Math.log10(1.0 + (double)n + (double)m);
                sum1 += v1;
                sum2 += v2;
                while (sum1 > 1.0E10) {
                    sum1 /= 10.0;
                }
                while (sum2 > 1.0E10) {
                    sum2 /= 10.0;
                }
            }
        }
    }

    @Override
    public void cleanupAfterFinishedFailure() {
    }
}

