/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Job;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Job.JobStatus;
import com.PecosLibrary.Job.MemoryAtTime;
import com.PecosLibrary.Job.MessageAtTime;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;

public class JobState {
    static int _magic = 62321;
    static HashMap<String, String> _pathStringMap = new HashMap();
    JobStatus _status = JobStatus.Created;
    Date _startTime;
    Date _endTime;
    Date _creationTime;
    boolean _bHalted = false;
    double _dPercentDone = 0.0;
    Date _timeAtPercentDone;
    String _sJobID = "";
    String _sWorkerDescription = "";
    Exception _lastError = null;
    String _sDescription = "";
    ArrayList<MemoryAtTime> _memoryAtTime = new ArrayList();

    public JobState() {
        this._creationTime = new Date();
        this._startTime = new Date();
        this._endTime = new Date();
        this._timeAtPercentDone = new Date();
        this._startTime.setTime(0L);
        this._startTime.setTime(0L);
        this._endTime.setTime(0L);
        this._timeAtPercentDone.setTime(0L);
        UUID uuid = UUID.randomUUID();
        this._sJobID = uuid.toString();
    }

    public String toString() {
        return "Kill Job";
    }

    public String getWorkerDescription() {
        return this._sWorkerDescription;
    }

    public void setWorkerDescription(String sValue) {
        this._sWorkerDescription = sValue;
    }

    public JobStatus getStatus() {
        return this._status;
    }

    public void setStatus(JobStatus status) {
        this._status = status;
    }

    public Exception getLastError() {
        return this._lastError;
    }

    public void setLastError(Exception error) {
        this._lastError = error;
    }

    public String getDescription() {
        return this._sDescription;
    }

    public ArrayList<MemoryAtTime> getMemoryAtTime() {
        return this._memoryAtTime;
    }

    public Date getCreationTime() {
        return this._creationTime;
    }

    public Date getStartTime() {
        return this._startTime;
    }

    public void setStartTime(Date startTime) {
        this._startTime = startTime;
    }

    public Date getEndTime() {
        return this._endTime;
    }

    public void setEndTime(Date endTime) {
        this._endTime = endTime;
    }

    public Date getTimeAtPercentDone() {
        return this._timeAtPercentDone;
    }

    public void setPercentDone(double dPercentDone, Date time) {
        this._dPercentDone = dPercentDone;
        this._timeAtPercentDone = time;
    }

    public double getPercentDone() {
        return this._dPercentDone;
    }

    public static void writeJobState(String sFilePath, JobState js) throws Exception {
        FileOutputStream fileOutputStream = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(_magic);
            dataOutputStream.writeUTF(js.getJobID());
            dataOutputStream.writeUTF(js.getWorkerDescription());
            dataOutputStream.writeUTF(js.getJobStatus().toString());
            dataOutputStream.writeLong(js.getCreationTime().getTime());
            dataOutputStream.writeLong(js.getStartTime().getTime());
            dataOutputStream.writeLong(js.getEndTime().getTime());
            dataOutputStream.writeLong(js.getTimeAtPercentDone().getTime());
            dataOutputStream.writeBoolean(js.getIsHalted());
            dataOutputStream.writeDouble(js.getPercentDone());
            dataOutputStream.writeUTF(js.getDescription());
            int nMemoryDescriptions = js.getMemoryAtTime().size();
            dataOutputStream.writeInt(nMemoryDescriptions);
            for (int i = 0; i < nMemoryDescriptions; ++i) {
                MemoryAtTime m = js.getMemoryAtTime().get(i);
                dataOutputStream.writeLong(m.Memory);
                dataOutputStream.writeLong(m.Time);
            }
            boolean bHasError = js._lastError != null;
            dataOutputStream.writeBoolean(bHasError);
            if (bHasError) {
                ByteArrayOutputStream exceptionByteStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOut = new ObjectOutputStream(exceptionByteStream);
                objectOut.writeObject(js._lastError);
                objectOut.close();
                byte[] bytes = exceptionByteStream.toByteArray();
                int nBytes = bytes.length;
                dataOutputStream.writeInt(nBytes);
                dataOutputStream.write(bytes);
            }
            dataOutputStream.writeInt(_magic);
            dataOutputStream.close();
            String sTempFilePath = sFilePath + ".tmp";
            File fFile = new File(sTempFilePath);
            int index = 1;
            while (fFile.exists()) {
                sTempFilePath = sFilePath + ".tmp" + Integer.toString(index);
                fFile = new File(sTempFilePath);
                ++index;
            }
            byte[] data = byteArrayOutputStream.toByteArray();
            fileOutputStream = new FileOutputStream(sTempFilePath);
            fileOutputStream.write(data, 0, data.length);
            fileOutputStream.close();
            fileOutputStream = null;
            Path FROM = Paths.get(sTempFilePath, new String[0]);
            Path TO = Paths.get(sFilePath, new String[0]);
            CopyOption[] options = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES};
            Files.copy(FROM, TO, options);
            fFile.delete();
        }
        catch (Exception error) {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static void copyFile(String sFrom, String sTo) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRegisteredFilePath(String sFilePath) {
        String sRegisteredFilePath;
        HashMap<String, String> hashMap = _pathStringMap;
        synchronized (hashMap) {
            sRegisteredFilePath = _pathStringMap.get(sFilePath);
            if (sRegisteredFilePath == null) {
                _pathStringMap.put(sFilePath, sFilePath);
                sRegisteredFilePath = sFilePath;
            }
        }
        return sRegisteredFilePath;
    }

    public static JobState readJobState(String sFilePath) throws Exception {
        JobState jobInfo = null;
        FileInputStream fileInputStream = null;
        try {
            jobInfo = new JobState();
            File fFile = new File(sFilePath);
            fileInputStream = new FileInputStream(sFilePath);
            int nFileBytes = (int)fFile.length();
            if (nFileBytes < 48) {
                return null;
            }
            byte[] fileBytes = new byte[nFileBytes];
            if (fileInputStream.read(fileBytes, 0, nFileBytes) != nFileBytes) {
                return null;
            }
            fileInputStream.close();
            fileInputStream = null;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fileBytes);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int magic = dataInputStream.readInt();
            if (magic != _magic) {
                return null;
            }
            dataInputStream.reset();
            dataInputStream.skipBytes(nFileBytes - 4);
            magic = dataInputStream.readInt();
            if (magic != _magic) {
                return null;
            }
            dataInputStream.reset();
            magic = dataInputStream.readInt();
            if (magic != _magic) {
                throw new Exception("invalid magic for file : " + sFilePath);
            }
            jobInfo._sJobID = dataInputStream.readUTF();
            jobInfo._sWorkerDescription = dataInputStream.readUTF();
            String sJobStatus = dataInputStream.readUTF();
            jobInfo._status = JobStatus.valueOf(sJobStatus);
            long lCreationTime = dataInputStream.readLong();
            long lStartTime = dataInputStream.readLong();
            long lEndTime = dataInputStream.readLong();
            long lTimeAtPercentDone = dataInputStream.readLong();
            jobInfo._creationTime = new Date(lCreationTime);
            jobInfo._startTime = new Date(lStartTime);
            jobInfo._endTime = new Date(lEndTime);
            jobInfo._timeAtPercentDone = new Date(lTimeAtPercentDone);
            jobInfo._bHalted = dataInputStream.readBoolean();
            jobInfo._dPercentDone = dataInputStream.readDouble();
            jobInfo._sDescription = dataInputStream.readUTF();
            int nMemoryAtTimes = dataInputStream.readInt();
            for (int i = 0; i < nMemoryAtTimes; ++i) {
                long lMemory = dataInputStream.readLong();
                long lTime = dataInputStream.readLong();
                MemoryAtTime m = new MemoryAtTime(lMemory, lTime);
                jobInfo._memoryAtTime.add(m);
            }
            boolean bHasError = dataInputStream.readBoolean();
            if (bHasError) {
                int nBytes = dataInputStream.readInt();
                byte[] bytes = new byte[nBytes];
                dataInputStream.read(bytes, 0, nBytes);
                ByteArrayInputStream exceptionByteStream = new ByteArrayInputStream(bytes);
                ObjectInputStream objectIn = new ObjectInputStream(exceptionByteStream);
                jobInfo._lastError = (Exception)objectIn.readObject();
            }
            if ((magic = dataInputStream.readInt()) != _magic) {
                return null;
            }
        }
        catch (Exception error) {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            ExceptionMonitor.add(error);
            throw error;
        }
        return jobInfo;
    }

    public void addMessageLevel1(String sMessage, Date date) {
        MessageAtTime desc = new MessageAtTime(sMessage, date.getTime());
        this._sDescription = sMessage;
    }

    public void addMemoryAtTime(long lMemory, long lTime) {
        MemoryAtTime mt = new MemoryAtTime(lMemory, lTime);
        this._memoryAtTime.add(mt);
    }

    public String getJobID() {
        return this._sJobID;
    }

    public boolean getIsHalted() {
        return this._bHalted;
    }

    public void setIsHalted(boolean bIsHalted) {
        this._bHalted = bIsHalted;
    }

    public JobStatus getJobStatus() {
        return this._status;
    }

    public void setJobStatus(JobStatus status) {
        this._status = status;
    }
}

