/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Job;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Job.IJobFinishedListener;
import com.PecosLibrary.Job.IJobStateListener;
import com.PecosLibrary.Job.JobManager;
import com.PecosLibrary.Job.JobManagerWorkerMonitor;
import com.PecosLibrary.Job.JobState;
import com.PecosLibrary.Job.JobStateComparator;
import com.PecosLibrary.Job.JobStateListenerInfo;
import com.PecosLibrary.Job.JobStatus;
import com.PecosLibrary.Job.JobWorkerThread;
import com.PecosLibrary.Job.Worker_Base;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;

public class JobManagerFileMonitor {
    String _sMonitorDirectory;
    Timer _timer;
    Date _lastScanDate;
    int _lastScanFileCount;
    File _directory;
    HashMap<String, JobState> _jobStateHash;
    ArrayList<JobStateListenerInfo> _jobStateListeners;
    ArrayList<IJobFinishedListener> _jobFinishedListeners;

    public JobManagerFileMonitor(String sDirectory) {
        try {
            this._sMonitorDirectory = sDirectory;
            this._directory = new File(this._sMonitorDirectory);
            this._jobStateHash = new HashMap();
            this._jobStateListeners = new ArrayList();
            this._jobFinishedListeners = new ArrayList();
            this._timer = new Timer();
            this._lastScanDate = new Date(0L);
            this._lastScanFileCount = 0;
            this.checkForModifiedJobStateFiles();
            this._timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    JobManagerFileMonitor.this.checkForModifiedJobStateFiles();
                }
            }, 5000L, 5000L);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public JobState getJobState(String sJobID) {
        return this._jobStateHash.get(sJobID);
    }

    public void createKillJobFile(String sJobID) {
        try {
            String sFilePath = JobManager.singleton().getJobKillFilePath(sJobID);
            File fKillJobFile = new File(sFilePath);
            if (!fKillJobFile.exists()) {
                FileOutputStream fileOutputStream = new FileOutputStream(sFilePath);
                int iValue = 42;
                fileOutputStream.write(iValue);
                fileOutputStream.close();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void removeJob(String sJobID) {
        try {
            String sJobStateFile = JobManager.singleton().getJobStateFilePath(sJobID);
            String sJobParameterFile = JobManager.singleton().getJobParamsFilePath(sJobID);
            File fJobStatefile = new File(sJobStateFile);
            File fJobParameterFile = new File(sJobParameterFile);
            JobState lastJobState = null;
            lastJobState = this._jobStateHash.get(sJobID);
            if (lastJobState != null && lastJobState.getStatus() == JobStatus.Working) {
                this.createKillJobFile(sJobID);
                return;
            }
            this._jobStateHash.remove(sJobID);
            if (fJobStatefile.exists()) {
                fJobStatefile.delete();
            }
            if (fJobParameterFile.exists()) {
                fJobParameterFile.delete();
            }
            this._jobStateHash.remove(sJobID);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public ArrayList<String> getJobs(JobStatus status) {
        ArrayList<String> jobs = new ArrayList<String>();
        ArrayList<JobState> jobList = new ArrayList<JobState>();
        Collection<JobState> jobSet = this._jobStateHash.values();
        for (JobState js : jobSet) {
            if (js.getJobStatus() != status) continue;
            jobList.add(js);
        }
        Collections.sort(jobList, new JobStateComparator());
        for (JobState js : jobList) {
            jobs.add(js.getJobID());
        }
        return jobs;
    }

    public ArrayList<String> getAllJobs() {
        ArrayList<String> jobs = new ArrayList<String>();
        ArrayList<JobState> jobList = new ArrayList<JobState>();
        Collection<JobState> jobSet = this._jobStateHash.values();
        for (JobState js : jobSet) {
            jobList.add(js);
        }
        Collections.sort(jobList, new JobStateComparator());
        for (JobState js : jobList) {
            jobs.add(js.getJobID());
        }
        return jobs;
    }

    public void sendJobStateChangedEvent(String sJobID, JobState oldJobState, JobState newJobState) {
        block12: {
            try {
                for (int i = 0; i < this._jobStateListeners.size(); ++i) {
                    try {
                        JobStateListenerInfo info = this._jobStateListeners.get(i);
                        if (!info.JobID.equals("") && !info.JobID.equals(sJobID)) continue;
                        info.Listener.jobStateChanged(sJobID, oldJobState, newJobState);
                        continue;
                    }
                    catch (Exception error) {
                        ExceptionMonitor.add(error);
                    }
                }
                if (newJobState == null) {
                    return;
                }
                if (newJobState.getStatus() != JobStatus.FinishedSuccess && newJobState.getStatus() != JobStatus.FinishedFailure && newJobState.getStatus() != JobStatus.FinishedSuccess) break block12;
                boolean bSendEvent = true;
                if (oldJobState == null) break block12;
                if (oldJobState.getStatus() == JobStatus.FinishedSuccess || oldJobState.getStatus() == JobStatus.FinishedFailure || oldJobState.getStatus() == JobStatus.FinishedSuccess) {
                    bSendEvent = false;
                    break block12;
                }
                ParameterTree paramTree = null;
                try {
                    String sParamsFile = JobManager.singleton().getJobParamsFilePath(newJobState.getJobID());
                    paramTree = new ParameterTree();
                    paramTree.read(sParamsFile);
                }
                catch (Exception err) {
                    ExceptionMonitor.add(err);
                }
                for (int i = 0; i < this._jobFinishedListeners.size(); ++i) {
                    try {
                        IJobFinishedListener listener = this._jobFinishedListeners.get(i);
                        listener.jobFinished(newJobState, paramTree);
                        continue;
                    }
                    catch (Exception error) {
                        ExceptionMonitor.add(error);
                    }
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }
    }

    public void removeJobFinishedListener(IJobFinishedListener listener) {
        try {
            this._jobFinishedListeners.remove(listener);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void addJobFinishedListener(IJobFinishedListener listener) {
        try {
            if (!this.containsJobFinishedListener(listener)) {
                this._jobFinishedListeners.add(listener);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public boolean containsJobFinishedListener(IJobFinishedListener listener) {
        try {
            return this._jobFinishedListeners.contains(listener);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public boolean containsJobStateListener(String sJobID, IJobStateListener listener) {
        boolean bContainsListener = false;
        try {
            for (int i = 0; i < this._jobStateListeners.size(); ++i) {
                JobStateListenerInfo info = this._jobStateListeners.get(i);
                if (!info.JobID.equals(sJobID) || listener != info.Listener) continue;
                return true;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return bContainsListener;
    }

    public void addJobStateListener(String sJobID, IJobStateListener listener) {
        try {
            if (this.containsJobStateListener(sJobID, listener)) {
                return;
            }
            JobStateListenerInfo info = new JobStateListenerInfo(sJobID, listener);
            this._jobStateListeners.add(info);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void removeJobStateListener(IJobStateListener listener) {
        try {
            JobStateListenerInfo info;
            int i;
            ArrayList<JobStateListenerInfo> removeList = new ArrayList<JobStateListenerInfo>();
            for (i = 0; i < this._jobStateListeners.size(); ++i) {
                info = this._jobStateListeners.get(i);
                if (listener != info.Listener) continue;
                removeList.add(info);
            }
            for (i = 0; i < removeList.size(); ++i) {
                info = (JobStateListenerInfo)removeList.get(i);
                this._jobStateListeners.remove(info);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void deleteDirectory(File fDir) {
        try {
            boolean bl;
            if (fDir == null) {
                return;
            }
            File[] filesInDir = fDir.listFiles();
            if (filesInDir == null) {
                fDir.delete();
                return;
            }
            for (int i = 0; i < filesInDir.length; ++i) {
                File f = filesInDir[i];
                if (f.isDirectory()) {
                    JobManagerFileMonitor.deleteDirectory(f);
                    continue;
                }
                bl = f.delete();
            }
            bl = fDir.delete();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    void killJob(String sJobID) {
        try {
            File fScratchDirectory;
            String sScratchDirectory = "";
            String sParamsFile = JobManager.singleton().getJobParamsFilePath(sJobID);
            String sKillFile = JobManager.singleton().getJobKillFilePath(sJobID);
            String sStateFile = JobManager.singleton().getJobStateFilePath(sJobID);
            File fKillFile = new File(sKillFile);
            File fParamsFile = new File(sParamsFile);
            File fStateFile = new File(sStateFile);
            fKillFile.delete();
            if (fParamsFile.exists()) {
                ParameterTree paramTree = new ParameterTree();
                paramTree.read(sParamsFile);
                fParamsFile.delete();
                sScratchDirectory = paramTree.string_get("Scratch", "");
            }
            if (sScratchDirectory.length() > 1 && (fScratchDirectory = new File(sScratchDirectory)).exists()) {
                JobManagerFileMonitor.deleteDirectory(fScratchDirectory);
            }
            if (fStateFile.exists()) {
                fStateFile.delete();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    void checkForKillJobFiles() {
        try {
            File[] listOfFiles = this._directory.listFiles();
            for (int i = 0; i < listOfFiles.length; ++i) {
                if (!listOfFiles[i].isFile()) continue;
                String sFileName = listOfFiles[i].getPath();
                try {
                    if (!sFileName.endsWith(".kill")) continue;
                    File fKillFile = new File(sFileName);
                    String sJobID = fKillFile.getName().replace(".kill", "");
                    JobManagerWorkerMonitor monitor = (JobManagerWorkerMonitor)JobManager.singleton().getWorkerMonitor();
                    JobWorkerThread workerThread = monitor.findWorkerThreadFromJobID(sJobID);
                    if (workerThread != null) {
                        fKillFile.delete();
                        Worker_Base worker = workerThread.getWorker();
                        if (worker != null) {
                            worker.setIsHalted(true);
                        }
                        try {
                            workerThread.join(1000L);
                            for (int ii = 0; ii < 10; ++ii) {
                                if (!workerThread.isAlive()) continue;
                                workerThread.interrupt();
                            }
                        }
                        catch (Exception e) {
                            ExceptionMonitor.add(e);
                        }
                        this.killJob(sJobID);
                        continue;
                    }
                    JobState js = this.getJobState(sJobID);
                    if (js == null || js.getJobStatus() != JobStatus.FinishedFailure && js.getJobStatus() != JobStatus.FinishedHalted && js.getJobStatus() != JobStatus.FinishedSuccess) continue;
                    this.killJob(sJobID);
                    continue;
                }
                catch (Exception ex) {
                    ExceptionMonitor.add(ex);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    void removeMissingJobFilesFromHash() {
        try {
            ArrayList<String> missingJobs = new ArrayList<String>();
            for (String sJobID : this._jobStateHash.keySet()) {
                String sJobPath = JobManager.singleton().getJobStateFilePath(sJobID);
                File file = new File(sJobPath);
                if (file.exists()) continue;
                missingJobs.add(sJobID);
            }
            for (String sJobID : missingJobs) {
                this._jobStateHash.remove(sJobID);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void reset() {
        this._lastScanDate = new Date(0L);
        this._jobStateHash.clear();
    }

    void checkForModifiedJobStateFiles() {
        try {
            long lLastScanTime = this._lastScanDate.getTime();
            int nLastScanFileCount = this._lastScanFileCount;
            this._lastScanDate = new Date();
            File[] listOfFiles = this._directory.listFiles();
            if (listOfFiles == null) {
                if (this._lastScanFileCount != 0) {
                    this._jobStateHash.clear();
                    this.sendJobStateChangedEvent("", null, null);
                }
                this._lastScanFileCount = 0;
            }
            for (int i = 0; i < listOfFiles.length; ++i) {
                File file;
                long lLastModified;
                String sFileName;
                if (!listOfFiles[i].isFile() || !(sFileName = listOfFiles[i].getPath()).endsWith(".state") || (lLastModified = (file = new File(sFileName)).lastModified()) < lLastScanTime) continue;
                try {
                    JobState state = JobState.readJobState(sFileName);
                    if (state == null) continue;
                    String sID = state.getJobID();
                    JobState oldJobState = this._jobStateHash.put(sID, state);
                    this.sendJobStateChangedEvent(sID, oldJobState, state);
                    continue;
                }
                catch (Exception ex) {
                    ExceptionMonitor.add(ex);
                }
            }
            if (listOfFiles.length != this._lastScanFileCount) {
                this.removeMissingJobFilesFromHash();
                this.sendJobStateChangedEvent("", null, null);
            }
            this._lastScanFileCount = listOfFiles.length;
            this._lastScanDate = new Date();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

