/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Geometry;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosLibrary.Geometry.GeometryProject_Base;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class GeometryProject_SPS
extends GeometryProject_Base {
    public static String SPS_Version = "SPS_Version";
    public static String SPS_Version_0 = "SPS_Version_0";
    public static String SPS_Version_21 = "SPS_Version_21";
    protected HashMap_Integers<FFIDENTRY> m_ffidHash = new HashMap_Integers();
    protected HashMap_Integers<Integer> m_shotHashLPI = new HashMap_Integers();
    protected Table_Abstract m_shotTable = null;
    protected Table_Abstract m_receiverTable = null;
    protected Table_Abstract m_relationTable = null;
    public String FailureReason = "";
    protected boolean m_useShotLineNumber = false;
    protected boolean m_useShotPointIndex = false;
    protected boolean m_useReceiverLineNumber = false;
    protected boolean m_useReceiverPointIndex = false;
    protected int m_is_PointNumber;
    protected int m_is_LineNumber;
    protected int m_is_PointIndex;
    protected int m_ix_ShotPointNumber;
    protected int m_ix_ShotLineNumber;
    protected int m_ix_ShotPointIndex;
    protected int m_ix_FromChannel;
    protected int m_ix_ToChannel;
    protected int m_ix_ChannelInc;
    protected int m_numHeadersFailed = 0;

    public GeometryProject_SPS(String projectName) throws Exception {
        try {
            this.m_projectName = projectName;
            String path = SharedApplicationData.geometryProjectPath();
            this.m_projectPath = Tools_FileSystem.confirmSubDirectoryExists(path, this.m_projectName);
            this.m_parameterTreeFileName = this.m_projectPath + "/ProjectDescription.xml";
            this.m_parameterTree.read(this.m_parameterTreeFileName);
            this.m_valid = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected boolean prepareRelation() {
        try {
            if (!this.m_relationTable.column_exists("ChannelIncrement")) {
                this.FailureReason = "Relation must have ChannelIncrement";
                return false;
            }
            if (!this.m_relationTable.column_exists("FromChannel")) {
                this.FailureReason = "Relation must have FromChannel";
                return false;
            }
            if (!this.m_relationTable.column_exists("ToChannel")) {
                this.FailureReason = "Relation must have ToChannel";
                return false;
            }
            this.m_ix_FromChannel = this.m_relationTable.column_indexOfColumn("FromChannel");
            this.m_ix_ToChannel = this.m_relationTable.column_indexOfColumn("ToChannel");
            this.m_ix_ChannelInc = this.m_relationTable.column_indexOfColumn("ChannelIncrement");
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    protected boolean prepareShot() {
        try {
            this.m_ffidHash.clear();
            this.m_shotHashLPI.clear();
            if (!this.m_shotTable.column_exists("PointNumber")) {
                this.FailureReason = "Shot must have PointNumber";
                return false;
            }
            if (!this.m_relationTable.column_exists("ShotPointNumber")) {
                this.FailureReason = "Relation must have ShotPointNumber";
                return false;
            }
            this.m_is_PointNumber = this.m_shotTable.column_indexOfColumn("PointNumber");
            this.m_ix_ShotPointNumber = this.m_relationTable.column_indexOfColumn("ShotPointNumber");
            this.m_useShotPointIndex = this.m_shotTable.column_exists("PointIndex");
            if (this.m_useShotPointIndex) {
                if (!this.m_relationTable.column_exists("ShotPointIndex")) {
                    this.FailureReason = "Shot has PointIndex, therefore Relation must have ShotPointIndex";
                    return false;
                }
                this.m_is_PointIndex = this.m_shotTable.column_indexOfColumn("PointIndex");
                this.m_ix_ShotPointIndex = this.m_relationTable.column_indexOfColumn("ShotPointIndex");
            }
            this.m_useShotLineNumber = this.m_shotTable.column_exists("LineNumber");
            if (this.m_useShotLineNumber) {
                if (!this.m_relationTable.column_exists("ShotLineNumber")) {
                    this.FailureReason = "Shot has LineNumber, therefore Relation must have ShotLineNumber";
                    return false;
                }
                this.m_is_LineNumber = this.m_shotTable.column_indexOfColumn("LineNumber");
                this.m_ix_ShotLineNumber = this.m_relationTable.column_indexOfColumn("ShotLineNumber");
            }
            for (int row = 0; row < this.m_shotTable.row_count(); ++row) {
                int line = -9999;
                int point = this.m_shotTable.getInt(row, this.m_is_PointNumber);
                int index = -9999;
                if (this.m_is_PointIndex >= 0) {
                    index = this.m_shotTable.getInt(row, this.m_is_PointIndex);
                }
                if (this.m_is_LineNumber >= 0) {
                    line = this.m_shotTable.getInt(row, this.m_is_LineNumber);
                }
                if (this.m_shotHashLPI.containsKey(line, point, index)) {
                    this.FailureReason = "LineNumber/PointNumber/PointIndex do not uniquely identify shots";
                    return false;
                }
                this.m_shotHashLPI.put(new Integer(row), line, point, index);
            }
            int numShotsNotFound = 0;
            int indexFFID = this.m_relationTable.column_indexOfColumn("FFID");
            for (int row = 0; row < this.m_relationTable.row_count(); ++row) {
                int ffid = this.m_relationTable.getInt(row, indexFFID);
                if (!this.m_ffidHash.containsKey(ffid)) {
                    this.m_ffidHash.put(new FFIDENTRY(ffid), ffid);
                }
                int line = -9999;
                int point = this.m_relationTable.getInt(row, this.m_ix_ShotPointNumber);
                int index = -9999;
                if (this.m_ix_ShotPointIndex >= 0) {
                    index = this.m_relationTable.getInt(row, this.m_ix_ShotPointIndex);
                }
                if (this.m_ix_ShotLineNumber >= 0) {
                    line = this.m_relationTable.getInt(row, this.m_ix_ShotLineNumber);
                }
                if (this.m_shotHashLPI.containsKey(line, point, index)) {
                    FFIDENTRY entry = this.m_ffidHash.get(ffid);
                    entry.RelationRow.add(row);
                    entry.ShotRow = this.m_shotHashLPI.get(line, point, index);
                    continue;
                }
                ++numShotsNotFound;
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public void populateHeader(int ffid, int chan, ByteBuffer buff, int offset) {
        try {
            if (!this.m_ffidHash.containsKey(ffid)) {
                ++this.m_numHeadersFailed;
                return;
            }
            FFIDENTRY entry = this.m_ffidHash.get(ffid);
            for (Integer row : entry.RelationRow) {
                int fromChan = this.m_relationTable.getInt(row, this.m_ix_FromChannel);
                int toChan = this.m_relationTable.getInt(row, this.m_ix_ToChannel);
                int incChan = this.m_relationTable.getInt(row, this.m_ix_ChannelInc);
                if (chan < fromChan || chan > toChan) continue;
                return;
            }
            ++this.m_numHeadersFailed;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public boolean prepareForImport() {
        try {
            this.m_numHeadersFailed = 0;
            this.m_shotTable = (Table_Abstract)this.TableHash.get(Shot);
            this.m_receiverTable = (Table_Abstract)this.TableHash.get(Receiver);
            this.m_relationTable = (Table_Abstract)this.TableHash.get(Relation);
            if (!this.prepareRelation()) {
                return false;
            }
            return this.prepareShot();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public class FFIDENTRY {
        public int FFID;
        public ArrayList<Integer> RelationRow = new ArrayList();
        public int ShotRow = 0;

        public FFIDENTRY(int ffid) {
            this.FFID = ffid;
        }
    }
}

