/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Geometry;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;

public class GeometryData {
    int _nRows = 0;
    double[] _easting = null;
    double[] _northing = null;
    double[] _elevation = null;
    float[] _depth = null;
    boolean[] _killed = null;
    int[] _id = null;
    float[][] m_velocity = null;
    float[][] m_delayTime = null;
    float[][] m_delayTimeAnisAz = null;
    float[][] m_delayTimeAnisMag = null;
    public float[][] UpholeCorrectionTime = null;
    public float[][] WaterBottomCorrectionTime = null;
    float[] _upholeTime = null;
    float[] _waterDepth = null;
    int _nMaxBranch = 0;
    transient int[] _idRowLookup = null;

    public GeometryData() {
    }

    public GeometryData(int nRows) {
        this.allocate(nRows);
    }

    public int getMaxBranch() {
        return this._nMaxBranch;
    }

    public float[][] getVelocities() {
        return this.m_velocity;
    }

    public float[][] getDelayTimes() {
        return this.m_delayTime;
    }

    public float[] getPointDepths() {
        return this._depth;
    }

    public float[] getUpholeTimes() {
        return this._upholeTime;
    }

    public float[] getWaterDepths() {
        return this._waterDepth;
    }

    public double[] getX() {
        return this._easting;
    }

    public double[] getY() {
        return this._northing;
    }

    public boolean[] getKilled() {
        return this._killed;
    }

    public int[] getID() {
        return this._id;
    }

    final void allocate(int nRows) {
        this._nRows = nRows;
        this._easting = new double[nRows];
        this._northing = new double[nRows];
        this._elevation = new double[nRows];
        this._depth = new float[nRows];
        this._id = new int[nRows];
        this._killed = new boolean[nRows];
        this._idRowLookup = null;
        this._upholeTime = new float[nRows];
        this._waterDepth = new float[nRows];
    }

    public GeometryData(Table_Abstract table) throws Exception {
        try {
            String sTableName = table.name();
            String sIdColumn = sTableName + "ID";
            int idColumn = table.column_indexOfColumn(sIdColumn);
            int iNorthingColumn = table.column_indexOfColumn("Northing");
            int iEastingColumn = table.column_indexOfColumn("Easting");
            int iElevationColumn = table.column_indexOfColumn("Elevation");
            int iKilledColumn = -1;
            if (table.column_exists("Killed")) {
                table.column_indexOfColumn("Killed");
            }
            int iPointDepthColumn = -1;
            if (table.column_exists("PointDepth")) {
                iPointDepthColumn = table.column_indexOfColumn("PointDepth");
            }
            int iUpholeTimeColumn = -1;
            if (table.column_exists("UpholeTime")) {
                iUpholeTimeColumn = table.column_indexOfColumn("UpholeTime");
            }
            int iWaterDepthColumn = -1;
            if (table.column_exists("WaterDepth")) {
                iWaterDepthColumn = table.column_indexOfColumn("WaterDepth");
            }
            int nRows = table.row_count();
            this.allocate(nRows);
            for (int i = 0; i < nRows; ++i) {
                int id = table.getInt(i, idColumn);
                double dEasting = table.getDouble(i, iEastingColumn);
                double dNorthing = table.getDouble(i, iNorthingColumn);
                double dElevation = table.getDouble(i, iElevationColumn);
                float fPointDepth = 0.0f;
                float fUpholeTime = 0.0f;
                float fWaterDepth = 0.0f;
                boolean bKilled = false;
                if (iPointDepthColumn >= 0) {
                    fPointDepth = table.getFloat(i, iPointDepthColumn);
                }
                if (iKilledColumn >= 0) {
                    bKilled = table.getBool(i, iKilledColumn);
                }
                if (iUpholeTimeColumn >= 0) {
                    fUpholeTime = table.getFloat(i, iUpholeTimeColumn);
                }
                if (iWaterDepthColumn >= 0) {
                    fWaterDepth = table.getFloat(i, iWaterDepthColumn);
                }
                this._easting[i] = dEasting;
                this._northing[i] = dNorthing;
                this._elevation[i] = dElevation;
                this._depth[i] = fPointDepth;
                this._upholeTime[i] = fUpholeTime;
                this._waterDepth[i] = fWaterDepth;
                this._killed[i] = bKilled;
                this._id[i] = id;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public int getRowFromID(int id) {
        if (this._idRowLookup == null) {
            int tmpID;
            int i;
            int iMaxID = 0;
            for (i = 0; i < this._nRows; ++i) {
                tmpID = this._id[i];
                if (tmpID < iMaxID) continue;
                iMaxID = tmpID;
            }
            this._idRowLookup = new int[++iMaxID];
            for (i = 0; i < iMaxID; ++i) {
                this._idRowLookup[i] = -1;
            }
            i = 0;
            while (i < this._nRows) {
                tmpID = this._id[i];
                this._idRowLookup[tmpID] = i++;
            }
        }
        if (id < 0 || id >= this._idRowLookup.length) {
            return -1;
        }
        return this._idRowLookup[id];
    }

    public double getEasting(int i) {
        return this._easting[i];
    }

    public void setEasting(int i, double dVal) {
        this._easting[i] = dVal;
    }

    public double getNorthing(int i) {
        return this._northing[i];
    }

    public void setNorthing(int i, double dVal) {
        this._northing[i] = dVal;
    }

    public double getElevation(int i) {
        return this._elevation[i];
    }

    public void setElevation(int i, double dVal) {
        this._elevation[i] = dVal;
    }

    public float getDepth(int i) {
        return this._depth[i];
    }

    public void setDepth(int i, float fVal) {
        this._depth[i] = fVal;
    }

    public float getWaterDepth(int i) {
        return this._waterDepth[i];
    }

    public void setWaterDepth(int i, float fVal) {
        this._waterDepth[i] = fVal;
    }

    public float getUpholeTime(int i) {
        return this._upholeTime[i];
    }

    public void setUpholeTime(int i, float fVal) {
        this._upholeTime[i] = fVal;
    }

    public int getId(int i) {
        return this._id[i];
    }

    public void setId(int i, int id) {
        this._id[i] = id;
    }

    public boolean getKilled(int i) {
        return this._killed[i];
    }

    public void setKilled(int i, boolean bKilled) {
        this._killed[i] = bKilled;
    }

    public int getRowCount() {
        return this._nRows;
    }

    public float getVelocity(int branch, int iIndex) {
        return this.m_velocity[iIndex][branch];
    }

    public void setVelocity(int branch, int iIndex, float fVal) {
        this.m_velocity[iIndex][branch] = fVal;
    }

    public float getDelayTime(int branch, int iIndex) {
        return this.m_delayTime[iIndex][branch];
    }

    public void setDelayTime(int branch, int iIndex, float fVal) {
        this.m_delayTime[iIndex][branch] = fVal;
    }

    public float getDelayTime(int branch, int iIndex, double azimuth, boolean useAnisTerm, boolean useDipTerm) {
        if (!useAnisTerm) {
            return this.m_delayTime[iIndex][branch];
        }
        float dt = this.m_delayTime[iIndex][branch];
        float dtAnisAz = this.m_delayTimeAnisAz[iIndex][branch];
        float dtAnisMag = this.m_delayTimeAnisMag[iIndex][branch];
        double anis = (double)dtAnisMag * Math.cos(2.0 * (azimuth - (double)dtAnisAz));
        return dt + (float)anis;
    }

    public void copyDelayTimeData(int nMaxBranch, int[] ids, float[][] vel, float[][] dt, float[][] dtAnisAz, float[][] dtAnisMag, float[][] upholeCorrection, float[][] waterBottomCorrection) throws Exception {
        try {
            if (ids == null) {
                throw new Exception("null ids");
            }
            if (vel == null) {
                throw new Exception("null vel");
            }
            if (dt == null) {
                throw new Exception("null dt");
            }
            if (dtAnisAz == null) {
                throw new Exception("null dtAnisAz");
            }
            if (dtAnisMag == null) {
                throw new Exception("null dtAnisMag");
            }
            if (upholeCorrection == null) {
                throw new Exception("null upholeCorrection");
            }
            if (waterBottomCorrection == null) {
                throw new Exception("null waterBottomCorrection");
            }
            int nRows = ids.length;
            if (nRows != this._nRows) {
                throw new Exception("row count mismatch : source row count = " + Integer.toString(this._nRows) + " arg row count = " + Integer.toString(nRows));
            }
            if (this._nMaxBranch != nMaxBranch) {
                this._nMaxBranch = nMaxBranch;
                this.m_velocity = new float[this._nRows][this._nMaxBranch + 1];
                this.m_delayTime = new float[this._nRows][this._nMaxBranch + 1];
                this.m_delayTimeAnisAz = new float[this._nRows][this._nMaxBranch + 1];
                this.m_delayTimeAnisMag = new float[this._nRows][this._nMaxBranch + 1];
                this.UpholeCorrectionTime = new float[this._nRows][this._nMaxBranch + 1];
                this.WaterBottomCorrectionTime = new float[this._nRows][this._nMaxBranch + 1];
            }
            for (int i = 0; i < nRows; ++i) {
                int id = ids[i];
                int iRowIndex = this.getRowFromID(id);
                if (iRowIndex < 0) {
                    throw new Exception("could not find row index for id " + Integer.toString(id));
                }
                for (int iBranch = 0; iBranch <= nMaxBranch; ++iBranch) {
                    float fVel = vel[i][iBranch];
                    float delayTime = dt[i][iBranch];
                    float dtAnisAzVal = dtAnisAz[i][iBranch];
                    float dtAnisMagVal = dtAnisMag[i][iBranch];
                    float upholeCorrectionVal = upholeCorrection[i][iBranch];
                    float waterBottomCorrectionVal = waterBottomCorrection[i][iBranch];
                    this.m_velocity[iRowIndex][iBranch] = fVel;
                    this.m_delayTime[iRowIndex][iBranch] = delayTime;
                    this.m_delayTimeAnisAz[iRowIndex][iBranch] = dtAnisAzVal;
                    this.m_delayTimeAnisMag[iRowIndex][iBranch] = dtAnisMagVal;
                    this.UpholeCorrectionTime[iRowIndex][iBranch] = upholeCorrectionVal;
                    this.WaterBottomCorrectionTime[iRowIndex][iBranch] = waterBottomCorrectionVal;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void copyDelayTimesToDelayTimeData(int nMaxBranch, int[] ids, float[][] dt, double[] x, double[] y) throws Exception {
        int nRows = ids.length;
        if (nRows != this._nRows) {
            throw new Exception("row count mismatch : id rows : " + Integer.toString(nRows) + " table rows " + Integer.toString(this._nRows));
        }
        if (this._nMaxBranch != nMaxBranch) {
            throw new Exception("Max branch error");
        }
        for (int i = 0; i < nRows; ++i) {
            int id = ids[i];
            int iRowIndex = this.getRowFromID(id);
            if (iRowIndex < 0) {
                throw new Exception("could not find row index for id " + Integer.toString(id));
            }
            double xTest = x[i];
            double yTest = y[i];
            double dataX = this._easting[iRowIndex];
            double dataY = this._northing[iRowIndex];
            if (xTest != dataX || yTest != dataY) {
                throw new Exception("coordinate error dt");
            }
            for (int iBranch = 0; iBranch <= nMaxBranch; ++iBranch) {
                float delayTime;
                dt[i][iBranch] = delayTime = this.m_delayTime[iRowIndex][iBranch];
            }
        }
    }

    public void copyVelocitiesToDelayTimeData(int nMaxBranch, int[] ids, float[][] vels, double[] x, double[] y) throws Exception {
        int nRows = ids.length;
        if (nRows != this._nRows) {
            throw new Exception("row count mismatch : id rows : " + Integer.toString(nRows) + " table rows " + Integer.toString(this._nRows));
        }
        if (this._nMaxBranch != nMaxBranch) {
            throw new Exception("Max branch error");
        }
        for (int i = 0; i < nRows; ++i) {
            int id = ids[i];
            int iRowIndex = this.getRowFromID(id);
            if (iRowIndex < 0) {
                throw new Exception("could not find row index for id " + Integer.toString(id));
            }
            double xTest = x[i];
            double yTest = y[i];
            double dataX = this._easting[iRowIndex];
            double dataY = this._northing[iRowIndex];
            if (xTest != dataX || yTest != dataY) {
                throw new Exception("coordinate error vels");
            }
            for (int iBranch = 0; iBranch <= nMaxBranch; ++iBranch) {
                float vel;
                vels[i][iBranch] = vel = this.m_velocity[iRowIndex][iBranch];
            }
        }
    }

    public void shiftDelayTimes(int branch, double shift) throws Exception {
        try {
            for (int row = 0; row < this._nRows; ++row) {
                this.m_delayTime[row][branch] = this.m_delayTime[row][branch] + (float)shift;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public boolean ensureDelayTimesIncrease() throws Exception {
        boolean bModifiedDelayTime = false;
        try {
            for (int row = 0; row < this._nRows; ++row) {
                for (int branch = 2; branch <= this._nMaxBranch; ++branch) {
                    double delayTime2 = this.m_delayTime[row][branch];
                    double delayTime1 = this.m_delayTime[row][branch - 1];
                    if (!(delayTime2 < delayTime1 + 1.0)) continue;
                    this.m_delayTime[row][branch] = this.m_delayTime[row][branch - 1] + 1.0f;
                    bModifiedDelayTime = true;
                }
            }
            return bModifiedDelayTime;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void clearWaterBottomCorrections() throws Exception {
        try {
            for (int branch = 0; branch <= this._nMaxBranch; ++branch) {
                for (int row = 0; row < this._nRows; ++row) {
                    this.WaterBottomCorrectionTime[row][branch] = 0.0f;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void clearUpholeCorrections() throws Exception {
        try {
            for (int branch = 0; branch <= this._nMaxBranch; ++branch) {
                for (int row = 0; row < this._nRows; ++row) {
                    this.UpholeCorrectionTime[row][branch] = 0.0f;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }
}

