/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Synthetic;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Math.SyntheticLayerGenerator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class EnsembleWorker_SyntheticNMO
extends EnsembleWorker_Base
implements ActionListener {
    protected Ensemble m_inputEnsemble = null;
    protected LinearLayoutWidget m_mainWidget = null;
    protected ArrayList<JTextField> m_listVel;
    protected ArrayList<JTextField> m_listT0;
    protected ArrayList<JTextField> m_listEta;
    protected ArrayList<JTextField> m_listDir;
    protected ArrayList<JTextField> m_listPer;
    protected JTextField m_txtTime;
    protected static final int Count = 5;
    protected SyntheticLayerGenerator m_gen = new SyntheticLayerGenerator();

    public EnsembleWorker_SyntheticNMO() {
        try {
            this.Abbreviation = "SYNNMO";
            this.ShortDescription = "Synthetic NMO";
            this.WorkerType = "Synthetic";
            this.InteractiveFlowsOkay = true;
            this.RequiresRefractionStaticsProject = false;
            this.EnsembleSource = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_SyntheticNMO";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            this.getAll(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void getAll(boolean broadcast) {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.m_parameterTree.double_put("Time", Tools_Widget.extractDouble(this.m_txtTime, 3000.0, 1000.0, 6000.0));
            double priorVel = 500.0;
            for (int n = 0; n < 5; ++n) {
                double vel = Tools_Widget.extractDouble(this.m_listVel.get(n), priorVel + 100.0, priorVel + 10.0, priorVel + 5000.0);
                double t0 = Tools_Widget.extractDouble(this.m_listT0.get(n), 400.0, 10.0, 5000.0);
                double eta = Tools_Widget.extractDouble(this.m_listEta.get(n), 0.0, -2.0, 2.0);
                double dir = Tools_Widget.extractDouble(this.m_listDir.get(n), 0.0, -360.0, 360.0);
                double per = Tools_Widget.extractDouble(this.m_listPer.get(n), 0.0, 0.0, 20.0);
                this.m_parameterTree.double_put("V" + Integer.toString(n), vel);
                this.m_parameterTree.double_put("T" + Integer.toString(n), t0);
                this.m_parameterTree.double_put("E" + Integer.toString(n), eta);
                this.m_parameterTree.double_put("D" + Integer.toString(n), dir);
                this.m_parameterTree.double_put("P" + Integer.toString(n), per);
                priorVel = vel;
            }
            if (broadcast) {
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = LinearLayoutWidget.vert(3, null);
                double time = this.m_parameterTree.double_get("Time", 3000.0);
                this.m_txtTime = new JTextField(Double.toString(time));
                this.m_txtTime.addActionListener(this);
                this.m_mainWidget.addHorzPair(new JLabel("Trace length (ms)"), 0, this.m_txtTime, 10);
                this.m_listVel = new ArrayList();
                this.m_listT0 = new ArrayList();
                this.m_listEta = new ArrayList();
                this.m_listDir = new ArrayList();
                this.m_listPer = new ArrayList();
                for (int n = 0; n < 5; ++n) {
                    double v = this.m_parameterTree.double_get("V" + Integer.toString(n), 5000 + 500 * n);
                    double t = this.m_parameterTree.double_get("T" + Integer.toString(n), 500 + 300 * n);
                    this.m_listVel.add(new JTextField(Double.toString(v)));
                    this.m_listT0.add(new JTextField(Double.toString(t)));
                    this.m_listEta.add(new JTextField(0));
                    this.m_listDir.add(new JTextField(0));
                    this.m_listPer.add(new JTextField(0));
                }
                GridLayoutWidget grid = this.m_mainWidget.createGridLayoutWidget(0, null, 0);
                int row = 0;
                grid.addSimple(row++, new JLabel("RMS velocity"), new JLabel("T0"), new JLabel("Eta"), new JLabel("Direction"), new JLabel("Percent"));
                for (int n = 0; n < 5; ++n) {
                    this.m_listVel.get(n).addActionListener(this);
                    this.m_listT0.get(n).addActionListener(this);
                    this.m_listEta.get(n).addActionListener(this);
                    this.m_listDir.get(n).addActionListener(this);
                    this.m_listPer.get(n).addActionListener(this);
                    grid.addSimple(row++, this.m_listVel.get(n), this.m_listT0.get(n), this.m_listEta.get(n), this.m_listDir.get(n), this.m_listPer.get(n));
                }
                this.m_mainWidget.addStretch(10);
                Tools_FontChanger.changeSizeOfFont(this.m_mainWidget, -2, null, true);
                this.getParametersFromWidget();
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected double eta(double t0, double x, double v, double eta) {
        double t2 = 1.0E-6 * t0 * t0;
        double x2 = x * x;
        double a = 2.0 * eta * x2 * x2;
        double v2 = v * v;
        double b = 1.0E-20 + t2 * v2 + (1.0 + 2.0 * eta) * x2;
        double temp = t2 + (x2 - a / b) / v2;
        if (temp > 0.0) {
            return 1000.0 * Math.sqrt(temp);
        }
        return 0.0;
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            if (ensemble.traceCount() < 1) {
                return;
            }
            this.getAll(false);
            double time = this.m_parameterTree.double_get("Time", 3000.0);
            double digi = 4.0;
            int numSamples = (int)(0.5 + time / digi);
            float[] data = new float[numSamples];
            Random rand = new Random();
            int indexOffset = ensemble.dictionary().getEntryIndex("Trace", "Offset");
            int indexAzimuth = ensemble.dictionary().getEntryIndex("Trace", "Azimuth");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                for (int s = 0; s < numSamples; ++s) {
                    data[s] = 0.4f * (0.5f - (float)rand.nextDouble());
                }
                EnsembleTrace trace = ensemble.trace(n);
                double offset = trace.header().getDouble(indexOffset);
                double azimuth = trace.header().getDouble(indexAzimuth);
                for (int r = 0; r < 5; ++r) {
                    double e = this.m_parameterTree.double_get("E" + Integer.toString(r), 0.0);
                    double v = this.m_parameterTree.double_get("V" + Integer.toString(r), 5000 + 500 * r);
                    double t0 = 0.001 * this.m_parameterTree.double_get("T" + Integer.toString(r), 1000.0);
                    double dir = this.m_parameterTree.double_get("D" + Integer.toString(r), 0.0);
                    double per = this.m_parameterTree.double_get("P" + Integer.toString(r), 0.0);
                    dir = dir * Math.PI / 180.0;
                    double vfast = v * (1.0 + 0.01 * per);
                    double vslow = v * (1.0 - 0.01 * per);
                    double cos = Math.cos(dir - azimuth);
                    double sin = Math.sin(dir - azimuth);
                    double temp = cos * cos / (vfast * vfast) + sin * sin / (vslow * vslow);
                    v = 1.0 / Math.sqrt(temp);
                    double t = 0.001 * this.eta(1000.0 * t0, offset, v, e);
                    for (int s = 0; s < numSamples; ++s) {
                        float dt = (float)Math.abs(t - (double)s * 0.001 * digi);
                        float exp = (float)(Math.cos(dt / 0.007f) * Math.exp(0.0 - (double)(dt / 0.012f)));
                        data[s] = data[s] + 5.0f * exp;
                    }
                }
                trace.data().insertArray(data, numSamples);
                trace.data().setSampleInterval((float)digi);
                trace.data().setFirstSampleCoord(0.0f);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

