/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Synthetic;

import com.PecosCore.Data.Synthetic.SyntheticCreator;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EnsembleWorker_CreateSynthetic3D
extends EnsembleWorker_Base
implements ItemListener,
ActionListener,
DocumentListener {
    protected JTabbedPane m_mainWidget = null;
    protected Ensemble m_inputEnsemble = null;
    protected Ensemble m_ensemble = new Ensemble();
    protected JLabel m_shotCountLabel = new JLabel("Shot count");
    protected JLabel m_receiverCountLabel = new JLabel("Receiver count");
    protected JLabel m_shotFoldLabel = new JLabel("Shot fold");
    protected JLabel m_shotSpacingLabel = new JLabel("Shot spacing");
    protected JLabel m_shotLineSpacingLabel = new JLabel("Shot line spacing");
    protected JLabel m_receiverSpacingLabel = new JLabel("Receiver spacing");
    protected JLabel m_receiverLineSpacingLabel = new JLabel("Receiver line spacing");
    protected JLabel m_midpointXLabel = new JLabel("Survey midpoint X");
    protected JLabel m_midpointYLabel = new JLabel("Survey midpoint Y");
    protected JLabel m_h0Label = new JLabel("Weathering thickness");
    protected JLabel m_h1Label = new JLabel("Layer 1 thickness");
    protected JLabel m_h2Label = new JLabel("Layer 2 thickness");
    protected JLabel m_v0Label = new JLabel("Weathering velocity");
    protected JLabel m_v1Label = new JLabel("Refractor 1 velocity");
    protected JLabel m_v2Label = new JLabel("Refractor 2 velocity");
    protected JLabel m_v3Label = new JLabel("Refractor 3 velocity");
    protected JLabel m_labelSpace = new JLabel(" ");
    protected JTextField m_shotCountField = new JTextField(1000);
    protected JTextField m_receiverCountField = new JTextField(2000);
    protected JTextField m_shotFoldField = new JTextField(500);
    protected JTextField m_shotSpacingField = new JTextField(Double.toString(100.0));
    protected JTextField m_shotLineSpacingField = new JTextField(Double.toString(800.0));
    protected JTextField m_receiverSpacingField = new JTextField(Double.toString(100.0));
    protected JTextField m_receiverLineSpacingField = new JTextField(Double.toString(800.0));
    protected JTextField m_midpointXField = new JTextField(Double.toString(100000.0));
    protected JTextField m_midpointYField = new JTextField(Double.toString(100000.0));
    protected JTextField m_h0Field = new JTextField(Double.toString(300.0));
    protected JTextField m_h1Field = new JTextField(Double.toString(300.0));
    protected JTextField m_h2Field = new JTextField(Double.toString(300.0));
    protected JTextField m_v0Field = new JTextField(Double.toString(3000.0));
    protected JTextField m_v1Field = new JTextField(Double.toString(5000.0));
    protected JTextField m_v2Field = new JTextField(Double.toString(7000.0));
    protected JTextField m_v3Field = new JTextField(Double.toString(9000.0));
    protected JTextField m_timeField;
    protected long m_totalRead;
    protected int m_nextIndex = 0;
    protected JCheckBox m_chkCreateData = new JCheckBox();
    protected SyntheticCreator m_syntheticCreator;

    public EnsembleWorker_CreateSynthetic3D() {
        try {
            this.Abbreviation = "SYNTHFULL3D";
            this.ShortDescription = "Create 3D synthetic SEG-Y";
            this.WorkerType = "Input";
            this.InteractiveFlowsOkay = false;
            this.RequiresRefractionStaticsProject = false;
            this.EnsembleSource = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_CreateSynthetic3D";
    }

    @Override
    public boolean prepareSource() {
        try {
            this.m_nextIndex = 0;
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    @Override
    public boolean hasMoreEnsembles() {
        try {
            if (this.m_syntheticCreator == null) {
                this.m_syntheticCreator = new SyntheticCreator();
            }
            if (this.m_nextIndex == 0) {
                this.m_syntheticCreator.createGeometry(this.m_parameterTree);
                this.m_syntheticCreator.setVelocityModel(this.m_parameterTree);
            }
            if (this.m_nextIndex >= this.m_syntheticCreator.shotCount()) {
                return false;
            }
            int shotID = this.m_nextIndex + 1000;
            this.m_ensemble.clearTraces(false);
            this.getAll(false);
            this.m_syntheticCreator.createEnsemble(this.m_ensemble, shotID, this.m_chkCreateData.isSelected());
            ++this.m_nextIndex;
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    @Override
    public Ensemble nextEnsemble() {
        try {
            return this.m_ensemble;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        try {
            this.getParametersFromWidget();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            this.m_parameterTree.int_get(this.m_shotCountField, "ShotCount", 1000);
            this.m_parameterTree.int_get(this.m_receiverCountField, "ReceiverCount", 2000);
            this.m_parameterTree.int_get(this.m_shotFoldField, "ShotFold", 500);
            this.m_parameterTree.double_get(this.m_shotSpacingField, "ShotSpacing", 100.0);
            this.m_parameterTree.double_get(this.m_shotLineSpacingField, "ShotLineSpacing", 800.0);
            this.m_parameterTree.double_get(this.m_receiverSpacingField, "ReceiverSpacing", 100.0);
            this.m_parameterTree.double_get(this.m_receiverLineSpacingField, "ReceiverLineSpacing", 800.0);
            this.m_parameterTree.double_get(this.m_midpointXField, "MidpointX", 100000.0);
            this.m_parameterTree.double_get(this.m_midpointYField, "MidpointY", 100000.0);
            this.m_parameterTree.double_get(this.m_h0Field, "H0", 300.0);
            this.m_parameterTree.double_get(this.m_h1Field, "H1", 300.0);
            this.m_parameterTree.double_get(this.m_h2Field, "H2", 300.0);
            this.m_parameterTree.double_get(this.m_v0Field, "V0", 3000.0);
            this.m_parameterTree.double_get(this.m_v1Field, "V1", 5000.0);
            this.m_parameterTree.double_get(this.m_v2Field, "V2", 7000.0);
            this.m_parameterTree.double_get(this.m_v3Field, "V3", 9000.0);
            this.m_mainWidget = new JTabbedPane();
            GridLayoutWidget geom = new GridLayoutWidget(3, null);
            int row = 0;
            geom.addSimple(row++, this.m_shotCountLabel, this.m_shotCountField);
            geom.addSimple(row++, this.m_receiverCountLabel, this.m_receiverCountField);
            geom.addSimple(row++, this.m_shotFoldLabel, this.m_shotFoldField);
            geom.addSimple(row++, this.m_shotSpacingLabel, this.m_shotSpacingField);
            geom.addSimple(row++, this.m_shotLineSpacingLabel, this.m_shotLineSpacingField);
            geom.addSimple(row++, this.m_receiverSpacingLabel, this.m_receiverSpacingField);
            geom.addSimple(row++, this.m_receiverLineSpacingLabel, this.m_receiverLineSpacingField);
            geom.addSimple(row++, this.m_labelSpace, this.m_labelSpace);
            geom.addSimple(row++, this.m_midpointXLabel, this.m_midpointXField);
            geom.addSimple(row++, this.m_midpointYLabel, this.m_midpointYField);
            this.m_mainWidget.add((Component)geom, "Geometry");
            LinearLayoutWidget layer = LinearLayoutWidget.vert(3, null);
            this.m_chkCreateData.setSelected(this.m_parameterTree.bool_get("CreateData"));
            double time = this.m_parameterTree.double_get("Time", 2000.0);
            this.m_timeField = new JTextField(Double.toString(time));
            this.m_timeField.addActionListener(this);
            layer.addHorzPair(this.m_chkCreateData, 0, new JLabel("Create trace data"), 10);
            layer.addHorzPair(new JLabel("Trace length (ms)"), 0, this.m_timeField, 10);
            GridLayoutWidget grid = layer.createGridLayoutWidget(0, null, 0);
            int row2 = 0;
            grid.addSimple(row2++, this.m_h0Label, this.m_h0Field);
            grid.addSimple(row2++, this.m_h1Label, this.m_h1Field);
            grid.addSimple(row2++, this.m_h2Label, this.m_h2Field);
            grid.addSimple(row2++, this.m_labelSpace, this.m_labelSpace);
            grid.addSimple(row2++, this.m_v0Label, this.m_v0Field);
            grid.addSimple(row2++, this.m_v1Label, this.m_v1Field);
            grid.addSimple(row2++, this.m_v2Label, this.m_v2Field);
            grid.addSimple(row2++, this.m_v3Label, this.m_v3Field);
            this.m_mainWidget.add((Component)layer, "Layer");
            return this.m_mainWidget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            this.getAll(false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public double percentDone() {
        if (this.m_syntheticCreator != null) {
            return 100.0 * (double)this.m_nextIndex / (0.01 + (double)this.m_syntheticCreator.shotCount());
        }
        return 0.0;
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.getParametersFromWidget();
            this.broadcast(this, "Modified");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        try {
            this.getAll(false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        try {
            this.getAll(false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        try {
            this.getAll(false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void getAll(boolean broadcast) {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            int shotCount = Tools_Widget.extractInteger(this.m_shotCountField, 1000, 1, 1000000);
            int receiverCount = Tools_Widget.extractInteger(this.m_receiverCountField, 2000, 1, 3000000);
            int shotFold = Tools_Widget.extractInteger(this.m_shotFoldField, 500, 1, 10000000);
            double shotSpacing = Tools_Widget.extractDouble(this.m_shotSpacingField, 100.0, 1.0, 1000.0);
            double shotLineSpacing = Tools_Widget.extractDouble(this.m_shotLineSpacingField, 800.0, 1.0, 10000.0);
            double receiverSpacing = Tools_Widget.extractDouble(this.m_receiverSpacingField, 100.0, 1.0, 1000.0);
            double receiverLineSpacing = Tools_Widget.extractDouble(this.m_receiverLineSpacingField, 800.0, 1.0, 10000.0);
            double midpointX = Tools_Widget.extractDouble(this.m_midpointXField, 100000.0, 0.0, Double.MAX_VALUE);
            double midpointY = Tools_Widget.extractDouble(this.m_midpointYField, 100000.0, 0.0, Double.MAX_VALUE);
            double h0 = Tools_Widget.extractDouble(this.m_h0Field, 300.0, 1.0, 1.0E8);
            double h1 = Tools_Widget.extractDouble(this.m_h1Field, 300.0, 1.0, 1.0E8);
            double h2 = Tools_Widget.extractDouble(this.m_h2Field, 300.0, 1.0, 1.0E8);
            double v0 = Tools_Widget.extractDouble(this.m_v0Field, 3000.0, 50.0, 1000000.0);
            double v1 = Tools_Widget.extractDouble(this.m_v1Field, 5000.0, v0 + 1.0, 1000000.0);
            double v2 = Tools_Widget.extractDouble(this.m_v2Field, 7000.0, v1 + 1.0, 1000000.0);
            double v3 = Tools_Widget.extractDouble(this.m_v3Field, 9000.0, v2 + 1.0, 1000000.0);
            this.m_parameterTree.int_put("ShotCount", shotCount);
            this.m_parameterTree.int_put("ReceiverCount", receiverCount);
            this.m_parameterTree.int_put("ShotFold", shotFold);
            this.m_parameterTree.double_put("ShotSpacing", shotSpacing);
            this.m_parameterTree.double_put("ShotLineSpacing", shotLineSpacing);
            this.m_parameterTree.double_put("ReceiverSpacing", receiverSpacing);
            this.m_parameterTree.double_put("ReceiverLineSpacing", receiverLineSpacing);
            this.m_parameterTree.double_put("MidpointX", midpointX);
            this.m_parameterTree.double_put("MidpointY", midpointY);
            boolean createData = this.m_chkCreateData.isSelected();
            this.m_parameterTree.bool_put("CreateData", createData);
            double maxTime = Tools_Widget.extractDouble(this.m_timeField, 2000.0, 0.0, 20000.0);
            this.m_parameterTree.double_put("Time", maxTime);
            this.m_parameterTree.double_put("H0", h0);
            this.m_parameterTree.double_put("H1", h1);
            this.m_parameterTree.double_put("H2", h2);
            this.m_parameterTree.double_put("V0", v0);
            this.m_parameterTree.double_put("V1", v1);
            this.m_parameterTree.double_put("V2", v2);
            this.m_parameterTree.double_put("V3", v3);
            if (broadcast) {
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

