/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Selectors;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class EnsembleWorker_Decimator
extends EnsembleWorker_Base
implements GenericObjectListener.Listener,
ActionListener,
IParameterWidgetListener,
ItemListener {
    protected Ensemble m_inputEnsemble = null;
    protected LinearLayoutWidget m_mainWidget;
    protected JTextField m_txtDecimation;

    public EnsembleWorker_Decimator() {
        try {
            this.Abbreviation = "TSBHV";
            this.ShortDescription = "Trace selector: decimation";
            this.WorkerType = "Trace selection";
            this.InteractiveFlowsOkay = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_Decimator";
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void getAll(boolean broadcast) {
        try {
            this.m_parameterTree.int_put("Decimation", Tools_Widget.extractInteger(this.m_txtDecimation, 1, 1, 100));
            if (broadcast) {
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.getAll(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.getAll(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                String dec = this.m_parameterTree.string_get("Decimation", "10");
                this.m_txtDecimation = new JTextField(dec);
                this.m_txtDecimation.addActionListener(this);
                GridLayoutWidget grid = this.m_mainWidget.createGridLayoutWidget(3, 0);
                grid.addSimple(0, new JLabel("Decimation"), this.m_txtDecimation);
                this.m_mainWidget.addStretch(10);
                Tools_FontChanger.changeSizeOfFont(this.m_mainWidget, -2, null, true);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            int dec = this.m_parameterTree.int_get("Decimation", 10);
            for (int n = this.m_inputEnsemble.traceCount() - 1; n >= 0; --n) {
                boolean remove;
                boolean bl = remove = n % dec != 0;
                if (!remove) continue;
                this.m_inputEnsemble.removeTrace(n);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

