/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Picker;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Parameter.SliderWidget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Ensemble.Tools_Picking;
import com.PecosLibrary.Refraction.PickEvent;
import com.PecosLibrary.Refraction.PickerGizmo;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Refraction.Picking.PickEventCombo;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class EnsembleWorker_ThresholdPicker
extends EnsembleWorker_Base
implements IParameterWidgetListener,
ActionListener,
ItemListener,
GenericObjectListener.Listener {
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected JTabbedPane m_editorWidget;
    protected SliderWidget m_editor;
    protected JTextField m_nameText;
    protected PickEventCombo m_eventCombo;
    protected JButton m_launchButton;
    protected JCheckBox m_deviationCheck;
    protected JCheckBox m_applyTrendCheck;
    protected JTextField m_trendShiftText;
    protected JCheckBox m_windowLimitCheck;
    protected JTextField m_windowLimitText;
    protected JCheckBox m_checkOffsetLimit;
    protected JTextField m_textMinOffset;
    protected JTextField m_textMaxOffset;
    public boolean LaunchThreaded = false;
    protected String m_existsString = "Pick with that name already exists";

    public EnsembleWorker_ThresholdPicker() {
        try {
            this.FirstBreakAutoPicker = true;
            this.RequiresShotOrderedData = true;
            this.Abbreviation = "TAP";
            this.ShortDescription = "Threshold auto picker";
            this.WorkerType = "First break picking";
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_ThresholdPicker";
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_editorWidget == null) {
                return;
            }
            this.getAll(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_editorWidget == null) {
                RefractionStaticsProject project = RefractionStaticsProject.singleton();
                boolean projectOK = project.valid();
                this.m_editorWidget = new JTabbedPane();
                LinearLayoutWidget page = LinearLayoutWidget.vert(3, null);
                this.m_editorWidget.addTab("Main", page);
                double threshold = this.m_parameterTree.double_get("Threshold", 0.8);
                this.m_editor = new SliderWidget(this, null, "Threshold", 0, threshold, 0.01, 1.0);
                this.m_editor.setRangeLocked(false);
                Tools_FontChanger.changeSizeOfFont(this.m_editor, -1, null, true);
                page.addComponent(this.m_editor, 0);
                this.m_nameText = new JTextField("FBP_TAP");
                this.m_nameText.addActionListener(this);
                this.m_nameText.setEnabled(false);
                this.m_eventCombo = new PickEventCombo();
                this.m_eventCombo.listener().addListener(this);
                LinearLayoutWidget sub = page.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, "Pick name, event", 0);
                LinearLayoutWidget sub2 = sub.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null, 0);
                sub2.addComponent(new JLabel("Pick name"), 0);
                sub2.addComponent(this.m_nameText, 10);
                sub2.addComponent(new JLabel("Event"), 0);
                sub2.addComponent(this.m_eventCombo, 0);
                String txt = "";
                txt = projectOK ? "Start batch picker, add entry to trace table" : "Start batch picker, create ASCII pick file";
                this.m_launchButton = page.createButton(txt, this, 0);
                page.addStretch(10);
                if (projectOK) {
                    page = LinearLayoutWidget.vert(3, null);
                    this.m_editorWidget.addTab("Limits", page);
                    this.m_applyTrendCheck = new JCheckBox("Apply");
                    boolean trend = this.m_parameterTree.bool_get("ApplyTrend", false);
                    this.m_applyTrendCheck.setSelected(trend);
                    this.m_applyTrendCheck.addActionListener(this);
                    double maxShift = this.m_parameterTree.double_get("TrendError", 200.0);
                    this.m_trendShiftText = new JTextField("200");
                    this.m_trendShiftText.addActionListener(this);
                    sub = page.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, "Limits picks using linear moveout curves", 0);
                    sub.addComponent(new JLabel("Max error"), 0);
                    sub.addComponent(this.m_trendShiftText, 10);
                    sub.addComponent(this.m_applyTrendCheck, 0);
                    this.m_windowLimitCheck = new JCheckBox("Kill picks outside window: ");
                    this.m_windowLimitCheck.addActionListener(this);
                    boolean windowLimit = this.m_parameterTree.bool_get("WindowLimit", false);
                    this.m_windowLimitCheck.setSelected(windowLimit);
                    this.m_windowLimitText = new JTextField();
                    this.m_windowLimitText.addActionListener(this);
                    this.m_windowLimitText.setText("100");
                    if (this.m_parameterTree.double_exists("WindowLimitTime")) {
                        double windowLimitTime = this.m_parameterTree.double_get("WindowLimitTime", 100.0);
                        this.m_windowLimitText.setText(Double.toString(windowLimitTime));
                    }
                    sub = page.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, "Limits picks outside of time window (centered on zero)", 0);
                    sub.addComponent(this.m_windowLimitCheck, 0);
                    sub.addComponent(this.m_windowLimitText, 10);
                    this.m_windowLimitText.setEditable(this.m_windowLimitCheck.isSelected());
                    this.m_windowLimitText.setEnabled(this.m_windowLimitCheck.isSelected());
                    sub = page.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, "Minimize deviations (shot gathers only!)", 0);
                    this.m_deviationCheck = new JCheckBox("Minimize trace-to-trace pick deviations");
                    boolean deviants = this.m_parameterTree.bool_get("Deviation", false);
                    this.m_deviationCheck.setSelected(deviants);
                    this.m_deviationCheck.addActionListener(this);
                    sub.addComponent(this.m_deviationCheck, 0);
                    sub.addComponent(new JLabel("     Requires linear moveout trend curves "), 0);
                    page.addStretch(10);
                }
                page = LinearLayoutWidget.vert(3, null);
                this.m_editorWidget.addTab("Offset", page);
                GridLayoutWidget batchGrid = page.createGridLayoutWidget(0, "Offset limits (BATCH JOB ONLY!)", 0);
                int batchRow = 0;
                this.m_checkOffsetLimit = new JCheckBox("Apply offset limits");
                this.m_checkOffsetLimit.setSelected(this.m_parameterTree.bool_get("BatchApplyOffsetLimits", false));
                batchGrid.addComponent(this.m_checkOffsetLimit, batchRow, 1, 1.0, 10.0);
                this.m_textMinOffset = new JTextField(this.m_parameterTree.string_get("BatchMinOffset", "0"));
                this.m_textMaxOffset = new JTextField(this.m_parameterTree.string_get("BatchMaxOffset", "100000"));
                int n = ++batchRow;
                batchGrid.addSimple(n, new JLabel("Min offset"), this.m_textMinOffset);
                int n2 = ++batchRow;
                ++batchRow;
                batchGrid.addSimple(n2, new JLabel("Max offset"), this.m_textMaxOffset);
                page.addStretch(10);
                Tools_FontChanger.changeSizeOfFont(this.m_editorWidget, -2, null, true);
            }
            return this.m_editorWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void setOverwritePicks() {
        try {
            this.m_parameterTree.bool_put("Overwrite", true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_eventCombo) {
                if (!PickerGizmo.singleton().PickEventJustChanged) {
                    return;
                }
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void getAll(boolean broadcast) {
        try {
            this.m_parameterTree.double_put("Threshold", this.m_editor.getDoubleValue());
            this.m_parameterTree.string_put("Name", this.m_nameText.getText());
            this.m_parameterTree.bool_put("BatchApplyOffsetLimits", this.m_checkOffsetLimit.isSelected());
            this.m_parameterTree.double_put("BatchMinOffset", Tools_Widget.extractDouble(this.m_textMinOffset, 0.0, 0.0, 1000000.0));
            this.m_parameterTree.double_put("BatchMaxOffset", Tools_Widget.extractDouble(this.m_textMaxOffset, 0.0, 0.0, 1000000.0));
            if (this.m_deviationCheck != null) {
                this.m_parameterTree.bool_put("Deviation", this.m_deviationCheck.isSelected());
            }
            if (this.m_applyTrendCheck != null) {
                this.m_parameterTree.bool_put("ApplyTrend", this.m_applyTrendCheck.isSelected());
            }
            if (this.m_trendShiftText != null) {
                this.m_parameterTree.double_put("TrendError", Tools_Widget.extractDouble(this.m_trendShiftText, 200.0, 1.0, 1000.0));
            }
            if (this.m_windowLimitCheck != null) {
                this.m_parameterTree.bool_put("WindowLimit", this.m_windowLimitCheck.isSelected());
                this.m_parameterTree.double_put("WindowLimitTime", Tools_Widget.extractDouble(this.m_windowLimitText, 100.0, 0.0, 200000.0));
                this.m_windowLimitText.setEditable(this.m_windowLimitCheck.isSelected());
                this.m_windowLimitText.setEnabled(this.m_windowLimitCheck.isSelected());
            }
            if (broadcast) {
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String getColumnName() {
        try {
            return "FBP_TAP";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "";
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (this.m_launchButton == e.getSource()) {
                this.LaunchThreaded = false;
                this.getAll(false);
                this.broadcast(this, "SendMessageToOwner");
                return;
            }
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            boolean windowLimit;
            boolean applyOffsetLimits = false;
            double minOffset = 0.0;
            double maxOffset = 100000.0;
            boolean bRunningInGeospark = this.getIsRunningInGeoSpark();
            if (this.SharedData != null && this.SharedData.Batch) {
                applyOffsetLimits = this.m_parameterTree.bool_get("BatchApplyOffsetLimits", false);
                minOffset = this.m_parameterTree.double_get("BatchMinOffset", 0.0);
                maxOffset = this.m_parameterTree.double_get("BatchMaxOffset", 0.0);
                if (applyOffsetLimits) {
                    ensemble.filter("Trace", "Offset", minOffset, maxOffset);
                }
            }
            boolean projectOK = false;
            if (!bRunningInGeospark) {
                RefractionStaticsProject project = RefractionStaticsProject.singleton();
                projectOK = project.valid();
            }
            this.m_inputEnsemble = ensemble;
            boolean deviation = this.m_parameterTree.bool_get("Deviation", false);
            double threshold = this.m_parameterTree.double_get("Threshold", 0.8);
            threshold = Math.max(threshold, 0.01);
            threshold = Math.min(threshold, 0.99);
            String name = "FBP_TAP";
            String event = this.m_parameterTree.string_get("Event", PickEvent.Peak.name());
            boolean overwrite = this.m_parameterTree.bool_get("Overwrite", false);
            boolean trend = this.m_parameterTree.bool_get("ApplyTrend", false);
            double maxShift = this.m_parameterTree.double_get("TrendError", 200.0);
            PickEvent pe = PickerGizmo.singleton().pickEvent();
            Tools_Picking.makeThresholdPicks(ensemble, name, pe, (float)threshold, trend, 0.0f, (float)maxShift, applyOffsetLimits, minOffset, maxOffset);
            if (deviation) {
                Tools_Picking.minimizeDeviancy(ensemble, name, pe);
            }
            if (windowLimit = this.m_parameterTree.bool_get("WindowLimit", false)) {
                double window = this.m_parameterTree.double_get("WindowLimitTime", 100.0);
                Tools_Picking.killPicksOutsideTimeWindow(ensemble, name, 0.0f, (float)window);
            }
            ensemble.pickPlotData().addRequiredPick(name);
            if (!projectOK) {
                ensemble.pickPlotData().add(name, Color.red, 9, Java2D_PointSymbol.FilledOval);
            }
            this.IasAutopicker = true;
            this.AutopickerColumnName = name;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

