/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Picker;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeData;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class EnsembleWorker_PredictedDelayTime
extends EnsembleWorker_Base
implements IParameterWidgetListener,
ActionListener {
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected LinearLayoutWidget m_mainWidget;
    protected JCheckBox m_velCheck;
    protected JCheckBox m_dtCheck;
    protected JCheckBox m_dtAnisCheck;
    protected JCheckBox m_upCheck;
    protected JCheckBox m_wbCheck;

    public EnsembleWorker_PredictedDelayTime() {
        try {
            this.Abbreviation = "DT";
            this.ShortDescription = "Predict delay time picks";
            this.WorkerType = "First break picking";
            this.InteractiveFlowsOkay = true;
            this.RequiresRefractionStaticsProject = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_PredictedDelayTime";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.getParametersFromWidget();
            this.broadcast(this, "Modified");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.m_parameterTree.bool_put("ApplyVelocities", this.m_velCheck.isSelected());
            this.m_parameterTree.bool_put("ApplyDelayTimeAnisotropy", this.m_dtAnisCheck.isSelected());
            this.m_parameterTree.bool_put("ApplyDelayTimes", this.m_dtCheck.isSelected());
            this.m_parameterTree.bool_put("ApplyUphole", this.m_upCheck.isSelected());
            this.m_parameterTree.bool_put("ApplyWaterBottom", this.m_wbCheck.isSelected());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                String s = "<HTML>Traces not assigned to a branch will NOT have a predicted pick</HTML>";
                JLabel lbl = new JLabel(s);
                this.m_mainWidget.addComponent(lbl, 0);
                this.m_mainWidget.createGapLabel(15);
                s = "<HTML><font color=\"red\">If no traces in the selected group are assigned to a branch then no picks will be predicted. </font></HTML>";
                lbl = new JLabel(s);
                this.m_mainWidget.addComponent(lbl, 0);
                this.m_mainWidget.createGapLabel(15);
                boolean applyDelayTimes = this.m_parameterTree.bool_get("ApplyDelayTimes", true);
                boolean applyDelayTimeAnis = this.m_parameterTree.bool_get("ApplyDelayTimeAnisotropy", true);
                boolean applyVelocities = this.m_parameterTree.bool_get("ApplyVelocities", true);
                boolean applyUphole = this.m_parameterTree.bool_get("ApplyUphole", true);
                boolean applyWB = this.m_parameterTree.bool_get("ApplyWaterBottom", true);
                this.m_velCheck = new JCheckBox("Apply refractor travel time");
                this.m_dtCheck = new JCheckBox("Apply delay times");
                this.m_dtAnisCheck = new JCheckBox("Apply delay time anisotropy");
                this.m_upCheck = new JCheckBox("Apply uphole correction term");
                this.m_wbCheck = new JCheckBox("Apply water bottom correction term");
                this.m_velCheck.setSelected(applyVelocities);
                this.m_dtCheck.setSelected(applyDelayTimes);
                this.m_upCheck.setSelected(applyUphole);
                this.m_dtAnisCheck.setSelected(applyDelayTimeAnis);
                this.m_wbCheck.setSelected(applyWB);
                this.m_mainWidget.addComponent(this.m_velCheck, 0);
                this.m_mainWidget.addComponent(this.m_dtCheck, 0);
                this.m_mainWidget.addComponent(this.m_dtAnisCheck, 0);
                this.m_mainWidget.addComponent(this.m_upCheck, 0);
                this.m_mainWidget.addComponent(this.m_wbCheck, 0);
                this.m_velCheck.addActionListener(this);
                this.m_dtCheck.addActionListener(this);
                this.m_upCheck.addActionListener(this);
                this.m_dtAnisCheck.addActionListener(this);
                this.m_wbCheck.addActionListener(this);
                this.m_mainWidget.addStretch(10);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            if (!RefractionStaticsProject.singleton().valid()) {
                return;
            }
            DelayTimeData dtd = RefractionStaticsProject.delayTimeData();
            if (dtd.branchAssignment().maxBranch() < 1) {
                this.Success = false;
                this.Reason = "Branch no valid";
                return;
            }
            boolean applyDelayTimes = this.m_parameterTree.bool_get("ApplyDelayTimes", true);
            boolean applyVelocities = this.m_parameterTree.bool_get("ApplyVelocities", true);
            boolean applyUphole = this.m_parameterTree.bool_get("ApplyUphole", true);
            boolean applyDelayTimeAnis = this.m_parameterTree.bool_get("ApplyDelayTimeAnisotropy", true);
            boolean applyWB = this.m_parameterTree.bool_get("ApplyWaterBottom", true);
            dtd.predictPicks(ensemble, applyDelayTimes, applyVelocities, applyUphole, applyDelayTimeAnis, applyWB);
            ensemble.pickPlotData().addRequiredPick("FBP_PredDelayTime");
            ensemble.pickPlotData().add("FBP_PredDelayTime", Color.blue, 9, Java2D_PointSymbol.X);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

