/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Picker;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Shared.RadioPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EnsembleWorker_EnergyEnvelope
extends EnsembleWorker_Base
implements IParameterWidgetListener,
ActionListener,
ItemListener,
ChangeListener,
GenericObjectListener.Listener {
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = new float[10];
    protected float[] m_energy = new float[10];
    protected float[] m_firstDeriv = new float[10];
    protected float[] m_secondDeriv = new float[10];
    protected LinearLayoutWidget m_mainWidget;
    protected RadioPanel m_outputPanel;
    protected SpinnerNumberModel m_model;
    protected JSpinner m_spinner;

    public EnsembleWorker_EnergyEnvelope() {
        try {
            this.FirstBreakAutoPicker = true;
            this.Abbreviation = "EEPICKER";
            this.ShortDescription = "Energy envelope picker";
            this.WorkerType = "First break picking";
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_EnergyEnvelope";
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.getAll(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                RefractionStaticsProject project = RefractionStaticsProject.singleton();
                boolean projectOK = project.valid();
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                this.m_outputPanel = new RadioPanel(LinearLayoutWidget.Direction.Horizontal, "Output", "Input", "First derivative", "Second derivative");
                this.m_mainWidget.addComponent(this.m_outputPanel, 0);
                this.m_outputPanel.listener().addListener(this);
                this.m_model = new SpinnerNumberModel(1, 1, 20, 1);
                this.m_spinner = new JSpinner(this.m_model);
                this.m_mainWidget.addHorzPair(new JLabel("Second derivative step count"), 2, this.m_spinner, 2);
                this.m_spinner.addChangeListener(this);
                this.m_mainWidget.addStretch(10);
                Tools_FontChanger.changeSizeOfFont(this.m_mainWidget, -2, null, true);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void setOverwritePicks() {
        try {
            this.m_parameterTree.bool_put("Overwrite", true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void getAll(boolean broadcast) {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.m_parameterTree.int_put("Output", this.m_outputPanel.getSelectedIndex());
            this.m_parameterTree.int_put("Steps", this.m_model.getNumber().intValue());
            if (broadcast) {
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String getColumnName() {
        try {
            return "FBP_AMP";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "";
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            boolean projectOK = project.valid();
            this.m_inputEnsemble = ensemble;
            int output = this.m_parameterTree.int_get("Output", 0);
            int steps = this.m_parameterTree.int_get("Steps", 0);
            for (int n = 0; n < this.m_inputEnsemble.traceCount(); ++n) {
                int s;
                EnsembleTrace trace = this.m_inputEnsemble.trace(n);
                int len = trace.data().length();
                if (len > this.m_tempArray.length) {
                    this.m_tempArray = new float[len + 100];
                    this.m_energy = new float[len + 100];
                    this.m_firstDeriv = new float[len + 100];
                    this.m_secondDeriv = new float[len + 100];
                }
                trace.data().copyToArray(this.m_tempArray);
                this.m_energy[0] = this.m_tempArray[0] * this.m_tempArray[0];
                for (s = 1; s < len; ++s) {
                    this.m_energy[s] = this.m_energy[s - 1] + this.m_tempArray[s] * this.m_tempArray[s];
                }
                for (s = 0; s < len; ++s) {
                    this.m_firstDeriv[s] = this.m_tempArray[s] * this.m_tempArray[s];
                }
                for (s = 0; s <= steps; ++s) {
                    this.m_secondDeriv[s] = 0.0f;
                    this.m_secondDeriv[len - 1 - s] = 0.0f;
                }
                for (s = steps + 1; s < len - 1 - steps; ++s) {
                    float sum = 0.0f;
                    for (int step = 1; step <= steps; ++step) {
                        float secondDeriv = (this.m_firstDeriv[s + step] - this.m_firstDeriv[s - step]) / (float)(2 * step);
                        sum += secondDeriv;
                    }
                    this.m_secondDeriv[s] = sum / (float)steps;
                }
                if (output == 1) {
                    trace.data().insertArray(this.m_firstDeriv, len);
                }
                if (output != 2) continue;
                trace.data().insertArray(this.m_secondDeriv, len);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

