/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Output;

import com.PecosCore.Data.DataType;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import javax.swing.JComponent;

public class EnsembleWorker_PickFileOutput
extends EnsembleWorker_Base {
    protected Ensemble m_inputEnsemble = null;
    protected String m_currentParentFileName = "";
    protected String m_currentPickFileName = "";
    protected PrintWriter m_printWriter;

    public EnsembleWorker_PickFileOutput() {
        try {
            this.Abbreviation = "PFO";
            this.ShortDescription = "Write picks to ASCII file";
            this.WorkerType = "Output";
            this.RequiresRefractionStaticsProject = true;
            this.InteractiveFlowsOkay = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_PickFileOutput";
    }

    public void setColumnName(String column) {
        try {
            this.m_parameterTree.string_put("ColumnName", column);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
    }

    @Override
    public boolean hasEditorWidget() {
        return false;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        return null;
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            String column = this.m_parameterTree.string_get("ColumnName", "");
            if (!this.m_inputEnsemble.dictionary().containsEntry("Trace", column)) {
                return;
            }
            if (!this.SharedData.Extra.containsKey("FileName")) {
                return;
            }
            String fileName = (String)this.SharedData.Extra.get("FileName");
            if (!fileName.equalsIgnoreCase(this.m_currentParentFileName)) {
                if (this.m_printWriter != null) {
                    this.m_printWriter.close();
                }
                this.m_currentParentFileName = fileName;
                this.m_currentPickFileName = fileName + "_" + column;
                if (Tools_FileSystem.exists_file(this.m_currentPickFileName)) {
                    Tools_FileSystem.deleteFile(this.m_currentPickFileName);
                }
                FileWriter fw = new FileWriter(this.m_currentPickFileName);
                this.m_printWriter = new PrintWriter(new BufferedWriter(fw));
            }
            int index = this.m_inputEnsemble.dictionary().getEntryIndex("Trace", column);
            DataType type = this.m_inputEnsemble.dictionary().getPreferredType("Trace", column);
            for (int n = 0; n < this.m_inputEnsemble.traceCount(); ++n) {
                EnsembleTrace trace = this.m_inputEnsemble.trace(n);
                if (type == DataType.Int || type == DataType.Short) {
                    int v = trace.header().getInt(index);
                    this.m_printWriter.println(v);
                    continue;
                }
                double v = trace.header().getDouble(index);
                this.m_printWriter.println(v);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

