/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Moveout;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Parameter.SliderWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class EnsembleWorker_ApplyMoveoutTrend
extends EnsembleWorker_Base
implements IParameterWidgetListener,
Messenger.Listener,
ActionListener {
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected LinearLayoutWidget m_mainWidget;
    protected JCheckBox m_endpointCheck;
    protected SliderWidget m_editor;

    public EnsembleWorker_ApplyMoveoutTrend() {
        try {
            this.Abbreviation = "MOT";
            this.ShortDescription = "Apply moveout trend";
            this.WorkerType = "Moveout";
            this.InteractiveFlowsOkay = true;
            this.RequiresRefractionStaticsProject = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_ApplyMoveoutTrend";
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            if (message == Messenger.Message.MoveoutTrendModified) {
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_endpointCheck) {
                this.getParametersFromWidget();
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            if (this.m_endpointCheck != null) {
                this.m_parameterTree.bool_put("Endpoint", this.m_endpointCheck.isSelected());
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                this.m_mainWidget.addStretch(10);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            boolean endpoint = this.m_parameterTree.bool_get("Endpoint", false);
            RefractionStaticsProject.singleton().moveoutTrendData().applyShifts(this.m_inputEnsemble, false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

