/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.ModelTimeShifts;

import com.PecosCore.Data.DataType;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.GLI.GliModel;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;

public class EnsembleWorker_GLI
extends EnsembleWorker_Base
implements IParameterWidgetListener,
ActionListener,
GenericObjectListener.Listener,
Messenger.Listener {
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected LinearLayoutWidget m_mainWidget;
    protected int m_currentID = -9999;

    public EnsembleWorker_GLI() {
        try {
            this.RequiresShotOrderedData = true;
            this.Abbreviation = "DT";
            this.ShortDescription = "Apply GLI model time shifts";
            this.WorkerType = "Model/analysis time shifts";
            this.InteractiveFlowsOkay = true;
            this.RequiresRefractionStaticsProject = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_GLI";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.getParametersFromWidget();
            this.broadcast(this, "Modified");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setResidual(boolean on) {
        try {
            this.m_parameterTree.bool_put("Residual", on);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                Messenger.singleton().addListener(this);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            if (this.m_inputEnsemble.traceCount() < 1) {
                return;
            }
            if (!RefractionStaticsProject.singleton().valid()) {
                return;
            }
            GliModel model = RefractionStaticsProject.singleton().getGliModel();
            if (!model.initialized()) {
                model.testNewModel();
            }
            for (int n = 1; n <= model.LayerCount(); ++n) {
                model.computeSRTimes(n);
            }
            boolean residual = this.m_parameterTree.bool_get("Residual", true);
            if (model == null) {
                this.Reason = "Model not selected";
                this.Success = false;
                return;
            }
            int indexShotKilled = this.m_inputEnsemble.dictionary().getEntryIndex("Shot", "Killed");
            int indexShotID = -9999;
            if (this.m_inputEnsemble.dictionary().containsEntry("Shot", "ShotID")) {
                indexShotID = this.m_inputEnsemble.dictionary().getEntryIndex("Shot", "ShotID");
            }
            int indexRecKilled = this.m_inputEnsemble.dictionary().getEntryIndex("Receiver", "Killed");
            int indexRecID = -9999;
            if (this.m_inputEnsemble.dictionary().containsEntry("Receiver", "ReceiverID")) {
                indexRecID = this.m_inputEnsemble.dictionary().getEntryIndex("Receiver", "ReceiverID");
            }
            int indexShift = this.m_inputEnsemble.dictionary().addEntry("Trace", "TomoTime", DataType.Double);
            int indexMaxDepth = this.m_inputEnsemble.dictionary().addEntry("Trace", "MaxRayDepth", DataType.Double);
            boolean numBad = false;
            boolean crap = false;
            for (int n = 0; n < this.m_inputEnsemble.traceCount(); ++n) {
                EnsembleTrace trace = this.m_inputEnsemble.trace(n);
                boolean killed = trace.header().getBool(indexShotKilled) || trace.header().getBool(indexRecKilled);
                int shotID = trace.header().getInt(indexShotID);
                int receiverID = trace.header().getInt(indexRecID);
                float travelTime = 0.0f;
                float maxDepth = 0.0f;
                if (killed) continue;
                try {
                    travelTime = 1000.0f * (float)model.rayTrace_ensembleWorker(shotID, receiverID);
                    trace.data().addShiftToFirstSampleCoord(-travelTime);
                    continue;
                }
                catch (Exception exx) {
                    travelTime = 0.0f;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

