/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Gravity;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Parameter.SliderWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class EnsembleWorker_ResidualGravityTest
extends EnsembleWorker_Base
implements IParameterWidgetListener {
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected LinearLayoutWidget m_mainWidget;
    protected SliderWidget m_editor;

    public EnsembleWorker_ResidualGravityTest() {
        try {
            this.Abbreviation = "RG";
            this.ShortDescription = "Residual gravity analysis";
            this.WorkerType = "Gravity";
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_ResidualGravityTest";
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getParametersFromWidget();
            this.broadcast(this, "Modified");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.m_parameterTree.double_put("V0", this.m_editor.getDoubleValue());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                double velocity = this.m_parameterTree.double_get("V0", 2000.0);
                this.m_editor = new SliderWidget(this, null, "Weathering velocity", 0, velocity, 200.0, 12000.0);
                this.m_editor.setRangeLocked(false);
                Object s = "<HTML>";
                s = (String)s + "Note - this process will not work until you create a statics field in  the \"Delay Time Model\" window. It does the following:<br />";
                s = (String)s + "1) Compute a temporary refractor model using the selected weathering velocity.<br />";
                s = (String)s + "2) Compute statics through the temporary refractor model.<br />";
                s = (String)s + "3) Force these statics to be zero-mean.<br />";
                s = (String)s + "4) Apply the statics to the shot and detectors.<br />";
                s = (String)s + "5) Compute a residual gravity field at each CMP location.<br />";
                s = (String)s + "</HTML>";
                this.m_mainWidget.addComponent(this.m_editor, 0);
                this.m_mainWidget.createGapLabel(20);
                this.m_mainWidget.addComponent(new JLabel((String)s), 10);
                Tools_FontChanger.changeSizeOfFont(this.m_mainWidget, -1, null, true);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            double velocity = this.m_parameterTree.double_get("V0", 0.0);
            if (Math.abs(velocity) < 0.001) {
                this.Success = false;
                this.Reason = "Velocity too small";
                return;
            }
            boolean ok = Tools_Ensemble.applyLinearMoveout(ensemble, velocity);
            if (!ok) {
                this.Success = false;
                this.Reason = "Offset header value not valid";
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

