/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Filter;

import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Parameter.SliderWidget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Math.Filter.FilterResponse_Notch;
import com.PecosLibrary.Math.Filter.ZeroPhaseFilter_TimeDomain;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class EnsembleWorker_NotchFilter
extends EnsembleWorker_Base
implements IParameterWidgetListener,
ActionListener {
    protected ZeroPhaseFilter_TimeDomain m_filter = new ZeroPhaseFilter_TimeDomain();
    protected FilterResponse_Notch m_response = new FilterResponse_Notch();
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected LinearLayoutWidget m_mainWidget;
    protected SliderWidget m_freqSlider;
    protected SliderWidget m_widthSlider;
    protected JTextField m_lengthText;

    public EnsembleWorker_NotchFilter() {
        try {
            this.Abbreviation = "BWLP";
            this.ShortDescription = "Notch filter";
            this.WorkerType = "Filter";
            this.m_filter.setResponse(this.m_response);
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_NotchFilter";
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_lengthText) {
                this.getAll(true);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void getAll(boolean broadcast) {
        try {
            int len = Tools_Widget.extractInteger(this.m_lengthText, 41, 11, 121);
            this.m_parameterTree.int_put("Length", len);
            this.m_parameterTree.double_put("Frequency", this.m_freqSlider.getDoubleValue());
            this.m_parameterTree.double_put("Width", this.m_widthSlider.getDoubleValue());
            if (broadcast) {
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.getAll(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                double freq = this.m_parameterTree.double_get("Frequency", 60.0);
                this.m_freqSlider = new SliderWidget(this, null, "Center frequency", 0, freq, 1.0, 120.0);
                this.m_freqSlider.setRangeLocked(false);
                Tools_FontChanger.changeSizeOfFont(this.m_freqSlider, -1, null, true);
                this.m_mainWidget.addComponent(this.m_freqSlider, 0);
                double w = this.m_parameterTree.double_get("Width", 2.0);
                this.m_widthSlider = new SliderWidget(this, null, "Notch width", 0, w, 1.0, 20.0);
                this.m_widthSlider.setRangeLocked(false);
                Tools_FontChanger.changeSizeOfFont(this.m_widthSlider, -1, null, true);
                this.m_mainWidget.addComponent(this.m_widthSlider, 0);
                GridLayoutWidget grid = this.m_mainWidget.createGridLayoutWidget(3, 0);
                int filterLen = this.m_parameterTree.int_get("Length", 41);
                this.m_lengthText = new JTextField(Integer.toString(filterLen));
                this.m_lengthText.addActionListener(this);
                grid.addSimple(0, new JLabel("Filter length (samples)"), this.m_lengthText);
                this.m_mainWidget.addStretch(10);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            int filterLen = this.m_parameterTree.int_get("Length", 41);
            double freq = this.m_parameterTree.double_get("Frequency", 60.0);
            double w = this.m_parameterTree.double_get("Width", 2.0);
            this.m_response.setCenter((float)freq);
            this.m_response.setWidth((float)w);
            this.m_filter.setFilterLength(filterLen);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                if (!trace.hasData()) continue;
                FloatArrayWrapper data = trace.data();
                if (this.m_tempArray == null) {
                    this.m_tempArray = new float[data.length()];
                }
                if (this.m_tempArray.length != data.length()) {
                    this.m_tempArray = new float[data.length()];
                }
                data.copyToArray(this.m_tempArray);
                this.m_filter.setDigi(data.getSampleInterval());
                this.m_filter.apply(this.m_tempArray, this.m_tempArray.length);
                data.insertArray(this.m_tempArray, this.m_tempArray.length);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

