/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Filter;

import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.FFT.FFT_1D_Wrapper;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class EnsembleWorker_FrequencySpikeRemoval
extends EnsembleWorker_Base
implements IParameterWidgetListener,
ActionListener {
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected FFT_1D_Wrapper m_fft = new FFT_1D_Wrapper(32);
    protected LinearLayoutWidget m_mainWidget;
    protected JTextField m_thresholdText;

    public EnsembleWorker_FrequencySpikeRemoval() {
        try {
            this.Abbreviation = "BP";
            this.ShortDescription = "Frequency spike removal";
            this.WorkerType = "Filter";
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_FrequencySpikeRemoval";
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void getAll(boolean broadcast) {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            float t = (float)Tools_Widget.extractDouble(this.m_thresholdText, 20.0, 10.0, 200.0);
            this.m_parameterTree.double_put("Threshold", t);
            if (broadcast) {
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.getAll(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                float t = (float)this.m_parameterTree.double_get("Threshold", 20.0);
                this.m_thresholdText = new JTextField(Float.toString(t));
                this.m_thresholdText.addActionListener(this);
                this.m_mainWidget.addComponent(new JLabel("Threshold (>= 10)"), 0);
                this.m_mainWidget.addComponent(this.m_thresholdText, 0);
                this.m_mainWidget.addStretch(10);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            float t = (float)this.m_parameterTree.double_get("Threshold", 20.0);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                if (!trace.hasData()) continue;
                FloatArrayWrapper data = trace.data();
                if (this.m_tempArray == null) {
                    this.m_tempArray = new float[data.length()];
                }
                if (this.m_tempArray.length != data.length()) {
                    this.m_tempArray = new float[data.length()];
                }
                data.copyToArray(this.m_tempArray);
                this.m_fft.removeFrequencySpikes(this.m_tempArray, t);
                data.insertArray(this.m_tempArray, this.m_tempArray.length);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

