/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Filter;

import com.PecosCore.Data.ArrayRenormalization;
import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Data.Seismic.CubicTraceInterpolator;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleGroupManager;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.FFT.FFT_2D_Wrapper;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Parameter.SliderWidget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Ensemble.Worker.QC.EnsembleWorker_FourierPeakAnalysis;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class EnsembleWorker_FFT_2D
extends EnsembleWorker_Base
implements IParameterWidgetListener,
ActionListener,
ItemListener {
    EnsembleWorker_FourierPeakAnalysis m_frequencySpike = new EnsembleWorker_FourierPeakAnalysis();
    protected FFT_2D_Wrapper m_fft = new FFT_2D_Wrapper();
    protected ArrayRenormalization m_renorm = new ArrayRenormalization();
    protected ArrayList<DataInfo> m_dataList = new ArrayList();
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected LinearLayoutWidget m_mainWidget;
    protected SliderWidget m_slider_trace;
    protected SliderWidget m_slider_time;
    protected JTextField m_text_noise_window;
    protected JTextField m_text_noise_cutoff;
    protected JTextField m_text_time0;
    protected JTextField m_text_window;
    protected float[] m_tempTraceArray = new float[20];
    protected int m_num_valid = 0;
    double m_off_cutoff = 0.2;
    double m_time_cutoff = 0.2;
    double m_t0 = 0.2;
    double m_window_time = 0.2;
    int m_window_samples = 100;
    double m_noise_window = 0.2;
    double m_noise_cutoff = 0.2;

    public EnsembleWorker_FFT_2D() {
        try {
            this.RequiresShotOrderedData = true;
            this.Abbreviation = "FFT2D";
            this.ShortDescription = "2D FFT";
            this.WorkerType = "Filter";
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_FFT_2D";
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.getAll(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = LinearLayoutWidget.vert(0, null);
                RefractionStaticsProject project = RefractionStaticsProject.singleton();
                boolean projectOK = project.valid();
                String s = "<HTML>This process requires moveout (linear, trend, tomo, etc). <br> It works by first sorting the traces using (Receiver,LineNumber) and (Receiver,PointNumber).</HTML>";
                JLabel lbl = new JLabel(s);
                lbl.setForeground(Color.blue);
                lbl.setBorder(BorderFactory.createRaisedBevelBorder());
                this.m_mainWidget.addComponent(lbl, 0);
                int off_cutoff = (int)this.m_parameterTree.double_get("m_slider_trace", 20.0);
                this.m_slider_trace = new SliderWidget(this, null, "Wavenumber cutoff, trace axis ( between 1 and 99)", 0, off_cutoff, 1.0, 99.0);
                this.m_slider_trace.setRangeLocked(true);
                Tools_FontChanger.changeSizeOfFont(this.m_slider_trace, 0, null, true);
                this.m_mainWidget.addComponent(this.m_slider_trace, 0);
                int time_cutoff = (int)this.m_parameterTree.double_get("m_slider_time", 20.0);
                this.m_slider_time = new SliderWidget(this, null, "Wavenumber cutoff, time axis ( between 1 and 99)", 0, time_cutoff, 1.0, 99.0);
                this.m_slider_time.setRangeLocked(true);
                Tools_FontChanger.changeSizeOfFont(this.m_slider_time, 0, null, true);
                this.m_mainWidget.addComponent(this.m_slider_time, 0);
                GridLayoutWidget grid = this.m_mainWidget.createGridLayoutWidget(3, 0);
                int row = 0;
                double v = this.m_parameterTree.double_get_range("m_text_time0", -300.0, -2000.0, 0.0);
                this.m_text_time0 = new JTextField(Double.toString(v));
                this.m_text_time0.addActionListener(this);
                grid.addComponent(new JLabel("Window time (ms)"), row, 0);
                grid.addComponent(this.m_text_time0, row++, 1, 0.0, 10.0, 1, 1);
                v = this.m_parameterTree.double_get_range("m_text_window", 500.0, 200.0, 2000.0);
                this.m_text_window = new JTextField(Double.toString(v));
                this.m_text_window.addActionListener(this);
                grid.addComponent(new JLabel("Window length (ms)"), row, 0);
                grid.addComponent(this.m_text_window, row++, 1, 0.0, 10.0, 1, 1);
                v = this.m_parameterTree.double_get_range("m_text_noise_window", 200.0, 50.0, 2000.0);
                this.m_text_noise_window = new JTextField(Double.toString(v));
                this.m_text_noise_window.addActionListener(this);
                grid.addComponent(new JLabel("Noise analysis window (ms)"), row, 0);
                grid.addComponent(this.m_text_noise_window, row++, 1, 0.0, 10.0, 1, 1);
                v = this.m_parameterTree.double_get_range("m_text_noise_cutoff", 0.7, 0.01, 0.99);
                this.m_text_noise_cutoff = new JTextField(Double.toString(v));
                this.m_text_noise_cutoff.addActionListener(this);
                grid.addComponent(new JLabel("Noise cutoff (between 0 and 1"), row, 0);
                grid.addComponent(this.m_text_noise_cutoff, row++, 1, 0.0, 10.0, 1, 1);
                this.m_mainWidget.addStretch(10);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void getAll(boolean broadcast) {
        try {
            this.m_parameterTree.double_put("m_slider_time", this.m_slider_time.getDoubleValue());
            this.m_parameterTree.double_put("m_slider_trace", this.m_slider_trace.getDoubleValue());
            double v = Tools_Widget.extractDouble(this.m_text_time0, -300.0, -2000.0, 0.0);
            this.m_parameterTree.double_put("m_text_time0", v);
            v = Tools_Widget.extractDouble(this.m_text_window, 500.0, 200.0, 2000.0);
            this.m_parameterTree.double_put("m_text_window", v);
            v = Tools_Widget.extractDouble(this.m_text_noise_window, 200.0, 50.0, 2000.0);
            this.m_parameterTree.double_put("m_text_noise_window", v);
            v = Tools_Widget.extractDouble(this.m_text_noise_cutoff, 0.2, 0.01, 0.99);
            this.m_parameterTree.double_put("m_text_noise_cutoff", v);
            if (broadcast) {
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String getColumnName() {
        try {
            return "FBP_" + this.m_parameterTree.string_get("Name", "");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "";
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void extract_data(Ensemble ensemble) {
        try {
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                DataInfo info = this.m_dataList.get(n);
                FloatArrayWrapper data = trace.data();
                if (this.m_tempArray == null) {
                    this.m_tempArray = new float[data.length()];
                }
                if (this.m_tempArray.length != data.length()) {
                    this.m_tempArray = new float[data.length()];
                }
                data.copyToArray(this.m_tempArray);
                info.Interpolator.prepareInput(info.Window, (float)this.m_t0, 4.0f);
                for (int s = 0; s < data.length(); ++s) {
                    float t = info.Time0 + (float)s * info.Digi;
                    this.m_tempArray[s] = info.Interpolator.interpolate(t);
                }
                data.insertArray(this.m_tempArray, this.m_tempArray.length);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void prepDataList(Ensemble ensemble) {
        try {
            while (this.m_dataList.size() < ensemble.traceCount()) {
                this.m_dataList.add(new DataInfo());
            }
            int noiseWindow = (int)(0.5 + this.m_noise_window / 4.0);
            this.m_num_valid = 0;
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                int s;
                EnsembleTrace trace = ensemble.trace(n);
                DataInfo info = this.m_dataList.get(n);
                FloatArrayWrapper wrapper = trace.data();
                info.Valid = false;
                info.Digi = wrapper.getSampleInterval();
                info.Time0 = wrapper.getFirstSampleCoord_WithShifts();
                info.NoiseLevel = 1.0f;
                info.NoiseWeight = 1.0f;
                info.SpikeWeight = 1.0f;
                info.TotalWeight = 1.0f;
                if (info.Window == null) {
                    info.Window = new float[this.m_window_samples];
                }
                if (info.Window.length != this.m_window_samples) {
                    info.Window = new float[this.m_window_samples];
                }
                if (wrapper.length() <= 10 || !trace.traceOkay()) continue;
                ++this.m_num_valid;
                info.Valid = true;
                if (this.m_tempTraceArray.length <= wrapper.length()) {
                    this.m_tempTraceArray = new float[100 + wrapper.length()];
                }
                wrapper.copyToArray(this.m_tempTraceArray);
                info.Interpolator.prepareInput(this.m_tempTraceArray, info.Time0, info.Digi);
                for (s = 0; s < this.m_window_samples; ++s) {
                    float t = (float)(this.m_t0 + (double)((float)s * 4.0f));
                    info.Window[s] = info.Interpolator.interpolate(t);
                }
                info.NoiseLevel = this.m_renorm.computeNoiseLevel(info.Window, noiseWindow);
                if (!((double)info.NoiseLevel > this.m_noise_cutoff)) continue;
                for (s = 0; s < this.m_window_samples; ++s) {
                    info.Window[s] = 0.0f;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            this.m_off_cutoff = 0.01 * this.m_parameterTree.double_get("m_slider_trace", 20.0);
            this.m_time_cutoff = 0.01 * this.m_parameterTree.double_get("m_slider_time", 35.0);
            this.m_t0 = this.m_parameterTree.double_get_range("m_text_time0", -300.0, -2000.0, 0.0);
            this.m_window_time = this.m_parameterTree.double_get_range("m_text_window", 500.0, 200.0, 2000.0);
            this.m_window_samples = (int)(0.5 + this.m_window_time / 4.0);
            this.m_noise_window = this.m_parameterTree.double_get_range("m_text_noise_window", 200.0, 50.0, 2000.0);
            this.m_noise_cutoff = this.m_parameterTree.double_get_range("m_text_noise_cutoff", 0.2, 0.01, 0.99);
            EnsembleGroupManager egm = new EnsembleGroupManager();
            egm.setParentEnsemble(this.m_inputEnsemble);
            egm.prepareGroupsBasedOnInteger("Receiver", "LineNumber");
            for (int group = 0; group < egm.GroupList.size(); ++group) {
                int t;
                Ensemble subEnsemble = egm.GroupList.get((int)group).GroupEnsemble;
                subEnsemble.sortInt(0, "Receiver", "PointNumber", "Receiver", "PointIndex");
                if (subEnsemble.traceCount() < 5) continue;
                this.prepDataList(subEnsemble);
                FFT_2D_Wrapper fft = new FFT_2D_Wrapper();
                if (this.m_num_valid != subEnsemble.traceCount()) continue;
                fft.setExternalDimensions(this.m_window_samples, this.m_num_valid);
                for (t = 0; t < this.m_num_valid; ++t) {
                    fft.insertColumn_Float(t, this.m_dataList.get((int)t).Window);
                }
                fft.forward();
                fft.filter(this.m_time_cutoff, this.m_off_cutoff);
                fft.inverse();
                for (t = 0; t < this.m_num_valid; ++t) {
                    fft.getColumn_Float(t, this.m_dataList.get((int)t).Window);
                }
                this.extract_data(subEnsemble);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }

    protected class DataInfo {
        public boolean Valid = false;
        public float Digi;
        public float Time0;
        public float NoiseLevel;
        public float NoiseWeight;
        public float SpikeWeight = 1.0f;
        public float TotalWeight = 1.0f;
        public CubicTraceInterpolator Interpolator = new CubicTraceInterpolator();
        public float[] Window;

        protected DataInfo() {
        }
    }
}

