/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Filter;

import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.FFT.FFT_1D_Wrapper;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import javax.swing.JComponent;

public class EnsembleWorker_CrudeEnvelope
extends EnsembleWorker_Base
implements IParameterWidgetListener {
    protected Ensemble m_inputEnsemble = null;
    protected FFT_1D_Wrapper m_fft = new FFT_1D_Wrapper(512);
    protected float[] m_tempArray = null;
    protected boolean[] m_isPeak = null;
    protected LinearLayoutWidget m_mainWidget;

    public EnsembleWorker_CrudeEnvelope() {
        try {
            this.Abbreviation = "ENVELOPE";
            this.ShortDescription = "Simple envelope";
            this.WorkerType = "Amplitude";
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_CrudeEnvelope";
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return false;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                int s;
                EnsembleTrace trace = ensemble.trace(n);
                if (!trace.hasData()) continue;
                FloatArrayWrapper data = trace.data();
                if (this.m_isPeak == null) {
                    this.m_isPeak = new boolean[data.length()];
                }
                if (this.m_isPeak.length != data.length()) {
                    this.m_isPeak = new boolean[data.length()];
                }
                if (this.m_tempArray == null) {
                    this.m_tempArray = new float[data.length()];
                }
                if (this.m_tempArray.length != data.length()) {
                    this.m_tempArray = new float[data.length()];
                }
                data.copyToArray(this.m_tempArray);
                this.m_isPeak[0] = true;
                this.m_isPeak[this.m_tempArray.length - 1] = true;
                for (s = 1; s < this.m_tempArray.length - 1; ++s) {
                    this.m_tempArray[s] = Math.abs(this.m_tempArray[s]);
                    float dm1 = this.m_tempArray[s - 1];
                    float d0 = this.m_tempArray[s];
                    float dp1 = this.m_tempArray[s + 1];
                    this.m_isPeak[s] = d0 > dm1 && d0 > dp1;
                }
                for (s = 1; s < this.m_tempArray.length - 1; ++s) {
                    if (this.m_isPeak[s]) continue;
                    int sm = s;
                    while (!this.m_isPeak[sm]) {
                        --sm;
                    }
                    int sp = s;
                    while (!this.m_isPeak[sp]) {
                        ++sp;
                    }
                    float dm = this.m_tempArray[sm];
                    float dp = this.m_tempArray[sp];
                    this.m_tempArray[s] = dm + (float)(s - sm) * (dp - dm) / (float)(sp - sm);
                }
                data.insertArray(this.m_tempArray, this.m_tempArray.length);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

