/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker;

import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Plugins.IPlugin;
import com.PecosCore.Plugins.PluginManager;
import com.PecosCore.Shared.AppType;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Ensemble.Worker.Amplitude.EnsembleWorker_AGC;
import com.PecosLibrary.Ensemble.Worker.Amplitude.EnsembleWorker_AmplitudeRange;
import com.PecosLibrary.Ensemble.Worker.Amplitude.EnsembleWorker_AmplitudeSquasher;
import com.PecosLibrary.Ensemble.Worker.Amplitude.EnsembleWorker_CrudeDespike;
import com.PecosLibrary.Ensemble.Worker.Amplitude.EnsembleWorker_NLAMP;
import com.PecosLibrary.Ensemble.Worker.Amplitude.EnsembleWorker_RMS;
import com.PecosLibrary.Ensemble.Worker.Amplitude.EnsembleWorker_WindowScalar;
import com.PecosLibrary.Ensemble.Worker.Amplitude.EnsembleWorker_WindowScaling;
import com.PecosLibrary.Ensemble.Worker.DelayTime.EnsembleWorker_DelayTimeShifts;
import com.PecosLibrary.Ensemble.Worker.Export.EnsembleWorker_ExportSegy_NoProjectRequired;
import com.PecosLibrary.Ensemble.Worker.Export.EnsembleWorker_ExportSegy_ProjectRequired;
import com.PecosLibrary.Ensemble.Worker.Filter.EnsembleWorker_Bandpass;
import com.PecosLibrary.Ensemble.Worker.Filter.EnsembleWorker_ButterworthLowPass;
import com.PecosLibrary.Ensemble.Worker.Filter.EnsembleWorker_CrudeEnvelope;
import com.PecosLibrary.Ensemble.Worker.Filter.EnsembleWorker_Envelope;
import com.PecosLibrary.Ensemble.Worker.Filter.EnsembleWorker_FFT_2D;
import com.PecosLibrary.Ensemble.Worker.Filter.EnsembleWorker_FrequencySpikeRemoval;
import com.PecosLibrary.Ensemble.Worker.Filter.EnsembleWorker_PhaseRotate;
import com.PecosLibrary.Ensemble.Worker.Geometry.EnsembleWorker_ComputeAzimuthAndOffset;
import com.PecosLibrary.Ensemble.Worker.Geometry.EnsembleWorker_PositionPredictor;
import com.PecosLibrary.Ensemble.Worker.Import.EnsembleWorker_ScanProjectTraces;
import com.PecosLibrary.Ensemble.Worker.Import.EnsembleWorker_ScanSegy;
import com.PecosLibrary.Ensemble.Worker.ModelTimeShifts.EnsembleWorker_Eikonal3D;
import com.PecosLibrary.Ensemble.Worker.ModelTimeShifts.EnsembleWorker_GLI;
import com.PecosLibrary.Ensemble.Worker.ModelTimeShifts.EnsembleWorker_TomoVNS;
import com.PecosLibrary.Ensemble.Worker.Moveout.EnsembleWorker_ApplyInteractiveTrend;
import com.PecosLibrary.Ensemble.Worker.Moveout.EnsembleWorker_ApplyLinearMoveout;
import com.PecosLibrary.Ensemble.Worker.Moveout.EnsembleWorker_ApplyMoveoutTrend;
import com.PecosLibrary.Ensemble.Worker.Moveout.EnsembleWorker_ApplyNMO;
import com.PecosLibrary.Ensemble.Worker.Moveout.EnsembleWorker_ApplySingleNMO;
import com.PecosLibrary.Ensemble.Worker.Picker.EnsembleWorker_AmpOnsetPicker;
import com.PecosLibrary.Ensemble.Worker.Picker.EnsembleWorker_AmpOnsetPicker_Snap;
import com.PecosLibrary.Ensemble.Worker.Picker.EnsembleWorker_EnergyEnvelope;
import com.PecosLibrary.Ensemble.Worker.Picker.EnsembleWorker_EnergyInWindow;
import com.PecosLibrary.Ensemble.Worker.Picker.EnsembleWorker_NearestTimePicker;
import com.PecosLibrary.Ensemble.Worker.Picker.EnsembleWorker_PickAverage;
import com.PecosLibrary.Ensemble.Worker.Picker.EnsembleWorker_PickDifferenceStatistics;
import com.PecosLibrary.Ensemble.Worker.Picker.EnsembleWorker_PredictEikonal3D;
import com.PecosLibrary.Ensemble.Worker.Picker.EnsembleWorker_PredictTomoVNS;
import com.PecosLibrary.Ensemble.Worker.Picker.EnsembleWorker_PredictedDelayTime;
import com.PecosLibrary.Ensemble.Worker.Picker.EnsembleWorker_ShiftUserPicks;
import com.PecosLibrary.Ensemble.Worker.Picker.EnsembleWorker_ThresholdPicker;
import com.PecosLibrary.Ensemble.Worker.QC.EnsembleWorker_FourierPeakAnalysis;
import com.PecosLibrary.Ensemble.Worker.QC.EnsembleWorker_KillDC;
import com.PecosLibrary.Ensemble.Worker.QC.EnsembleWorker_NoiseTrace;
import com.PecosLibrary.Ensemble.Worker.Selectors.EnsembleWorker_AzimuthSelector;
import com.PecosLibrary.Ensemble.Worker.Selectors.EnsembleWorker_BooleanTraceSelector;
import com.PecosLibrary.Ensemble.Worker.Selectors.EnsembleWorker_Decimator;
import com.PecosLibrary.Ensemble.Worker.Selectors.EnsembleWorker_PolygonSelector;
import com.PecosLibrary.Ensemble.Worker.Selectors.EnsembleWorker_RangeTraceSelector;
import com.PecosLibrary.Ensemble.Worker.Stacks.EnsembleWorker_BruteStack;
import com.PecosLibrary.Ensemble.Worker.Stacks.EnsembleWorker_RecLineMixer;
import com.PecosLibrary.Ensemble.Worker.Synthetic.EnsembleWorker_CreateSynthetic3D;
import com.PecosLibrary.Ensemble.Worker.Synthetic.EnsembleWorker_Simple2DSynthetic;
import com.PecosLibrary.Ensemble.Worker.Synthetic.EnsembleWorker_SyntheticLayers;
import com.PecosLibrary.Ensemble.Worker.Synthetic.EnsembleWorker_SyntheticModel;
import com.PecosLibrary.Ensemble.Worker.Synthetic.EnsembleWorker_SyntheticNMO;
import com.PecosLibrary.Ensemble.Worker.Synthetic.EnsembleWorker_SyntheticResidualStatics;
import com.PecosLibrary.Ensemble.Worker.TimeShift.EnsembleWorker_ElevationStatics;
import com.PecosLibrary.Ensemble.Worker.TimeShift.EnsembleWorker_GeneralShtRecStackPick;
import com.PecosLibrary.Ensemble.Worker.TimeShift.EnsembleWorker_HeaderShift;
import com.PecosLibrary.Ensemble.Worker.TimeShift.EnsembleWorker_RefractionStatics;
import com.PecosLibrary.Ensemble.Worker.TimeShift.EnsembleWorker_TimeShift;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.util.ArrayList;

public class EnsembleWorker_CompleteList {
    protected ArrayList<EnsembleWorker_Base> m_list = new ArrayList();
    protected static EnsembleWorker_CompleteList m_singleton = null;

    protected EnsembleWorker_CompleteList() {
        try {
            this.addWorker(new EnsembleWorker_Bandpass());
            this.addWorker(new EnsembleWorker_ButterworthLowPass());
            this.addWorker(new EnsembleWorker_FFT_2D());
            this.addWorker(new EnsembleWorker_FrequencySpikeRemoval());
            this.addWorker(new EnsembleWorker_PhaseRotate());
            this.addWorker(new EnsembleWorker_Envelope());
            this.addWorker(new EnsembleWorker_EnergyInWindow());
            this.addWorker(new EnsembleWorker_AmplitudeSquasher());
            this.addWorker(new EnsembleWorker_AmplitudeRange());
            this.addWorker(new EnsembleWorker_CrudeDespike());
            this.addWorker(new EnsembleWorker_AGC());
            this.addWorker(new EnsembleWorker_RMS());
            this.addWorker(new EnsembleWorker_NLAMP());
            this.addWorker(new EnsembleWorker_WindowScaling());
            this.addWorker(new EnsembleWorker_WindowScalar());
            this.addWorker(new EnsembleWorker_CrudeEnvelope());
            if (AppType.isRefraction()) {
                this.addWorker(new EnsembleWorker_ThresholdPicker());
                this.addWorker(new EnsembleWorker_NearestTimePicker());
                this.addWorker(new EnsembleWorker_AmpOnsetPicker());
                this.addWorker(new EnsembleWorker_AmpOnsetPicker_Snap());
                this.addWorker(new EnsembleWorker_EnergyEnvelope());
                this.addWorker(new EnsembleWorker_ShiftUserPicks());
                this.addWorker(new EnsembleWorker_RecLineMixer());
                this.addWorker(new EnsembleWorker_BruteStack());
                this.addWorker(new EnsembleWorker_PredictedDelayTime());
                this.addWorker(new EnsembleWorker_PredictTomoVNS());
                this.addWorker(new EnsembleWorker_PredictEikonal3D());
                this.addWorker(new EnsembleWorker_PickDifferenceStatistics());
                this.addWorker(new EnsembleWorker_PickAverage());
            }
            if (AppType.isRefraction()) {
                this.addWorker(new EnsembleWorker_RefractionStatics());
                this.addWorker(new EnsembleWorker_HeaderShift());
            }
            this.addWorker(new EnsembleWorker_ElevationStatics());
            this.addWorker(new EnsembleWorker_TimeShift());
            this.addWorker(new EnsembleWorker_GeneralShtRecStackPick());
            if (AppType.isRefraction()) {
                this.addWorker(new EnsembleWorker_DelayTimeShifts());
                this.addWorker(new EnsembleWorker_Eikonal3D());
                this.addWorker(new EnsembleWorker_TomoVNS());
                this.addWorker(new EnsembleWorker_GLI());
            }
            this.addWorker(new EnsembleWorker_NoiseTrace());
            this.addWorker(new EnsembleWorker_KillDC());
            this.addWorker(new EnsembleWorker_FourierPeakAnalysis());
            this.addWorker(new EnsembleWorker_ComputeAzimuthAndOffset());
            this.addWorker(new EnsembleWorker_PositionPredictor());
            this.addWorker(new EnsembleWorker_ApplyLinearMoveout());
            this.addWorker(new EnsembleWorker_ApplyMoveoutTrend());
            this.addWorker(new EnsembleWorker_ApplyInteractiveTrend());
            this.addWorker(new EnsembleWorker_ApplyNMO());
            this.addWorker(new EnsembleWorker_ApplySingleNMO());
            this.addWorker(new EnsembleWorker_PolygonSelector());
            this.addWorker(new EnsembleWorker_BooleanTraceSelector());
            this.addWorker(new EnsembleWorker_RangeTraceSelector());
            this.addWorker(new EnsembleWorker_AzimuthSelector());
            this.addWorker(new EnsembleWorker_Decimator());
            this.addWorker(new EnsembleWorker_ScanProjectTraces());
            this.addWorker(new EnsembleWorker_ScanSegy());
            this.addWorker(new EnsembleWorker_Simple2DSynthetic());
            this.addWorker(new EnsembleWorker_CreateSynthetic3D());
            this.addWorker(new EnsembleWorker_SyntheticResidualStatics());
            this.addWorker(new EnsembleWorker_SyntheticNMO());
            this.addWorker(new EnsembleWorker_SyntheticLayers());
            this.addWorker(new EnsembleWorker_SyntheticModel());
            this.addWorker(new EnsembleWorker_ExportSegy_ProjectRequired());
            this.addWorker(new EnsembleWorker_ExportSegy_NoProjectRequired());
            PluginManager pluginManager = PluginManager.singleton();
            pluginManager.loadList();
            ArrayList pluginList = pluginManager.getPluginList();
            for (String pluginName : pluginList) {
                ArrayList<EnsembleWorker_Base> pluginWorkerList;
                pluginManager.setCurrentPlugin(pluginName);
                pluginManager.loadCurrentPlugin();
                IPlugin plugin = pluginManager.currentPlugin();
                if (plugin == null || (pluginWorkerList = plugin.getEnsembleWorkerList()) == null || pluginWorkerList.size() <= 0) continue;
                for (EnsembleWorker_Base worker : pluginWorkerList) {
                    this.addWorker(worker);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean uniqueIDExists(String uniqueID) {
        try {
            if (uniqueID == null) {
                return false;
            }
            for (EnsembleWorker_Base worker : this.m_list) {
                String cn = worker.getClass().getName();
                if (!worker.uniqueID().equalsIgnoreCase(uniqueID)) continue;
                return true;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public EnsembleWorker_Base getWorkerFromUniqueID(String uniqueID) {
        try {
            if (uniqueID == null) {
                return null;
            }
            for (EnsembleWorker_Base worker : this.m_list) {
                String cn = worker.getClass().getName();
                if (!worker.uniqueID().equalsIgnoreCase(uniqueID)) continue;
                return worker.cloneWithParameterTree();
            }
            return null;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public boolean classExists(String className) {
        try {
            if (className == null) {
                return false;
            }
            for (EnsembleWorker_Base worker : this.m_list) {
                String cn = worker.getClass().getName();
                if (!cn.equals(className)) continue;
                return true;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public ArrayList<String> listOfTypes(boolean requireInteractiveFlowsOkay, EnsembleWorker_Sequence.SequenceType sequenceType) {
        try {
            boolean isProcessFlow = sequenceType == EnsembleWorker_Sequence.SequenceType.Processing;
            boolean projectOK = RefractionStaticsProject.singleton().valid();
            ArrayList<String> list = new ArrayList<String>();
            for (EnsembleWorker_Base worker : this.m_list) {
                boolean okay = true;
                if (requireInteractiveFlowsOkay) {
                    okay = worker.InteractiveFlowsOkay;
                }
                if (worker.RequiresRefractionStaticsProject) {
                    boolean bl = okay = okay && projectOK;
                }
                if (worker.WorkerType.equalsIgnoreCase("Input") && !isProcessFlow) {
                    okay = false;
                }
                if (worker.WorkerType.equalsIgnoreCase("Output") && !isProcessFlow) {
                    okay = false;
                }
                if (!okay) continue;
                boolean inList = false;
                for (String type : list) {
                    inList = inList || type.equalsIgnoreCase(worker.WorkerType);
                }
                if (inList) continue;
                list.add(worker.WorkerType);
            }
            return list;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public ArrayList<EnsembleWorker_Base> listOfWorkersOfType(String type) {
        try {
            boolean projectOK = RefractionStaticsProject.singleton().valid();
            ArrayList<EnsembleWorker_Base> list = new ArrayList<EnsembleWorker_Base>();
            for (EnsembleWorker_Base worker : this.m_list) {
                if (!worker.WorkerType.equalsIgnoreCase(type)) continue;
                boolean ok = true;
                if (worker.RequiresRefractionStaticsProject) {
                    ok = projectOK;
                }
                if (!ok) continue;
                list.add(worker);
            }
            return list;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public void addWorker(EnsembleWorker_Base worker) {
        try {
            this.m_list.add(worker);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static EnsembleWorker_CompleteList singleton() throws Exception {
        try {
            if (m_singleton == null) {
                m_singleton = new EnsembleWorker_CompleteList();
            }
            return m_singleton;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }
}

