/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Echos;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Echos.EchosInterface;
import com.PecosLibrary.Echos.Result;
import com.PecosLibrary.Echos.SWIGTYPE_p_float;
import com.PecosLibrary.Echos.TableExportResult;
import com.PecosLibrary.Echos.XtEchos;
import com.PecosLibrary.Echos.XtEchosColumnMap;
import com.PecosLibrary.Echos.XtEchosColumnMapEntry;
import com.PecosLibrary.Echos.XtParadigmSeisDataAttributeInfo;
import com.PecosLibrary.Echos.XtParadigmSeisDataAttributeInfoList;
import com.PecosLibrary.Echos.XtParadigmSeisDataDB;
import com.PecosLibrary.Echos.XtParadigmSeisDataModelInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class XtParadigmTableTools {
    public static void openEchosSurveySeisDataDB(String sSurvey, String sLine, String sHost) throws Exception {
        String sSeisSpaceSurvey;
        int iOpenOK;
        boolean bInitOK;
        if (!XtEchos.initialized() && !(bInitOK = XtEchos.initialize())) {
            Object sError = "Failed to initialize Echos connection :";
            if (XtEchos.getLastInitializeError() != null) {
                sError = (String)sError + XtEchos.getLastInitializeError().getMessage();
                throw new Exception((String)sError);
            }
        }
        if ((iOpenOK = XtParadigmSeisDataDB.echos_sdb_open(sSeisSpaceSurvey = sSurvey + "@" + sHost)) != 0) {
            throw new Exception("Failed to open SeisDataDB : " + XtParadigmSeisDataDB.getErrorMessage(iOpenOK));
        }
    }

    public static XtParadigmSeisDataAttributeInfoList getAttributeInfoList(String sEchosModelName, String sEchosLineName) throws Exception {
        int iii;
        int nLocs;
        XtParadigmSeisDataAttributeInfoList attributeInfoList = new XtParadigmSeisDataAttributeInfoList();
        Result result = new Result();
        XtParadigmSeisDataDB.getXtParadigmSeisDataAttributeInfoList(attributeInfoList, result);
        if (result.getErrorCode() == 1) {
            throw new Exception("Failed to get attribute info list : " + result.getErrorMessage());
        }
        int iResult = 0;
        if (sEchosModelName.equals("SHOT")) {
            XtParadigmSeisDataModelInfo shotModelInfo = XtParadigmSeisDataDB.echos_sdb_mdlget(sEchosLineName, "SHOT");
            iResult = shotModelInfo.getResult();
            if (iResult != 0) {
                throw new Exception("Failed to get SHOT model : " + XtParadigmSeisDataDB.getErrorMessage(iResult));
            }
            nLocs = shotModelInfo.getNlocs();
            if (nLocs == 0) {
                iii = 0;
                ++iii;
            }
            attributeInfoList.add(sEchosLineName, "SHOT", "SHOT", "STATION", shotModelInfo.getInterp(), shotModelInfo.getXunit(), shotModelInfo.getInc(), shotModelInfo.getFirst(), shotModelInfo.getLast(), shotModelInfo.getNlocs(), 1);
            attributeInfoList.add(sEchosLineName, sEchosModelName, "Model", "Model", shotModelInfo.getInterp(), shotModelInfo.getXunit(), shotModelInfo.getInc(), shotModelInfo.getFirst(), shotModelInfo.getLast(), shotModelInfo.getNlocs(), 1);
        }
        if (sEchosModelName.equals("STATION")) {
            XtParadigmSeisDataModelInfo stationModelInfo = XtParadigmSeisDataDB.echos_sdb_mdlget(sEchosLineName, "STATION");
            iResult = stationModelInfo.getResult();
            if (iResult != 0) {
                throw new Exception("Failed to get STATION model : " + XtParadigmSeisDataDB.getErrorMessage(iResult));
            }
            nLocs = stationModelInfo.getNlocs();
            if (nLocs == 0) {
                iii = 0;
                ++iii;
            }
            attributeInfoList.add(sEchosLineName, "STATION", "RECEIVER", "STATION", stationModelInfo.getInterp(), stationModelInfo.getXunit(), stationModelInfo.getInc(), stationModelInfo.getFirst(), stationModelInfo.getLast(), stationModelInfo.getNlocs(), 1);
            attributeInfoList.add(sEchosLineName, sEchosModelName, "Model", "Model", stationModelInfo.getInterp(), stationModelInfo.getXunit(), stationModelInfo.getInc(), stationModelInfo.getFirst(), stationModelInfo.getLast(), stationModelInfo.getNlocs(), 1);
        }
        int nAttributes = attributeInfoList.size();
        for (int i = 0; i < nAttributes; ++i) {
            XtParadigmSeisDataAttributeInfo attrInfo = attributeInfoList.get(i);
            String sEvent = attrInfo.getEvent();
            String sAttr = attrInfo.getAttribute();
            String sModel = attrInfo.getModel();
            int n = attrInfo.getNlocs();
        }
        return attributeInfoList;
    }

    public static TableExportResult importTableColumnFromEchos(Table_Abstract geometryTable, Table_Abstract solutionTable, XtEchosColumnMap columnMap, String sEchosSurvey, String sEchosLine, String sEchosHost) throws Exception {
        TableExportResult tableExportResult = new TableExportResult();
        try {
            int i;
            XtParadigmSeisDataAttributeInfo info;
            int iColumn;
            String sColumnName;
            if (columnMap == null) {
                throw new Exception("null column map");
            }
            if (geometryTable == null) {
                throw new Exception("null geometryTable table");
            }
            if (solutionTable == null) {
                throw new Exception("null solutionTable table");
            }
            String sEchosModel = columnMap.getEchosModel();
            String sTableName = columnMap.getTableName();
            String sTableID = "";
            if (sTableName.toUpperCase().equals("Receiver".toUpperCase())) {
                sTableID = "ReceiverID".toUpperCase();
            } else if (sTableName.toUpperCase().equals("Shot".toUpperCase())) {
                sTableID = "ShotID".toUpperCase();
            } else {
                throw new Exception("Invalid table name " + sTableName);
            }
            List<XtEchosColumnMapEntry> keyEntries = columnMap.keyEntries();
            List<XtEchosColumnMapEntry> valueEntries = columnMap.valueEntries();
            int nKeys = keyEntries.size();
            if (keyEntries.size() == 0) {
                throw new Exception("no key entries");
            }
            if (keyEntries.size() > 3) {
                throw new Exception("num keys greater than 3 is not supported");
            }
            if (valueEntries.size() == 0) {
                throw new Exception("no value entries");
            }
            XtParadigmTableTools.openEchosSurveySeisDataDB(sEchosSurvey, sEchosLine, sEchosHost);
            XtParadigmSeisDataAttributeInfoList attrInfoList = XtParadigmTableTools.getAttributeInfoList(sEchosModel, sEchosLine);
            int nRows = -999;
            int iResult = 0;
            XtParadigmSeisDataModelInfo modelInfo = null;
            if (sEchosModel.equals("SHOT")) {
                XtParadigmSeisDataModelInfo shotModelInfo = XtParadigmSeisDataDB.echos_sdb_mdlget(sEchosLine, "SHOT");
                iResult = shotModelInfo.getResult();
                if (iResult != 0) {
                    throw new Exception("Failed to get SHOT model : " + XtParadigmSeisDataDB.getErrorMessage(iResult));
                }
                modelInfo = shotModelInfo;
            } else if (sEchosModel.equals("STATION")) {
                XtParadigmSeisDataModelInfo stationModelInfo = XtParadigmSeisDataDB.echos_sdb_mdlget(sEchosLine, "STATION");
                iResult = stationModelInfo.getResult();
                if (iResult != 0) {
                    throw new Exception("Failed to get STATION model : " + XtParadigmSeisDataDB.getErrorMessage(iResult));
                }
                modelInfo = stationModelInfo;
            } else {
                throw new Exception("Invalid Echos Model : " + sEchosModel);
            }
            nRows = modelInfo.getNlocs();
            HashMap<XtEchosColumnMapEntry, XtParadigmSeisDataAttributeInfo> entryInfoMap = new HashMap<XtEchosColumnMapEntry, XtParadigmSeisDataAttributeInfo>();
            HashMap<XtEchosColumnMapEntry, SWIGTYPE_p_float> dataMap = new HashMap<XtEchosColumnMapEntry, SWIGTYPE_p_float>();
            ArrayList<XtEchosColumnMapEntry> allEntries = new ArrayList<XtEchosColumnMapEntry>();
            for (XtEchosColumnMapEntry entry : keyEntries) {
                allEntries.add(entry);
                sColumnName = entry.getColumnName();
                iColumn = geometryTable.column_indexOfColumn(sColumnName);
                if (iColumn < 0) {
                    throw new Exception("Column " + entry.getColumnName() + " not found in table " + sTableName);
                }
                entry.setTableColumnIndex(iColumn);
            }
            for (XtEchosColumnMapEntry entry : valueEntries) {
                allEntries.add(entry);
                sColumnName = entry.getColumnName();
                if (!solutionTable.column_exists(sColumnName)) {
                    solutionTable.column_append(sColumnName, DataType.Double);
                }
                iColumn = solutionTable.column_indexOfColumn(sColumnName);
                entry.setTableColumnIndex(iColumn);
            }
            for (XtEchosColumnMapEntry entry : keyEntries) {
                info = XtParadigmTableTools.getSeisDataAttribute(attrInfoList, sEchosModel, entry.getEchosEvent(), entry.getEchosAttribute());
                if (info == null) {
                    throw new Exception("Unable to find AttributeInfo for : " + sEchosModel + " : " + entry.getEchosEvent() + " : " + entry.getEchosAttribute());
                }
                if (info.getNvals() > 1) {
                    throw new Exception("Nvals greater than 1 is not supported : " + Integer.toString(info.getNvals()) + " " + sEchosModel + " : " + entry.getEchosEvent() + " : " + entry.getEchosAttribute());
                }
                entryInfoMap.put(entry, info);
            }
            for (XtEchosColumnMapEntry entry : valueEntries) {
                info = XtParadigmTableTools.getSeisDataAttribute(attrInfoList, sEchosModel, entry.getEchosEvent(), entry.getEchosAttribute());
                if (info == null) {
                    info = new XtParadigmSeisDataAttributeInfo();
                    info.setLine(sEchosLine);
                    info.setModel(sEchosModel);
                    info.setEvent(entry.getEchosEvent());
                    info.setAttribute(entry.getEchosAttribute());
                    info.setFirst(modelInfo.getFirst());
                    info.setLast(modelInfo.getLast());
                    info.setMdate("");
                    info.setInterp("");
                    info.setNlocs(modelInfo.getNlocs());
                    info.setNvals(1);
                    info.setXunit("");
                    if (modelInfo.getNlocs() < nRows) {
                        throw new Exception("Row count error in model : " + sEchosModel + " " + Integer.toString(modelInfo.getNlocs()) + " " + Integer.toString(nRows));
                    }
                } else if (info.getNvals() > 1) {
                    throw new Exception("Nvals greater than 1 is not supported : " + Integer.toString(info.getNvals()) + " " + sEchosModel + " : " + entry.getEchosEvent() + " : " + entry.getEchosAttribute());
                }
                entryInfoMap.put(entry, info);
            }
            for (XtEchosColumnMapEntry entry : allEntries) {
                info = (XtParadigmSeisDataAttributeInfo)entryInfoMap.get(entry);
                int nTmpRows = info.getNlocs();
                int nTmpBufferSize = nTmpRows * 2;
                SWIGTYPE_p_float floatArray = EchosInterface.new_floatArray(nTmpBufferSize);
                for (int ii = 0; ii < nTmpBufferSize; ++ii) {
                    EchosInterface.floatArray_setitem(floatArray, ii, 0.0f);
                }
                String sTmpAttribute = info.getAttribute();
                String sTmpEvent = info.getEvent();
                String sTmpLine = info.getLine();
                String sTmpModel = info.getModel();
                if (nTmpRows < nRows) {
                    throw new Exception("Invalid row count : " + Integer.toString(nRows) + " : " + Integer.toString(nTmpRows) + " " + sTmpModel + " " + sTmpEvent + " " + sTmpAttribute);
                }
                Result result = new Result();
                XtParadigmSeisDataDB.echos_sdb_atrget_float(info, floatArray, nTmpBufferSize, result);
                dataMap.put(entry, floatArray);
                if (result.getErrorCode() == 0) continue;
                throw new Exception("Error getting event attribute : " + info.getEvent() + " " + info.getAttribute() + " : " + result.getErrorMessage());
            }
            int nGeometryRows = geometryTable.row_count();
            int nSolutionRows = solutionTable.row_count();
            HashMap_Integers<Integer> map = new HashMap_Integers<Integer>();
            HashMap<Integer, Integer> solutionMap = new HashMap<Integer, Integer>();
            int[] columnIndexes = new int[3];
            for (int i2 = 0; i2 < 3; ++i2) {
                columnIndexes[i2] = -1;
            }
            for (int iKey = 0; iKey < nKeys; ++iKey) {
                int iIndex;
                String sColumn = keyEntries.get(iKey).getColumnName();
                columnIndexes[iKey] = iIndex = geometryTable.column_indexOfColumn(sColumn);
            }
            boolean bUniqueMap = true;
            int iGeometryTableIdColumn = geometryTable.column_indexOfColumn(sTableID);
            int iSolutionTableIdColumn = solutionTable.column_indexOfColumn(sTableID);
            for (i = 0; i < nGeometryRows; ++i) {
                int iKeyVal1 = 0;
                int iKeyVal2 = 0;
                int iKeyVal3 = 0;
                int id = geometryTable.getInt(i, iGeometryTableIdColumn);
                if (columnIndexes[0] >= 0) {
                    iKeyVal1 = geometryTable.getInt(i, columnIndexes[0]);
                }
                if (columnIndexes[1] >= 0) {
                    iKeyVal2 = geometryTable.getInt(i, columnIndexes[1]);
                }
                if (columnIndexes[2] >= 0) {
                    iKeyVal3 = geometryTable.getInt(i, columnIndexes[2]);
                }
                if (!map.containsKey(iKeyVal1, iKeyVal2, iKeyVal3)) {
                    map.put(id, iKeyVal1, iKeyVal2, iKeyVal3);
                    continue;
                }
                bUniqueMap = false;
            }
            if (!bUniqueMap) {
                StringBuilder sb = new StringBuilder();
                for (XtEchosColumnMapEntry tmpEntry : keyEntries) {
                    sb.append(tmpEntry.getColumnName());
                    sb.append(" ");
                }
                throw new Exception("column keys for table ( " + sTableName + " ) do not map to unique row indices : " + sb.toString());
            }
            for (i = 0; i < nSolutionRows; ++i) {
                int id = solutionTable.getInt(i, iSolutionTableIdColumn);
                solutionMap.put(id, i);
                for (XtEchosColumnMapEntry entry : valueEntries) {
                    float fOutputValue = entry.getDefaultValue();
                    solutionTable.putDouble(i, entry.getTableColumnIndex(), fOutputValue);
                }
            }
            XtEchosColumnMapEntry keyEntry1 = null;
            XtEchosColumnMapEntry keyEntry2 = null;
            XtEchosColumnMapEntry keyEntry3 = null;
            if (nKeys >= 1) {
                keyEntry1 = keyEntries.get(0);
            }
            if (nKeys >= 2) {
                keyEntry2 = keyEntries.get(1);
            }
            if (nKeys >= 3) {
                keyEntry3 = keyEntries.get(2);
            }
            SWIGTYPE_p_float keyData1 = null;
            SWIGTYPE_p_float keyData2 = null;
            SWIGTYPE_p_float keyData3 = null;
            if (keyEntry1 != null) {
                keyData1 = (SWIGTYPE_p_float)dataMap.get(keyEntry1);
            }
            if (keyEntry2 != null) {
                keyData2 = (SWIGTYPE_p_float)dataMap.get(keyEntry2);
            }
            if (keyEntry3 != null) {
                keyData3 = (SWIGTYPE_p_float)dataMap.get(keyEntry3);
            }
            int nMatches = 0;
            int nMisses = 0;
            for (int iRow = 0; iRow < nRows; ++iRow) {
                int iKeyVal1 = 0;
                int iKeyVal2 = 0;
                int iKeyVal3 = 0;
                int iTableID = -1;
                int iTableRow = -1;
                if (keyData1 != null) {
                    iKeyVal1 = (int)EchosInterface.floatArray_getitem(keyData1, iRow);
                }
                if (keyData2 != null) {
                    iKeyVal2 = (int)EchosInterface.floatArray_getitem(keyData2, iRow);
                }
                if (keyData3 != null) {
                    iKeyVal3 = (int)EchosInterface.floatArray_getitem(keyData3, iRow);
                }
                if (map.containsKey(iKeyVal1, iKeyVal2, iKeyVal3) && solutionMap.containsKey(iTableID = ((Integer)map.get(iKeyVal1, iKeyVal2, iKeyVal3)).intValue())) {
                    iTableRow = (Integer)solutionMap.get(iTableID);
                }
                if (iTableRow >= 0) {
                    ++nMatches;
                } else {
                    ++nMisses;
                }
                for (XtEchosColumnMapEntry entry : valueEntries) {
                    float fOutputValue = entry.getDefaultValue();
                    SWIGTYPE_p_float valueData = (SWIGTYPE_p_float)dataMap.get(entry);
                    fOutputValue = EchosInterface.floatArray_getitem(valueData, iRow);
                    if (iTableRow < 0) continue;
                    solutionTable.putDouble(iTableRow, entry.getTableColumnIndex(), fOutputValue);
                }
            }
            tableExportResult.NumEchosRows = nRows;
            tableExportResult.NumXtGeoRows = nSolutionRows;
            tableExportResult.NumKeyMatches = nMatches;
            tableExportResult.NumKeyMisses = nMisses;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
        return tableExportResult;
    }

    public static TableExportResult exportTableColumnGeometryToEchos(Table_Abstract geometryTable, Table_Abstract solutionTable, XtEchosColumnMap columnMap, String sEchosSurvey, String sEchosLine, String sEchosHost) throws Exception {
        TableExportResult tableExportResult = new TableExportResult();
        try {
            int i;
            SWIGTYPE_p_float floatArray;
            int iColumn;
            String sColumnName;
            if (columnMap == null) {
                throw new Exception("null column map");
            }
            if (geometryTable == null) {
                throw new Exception("null geometryTable table");
            }
            if (solutionTable == null) {
                throw new Exception("null solutionTable table");
            }
            String sEchosModel = columnMap.getEchosModel();
            String sTableName = columnMap.getTableName();
            String sTableID = "";
            if (sTableName.toUpperCase().equals("Receiver".toUpperCase())) {
                sTableID = "ReceiverID".toUpperCase();
            } else if (sTableName.toUpperCase().equals("Shot".toUpperCase())) {
                sTableID = "ShotID".toUpperCase();
            } else {
                throw new Exception("Invalid table name " + sTableName);
            }
            List<XtEchosColumnMapEntry> keyEntries = columnMap.keyEntries();
            ArrayList<XtEchosColumnMapEntry> valueEntries = new ArrayList<XtEchosColumnMapEntry>();
            XtEchosColumnMapEntry eastingEntryEchosOriginalValue = new XtEchosColumnMapEntry("Easting", "X", "COORD");
            XtEchosColumnMapEntry northingEntryEchosOriginalValue = new XtEchosColumnMapEntry("Northing", "Y", "COORD");
            String sEvent = "SHOT";
            sEvent = sEchosModel.equals("SHOT") ? "SHOT" : "REC";
            XtEchosColumnMapEntry eastingEntry = new XtEchosColumnMapEntry("Easting", sEvent, "XFL");
            XtEchosColumnMapEntry northingEntry = new XtEchosColumnMapEntry("Northing", sEvent, "YFL");
            XtEchosColumnMapEntry movedEntry = new XtEchosColumnMapEntry("DistanceMoved", sEvent, "MOVEDFL");
            valueEntries.add(eastingEntry);
            valueEntries.add(northingEntry);
            valueEntries.add(movedEntry);
            int nKeys = keyEntries.size();
            if (keyEntries.size() == 0) {
                throw new Exception("no key entries");
            }
            if (keyEntries.size() > 3) {
                throw new Exception("num keys greater than 3 is not supported");
            }
            if (valueEntries.size() == 0) {
                throw new Exception("no value entries");
            }
            XtParadigmTableTools.openEchosSurveySeisDataDB(sEchosSurvey, sEchosLine, sEchosHost);
            XtParadigmSeisDataAttributeInfoList attrInfoList = XtParadigmTableTools.getAttributeInfoList(sEchosModel, sEchosLine);
            int nRows = -999;
            int nBufferSize = -999;
            XtParadigmSeisDataModelInfo stationModelInfo = XtParadigmSeisDataDB.echos_sdb_mdlget(sEchosLine, "STATION");
            int iResult = stationModelInfo.getResult();
            if (iResult != 0) {
                throw new Exception("Failed to get STATION model : " + XtParadigmSeisDataDB.getErrorMessage(iResult));
            }
            XtParadigmSeisDataModelInfo shotModelInfo = XtParadigmSeisDataDB.echos_sdb_mdlget(sEchosLine, "SHOT");
            iResult = shotModelInfo.getResult();
            if (iResult != 0) {
                throw new Exception("Failed to get SHOT model : " + XtParadigmSeisDataDB.getErrorMessage(iResult));
            }
            XtParadigmSeisDataModelInfo modelInfo = null;
            if (sEchosModel.equals("SHOT")) {
                modelInfo = shotModelInfo;
            } else if (sEchosModel.equals("STATION")) {
                modelInfo = stationModelInfo;
            } else {
                throw new Exception("Invalid Echos Model : " + sEchosModel);
            }
            HashMap<XtEchosColumnMapEntry, XtParadigmSeisDataAttributeInfo> entryInfoMap = new HashMap<XtEchosColumnMapEntry, XtParadigmSeisDataAttributeInfo>();
            HashMap<XtEchosColumnMapEntry, SWIGTYPE_p_float> dataMap = new HashMap<XtEchosColumnMapEntry, SWIGTYPE_p_float>();
            ArrayList<XtEchosColumnMapEntry> allEntries = new ArrayList<XtEchosColumnMapEntry>();
            for (XtEchosColumnMapEntry xtEchosColumnMapEntry : keyEntries) {
                allEntries.add(xtEchosColumnMapEntry);
                sColumnName = xtEchosColumnMapEntry.getColumnName();
                iColumn = geometryTable.column_indexOfColumn(sColumnName);
                if (iColumn < 0) {
                    throw new Exception("Column " + xtEchosColumnMapEntry.getColumnName() + " not found in table " + sTableName);
                }
                xtEchosColumnMapEntry.setTableColumnIndex(iColumn);
            }
            for (XtEchosColumnMapEntry xtEchosColumnMapEntry : valueEntries) {
                allEntries.add(xtEchosColumnMapEntry);
                sColumnName = xtEchosColumnMapEntry.getColumnName();
                iColumn = -1;
                if (solutionTable.column_exists(sColumnName)) {
                    iColumn = solutionTable.column_indexOfColumn(sColumnName);
                }
                if (iColumn < 0 && !sColumnName.equals("DistanceMoved")) {
                    throw new Exception("Column " + xtEchosColumnMapEntry.getColumnName() + " not found in table " + sTableName);
                }
                xtEchosColumnMapEntry.setTableColumnIndex(iColumn);
            }
            ArrayList<XtEchosColumnMapEntry> valuesToGetEntries = new ArrayList<XtEchosColumnMapEntry>();
            for (XtEchosColumnMapEntry entry : keyEntries) {
                valuesToGetEntries.add(entry);
            }
            valuesToGetEntries.add(eastingEntryEchosOriginalValue);
            valuesToGetEntries.add(northingEntryEchosOriginalValue);
            for (XtEchosColumnMapEntry entry : valuesToGetEntries) {
                XtParadigmSeisDataAttributeInfo info = XtParadigmTableTools.getSeisDataAttribute(attrInfoList, sEchosModel, entry.getEchosEvent(), entry.getEchosAttribute());
                if (info == null) {
                    throw new Exception("Unable to find AttributeInfo for : " + sEchosModel + " : " + entry.getEchosEvent() + " : " + entry.getEchosAttribute());
                }
                if (info.getNvals() > 1) {
                    throw new Exception("Nvals greater than 1 is not supported : " + Integer.toString(info.getNvals()) + " " + sEchosModel + " : " + entry.getEchosEvent() + " : " + entry.getEchosAttribute());
                }
                if (nRows < 0) {
                    nRows = info.getNlocs();
                    nBufferSize = nRows * 2;
                } else if (nRows != info.getNlocs()) {
                    throw new Exception("Inconsistent Nlocs : " + sEchosModel + " : " + entry.getEchosEvent() + " : " + entry.getEchosAttribute());
                }
                floatArray = EchosInterface.new_floatArray(nBufferSize);
                entryInfoMap.put(entry, info);
                dataMap.put(entry, floatArray);
            }
            for (XtEchosColumnMapEntry entry : valueEntries) {
                XtParadigmSeisDataAttributeInfo info = XtParadigmTableTools.getSeisDataAttribute(attrInfoList, sEchosModel, entry.getEchosEvent(), entry.getEchosAttribute());
                if (info == null) {
                    info = new XtParadigmSeisDataAttributeInfo();
                    info.setLine(sEchosLine);
                    info.setModel(sEchosModel);
                    info.setEvent(entry.getEchosEvent());
                    info.setAttribute(entry.getEchosAttribute());
                    info.setFirst(modelInfo.getFirst());
                    info.setLast(modelInfo.getLast());
                    info.setMdate("");
                    info.setInterp("");
                    info.setNlocs(modelInfo.getNlocs());
                    info.setNvals(1);
                    info.setXunit("");
                    if (modelInfo.getNlocs() != nRows) {
                        throw new Exception("Row count error in model : " + sEchosModel + " " + Integer.toString(modelInfo.getNlocs()) + " " + Integer.toString(nRows));
                    }
                } else if (info.getNvals() > 1) {
                    throw new Exception("Nvals greater than 1 is not supported : " + Integer.toString(info.getNvals()) + " " + sEchosModel + " : " + entry.getEchosEvent() + " : " + entry.getEchosAttribute());
                }
                floatArray = EchosInterface.new_floatArray(nBufferSize);
                entryInfoMap.put(entry, info);
                dataMap.put(entry, floatArray);
            }
            for (XtEchosColumnMapEntry entry : valuesToGetEntries) {
                XtParadigmSeisDataAttributeInfo info = (XtParadigmSeisDataAttributeInfo)entryInfoMap.get(entry);
                floatArray = (SWIGTYPE_p_float)dataMap.get(entry);
                Result result = new Result();
                XtParadigmSeisDataDB.echos_sdb_atrget_float(info, floatArray, nBufferSize, result);
                if (result.getErrorCode() == 0) continue;
                throw new Exception("Error getting event attribute : " + info.getEvent() + " " + info.getAttribute() + " : " + result.getErrorMessage());
            }
            int n = geometryTable.row_count();
            int nSolutionRows = solutionTable.row_count();
            HashMap_Integers<Integer> map = new HashMap_Integers<Integer>();
            HashMap<Integer, Integer> solutionMap = new HashMap<Integer, Integer>();
            int[] columnIndexes = new int[3];
            for (int i2 = 0; i2 < 3; ++i2) {
                columnIndexes[i2] = -1;
            }
            for (int iKey = 0; iKey < nKeys; ++iKey) {
                int iIndex;
                String sColumn = keyEntries.get(iKey).getColumnName();
                columnIndexes[iKey] = iIndex = geometryTable.column_indexOfColumn(sColumn);
            }
            boolean bUniqueMap = true;
            int iGeometryTableIdColumn = geometryTable.column_indexOfColumn(sTableID);
            int iSolutionTableIdColumn = solutionTable.column_indexOfColumn(sTableID);
            for (i = 0; i < n; ++i) {
                int iKeyVal1 = 0;
                int iKeyVal2 = 0;
                int iKeyVal3 = 0;
                int id = geometryTable.getInt(i, iGeometryTableIdColumn);
                if (columnIndexes[0] >= 0) {
                    iKeyVal1 = geometryTable.getInt(i, columnIndexes[0]);
                }
                if (columnIndexes[1] >= 0) {
                    iKeyVal2 = geometryTable.getInt(i, columnIndexes[1]);
                }
                if (columnIndexes[2] >= 0) {
                    iKeyVal3 = geometryTable.getInt(i, columnIndexes[2]);
                }
                if (!map.containsKey(iKeyVal1, iKeyVal2, iKeyVal3)) {
                    map.put(id, iKeyVal1, iKeyVal2, iKeyVal3);
                    continue;
                }
                bUniqueMap = false;
            }
            for (i = 0; i < nSolutionRows; ++i) {
                int index;
                int id = solutionTable.getInt(i, iSolutionTableIdColumn);
                solutionMap.put(id, i);
                if (id != 3549 || (index = ((Integer)solutionMap.get(3549)).intValue()) >= 0) continue;
                int iii = 0;
                ++iii;
            }
            if (!bUniqueMap) {
                StringBuilder sb = new StringBuilder();
                for (XtEchosColumnMapEntry tmpEntry : keyEntries) {
                    sb.append(tmpEntry.getColumnName());
                    sb.append(" ");
                }
                throw new Exception("column keys for table ( " + sTableName + " ) do not map to unique row indices : " + sb.toString());
            }
            XtEchosColumnMapEntry keyEntry1 = null;
            XtEchosColumnMapEntry keyEntry2 = null;
            XtEchosColumnMapEntry keyEntry3 = null;
            if (nKeys >= 1) {
                keyEntry1 = keyEntries.get(0);
            }
            if (nKeys >= 2) {
                keyEntry2 = keyEntries.get(1);
            }
            if (nKeys >= 3) {
                keyEntry3 = keyEntries.get(2);
            }
            SWIGTYPE_p_float keyData1 = null;
            SWIGTYPE_p_float keyData2 = null;
            SWIGTYPE_p_float keyData3 = null;
            SWIGTYPE_p_float echosEastingData = null;
            SWIGTYPE_p_float echosNorthingData = null;
            if (keyEntry1 != null) {
                keyData1 = (SWIGTYPE_p_float)dataMap.get(keyEntry1);
            }
            if (keyEntry2 != null) {
                keyData2 = (SWIGTYPE_p_float)dataMap.get(keyEntry2);
            }
            if (keyEntry3 != null) {
                keyData3 = (SWIGTYPE_p_float)dataMap.get(keyEntry3);
            }
            echosEastingData = (SWIGTYPE_p_float)dataMap.get(eastingEntryEchosOriginalValue);
            echosNorthingData = (SWIGTYPE_p_float)dataMap.get(northingEntryEchosOriginalValue);
            if (echosEastingData == null) {
                throw new Exception("missing Echos X COORD");
            }
            if (echosNorthingData == null) {
                throw new Exception("missing Echos Y COORD");
            }
            int nMatches = 0;
            int nMisses = 0;
            for (int iRow = 0; iRow < nRows; ++iRow) {
                int iKeyVal1 = 0;
                int iKeyVal2 = 0;
                int iKeyVal3 = 0;
                int iTableID = -1;
                int iTableRow = -1;
                double dEchosOriginalEasting = 0.0;
                double dEchosOriginalNorthing = 0.0;
                double dFlatironsEasting = 0.0;
                double dFlatironsNorthing = 0.0;
                if (keyData1 != null) {
                    iKeyVal1 = (int)EchosInterface.floatArray_getitem(keyData1, iRow);
                }
                if (keyData2 != null) {
                    iKeyVal2 = (int)EchosInterface.floatArray_getitem(keyData2, iRow);
                }
                if (keyData3 != null) {
                    iKeyVal3 = (int)EchosInterface.floatArray_getitem(keyData3, iRow);
                }
                dEchosOriginalEasting = EchosInterface.floatArray_getitem(echosEastingData, iRow);
                dEchosOriginalNorthing = EchosInterface.floatArray_getitem(echosNorthingData, iRow);
                if (map.containsKey(iKeyVal1, iKeyVal2, iKeyVal3) && solutionMap.containsKey(iTableID = ((Integer)map.get(iKeyVal1, iKeyVal2, iKeyVal3)).intValue())) {
                    iTableRow = (Integer)solutionMap.get(iTableID);
                }
                if (iTableRow >= 0) {
                    ++nMatches;
                } else {
                    ++nMisses;
                }
                if (iTableRow >= 0) {
                    dFlatironsEasting = solutionTable.getDouble(iTableRow, eastingEntry.getTableColumnIndex());
                    dFlatironsNorthing = solutionTable.getDouble(iTableRow, northingEntry.getTableColumnIndex());
                } else {
                    dFlatironsEasting = dEchosOriginalEasting;
                    dFlatironsNorthing = dEchosOriginalNorthing;
                }
                double dx = dFlatironsEasting - dEchosOriginalEasting;
                double dy = dFlatironsNorthing - dEchosOriginalNorthing;
                double dDistanceMoved = Math.sqrt(dx * dx + dy * dy);
                SWIGTYPE_p_float valueDataFlatironsEasting = (SWIGTYPE_p_float)dataMap.get(eastingEntry);
                EchosInterface.floatArray_setitem(valueDataFlatironsEasting, iRow, (float)dFlatironsEasting);
                SWIGTYPE_p_float valueDataFlatironsNorthing = (SWIGTYPE_p_float)dataMap.get(northingEntry);
                EchosInterface.floatArray_setitem(valueDataFlatironsNorthing, iRow, (float)dFlatironsNorthing);
                SWIGTYPE_p_float valueDataDistanceMoved = (SWIGTYPE_p_float)dataMap.get(movedEntry);
                EchosInterface.floatArray_setitem(valueDataDistanceMoved, iRow, (float)dDistanceMoved);
            }
            for (XtEchosColumnMapEntry entry : valueEntries) {
                Result result = new Result();
                SWIGTYPE_p_float valueData = (SWIGTYPE_p_float)dataMap.get(entry);
                XtParadigmSeisDataAttributeInfo attrInfo = (XtParadigmSeisDataAttributeInfo)entryInfoMap.get(entry);
                XtParadigmSeisDataDB.sdb_atrput_float(attrInfo, valueData, nBufferSize, result);
                if (result.getErrorCode() == 0) continue;
                throw new Exception("Error setting event attribute value : " + attrInfo.getEvent() + " " + attrInfo.getAttribute() + " : " + result.getErrorMessage());
            }
            tableExportResult.NumEchosRows = nRows;
            tableExportResult.NumXtGeoRows = nSolutionRows;
            tableExportResult.NumKeyMatches = nMatches;
            tableExportResult.NumKeyMisses = nMisses;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
        return tableExportResult;
    }

    public static TableExportResult exportTableColumnToEchos(Table_Abstract geometryTable, Table_Abstract solutionTable, XtEchosColumnMap columnMap, String sEchosSurvey, String sEchosLine, String sEchosHost) throws Exception {
        TableExportResult tableExportResult = new TableExportResult();
        try {
            int i;
            XtParadigmSeisDataAttributeInfo info;
            int iColumn;
            String sColumnName;
            if (columnMap == null) {
                throw new Exception("null column map");
            }
            if (geometryTable == null) {
                throw new Exception("null geometryTable table");
            }
            if (solutionTable == null) {
                throw new Exception("null solutionTable table");
            }
            String sEchosModel = columnMap.getEchosModel();
            String sTableName = columnMap.getTableName();
            String sTableID = "";
            if (sTableName.toUpperCase().equals("Receiver".toUpperCase())) {
                sTableID = "ReceiverID".toUpperCase();
            } else if (sTableName.toUpperCase().equals("Shot".toUpperCase())) {
                sTableID = "ShotID".toUpperCase();
            } else {
                throw new Exception("Invalid table name " + sTableName);
            }
            List<XtEchosColumnMapEntry> keyEntries = columnMap.keyEntries();
            List<XtEchosColumnMapEntry> valueEntries = columnMap.valueEntries();
            int nKeys = keyEntries.size();
            if (keyEntries.size() == 0) {
                throw new Exception("no key entries");
            }
            if (keyEntries.size() > 3) {
                throw new Exception("num keys greater than 3 is not supported");
            }
            if (valueEntries.size() == 0) {
                throw new Exception("no value entries");
            }
            XtParadigmTableTools.openEchosSurveySeisDataDB(sEchosSurvey, sEchosLine, sEchosHost);
            XtParadigmSeisDataAttributeInfoList attrInfoList = XtParadigmTableTools.getAttributeInfoList(sEchosModel, sEchosLine);
            int nRows = -999;
            int nBufferSize = -999;
            XtParadigmSeisDataModelInfo stationModelInfo = XtParadigmSeisDataDB.echos_sdb_mdlget(sEchosLine, "STATION");
            int iResult = stationModelInfo.getResult();
            if (iResult != 0) {
                throw new Exception("Failed to get STATION model : " + XtParadigmSeisDataDB.getErrorMessage(iResult));
            }
            XtParadigmSeisDataModelInfo shotModelInfo = XtParadigmSeisDataDB.echos_sdb_mdlget(sEchosLine, "SHOT");
            iResult = shotModelInfo.getResult();
            if (iResult != 0) {
                throw new Exception("Failed to get SHOT model : " + XtParadigmSeisDataDB.getErrorMessage(iResult));
            }
            XtParadigmSeisDataModelInfo modelInfo = null;
            if (sEchosModel.equals("SHOT")) {
                modelInfo = shotModelInfo;
            } else if (sEchosModel.equals("STATION")) {
                modelInfo = stationModelInfo;
            } else {
                throw new Exception("Invalid Echos Model : " + sEchosModel);
            }
            HashMap<XtEchosColumnMapEntry, XtParadigmSeisDataAttributeInfo> entryInfoMap = new HashMap<XtEchosColumnMapEntry, XtParadigmSeisDataAttributeInfo>();
            HashMap<XtEchosColumnMapEntry, SWIGTYPE_p_float> dataMap = new HashMap<XtEchosColumnMapEntry, SWIGTYPE_p_float>();
            ArrayList<XtEchosColumnMapEntry> allEntries = new ArrayList<XtEchosColumnMapEntry>();
            for (XtEchosColumnMapEntry entry : keyEntries) {
                allEntries.add(entry);
                sColumnName = entry.getColumnName();
                iColumn = geometryTable.column_indexOfColumn(sColumnName);
                if (iColumn < 0) {
                    throw new Exception("Column " + entry.getColumnName() + " not found in table " + sTableName);
                }
                entry.setTableColumnIndex(iColumn);
            }
            for (XtEchosColumnMapEntry entry : valueEntries) {
                allEntries.add(entry);
                sColumnName = entry.getColumnName();
                iColumn = solutionTable.column_indexOfColumn(sColumnName);
                if (iColumn < 0) {
                    throw new Exception("Column " + entry.getColumnName() + " not found in table " + sTableName);
                }
                entry.setTableColumnIndex(iColumn);
            }
            for (XtEchosColumnMapEntry entry : keyEntries) {
                info = XtParadigmTableTools.getSeisDataAttribute(attrInfoList, sEchosModel, entry.getEchosEvent(), entry.getEchosAttribute());
                if (info == null) {
                    throw new Exception("Unable to find AttributeInfo for : " + sEchosModel + " : " + entry.getEchosEvent() + " : " + entry.getEchosAttribute());
                }
                if (info.getNvals() > 1) {
                    throw new Exception("Nvals greater than 1 is not supported : " + Integer.toString(info.getNvals()) + " " + sEchosModel + " : " + entry.getEchosEvent() + " : " + entry.getEchosAttribute());
                }
                if (nRows < 0) {
                    nRows = info.getNlocs();
                    nBufferSize = nRows * 2;
                } else if (nRows != info.getNlocs()) {
                    throw new Exception("Inconsistent Nlocs : " + sEchosModel + " : " + entry.getEchosEvent() + " : " + entry.getEchosAttribute());
                }
                SWIGTYPE_p_float floatArray = EchosInterface.new_floatArray(nBufferSize);
                entryInfoMap.put(entry, info);
                dataMap.put(entry, floatArray);
            }
            for (XtEchosColumnMapEntry entry : valueEntries) {
                info = XtParadigmTableTools.getSeisDataAttribute(attrInfoList, sEchosModel, entry.getEchosEvent(), entry.getEchosAttribute());
                if (info == null) {
                    info = new XtParadigmSeisDataAttributeInfo();
                    info.setLine(sEchosLine);
                    info.setModel(sEchosModel);
                    info.setEvent(entry.getEchosEvent());
                    info.setAttribute(entry.getEchosAttribute());
                    info.setFirst(modelInfo.getFirst());
                    info.setLast(modelInfo.getLast());
                    info.setMdate("");
                    info.setInterp("");
                    info.setNlocs(modelInfo.getNlocs());
                    info.setNvals(1);
                    info.setXunit("");
                    if (modelInfo.getNlocs() != nRows) {
                        throw new Exception("Row count error in model : " + sEchosModel + " " + Integer.toString(modelInfo.getNlocs()) + " " + Integer.toString(nRows));
                    }
                } else if (info.getNvals() > 1) {
                    throw new Exception("Nvals greater than 1 is not supported : " + Integer.toString(info.getNvals()) + " " + sEchosModel + " : " + entry.getEchosEvent() + " : " + entry.getEchosAttribute());
                }
                SWIGTYPE_p_float floatArray = EchosInterface.new_floatArray(nBufferSize);
                entryInfoMap.put(entry, info);
                dataMap.put(entry, floatArray);
            }
            for (XtEchosColumnMapEntry entry : keyEntries) {
                info = (XtParadigmSeisDataAttributeInfo)entryInfoMap.get(entry);
                SWIGTYPE_p_float floatArray = (SWIGTYPE_p_float)dataMap.get(entry);
                Result result = new Result();
                XtParadigmSeisDataDB.echos_sdb_atrget_float(info, floatArray, nBufferSize, result);
                if (result.getErrorCode() == 0) continue;
                throw new Exception("Error getting event attribute for key : " + info.getEvent() + " " + info.getAttribute() + " : " + result.getErrorMessage());
            }
            int nGeometryRows = geometryTable.row_count();
            int nSolutionRows = solutionTable.row_count();
            HashMap_Integers<Integer> map = new HashMap_Integers<Integer>();
            HashMap<Integer, Integer> solutionMap = new HashMap<Integer, Integer>();
            int[] columnIndexes = new int[3];
            for (int i2 = 0; i2 < 3; ++i2) {
                columnIndexes[i2] = -1;
            }
            for (int iKey = 0; iKey < nKeys; ++iKey) {
                int iIndex;
                String sColumn = keyEntries.get(iKey).getColumnName();
                columnIndexes[iKey] = iIndex = geometryTable.column_indexOfColumn(sColumn);
            }
            boolean bUniqueMap = true;
            int iGeometryTableIdColumn = geometryTable.column_indexOfColumn(sTableID);
            int iSolutionTableIdColumn = solutionTable.column_indexOfColumn(sTableID);
            for (i = 0; i < nGeometryRows; ++i) {
                int iKeyVal1 = 0;
                int iKeyVal2 = 0;
                int iKeyVal3 = 0;
                int id = geometryTable.getInt(i, iGeometryTableIdColumn);
                if (columnIndexes[0] >= 0) {
                    iKeyVal1 = geometryTable.getInt(i, columnIndexes[0]);
                }
                if (columnIndexes[1] >= 0) {
                    iKeyVal2 = geometryTable.getInt(i, columnIndexes[1]);
                }
                if (columnIndexes[2] >= 0) {
                    iKeyVal3 = geometryTable.getInt(i, columnIndexes[2]);
                }
                if (!map.containsKey(iKeyVal1, iKeyVal2, iKeyVal3)) {
                    map.put(id, iKeyVal1, iKeyVal2, iKeyVal3);
                    continue;
                }
                bUniqueMap = false;
            }
            for (i = 0; i < nSolutionRows; ++i) {
                int index;
                int id = solutionTable.getInt(i, iSolutionTableIdColumn);
                solutionMap.put(id, i);
                if (id != 3549 || (index = ((Integer)solutionMap.get(3549)).intValue()) >= 0) continue;
                int iii = 0;
                ++iii;
            }
            if (!bUniqueMap) {
                StringBuilder sb = new StringBuilder();
                for (XtEchosColumnMapEntry tmpEntry : keyEntries) {
                    sb.append(tmpEntry.getColumnName());
                    sb.append(" ");
                }
                throw new Exception("column keys for table ( " + sTableName + " ) do not map to unique row indices : " + sb.toString());
            }
            XtEchosColumnMapEntry keyEntry1 = null;
            XtEchosColumnMapEntry keyEntry2 = null;
            XtEchosColumnMapEntry keyEntry3 = null;
            if (nKeys >= 1) {
                keyEntry1 = keyEntries.get(0);
            }
            if (nKeys >= 2) {
                keyEntry2 = keyEntries.get(1);
            }
            if (nKeys >= 3) {
                keyEntry3 = keyEntries.get(2);
            }
            SWIGTYPE_p_float keyData1 = null;
            SWIGTYPE_p_float keyData2 = null;
            SWIGTYPE_p_float keyData3 = null;
            if (keyEntry1 != null) {
                keyData1 = (SWIGTYPE_p_float)dataMap.get(keyEntry1);
            }
            if (keyEntry2 != null) {
                keyData2 = (SWIGTYPE_p_float)dataMap.get(keyEntry2);
            }
            if (keyEntry3 != null) {
                keyData3 = (SWIGTYPE_p_float)dataMap.get(keyEntry3);
            }
            int nMatches = 0;
            int nMisses = 0;
            for (int iRow = 0; iRow < nRows; ++iRow) {
                int iKeyVal1 = 0;
                int iKeyVal2 = 0;
                int iKeyVal3 = 0;
                int iTableID = -1;
                int iTableRow = -1;
                if (keyData1 != null) {
                    iKeyVal1 = (int)EchosInterface.floatArray_getitem(keyData1, iRow);
                }
                if (keyData2 != null) {
                    iKeyVal2 = (int)EchosInterface.floatArray_getitem(keyData2, iRow);
                }
                if (keyData3 != null) {
                    iKeyVal3 = (int)EchosInterface.floatArray_getitem(keyData3, iRow);
                }
                if (map.containsKey(iKeyVal1, iKeyVal2, iKeyVal3) && solutionMap.containsKey(iTableID = ((Integer)map.get(iKeyVal1, iKeyVal2, iKeyVal3)).intValue())) {
                    iTableRow = (Integer)solutionMap.get(iTableID);
                }
                if (iTableRow >= 0) {
                    ++nMatches;
                } else {
                    ++nMisses;
                }
                for (XtEchosColumnMapEntry entry : valueEntries) {
                    float fOutputValue = entry.getDefaultValue();
                    if (iTableRow >= 0) {
                        fOutputValue = solutionTable.getFloat(iTableRow, entry.getTableColumnIndex());
                    } else if (!entry.getUseDefaultValueOnError()) {
                        throw new Exception("key not found for table : " + sTableName + " " + Integer.toString(iKeyVal1) + " " + Integer.toString(iKeyVal2) + " " + Integer.toString(iKeyVal3));
                    }
                    SWIGTYPE_p_float valueData = (SWIGTYPE_p_float)dataMap.get(entry);
                    EchosInterface.floatArray_setitem(valueData, iRow, fOutputValue);
                }
            }
            for (XtEchosColumnMapEntry entry : valueEntries) {
                Result result = new Result();
                SWIGTYPE_p_float valueData = (SWIGTYPE_p_float)dataMap.get(entry);
                XtParadigmSeisDataAttributeInfo attrInfo = (XtParadigmSeisDataAttributeInfo)entryInfoMap.get(entry);
                XtParadigmSeisDataDB.sdb_atrput_float(attrInfo, valueData, nBufferSize, result);
                if (result.getErrorCode() == 0) continue;
                throw new Exception("Error setting event attribute value : " + attrInfo.getEvent() + " " + attrInfo.getAttribute() + " : " + result.getErrorMessage());
            }
            tableExportResult.NumEchosRows = nRows;
            tableExportResult.NumXtGeoRows = nSolutionRows;
            tableExportResult.NumKeyMatches = nMatches;
            tableExportResult.NumKeyMisses = nMisses;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
        return tableExportResult;
    }

    public static XtParadigmSeisDataAttributeInfo getSeisDataAttribute(XtParadigmSeisDataAttributeInfoList list, String sModel, String sEvent, String sAttribute) {
        XtParadigmSeisDataAttributeInfo tmpInfo;
        int i;
        int nEntries = list.size();
        int nRows = 0;
        for (i = 0; i < nEntries; ++i) {
            tmpInfo = list.get(i);
            if (!tmpInfo.getModel().equals(sModel) || !tmpInfo.getEvent().equalsIgnoreCase("Model") || !tmpInfo.getAttribute().equalsIgnoreCase("Model")) continue;
            nRows = tmpInfo.getNlocs();
        }
        for (i = 0; i < nEntries; ++i) {
            tmpInfo = list.get(i);
            if (!tmpInfo.getModel().equals(sModel) || !tmpInfo.getEvent().equals(sEvent) || !tmpInfo.getAttribute().equals(sAttribute) || tmpInfo.getNlocs() != nRows) continue;
            return tmpInfo;
        }
        return null;
    }
}

