/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Echos;

import com.PecosCore.Shared.SharedApplicationData;
import com.PecosLibrary.Application.AppLauncher;
import com.PecosLibrary.Echos.EchosUserDialog;
import com.PecosLibrary.Echos.Result;
import com.PecosLibrary.Echos.XtLineInfo;
import com.PecosLibrary.Echos.XtParadigmEnvironment;
import com.PecosLibrary.Echos.XtParadigmEposUser;
import com.PecosLibrary.Echos.XtParadigmFileRecList;
import com.PecosLibrary.Echos.XtParadigmProject;
import com.PecosLibrary.Echos.XtParadigmSurvey;
import com.PecosLibrary.Echos.XtStringList;
import com.PecosLibrary.Echos.XtStudyInfoList;
import com.PecosLibrary.Windows.Echos.Environment;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;

public class XtEchos {
    public static XtParadigmEnvironment ParadigmEnvironment = null;
    static Exception _lastInitializeError = null;
    static UnsatisfiedLinkError _unsatisfiedLinkError = null;
    static String _sUser;
    static boolean _bLoadEposLibraryOK;
    static boolean _bInitializeParadigmEnvironmentOK;

    public static UnsatisfiedLinkError getUnsatisfiedLinkError() {
        return _unsatisfiedLinkError;
    }

    public static boolean getLoadEposLibraryOK() {
        return _bLoadEposLibraryOK;
    }

    public static boolean getInitializeParadigmEnvironmentOK() {
        return _bInitializeParadigmEnvironmentOK;
    }

    public static String getUser() {
        return _sUser;
    }

    public static XtStudyInfoList getStudyInfoList() {
        if (ParadigmEnvironment == null) {
            return null;
        }
        return ParadigmEnvironment.getStudyInfoList();
    }

    public static XtParadigmSurvey getParadigmSurvey(String sName, String sHost, int iSurveyType) throws Exception {
        if (iSurveyType == 1) {
            int kkk = 0;
            ++kkk;
        }
        String sNameAtHost = sName + "@" + sHost;
        XtParadigmProject.setActiveSurvey(sName, sHost);
        XtParadigmSurvey survey = new XtParadigmSurvey(sNameAtHost, iSurveyType);
        boolean bIsValid = survey.getIsValid();
        String sLastError = survey.getLastError();
        if (!bIsValid) {
            throw new Exception("Invalid survey : " + sName + " " + sHost + " : " + sLastError);
        }
        if (!bIsValid) {
            System.out.println("Invalid survey : " + sName + " " + sHost);
        }
        int nLines = survey.getNumLineInfo();
        for (int i = 0; i < nLines; ++i) {
            XtLineInfo lineInfo = survey.getLineInfo(i);
            String sLineName = lineInfo.getName();
            long l = lineInfo.getId();
        }
        return survey;
    }

    public static List<XtLineInfo> getLineInfoList(String sSurvey, String sHost, int iSurveyType) throws Exception {
        if (ParadigmEnvironment == null) {
            return null;
        }
        String sNameAtHost = sSurvey + "@" + sHost;
        XtParadigmProject.setActiveSurvey(sSurvey, sHost);
        XtParadigmSurvey survey = new XtParadigmSurvey(sNameAtHost, iSurveyType);
        boolean bIsValid = survey.getIsValid();
        String sLastError = survey.getLastError();
        if (!bIsValid) {
            throw new Exception("Invalid survey : " + sSurvey + " " + sHost + " : " + sLastError);
        }
        ArrayList<XtLineInfo> list = new ArrayList<XtLineInfo>();
        int nLines = survey.getNumLineInfo();
        for (int i = 0; i < nLines; ++i) {
            XtLineInfo lineInfo = survey.getLineInfo(i);
            String sLineName = lineInfo.getName();
            list.add(lineInfo);
        }
        return list;
    }

    public static XtParadigmFileRecList getFileRecList(String sName, String sHost, int iSurveyType) throws Exception {
        if (ParadigmEnvironment == null) {
            return null;
        }
        String sNameAtHost = sName + "@" + sHost;
        XtParadigmProject.setActiveSurvey(sName, sHost);
        XtParadigmSurvey survey = new XtParadigmSurvey(sNameAtHost, iSurveyType);
        boolean bIsValid = survey.getIsValid();
        String sLastError = survey.getLastError();
        if (!bIsValid) {
            throw new Exception("Invalid survey : " + sName + " " + sHost + " : " + sLastError);
        }
        int nLines = survey.getNumLineInfo();
        for (int i = 0; i < nLines; ++i) {
            XtLineInfo lineInfo = survey.getLineInfo(i);
            String sLineName = lineInfo.getName();
            long lineId = lineInfo.getId();
            System.out.println(sLineName);
            System.out.println(lineId);
        }
        XtParadigmFileRecList fileRecList = survey.getFileRecList();
        int nFiles = fileRecList.size();
        System.out.println("nFiles = " + nFiles);
        return fileRecList;
    }

    XtEchos(String user) {
        _sUser = user;
    }

    public static boolean initialized() {
        return ParadigmEnvironment != null;
    }

    public static boolean initializeAndShowErrorDialog() {
        boolean bEchosSetupOK = Environment.getIsEchosEnvironmentSetupOK("Pecos");
        if (!bEchosSetupOK) {
            return false;
        }
        boolean bEchosInitializedOk = XtEchos.initialize();
        if (!bEchosInitializedOk) {
            Exception lastError = XtEchos.getLastInitializeError();
            boolean bLoadLibraryOK = XtEchos.getLoadEposLibraryOK();
            boolean initializeParadigmOK = XtEchos.getInitializeParadigmEnvironmentOK();
            String sError = "Error connecting to Echos";
            if (!bLoadLibraryOK) {
                sError = "Error loading Echos library";
            }
            if (!initializeParadigmOK) {
                sError = "Error calling PG_InitializeApplication";
            }
            String sErrorDetails = "";
            if (lastError != null) {
                sErrorDetails = lastError.getMessage();
            }
            JOptionPane.showMessageDialog(null, sError, sErrorDetails, 0);
            return false;
        }
        return bEchosInitializedOk;
    }

    public static boolean initialize() {
        if (_lastInitializeError != null) {
            return false;
        }
        if (ParadigmEnvironment != null) {
            return true;
        }
        try {
            boolean bParadigmVersionOK;
            String sUserName = SharedApplicationData.singleton().getEchosUser();
            if (sUserName.equals("")) {
                EchosUserDialog.setEchosUserName();
            }
            if ((sUserName = SharedApplicationData.singleton().getEchosUser()).equals("")) {
                JOptionPane.showMessageDialog(null, "Echos User is not set", "Error", 0);
                return false;
            }
            String sParadigmReleaseBrand = System.getenv("PG_RELEASE_BRAND");
            if (sParadigmReleaseBrand == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("Paradigm Echos environment is not setup, PG_RELEASE_BRAND not found\n");
                sb.append("Please exit , then run the following command in the shell before restarting\n");
                sb.append("pgstart -cmd=\"csh -f\"\n");
                sb.append("'pgstart' is located in the 'PGHOME/Applications/bin' directory\n");
                JOptionPane.showMessageDialog(null, sb.toString(), "Error", 0);
                return false;
            }
            boolean bl = bParadigmVersionOK = sParadigmReleaseBrand.equals("15") || sParadigmReleaseBrand.equals("15.5") || sParadigmReleaseBrand.equals("17") || sParadigmReleaseBrand.equals("18") || sParadigmReleaseBrand.equals("19");
            if (!bParadigmVersionOK) {
                StringBuilder sb = new StringBuilder();
                sb.append("Paradigm Echos environment for version " + sParadigmReleaseBrand + " is not supported yet\n");
                JOptionPane.showMessageDialog(null, sb.toString(), "Error", 0);
                return false;
            }
            String sLibraryName = "libXtEchos_" + sParadigmReleaseBrand + ".so";
            String exeDir = AppLauncher.getExecuteableDirectory();
            Object sLibraryPath = exeDir + "/lib/" + sLibraryName;
            if (sParadigmReleaseBrand.equals("15")) {
                sLibraryPath = exeDir + "/lib/libXtEchosLib.so";
            }
            String sDebugPath = "/home/xtgeo/OpenGeo/Paradigm-15.5/arch/Linux_x64_2.12_i15/lib/" + sLibraryName;
            if (sParadigmReleaseBrand.equals("15")) {
                sDebugPath = "/home/xtgeo/Paradigm-15/OpenGeo/arch/Linux_x64_2.5.0_il2/bin/" + sLibraryName;
            } else if (sParadigmReleaseBrand.equals("17")) {
                sDebugPath = "/home/xtgeo/OpenGeo/Paradigm-17/arch/Linux_x64_2.12_i15/lib/" + sLibraryName;
            }
            File fDebugFile = new File(sDebugPath);
            if (fDebugFile.exists()) {
                sLibraryPath = fDebugFile.getAbsolutePath();
            }
            try {
                File libraryPathFile = new File((String)sLibraryPath);
                if (!libraryPathFile.exists()) {
                    throw new Exception("Missing Library file : " + (String)sLibraryPath);
                }
                System.load((String)sLibraryPath);
            }
            catch (UnsatisfiedLinkError e) {
                _unsatisfiedLinkError = e;
                throw new Exception("Error loading library : " + e.getMessage());
            }
            _bLoadEposLibraryOK = true;
            _sUser = sUserName;
            ParadigmEnvironment = new XtParadigmEnvironment();
            XtStringList argsList = new XtStringList();
            argsList.add("");
            argsList.add("");
            argsList.add("");
            argsList.add("");
            Result result = ParadigmEnvironment.initialize(argsList);
            if (result.getErrorCode() != 0) {
                throw new Exception("Init Paradigm Environment failed: " + result.getErrorMessage());
            }
            XtParadigmEposUser.setCurrentEposUser(_sUser);
            return true;
        }
        catch (Exception ex) {
            _lastInitializeError = ex;
            return false;
        }
    }

    public static Exception getLastInitializeError() {
        return _lastInitializeError;
    }

    public static String getLineName(int iLineID, XtParadigmSurvey survey) throws Exception {
        String sLineName = "";
        int nLines = survey.getNumLineInfo();
        for (int iLine = 0; iLine < nLines; ++iLine) {
            XtLineInfo lineInfo = survey.getLineInfo(iLine);
            if (lineInfo.getId() != (long)iLineID) continue;
            sLineName = lineInfo.getShortName();
            break;
        }
        return sLineName;
    }

    static {
        _bLoadEposLibraryOK = false;
        _bInitializeParadigmEnvironmentOK = false;
    }
}

