/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Data.TraceTable;

import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Shared.ExceptionMonitor;
import javax.swing.table.AbstractTableModel;

public class TraceTable_SimpleModel
extends AbstractTableModel {
    protected ITraceTable m_table;

    public TraceTable_SimpleModel(ITraceTable table) {
        this.m_table = table;
    }

    @Override
    public String getColumnName(int column) {
        try {
            if (column >= 1) {
                return this.m_table.column_name(column - 1);
            }
            return "Row";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "Error";
        }
    }

    @Override
    public int getRowCount() {
        try {
            if (this.m_table == null) {
                return 0;
            }
            double maxRows = 2.0E9 / (double)(1 + this.m_table.column_count());
            int numRows = Math.min((int)this.m_table.rowCount(), (int)maxRows);
            return Math.min(numRows, 126000000);
        }
        catch (Exception error) {
            return 0;
        }
    }

    @Override
    public int getColumnCount() {
        if (this.m_table == null) {
            return 0;
        }
        return 1 + this.m_table.column_count();
    }

    @Override
    public Object getValueAt(int row, int column) {
        try {
            if (column >= 1) {
                return this.m_table.getString(row, column - 1);
            }
            return Integer.toString(row);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "Error";
        }
    }
}

