/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Data.TraceTable;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Data.TraceTable.TraceTable_ScannerBase;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.Date;

public class TraceTable_Scanner_SeisupPickExport
extends TraceTable_ScannerBase {
    public int ColumnIndex = -9999;
    public float Value = -9999.0f;
    public boolean RequireOutsideBranch = false;
    protected int m_currentFileID = -9999;
    protected boolean m_prepped = false;
    protected int m_indexShotLine;
    protected int m_indexShotPoint;
    protected int m_currentLine = -999;
    protected int m_currentPoint = -999;
    protected BufferedWriter m_writer;
    protected String m_formatD = "D  %8d%8d";
    protected String m_formatV = "V  %12d";
    protected String m_formatE = "V               ";
    protected String m_outputFileName;
    protected RefractionStaticsProject.FileInfo m_fileInfo = null;

    @Override
    public void finishScan() throws Exception {
        try {
            if (this.m_writer != null) {
                this.m_writer.close();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public void work() throws Exception {
        try {
            if (!this.m_prepped) {
                this.m_prepped = true;
                this.m_indexShotLine = this.m_shotTable.column_indexOfColumn("LineNumber");
                this.m_indexShotPoint = this.m_shotTable.column_indexOfColumn("PointNumber");
            }
            if (this.m_fileID < 0) {
                return;
            }
            if (this.m_currentFileID != this.m_fileID) {
                if (this.m_writer != null) {
                    this.m_writer.close();
                }
                this.prepNextFile();
            }
            if (this.m_writer == null) {
                return;
            }
            int shotLine = this.m_shotTable.getInt(this.m_shotRow, this.m_indexShotLine);
            int shotPoint = this.m_shotTable.getInt(this.m_shotRow, this.m_indexShotPoint);
            if (shotLine != this.m_currentLine || shotPoint != this.m_currentPoint) {
                this.m_currentLine = shotLine;
                this.m_currentPoint = shotPoint;
                this.m_writer.write(String.format(this.m_formatD, this.m_currentLine, this.m_currentPoint));
                this.m_writer.newLine();
            }
            if (this.m_fbp > 0.0f) {
                this.m_writer.write(String.format(this.m_formatV, (int)(0.5f + this.m_fbp)));
                this.m_writer.newLine();
            } else {
                this.m_writer.write(this.m_formatE);
                this.m_writer.newLine();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void prepNextFile() {
        try {
            this.m_currentLine = -999;
            this.m_currentPoint = -999;
            this.m_writer = null;
            this.m_currentFileID = this.m_fileID;
            this.m_fileInfo = this.m_project.getFileInfo(this.m_currentFileID);
            if (this.m_fileInfo == null) {
                return;
            }
            Date date = new Date();
            String dateCreated = date.toString();
            String fileName = this.m_fileInfo.FullPath + ".sup";
            this.m_writer = new BufferedWriter(new FileWriter(fileName));
            this.m_writer.write("****************************************");
            this.m_writer.newLine();
            this.m_writer.write("*             Flatirons export");
            this.m_writer.newLine();
            this.m_writer.write("*      " + dateCreated);
            this.m_writer.newLine();
            this.m_writer.write("*");
            this.m_writer.newLine();
            this.m_writer.write("* AREA  ?????           LINE  ????????? ");
            this.m_writer.newLine();
            this.m_writer.write("* NAME  Picks_01        TYPE  AFS1B ");
            this.m_writer.newLine();
            this.m_writer.write("*");
            this.m_writer.newLine();
            this.m_writer.write("*");
            this.m_writer.newLine();
            this.m_writer.write("* DIMENSIONS            COLUMNS ");
            this.m_writer.newLine();
            this.m_writer.write("* SLIN                   3 - 10");
            this.m_writer.newLine();
            this.m_writer.write("* SBIN                  12 - 19");
            this.m_writer.newLine();
            this.m_writer.write("*");
            this.m_writer.newLine();
            this.m_writer.write("* VECTORS               COLUMNS");
            this.m_writer.newLine();
            this.m_writer.write("* Time (ms.)             3 - 14");
            this.m_writer.newLine();
            this.m_writer.write("*");
            this.m_writer.newLine();
            this.m_writer.write("****************************************");
            this.m_writer.newLine();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.m_writer = null;
        }
    }
}

