/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Data.TraceTable;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.DataType;
import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Data.TraceTable.TraceTable_ScannerBase;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Refraction.Database.SegyHeaderExportDialog;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

public class TraceTable_Scanner_SegyHeaderExport
extends TraceTable_ScannerBase {
    public int ColumnIndex = -9999;
    public float Value = -9999.0f;
    public boolean RequireOutsideBranch = false;
    protected ArrayList<SegyHeaderExportDialog.Entry> m_list;
    protected String m_outputDir;
    protected boolean m_prepped = false;
    protected int m_currentFileID = -9999;
    protected RefractionStaticsProject.FileInfo m_fileInfo = null;
    protected Segy m_segy = null;
    protected int m_bytesPerTrace;
    protected ByteOrder m_fileByteOrder = ByteOrder.LITTLE_ENDIAN;
    protected int m_maxTracesPerChunk = 2000;
    protected int m_numValidWithinCurrentChunk = 0;
    protected int m_currentIndexWithinChunk;
    protected int m_currentIndexWithinFile;
    protected ByteBuffer m_buffer;
    protected int m_headerOffset;
    protected double m_coordScalar = 1.0;
    protected double m_elevScalar = 1.0;
    protected String m_outputFileName;

    public TraceTable_Scanner_SegyHeaderExport(String outputDir, ArrayList<SegyHeaderExportDialog.Entry> list) throws Exception {
        try {
            this.m_list = list;
            this.m_outputDir = outputDir;
            for (SegyHeaderExportDialog.Entry entry : this.m_list) {
                entry.IsShot = entry.Table.equalsIgnoreCase("Shot");
                entry.IsRec = entry.Table.equalsIgnoreCase("Receiver");
                entry.IsTrace = entry.Table.equalsIgnoreCase("Trace");
                entry.InputType = DataType.Int;
                entry.ApplyElevScalar = entry.Column.equalsIgnoreCase("Elevation");
                boolean bl = entry.ApplyCoordScalar = entry.Column.equalsIgnoreCase("Easting") || entry.Column.equalsIgnoreCase("Northing");
                if (!entry.IsRec) continue;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public void finishScan() throws Exception {
    }

    protected void prepList() {
        try {
            this.m_prepped = true;
            for (SegyHeaderExportDialog.Entry entry : this.m_list) {
                entry.Valid = false;
                entry.IsShot = entry.Table.equalsIgnoreCase("Shot");
                entry.IsRec = entry.Table.equalsIgnoreCase("Receiver");
                entry.IsTrace = entry.Table.equalsIgnoreCase("Trace");
                entry.InputType = DataType.Int;
                entry.ApplyElevScalar = entry.Column.equalsIgnoreCase("Elevation");
                boolean bl = entry.ApplyCoordScalar = entry.Column.equalsIgnoreCase("Easting") || entry.Column.equalsIgnoreCase("Northing");
                if (entry.IsRec && this.m_recTable.column_exists(entry.Column)) {
                    entry.Valid = true;
                    entry.ColumnIndex = this.m_recTable.column_indexOfColumn(entry.Column);
                    entry.InputType = this.m_recTable.column_type(entry.ColumnIndex);
                }
                if (entry.IsShot && this.m_shotTable.column_exists(entry.Column)) {
                    entry.Valid = true;
                    entry.ColumnIndex = this.m_shotTable.column_indexOfColumn(entry.Column);
                    entry.InputType = this.m_shotTable.column_type(entry.ColumnIndex);
                }
                if (!entry.IsTrace || !this.m_traceTable.column_exists(entry.Column)) continue;
                entry.Valid = true;
                entry.ColumnIndex = this.m_traceTable.column_indexOfColumn(entry.Column);
                entry.InputType = this.m_traceTable.column_type(entry.ColumnIndex);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void prepScalars() {
        try {
            short coordScalar;
            this.m_coordScalar = 1.0;
            this.m_elevScalar = 1.0;
            int elevOffset = this.m_headerOffset + 68;
            int coordOffset = this.m_headerOffset + 70;
            short elevScalar = this.m_buffer.getShort(elevOffset);
            if (elevScalar > 1) {
                this.m_elevScalar = elevScalar;
            }
            if (elevScalar < -1) {
                this.m_elevScalar = -1.0 / (double)elevScalar;
            }
            if ((coordScalar = this.m_buffer.getShort(coordOffset)) > 1) {
                this.m_coordScalar = coordScalar;
            }
            if (coordScalar < -1) {
                this.m_coordScalar = -1.0 / (double)coordScalar;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void work() throws Exception {
        try {
            if (!this.m_prepped) {
                this.prepList();
            }
            if (this.m_fileID < 0) {
                return;
            }
            if (this.m_currentFileID != this.m_fileID) {
                this.prepNextFile();
            }
            if (this.m_segy == null) {
                System.out.println("Massive error = (m_segy == null)");
                return;
            }
            if (this.m_traceIndexWithinFile != (long)this.m_currentIndexWithinFile) {
                System.out.println("m_traceIndexWithinFile != m_currentIndexWithinFile");
                this.m_segy = null;
            }
            this.m_headerOffset = this.m_bytesPerTrace * this.m_currentIndexWithinChunk;
            this.prepScalars();
            for (SegyHeaderExportDialog.Entry entry : this.m_list) {
                if (!entry.Valid) continue;
                double dv = 0.0;
                int iv = 0;
                if (entry.IsShot) {
                    if (entry.InputType == DataType.Int) {
                        iv = this.m_shotTable.getInt(this.m_shotRow, entry.ColumnIndex);
                        dv = iv;
                    } else {
                        dv = this.m_shotTable.getDouble(this.m_shotRow, entry.ColumnIndex);
                        iv = (int)(dv + 0.1);
                    }
                }
                if (entry.IsTrace) {
                    if (entry.InputType == DataType.Int) {
                        iv = this.m_traceTable.getInt(this.m_traceRow, entry.ColumnIndex);
                        dv = iv;
                    } else {
                        dv = this.m_traceTable.getFloat(this.m_traceRow, entry.ColumnIndex);
                        iv = (int)(dv + 0.1);
                    }
                }
                if (entry.IsRec) {
                    if (entry.InputType == DataType.Int) {
                        iv = this.m_recTable.getInt(this.m_recRow, entry.ColumnIndex);
                        dv = iv;
                    } else {
                        dv = this.m_recTable.getDouble(this.m_recRow, entry.ColumnIndex);
                        iv = (int)(dv + 0.1);
                    }
                }
                if (entry.ApplyElevScalar) {
                    iv = (int)((dv *= this.m_elevScalar) + 0.5);
                }
                if (entry.ApplyCoordScalar) {
                    iv = (int)((dv *= this.m_coordScalar) + 0.5);
                }
                int offset = this.m_currentIndexWithinChunk * this.m_bytesPerTrace + entry.Offset - 1;
                if (entry.Type == DataType.Short) {
                    this.m_buffer.putShort(offset, (short)iv);
                    continue;
                }
                if (entry.Type == DataType.Int) {
                    this.m_buffer.putInt(offset, iv);
                    continue;
                }
                if (entry.Type != DataType.Float) continue;
                this.m_buffer.putFloat(offset, (float)dv);
            }
            ++this.m_currentIndexWithinChunk;
            ++this.m_currentIndexWithinFile;
            if (this.m_currentIndexWithinChunk >= this.m_numValidWithinCurrentChunk) {
                RandomAccessFile writer = new RandomAccessFile(this.m_outputFileName, "rw");
                writer.write(this.m_buffer.array(), 0, this.m_numValidWithinCurrentChunk * this.m_bytesPerTrace);
                writer.close();
                this.m_currentIndexWithinChunk = 0;
                if ((long)this.m_currentIndexWithinFile >= this.m_segy.traceCount()) {
                    this.m_segy = null;
                    return;
                }
                long offset = 3600L + (long)this.m_currentIndexWithinFile * (long)this.m_bytesPerTrace;
                RandomAccessFile reader = new RandomAccessFile(this.m_fileInfo.FullPath, "r");
                reader.seek(offset);
                this.m_numValidWithinCurrentChunk = this.m_maxTracesPerChunk;
                int lastIndex = this.m_currentIndexWithinFile + this.m_numValidWithinCurrentChunk - 1;
                if (lastIndex >= (int)this.m_segy.traceCount()) {
                    lastIndex = (int)this.m_segy.traceCount() - 1;
                    this.m_numValidWithinCurrentChunk = lastIndex - this.m_currentIndexWithinFile + 1;
                }
                reader.read(this.m_buffer.array(), 0, this.m_numValidWithinCurrentChunk * this.m_bytesPerTrace);
                reader.close();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void prepNextFile() {
        try {
            this.m_segy = null;
            this.m_currentFileID = this.m_fileID;
            this.m_fileInfo = this.m_project.getFileInfo(this.m_currentFileID);
            if (this.m_fileInfo != null && this.m_fileInfo.SeismicFile instanceof Segy) {
                this.m_segy = (Segy)this.m_fileInfo.SeismicFile;
            }
            if (this.m_segy == null) {
                return;
            }
            this.m_fileByteOrder = this.m_segy.binaryHeader().FileByteOrder;
            this.m_bytesPerTrace = this.m_segy.binaryHeader().BytesPerTrace;
            int numBytesPerChunk = this.m_bytesPerTrace * this.m_maxTracesPerChunk;
            this.m_buffer = ByteBuffer_Shared.buffer(0, numBytesPerChunk);
            this.m_buffer.order(this.m_fileByteOrder);
            RandomAccessFile reader = new RandomAccessFile(this.m_fileInfo.FullPath, "r");
            reader.read(this.m_buffer.array(), 0, 3600);
            this.m_outputFileName = this.m_outputDir + "/" + this.m_fileInfo.Name;
            RandomAccessFile writer = new RandomAccessFile(this.m_outputFileName, "rw");
            writer.write(this.m_buffer.array(), 0, 3600);
            writer.close();
            this.m_currentIndexWithinChunk = 0;
            this.m_currentIndexWithinFile = 0;
            this.m_numValidWithinCurrentChunk = this.m_maxTracesPerChunk;
            int lastIndex = this.m_currentIndexWithinFile + this.m_numValidWithinCurrentChunk - 1;
            if (lastIndex >= (int)this.m_segy.traceCount()) {
                lastIndex = (int)this.m_segy.traceCount() - 1;
                this.m_numValidWithinCurrentChunk = lastIndex - this.m_currentIndexWithinFile + 1;
            }
            reader.read(this.m_buffer.array(), 0, this.m_numValidWithinCurrentChunk * this.m_bytesPerTrace);
            reader.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.m_segy = null;
        }
    }
}

