/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Data.TraceTable;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Data.TraceTable.ITraceTableScannerMonitor;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Refraction.DelayTime.BranchAssignment;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import java.util.ArrayList;

public abstract class TraceTable_ScannerBase {
    protected RefractionStaticsProject m_project;
    protected HashMap_Integer m_shotMap;
    protected Table_Abstract m_shotTable;
    protected HashMap_Integer m_recMap;
    protected Table_Abstract m_recTable;
    protected BranchAssignment m_branchAssignment;
    protected int m_maxBranch;
    protected ITraceTableScannerMonitor m_monitor;
    protected ITraceTable m_traceTable;
    protected long m_traceRow;
    protected int m_indexFBP;
    protected int m_indexTraceIndex = -9999;
    protected int m_indexFileID = -9999;
    protected int m_indexChannel = -9999;
    protected int m_indexShotID;
    protected int m_indexRecID;
    protected int m_indexShotLine;
    protected int m_indexShotPoint;
    protected int m_indexShotX;
    protected int m_indexShotY;
    protected int m_indexShotZ;
    protected int m_indexShotDepth;
    protected int m_indexShotKilled;
    protected int m_indexRecLine;
    protected int m_indexRecPoint;
    protected int m_indexRecX;
    protected int m_indexRecY;
    protected int m_indexRecZ;
    protected int m_indexRecKilled;
    protected ArrayList<ColumnSelector> m_requestedSelectorList = new ArrayList();
    protected ArrayList<ColumnSelector> m_validSelectorList = new ArrayList();
    protected Java2D_Polygon m_polygon;
    protected boolean m_polygonValid = false;
    public boolean CheckIfShotInsidePolygon = false;
    public boolean CheckIfShotOutsidePolygon = false;
    public boolean CheckIfRecInsidePolygon = false;
    public boolean CheckIfRecOutsidePolygon = false;
    public boolean CheckIfMidInsidePolygon = false;
    public boolean CheckIfMidOutsidePolygon = false;
    protected boolean m_isShotInsidePolygon = false;
    protected boolean m_isRecInsidePolygon = false;
    protected boolean m_isMidInsidePolygon = false;
    protected int m_fileID = -99999;
    protected long m_traceIndexWithinFile = -99999L;
    protected int m_shotID;
    protected int m_shotRow;
    protected double m_shotX;
    protected double m_shotY;
    protected double m_shotZ;
    protected double m_shotDepth;
    protected boolean m_shotKilled;
    protected int m_shotLine;
    protected int m_shotPoint;
    protected int m_recID;
    protected int m_recRow;
    protected double m_recX;
    protected double m_recY;
    protected double m_recZ;
    protected boolean m_recKilled;
    protected int m_recLine;
    protected int m_recPoint;
    protected double m_midX;
    protected double m_midY;
    protected double m_offset;
    protected double m_azimuth;
    protected float m_fbp;
    protected int m_branch = 0;
    protected int m_channel = 0;
    protected int m_indexInline = -9999;
    protected int m_indexCrossline = -9999;
    protected int m_inlineBin = -9999999;
    protected int m_crosslineBin = -9999999;

    public void addColumnSelector(String tbl, String col, double min, double max) {
        try {
            if (tbl == null || col == null) {
                return;
            }
            ColumnSelector sel = new ColumnSelector();
            sel.Table = tbl;
            sel.Column = col;
            sel.Minimum = min;
            sel.Maximum = max;
            this.m_requestedSelectorList.add(sel);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public int getSelectorCount() {
        return this.m_validSelectorList.size();
    }

    public ColumnSelector getSelector(int index) {
        try {
            return this.m_validSelectorList.get(index);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public ColumnSelector getSelector(String tbl, String col) {
        try {
            if (tbl == null || col == null) {
                return null;
            }
            for (ColumnSelector sel : this.m_validSelectorList) {
                if (!tbl.equalsIgnoreCase(sel.Table) || !col.equalsIgnoreCase(sel.Column)) continue;
                return sel;
            }
            return null;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public abstract void work() throws Exception;

    public abstract void finishScan() throws Exception;

    public void scan(ITraceTable traceTable, ITraceTableScannerMonitor monitor) throws Exception {
        try {
            this.scan(traceTable, monitor, false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void scan(ITraceTable traceTable, ITraceTableScannerMonitor monitor, boolean preScan) throws Exception {
        try {
            this.m_traceTable = traceTable;
            this.m_project = RefractionStaticsProject.singleton();
            this.m_polygon = this.m_project.polygon();
            this.m_polygonValid = this.m_polygon.valid();
            if (!this.m_polygonValid) {
                this.CheckIfShotInsidePolygon = false;
                this.CheckIfShotOutsidePolygon = false;
                this.CheckIfRecInsidePolygon = false;
                this.CheckIfRecOutsidePolygon = false;
                this.CheckIfMidInsidePolygon = false;
                this.CheckIfMidOutsidePolygon = false;
            }
            this.m_branchAssignment = this.m_project.getDelayTimeData().branchAssignment();
            this.m_maxBranch = this.m_branchAssignment.maxBranch();
            this.m_shotMap = this.m_project.shotMap();
            this.m_shotTable = this.m_project.shotTable();
            this.m_indexShotX = this.m_shotTable.column_indexOfColumn("Easting");
            this.m_indexShotY = this.m_shotTable.column_indexOfColumn("Northing");
            this.m_indexShotZ = this.m_shotTable.column_indexOfColumn("Elevation");
            this.m_indexShotKilled = this.m_shotTable.column_indexOfColumn("Killed");
            this.m_indexShotLine = this.m_shotTable.column_indexOfColumn("LineNumber");
            this.m_indexShotPoint = this.m_shotTable.column_indexOfColumn("PointNumber");
            this.m_indexShotDepth = -9999;
            if (this.m_shotTable.column_exists("PointDepth")) {
                this.m_indexShotDepth = this.m_shotTable.column_indexOfColumn("PointDepth");
            }
            this.m_recMap = this.m_project.receiverMap();
            this.m_recTable = this.m_project.receiverTable();
            this.m_indexRecX = this.m_recTable.column_indexOfColumn("Easting");
            this.m_indexRecY = this.m_recTable.column_indexOfColumn("Northing");
            this.m_indexRecZ = this.m_recTable.column_indexOfColumn("Elevation");
            this.m_indexRecKilled = this.m_recTable.column_indexOfColumn("Killed");
            this.m_indexRecLine = this.m_recTable.column_indexOfColumn("LineNumber");
            this.m_indexRecPoint = this.m_recTable.column_indexOfColumn("PointNumber");
            if (this.m_traceTable.column_exists("Inline")) {
                this.m_indexInline = this.m_traceTable.column_indexOfColumn("Inline");
            }
            if (this.m_traceTable.column_exists("Crossline")) {
                this.m_indexCrossline = this.m_traceTable.column_indexOfColumn("Crossline");
            }
            this.m_indexShotID = this.m_traceTable.column_indexOfColumn("ShotID");
            this.m_indexRecID = this.m_traceTable.column_indexOfColumn("ReceiverID");
            this.m_indexFBP = this.m_traceTable.column_indexOfColumn("FBP_User");
            if (this.m_traceTable.column_exists("Channel")) {
                this.m_indexChannel = this.m_traceTable.column_indexOfColumn("Channel");
            }
            if (this.m_traceTable.column_exists("FileID")) {
                this.m_indexFileID = this.m_traceTable.column_indexOfColumn("FileID");
            }
            if (this.m_traceTable.column_exists("IndexInFile")) {
                this.m_indexTraceIndex = this.m_traceTable.column_indexOfColumn("IndexInFile");
            }
            for (ColumnSelector sel : this.m_requestedSelectorList) {
                sel.TempTable = null;
                sel.UseTraceTable = false;
                sel.UseOffset = false;
                if (sel.Table.equalsIgnoreCase("Trace")) {
                    if (traceTable.column_exists(sel.Column)) {
                        sel.ColumnIndex = traceTable.column_indexOfColumn(sel.Column);
                        sel.UseTraceTable = true;
                        this.m_validSelectorList.add(sel);
                    }
                    if (sel.Column.equalsIgnoreCase("Offset")) {
                        sel.UseOffset = true;
                        this.m_validSelectorList.add(sel);
                    }
                }
                if (sel.Table.equalsIgnoreCase("Shot") && this.m_shotTable.column_exists(sel.Column)) {
                    sel.TempTable = this.m_shotTable;
                    sel.ColumnIndex = this.m_shotTable.column_indexOfColumn(sel.Column);
                    this.m_validSelectorList.add(sel);
                }
                if (!sel.Table.equalsIgnoreCase("Receiver") || !this.m_recTable.column_exists(sel.Column)) continue;
                sel.TempTable = this.m_recTable;
                sel.ColumnIndex = this.m_recTable.column_indexOfColumn(sel.Column);
                this.m_validSelectorList.add(sel);
            }
            int numBad = 0;
            if (preScan && this.m_indexTraceIndex >= 0) {
                try {
                    this.m_traceRow = 0L;
                    while (this.m_traceRow < this.m_traceTable.rowCount()) {
                        long indexInFile = this.m_traceTable.getLong(this.m_traceRow, this.m_indexTraceIndex);
                        if (indexInFile != this.m_traceRow) {
                            ++numBad;
                        }
                        ++this.m_traceRow;
                    }
                    if (numBad >= 1) {
                        System.out.println("numBad = " + numBad);
                    }
                }
                catch (Exception errrr) {
                    errrr.printStackTrace();
                }
            }
            this.m_traceRow = 0L;
            while (this.m_traceRow < this.m_traceTable.rowCount()) {
                this.m_channel = -9999;
                if (this.m_indexChannel >= 0) {
                    this.m_channel = this.m_traceTable.getInt(this.m_traceRow, this.m_indexChannel);
                }
                this.m_fileID = -99999;
                if (this.m_indexFileID >= 0) {
                    this.m_fileID = this.m_traceTable.getInt(this.m_traceRow, this.m_indexFileID);
                }
                this.m_traceIndexWithinFile = -9999L;
                if (this.m_indexTraceIndex >= 0) {
                    this.m_traceIndexWithinFile = this.m_traceTable.getLong(this.m_traceRow, this.m_indexTraceIndex);
                }
                if (this.m_indexCrossline >= 0) {
                    this.m_crosslineBin = this.m_traceTable.getInt(this.m_traceRow, this.m_indexCrossline);
                }
                if (this.m_indexInline >= 0) {
                    this.m_inlineBin = this.m_traceTable.getInt(this.m_traceRow, this.m_indexInline);
                }
                this.m_fbp = this.m_traceTable.getInt(this.m_traceRow, this.m_indexFBP);
                this.m_shotID = this.m_traceTable.getInt(this.m_traceRow, this.m_indexShotID);
                this.m_recID = this.m_traceTable.getInt(this.m_traceRow, this.m_indexRecID);
                if (this.m_recMap.containsKey(this.m_recID) && this.m_shotMap.containsKey(this.m_shotID)) {
                    this.m_recRow = this.m_recMap.get(this.m_recID);
                    this.m_shotRow = this.m_shotMap.get(this.m_shotID);
                    this.m_recLine = this.m_recTable.getInt(this.m_recRow, this.m_indexRecLine);
                    this.m_recPoint = this.m_recTable.getInt(this.m_recRow, this.m_indexRecPoint);
                    this.m_recX = this.m_recTable.getDouble(this.m_recRow, this.m_indexRecX);
                    this.m_recY = this.m_recTable.getDouble(this.m_recRow, this.m_indexRecY);
                    this.m_recZ = this.m_recTable.getDouble(this.m_recRow, this.m_indexRecZ);
                    this.m_recKilled = this.m_recTable.getBool(this.m_recRow, this.m_indexRecKilled);
                    this.m_shotLine = this.m_shotTable.getInt(this.m_shotRow, this.m_indexShotLine);
                    this.m_shotPoint = this.m_shotTable.getInt(this.m_shotRow, this.m_indexShotPoint);
                    this.m_shotX = this.m_shotTable.getDouble(this.m_shotRow, this.m_indexShotX);
                    this.m_shotY = this.m_shotTable.getDouble(this.m_shotRow, this.m_indexShotY);
                    this.m_shotZ = this.m_shotTable.getDouble(this.m_shotRow, this.m_indexShotZ);
                    this.m_shotKilled = this.m_shotTable.getBool(this.m_shotRow, this.m_indexShotKilled);
                    this.m_shotDepth = this.m_indexShotDepth >= 0 ? this.m_shotTable.getDouble(this.m_shotRow, this.m_indexShotDepth) : 0.0;
                    this.m_midX = 0.5 * (this.m_recX + this.m_shotX);
                    this.m_midY = 0.5 * (this.m_recY + this.m_shotY);
                    double dx = this.m_recX - this.m_shotX;
                    double dy = this.m_recY - this.m_shotY;
                    this.m_offset = Math.sqrt(dx * dx + dy * dy);
                    this.m_azimuth = 0.0;
                    if (this.m_offset > 0.1) {
                        this.m_azimuth = Math.atan2(dy, dx);
                    }
                    if (this.m_maxBranch >= 1) {
                        this.m_branch = this.m_branchAssignment.getBranch(this.m_midX, this.m_midY, this.m_offset);
                    }
                    for (ColumnSelector sel : this.m_validSelectorList) {
                        if (sel.TempTable == this.m_shotTable) {
                            sel.Value = this.m_shotTable.getDouble(this.m_shotRow, sel.ColumnIndex);
                        }
                        if (sel.TempTable == this.m_recTable) {
                            sel.Value = this.m_recTable.getDouble(this.m_recRow, sel.ColumnIndex);
                        }
                        if (sel.UseTraceTable) {
                            sel.Value = traceTable.getFloat(this.m_traceRow, sel.ColumnIndex);
                        }
                        if (sel.UseOffset) {
                            sel.Value = this.m_offset;
                        }
                        double min = sel.Minimum - 1.0E-10;
                        double max = sel.Maximum + 1.0E-10;
                        sel.Inside = sel.Value >= min && sel.Value <= max;
                    }
                    if (this.m_polygonValid) {
                        if (this.CheckIfShotInsidePolygon) {
                            this.m_isShotInsidePolygon = this.m_polygon.contains(this.m_shotX, this.m_shotY);
                        }
                        if (this.CheckIfRecInsidePolygon) {
                            this.m_isRecInsidePolygon = this.m_polygon.contains(this.m_recX, this.m_recY);
                        }
                        if (this.CheckIfMidInsidePolygon) {
                            this.m_isMidInsidePolygon = this.m_polygon.contains(this.m_midX, this.m_midY);
                        }
                    }
                    this.work();
                    if (this.m_traceRow % 50000L == 0L) {
                        long numRows = this.m_traceTable.rowCount();
                        double percent = 100.0 * (double)this.m_traceRow / (double)numRows;
                        if (monitor != null) {
                            monitor.setPercentDone(percent);
                        }
                    }
                }
                ++this.m_traceRow;
            }
            this.m_traceTable.saveCurrentSection();
            this.finishScan();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static class ColumnSelector {
        public String Table;
        public String Column;
        public double Minimum;
        public double Maximum;
        public int ColumnIndex;
        public Table_Abstract TempTable;
        public boolean UseTraceTable = false;
        public boolean UseOffset = false;
        public double Value;
        public boolean Inside;
    }
}

