/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Data.Sort;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.DataType;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosLibrary.Data.Sort.SegySortEntry;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class SegySortManager {
    protected String m_sortPath = "";
    protected String m_fileName_Data = "";
    protected String m_fileName_Dictionary = "";
    protected String m_fileName_RowIndex = "";
    protected boolean m_valid = false;
    protected Segy m_segy = new Segy();
    protected long[] m_indexArray = new long[200];
    protected HashMap_Integers<SegySortEntry> m_hash = new HashMap_Integers();
    protected ArrayList<SegySortEntry> m_list = new ArrayList();

    public boolean valid() {
        return this.m_valid;
    }

    public SegySortManager(String path) {
        try {
            this.m_sortPath = path;
            this.m_fileName_Data = this.m_sortPath + "/sort.sgy";
            this.m_fileName_Dictionary = this.m_sortPath + "/sort.map";
            this.m_fileName_RowIndex = this.m_sortPath + "/sort.rowindex";
            if (!Tools_FileSystem.exists_file(this.m_fileName_Data)) {
                return;
            }
            if (!Tools_FileSystem.exists_file(this.m_fileName_Dictionary)) {
                return;
            }
            if (!Tools_FileSystem.exists_file(this.m_fileName_RowIndex)) {
                return;
            }
            this.m_segy.setFileName(this.m_fileName_Data);
            if (!this.m_segy.isFileOK()) {
                return;
            }
            RandomAccessFile dictFile = new RandomAccessFile(this.m_fileName_Dictionary, "rw");
            int version = dictFile.readInt();
            if (version == 1000) {
                int count = dictFile.readInt();
                for (int n = 0; n < count; ++n) {
                    this.m_list.add(new SegySortEntry(dictFile));
                }
            } else {
                dictFile.close();
                return;
            }
            dictFile.close();
            for (SegySortEntry entry : this.m_list) {
                this.m_hash.put(entry, entry.Key1, entry.Key2);
            }
            this.m_valid = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void populateEnsemble(Ensemble ensemble, int key1, int key2) {
        try {
            if (!this.hasEntry(key1, key2)) {
                return;
            }
            SegySortEntry entry = this.m_hash.get(key1, key2);
            if (this.m_indexArray.length < entry.Count) {
                this.m_indexArray = new long[entry.Count + 100];
            }
            for (int n = 0; n < entry.Count; ++n) {
                this.m_indexArray[n] = n + entry.FileIndex;
            }
            this.m_segy.populateEnsemble(ensemble, this.m_indexArray, entry.Count, false, true);
            ByteBuffer buffer = ByteBuffer_Shared.buffer(0, 1000 + 4 * entry.Count);
            RandomAccessFile rowFile = new RandomAccessFile(this.m_fileName_RowIndex, "rw");
            rowFile.seek(entry.FileIndex * 4);
            rowFile.read(buffer.array(), 0, 4 * entry.Count);
            rowFile.close();
            int indexRow = ensemble.dictionary().addEntry("Trace", "TraceIndex", DataType.Int);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                int row = buffer.getInt(n * 4);
                ensemble.trace(n).header().putLong(indexRow, row);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean hasEntry(int key1, int key2) {
        try {
            return this.m_hash.containsKey(key1, key2);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }
}

