/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Application;

import com.PecosCore.Application.Environment;
import com.PecosCore.Plugins.PluginManager;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.IChangeLog;
import com.PecosLibrary.Application.CANONGEOInfo;
import com.PecosLibrary.Application.LicenseInfoDlg;
import com.macrovision.flexlm.FeatureSpecifier;
import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.License;
import com.macrovision.flexlm.VendorInfo;
import com.westerngeco.omega.io.OmegaIoServer;
import java.awt.Frame;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class LicenseWorker
implements FlexlmConstants {
    private String Port = "";
    private String Host = "";
    private String Port2 = "";
    private String Port3 = "";
    private String Host2 = "";
    private String Host3 = "";
    private String PecosPort = "";
    private String PecosHost = "";
    private String PecosPort2 = "";
    private String PecosHost2 = "";
    private String PecosPort3 = "";
    private String PecosHost3 = "";
    private String LicFilePath = "";
    private boolean licStatus = false;
    protected static LicenseWorker m_singleton = null;
    protected License m_license;
    public String currentProduct = "";
    public String currentVersion = "";
    public static Boolean useNodeLocked = false;
    private String failMessage = "";

    public void print_status(String prefix) {
        try {
            System.out.println(prefix + "   Port = " + this.Port);
            System.out.println(prefix + "   Host = " + this.Host);
            System.out.println(prefix + "   Port2 = " + this.Port2);
            System.out.println(prefix + "   Port3 = " + this.Port3);
            System.out.println(prefix + "   Host2 = " + this.Host2);
            System.out.println(prefix + "   Host3 = " + this.Host3);
            System.out.println(prefix + "   PecosPort = " + this.PecosPort);
            System.out.println(prefix + "   PecosPort = " + this.PecosPort);
            System.out.println(prefix + "   PecosPort = " + this.PecosPort);
            System.out.println(prefix + "   PecosPort = " + this.PecosPort);
            System.out.println(prefix + "   PecosPort = " + this.PecosPort);
            System.out.println(prefix + "   PecosPort = " + this.PecosPort);
            System.out.println(prefix + "   LicFilePath = " + this.LicFilePath);
            System.out.println(prefix + "   currentProduct = " + this.currentProduct);
            System.out.println(prefix + "   currentVersion = " + this.currentVersion);
            System.out.println(prefix + "   failMessage = " + this.failMessage);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected LicenseWorker() {
        if (Environment.XT_ARGS.containsValue("NUKE_LIC_PREFS")) {
            this.nukePrefs();
        }
    }

    public String getErrorMessage() {
        return this.failMessage;
    }

    private void nukePrefs() {
        try {
            Preferences prefs = Preferences.userRoot();
            prefs.put("CanonPort", "");
            prefs.put("CanonPort2", "");
            prefs.put("CanonPort3", "");
            prefs.put("CanonHost", "");
            prefs.put("CanonHost2", "");
            prefs.put("CanonHost3", "");
            prefs.put("CanonLicFile", "");
            prefs.put("PecosPort", "");
            prefs.put("PecosHost", "");
            prefs.put("PecosPort2", "");
            prefs.put("PecosHost2", "");
            prefs.put("PecosPort3", "");
            prefs.put("PecosHost3", "");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void loadLicensePrefs() {
        try {
            Preferences prefs = Preferences.userRoot();
            this.setHost(System.getenv("XT_FLEXHOST"));
            this.setHost2(System.getenv("XT_FLEXHOST2"));
            this.setHost3(System.getenv("XT_FLEXHOST3"));
            this.setPort(System.getenv("XT_FLEXPORT"));
            this.setPort2(System.getenv("XT_FLEXPORT2"));
            this.setPort3(System.getenv("XT_FLEXPORT3"));
            this.setPecosHost(System.getenv("XT_PECOSHOST"));
            this.setPecosPort(System.getenv("XT_PECOSPORT"));
            this.setPecosHost2(System.getenv("XT_PECOSHOST2"));
            this.setPecosPort2(System.getenv("XT_PECOSPORT2"));
            this.setPecosHost3(System.getenv("XT_PECOSHOST3"));
            this.setPecosPort3(System.getenv("XT_PECOSPORT3"));
            if (this.Host3.length() == 0) {
                this.setHost3(prefs.get("CanonHost3", ""));
                this.setPort3(prefs.get("CanonPort3", ""));
            }
            if (this.Host2.length() == 0) {
                this.setHost2(prefs.get("CanonHost2", ""));
                this.setPort2(prefs.get("CanonPort2", ""));
            }
            if (this.Host.length() == 0) {
                this.setHost(prefs.get("CanonHost", ""));
                this.setPort(prefs.get("CanonPort", ""));
            }
            if (this.PecosHost3.length() == 0) {
                this.setPecosHost3(prefs.get("PecosHost3", ""));
                this.setPecosPort3(prefs.get("PecosPort3", ""));
            }
            if (this.PecosHost2.length() == 0) {
                this.setPecosHost2(prefs.get("PecosHost2", ""));
                this.setPecosPort2(prefs.get("PecosPort2", ""));
            }
            if (this.PecosHost.length() == 0) {
                this.setPecosHost(prefs.get("PecosHost", ""));
                this.setPecosPort(prefs.get("PecosPort", ""));
            }
            this.setLicFilePath(prefs.get("CanonLicFile", ""));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void saveToPrefs() {
        try {
            Preferences prefs = Preferences.userRoot();
            prefs.put("CanonPort", this.Port);
            prefs.put("CanonPort2", this.Port2);
            prefs.put("CanonPort3", this.Port3);
            prefs.put("CanonHost", this.Host);
            prefs.put("CanonHost2", this.Host2);
            prefs.put("CanonHost3", this.Host3);
            prefs.put("PecosPort", this.PecosPort);
            prefs.put("PecosPort2", this.PecosPort2);
            prefs.put("PecosPort3", this.PecosPort3);
            prefs.put("PecosHost", this.PecosHost);
            prefs.put("PecosHost2", this.PecosHost2);
            prefs.put("PecosHost3", this.PecosHost3);
            prefs.put("CanonLicFile", this.LicFilePath);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static LicenseWorker singleton() {
        try {
            if (m_singleton == null) {
                m_singleton = new LicenseWorker();
            }
            return m_singleton;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static VendorInfo getVendorInfo() {
        CANONGEOInfo vInfo = null;
        try {
            vInfo = new CANONGEOInfo();
        }
        catch (FlexlmException fle) {
            JOptionPane.showMessageDialog(new JFrame(), fle.getMessage(), "FlexLM Error:", 0);
            System.exit(1);
        }
        return vInfo;
    }

    public Boolean checkoutLicense(String product, IChangeLog changeLog) {
        try {
            this.currentProduct = product;
            String fullVersion = changeLog.currentVersion();
            this.currentVersion = fullVersion.substring(0, fullVersion.lastIndexOf("."));
            System.out.println("LicenseWorker.checkoutLicense(): currentProduct " + this.currentProduct);
            System.out.println("LicenseWorker.checkoutLicense(): fullVersion " + fullVersion);
            System.out.println("LicenseWorker.checkoutLicense(): currentVersion " + this.currentVersion);
            if (PluginManager.singleton().checkConfig() && !PluginManager.singleton().overrideOK()) {
                System.out.println("LicenseWorker.checkoutLicense(): licStatus = checkConfig();");
                this.licStatus = this.checkConfig();
            } else {
                System.out.println("LicenseWorker.checkoutLicense(): licStatus = checkLicense();");
                this.licStatus = this.checkLicense();
            }
            if (this.licStatus) {
                return true;
            }
            LicenseInfoDlg lid = new LicenseInfoDlg(this);
            JDialog dlg = new JDialog((Frame)new JFrame(), true);
            dlg.add(lid);
            dlg.setTitle("Could not find valid license for: " + this.currentProduct);
            dlg.pack();
            dlg.setLocationRelativeTo(null);
            dlg.setVisible(true);
            return lid.getLicenseOK();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public Boolean checkLicense() {
        try {
            if (this.currentProduct == null) {
                throw new Exception("No product specified");
            }
            if (this.currentProduct.length() == 0) {
                throw new Exception("No product specified");
            }
            if (this.currentVersion == null) {
                throw new Exception("No version specified");
            }
            if (this.currentVersion.length() == 0) {
                throw new Exception("No version specified");
            }
            FeatureSpecifier featSpec = new FeatureSpecifier(this.currentProduct, this.currentVersion);
            String licSpec = this.getLicenseServerString();
            System.out.println("LicenseWorker.checkLicense(): licSpec = ;" + licSpec);
            if (licSpec.length() == 0) {
                throw new Exception("No license server/file specified");
            }
            License lic = new License(featSpec, licSpec, LicenseWorker.getVendorInfo(), null);
            System.out.println("Checking out license from server at " + licSpec);
            this.licStatus = lic.checkout(1);
            System.out.println("License checkout successful.");
            System.out.println("Product " + this.currentProduct + " version " + lic.getFeatureSpecifier().getVersion() + " checked out from server at " + lic.getLicenseSource().getName());
            this.m_license = lic;
            return true;
        }
        catch (FlexlmException fex) {
            this.failMessage = "FlexlmException: " + fex.getMessage();
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.failMessage = "Exception: " + ex.getMessage();
            return false;
        }
    }

    private boolean checkConfig() {
        try {
            System.out.println("LicenseWorker.checkConfig(): entering checkConfig()");
            OmegaIoServer configService = new OmegaIoServer();
            PluginManager.singleton().currentPlugin().setConfigService(configService);
            return configService.checkConfig();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public String getPort() {
        return this.Port;
    }

    public void setPort(String s) {
        if (s == null) {
            s = "";
        }
        this.Port = s;
    }

    public String getHost() {
        return this.Host;
    }

    public void setHost(String s) {
        if (s == null) {
            s = "";
        }
        this.Host = s;
    }

    public String getPort2() {
        return this.Port2;
    }

    public void setPort2(String s) {
        if (s == null) {
            s = "";
        }
        this.Port2 = s;
    }

    public String getHost2() {
        return this.Host2;
    }

    public void setHost2(String s) {
        if (s == null) {
            s = "";
        }
        this.Host2 = s;
    }

    public String getPort3() {
        return this.Port3;
    }

    public void setPort3(String s) {
        if (s == null) {
            s = "";
        }
        this.Port3 = s;
    }

    public String getHost3() {
        return this.Host3;
    }

    public void setHost3(String s) {
        if (s == null) {
            s = "";
        }
        this.Host3 = s;
    }

    public String getLicFilePath() {
        return this.LicFilePath;
    }

    public void setLicFilePath(String s) {
        if (s == null) {
            s = "";
        }
        this.LicFilePath = s;
    }

    public String getLicenseServerString() {
        Object s = "";
        if (this.LicFilePath.length() == 0) {
            useNodeLocked = false;
        } else {
            File f = new File(this.LicFilePath);
            useNodeLocked = f.exists();
        }
        if (useNodeLocked.booleanValue()) {
            s = (String)s + this.LicFilePath;
        }
        if (((String)s).length() > 0 && !((String)s).endsWith("&")) {
            s = (String)s + "&";
        }
        if (this.currentProduct.equalsIgnoreCase("Pecos")) {
            if (this.PecosPort.length() == 0 && this.PecosHost.length() > 0) {
                s = (String)s + String.format("@%s", this.PecosHost);
            } else if (this.PecosPort.length() > 0 && this.PecosHost.length() > 0) {
                s = (String)s + String.format("%s@%s", this.PecosPort, this.PecosHost);
            }
            if (((String)s).length() > 0 && !((String)s).endsWith("&")) {
                s = (String)s + "&";
            }
            if (this.PecosPort2.length() == 0 && this.PecosHost2.length() > 0) {
                s = (String)s + String.format("@%s", this.PecosHost2);
            } else if (this.PecosPort2.length() > 0 && this.PecosHost2.length() > 0) {
                s = (String)s + String.format("%s@%s", this.PecosPort2, this.PecosHost2);
            }
            if (((String)s).length() > 0 && !((String)s).endsWith("&")) {
                s = (String)s + "&";
            }
            if (this.PecosPort3.length() == 0 && this.PecosHost3.length() > 0) {
                s = (String)s + String.format("@%s", this.PecosHost3);
            } else if (this.PecosPort3.length() > 0 && this.PecosHost3.length() > 0) {
                s = (String)s + String.format("%s@%s", this.PecosPort3, this.PecosHost3);
            }
        } else {
            if (this.Port.length() == 0 && this.Host.length() > 0) {
                s = (String)s + String.format("@%s", this.Host);
            } else if (this.Port.length() > 0 && this.Host.length() > 0) {
                s = (String)s + String.format("%s@%s", this.Port, this.Host);
            }
            if (((String)s).length() > 0 && !((String)s).endsWith("&")) {
                s = (String)s + "&";
            }
            if (this.Port2.length() == 0 && this.Host2.length() > 0) {
                s = (String)s + String.format("@%s", this.Host2);
            } else if (this.Port2.length() > 0 && this.Host2.length() > 0) {
                s = (String)s + String.format("%s@%s", this.Port2, this.Host2);
            }
            if (((String)s).length() > 0 && !((String)s).endsWith("&")) {
                s = (String)s + "&";
            }
            if (this.Port3.length() == 0 && this.Host3.length() > 0) {
                s = (String)s + String.format("@%s", this.Host3);
            } else if (this.Port3.length() > 0 && this.Host3.length() > 0) {
                s = (String)s + String.format("%s@%s", this.Port3, this.Host3);
            }
        }
        return s;
    }

    public void setPecosHost(String s) {
        if (s == null) {
            s = "";
        }
        this.PecosHost = s;
    }

    public void setPecosPort(String s) {
        if (s == null) {
            s = "";
        }
        this.PecosPort = s;
    }

    public void setPecosHost2(String s) {
        if (s == null) {
            s = "";
        }
        this.PecosHost2 = s;
    }

    public void setPecosPort2(String s) {
        if (s == null) {
            s = "";
        }
        this.PecosPort2 = s;
    }

    public void setPecosHost3(String s) {
        if (s == null) {
            s = "";
        }
        this.PecosHost3 = s;
    }

    public void setPecosPort3(String s) {
        if (s == null) {
            s = "";
        }
        this.PecosPort3 = s;
    }

    public String getPecosPort() {
        return this.PecosPort;
    }

    public String getPecosHost() {
        return this.PecosHost;
    }

    public String getPecosPort2() {
        return this.PecosPort2;
    }

    public String getPecosHost2() {
        return this.PecosHost2;
    }

    public String getPecosPort3() {
        return this.PecosPort3;
    }

    public String getPecosHost3() {
        return this.PecosHost3;
    }

    public License getActiveLicense() {
        return this.m_license;
    }

    public boolean getLicStatus() {
        return this.licStatus;
    }
}

