/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Application;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Application.LicenseWorker;
import java.awt.Color;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URLDecoder;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class LicenseInfoDlg
extends JPanel {
    private Boolean licenseOK = false;
    private LicenseWorker m_lw = null;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel17;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JScrollPane jScrollPane2;
    private JButton m_btnBrowseHost1;
    private JButton m_btnBrowseHost2;
    private JButton m_btnBrowseHost3;
    private JButton m_btnBrowseLicFile;
    private JButton m_btnCancel;
    private JButton m_btnOK;
    private JTextField m_txtHost1;
    private JTextField m_txtHost2;
    private JTextField m_txtHost3;
    private JTextField m_txtLicFile;
    private JTextField m_txtPort1;
    private JTextField m_txtPort2;
    private JTextField m_txtPort3;
    private JTextArea m_txtStatus;

    public LicenseInfoDlg(LicenseWorker lw) {
        this.initComponents();
        try {
            this.m_lw = lw;
            this.m_lw.loadLicensePrefs();
            if (lw.currentProduct.equalsIgnoreCase("Pecos")) {
                this.m_txtHost1.setText(lw.getPecosHost());
                this.m_txtHost2.setText(lw.getPecosHost2());
                this.m_txtHost3.setText(lw.getPecosHost3());
                this.m_txtPort1.setText(lw.getPecosPort());
                this.m_txtPort2.setText(lw.getPecosPort2());
                this.m_txtPort3.setText(lw.getPecosPort3());
            } else {
                this.m_txtHost1.setText(lw.getHost());
                this.m_txtHost2.setText(lw.getHost2());
                this.m_txtHost3.setText(lw.getHost3());
                this.m_txtPort1.setText(lw.getPort());
                this.m_txtPort2.setText(lw.getPort2());
                this.m_txtPort3.setText(lw.getPort3());
            }
            this.m_btnBrowseHost1.setVisible(false);
            this.m_btnBrowseHost1.setEnabled(false);
            this.m_btnBrowseHost2.setVisible(false);
            this.m_btnBrowseHost2.setEnabled(false);
            this.m_btnBrowseHost3.setVisible(false);
            this.m_btnBrowseHost3.setEnabled(false);
            if (!this.m_lw.getLicStatus()) {
                this.m_txtStatus.setText(this.m_lw.getErrorMessage());
                this.m_txtStatus.setForeground(Color.red);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Boolean getLicenseOK() {
        return this.licenseOK;
    }

    public Boolean getUseNodeLocked() {
        File f;
        if (this.m_txtLicFile.getText().length() > 0 && (f = new File(this.m_txtLicFile.getText())).exists()) {
            return true;
        }
        return false;
    }

    private void setLicenseWorkerInfo() throws Exception {
        if (this.m_lw == null) {
            throw new Exception("License Worker is NULL");
        }
        if (this.m_lw.currentProduct.equalsIgnoreCase("Pecos")) {
            this.m_lw.setPecosHost(this.m_txtHost1.getText());
            this.m_lw.setPecosHost2(this.m_txtHost2.getText());
            this.m_lw.setPecosHost3(this.m_txtHost3.getText());
            this.m_lw.setPecosPort(this.m_txtPort1.getText());
            this.m_lw.setPecosPort2(this.m_txtPort2.getText());
            this.m_lw.setPecosPort3(this.m_txtPort3.getText());
        } else {
            this.m_lw.setHost(this.m_txtHost1.getText());
            this.m_lw.setHost2(this.m_txtHost2.getText());
            this.m_lw.setHost3(this.m_txtHost3.getText());
            this.m_lw.setPort(this.m_txtPort1.getText());
            this.m_lw.setPort2(this.m_txtPort2.getText());
            this.m_lw.setPort3(this.m_txtPort3.getText());
        }
        this.m_lw.setLicFilePath(this.m_txtLicFile.getText());
        LicenseWorker.useNodeLocked = this.getUseNodeLocked();
        this.m_lw.saveToPrefs();
    }

    private void initComponents() {
        this.m_txtPort1 = new JTextField();
        this.jLabel1 = new JLabel();
        this.m_txtHost1 = new JTextField();
        this.m_txtPort2 = new JTextField();
        this.jLabel2 = new JLabel();
        this.m_txtHost2 = new JTextField();
        this.m_txtHost3 = new JTextField();
        this.m_txtPort3 = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.m_btnCancel = new JButton();
        this.m_btnOK = new JButton();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.m_txtStatus = new JTextArea();
        this.m_btnBrowseHost1 = new JButton();
        this.m_btnBrowseHost2 = new JButton();
        this.m_btnBrowseHost3 = new JButton();
        this.m_txtLicFile = new JTextField();
        this.jLabel17 = new JLabel();
        this.m_btnBrowseLicFile = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jLabel1.setText("@");
        this.jLabel2.setText("@");
        this.jLabel3.setText("@");
        this.jLabel4.setText("Port");
        this.jLabel5.setText("@");
        this.jLabel6.setText("Host");
        this.jLabel7.setText("Port");
        this.jLabel8.setText("@");
        this.jLabel9.setText("Host");
        this.jLabel10.setText("Main License Server Info:");
        this.m_btnCancel.setText("Cancel");
        this.m_btnCancel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LicenseInfoDlg.this.m_btnCancelMouseClicked(evt);
            }
        });
        this.m_btnOK.setText("OK");
        this.m_btnOK.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LicenseInfoDlg.this.m_btnOKMouseClicked(evt);
            }
        });
        this.jLabel11.setText("Backup License Server Info:");
        this.jLabel12.setText("Third Server Redundancy Info:");
        this.jLabel13.setText("Port");
        this.jLabel14.setText("@");
        this.jLabel15.setText("Host");
        this.m_txtStatus.setEditable(false);
        this.m_txtStatus.setColumns(20);
        this.m_txtStatus.setLineWrap(true);
        this.m_txtStatus.setRows(5);
        this.m_txtStatus.setWrapStyleWord(true);
        this.jScrollPane2.setViewportView(this.m_txtStatus);
        this.m_btnBrowseHost1.setText("Browse...");
        this.m_btnBrowseHost1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LicenseInfoDlg.this.m_btnBrowseHost1MouseClicked(evt);
            }
        });
        this.m_btnBrowseHost2.setText("Browse...");
        this.m_btnBrowseHost2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LicenseInfoDlg.this.m_btnBrowseHost2MouseClicked(evt);
            }
        });
        this.m_btnBrowseHost3.setText("Browse...");
        this.m_btnBrowseHost3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LicenseInfoDlg.this.m_btnBrowseHost3MouseClicked(evt);
            }
        });
        this.jLabel17.setText("License File Location (Node locked only)");
        this.m_btnBrowseLicFile.setText("Browse...");
        this.m_btnBrowseLicFile.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LicenseInfoDlg.this.m_btnBrowseLicFileMouseClicked(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.m_txtLicFile).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane2).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.m_txtPort2, -2, 141, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_btnBrowseHost2).addGap(0, 318, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_txtHost2))).addGap(12, 12, 12)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel8)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.m_txtPort1, -2, 141, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_btnBrowseHost1).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.m_txtHost1).addContainerGap()))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel10).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.m_txtPort3, -2, 141, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_txtHost3)).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.m_btnOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_btnCancel))).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel17).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.m_btnBrowseLicFile)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel13).addGap(124, 124, 124).addComponent(this.jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_btnBrowseHost3)).addComponent(this.jLabel11).addComponent(this.jLabel12)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel17).addComponent(this.m_btnBrowseLicFile)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_txtLicFile, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jLabel8).addComponent(this.jLabel9).addComponent(this.m_btnBrowseHost1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_txtPort1, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.m_txtHost1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.jLabel6).addComponent(this.m_btnBrowseHost2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_txtPort2, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.m_txtHost2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.jLabel14).addComponent(this.jLabel15).addComponent(this.m_btnBrowseHost3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_txtPort3, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.m_txtHost3, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jScrollPane2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_btnCancel).addComponent(this.m_btnOK)).addContainerGap()));
    }

    private void m_btnCancelMouseClicked(MouseEvent evt) {
        try {
            this.licenseOK = false;
            Window w = SwingUtilities.getWindowAncestor(this);
            w.setVisible(false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    private void m_btnOKMouseClicked(MouseEvent evt) {
        try {
            this.setLicenseWorkerInfo();
            this.licenseOK = this.m_lw.checkLicense();
            if (this.licenseOK.booleanValue()) {
                Window w = SwingUtilities.getWindowAncestor(this);
                w.setVisible(false);
            } else {
                this.m_txtStatus.setText(this.m_lw.getErrorMessage());
                this.m_txtStatus.setForeground(Color.red);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void m_btnBrowseHost1MouseClicked(MouseEvent evt) {
        try {
            JFileChooser jfc = new JFileChooser();
            int retval = jfc.showOpenDialog(this);
            if (retval == 0) {
                this.m_txtHost1.setText(URLDecoder.decode(jfc.getSelectedFile().getPath(), "UTF-8"));
                this.m_txtPort1.setText("");
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    private void m_btnBrowseHost2MouseClicked(MouseEvent evt) {
        try {
            JFileChooser jfc = new JFileChooser();
            int retval = jfc.showOpenDialog(this);
            if (retval == 0) {
                this.m_txtHost2.setText(URLDecoder.decode(jfc.getSelectedFile().getPath(), "UTF-8"));
                this.m_txtPort2.setText("");
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    private void m_btnBrowseHost3MouseClicked(MouseEvent evt) {
        try {
            JFileChooser jfc = new JFileChooser();
            int retval = jfc.showOpenDialog(this);
            if (retval == 0) {
                this.m_txtHost3.setText(URLDecoder.decode(jfc.getSelectedFile().getPath(), "UTF-8"));
                this.m_txtPort3.setText("");
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    private void m_btnBrowseLicFileMouseClicked(MouseEvent evt) {
        try {
            JFileChooser jfc = new JFileChooser();
            int retval = jfc.showOpenDialog(this);
            if (retval == 0) {
                this.m_txtLicFile.setText(URLDecoder.decode(jfc.getSelectedFile().getPath(), "UTF-8"));
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

