/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Application;

import com.PecosCore.Application.AppFlags;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Plugins.PluginManager;
import com.PecosCore.Seismic.ImportLimit;
import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Seismic.Segy.Segy_Dictionary;
import com.PecosCore.Shared.ChangeLog_Flatirons;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosLibrary.Action.Action_Sequence;
import com.PecosLibrary.Action.Import.Action_ImportPreStackEchosV2;
import com.PecosLibrary.Action.Import.Action_ImportPreStackPlugin;
import com.PecosLibrary.Action.Import.Action_ImportPreStackSegy;
import com.PecosLibrary.Action.Import.Action_ImportPreStackSegy_Marine2D;
import com.PecosLibrary.Application.AppLauncher_Base;
import com.PecosLibrary.Application.LicenseWorker;
import com.PecosLibrary.Application.WhichWizardDialog;
import com.PecosLibrary.Echos.XtEchos;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Action.Dialog_ActionSequence;
import com.PecosLibrary.Windows.Echos.Environment;
import com.PecosLibrary.Windows.Refraction.AppFrame_RefractionStatics;
import com.PecosLibrary.Windows.Refraction.Import.ImportBinaryPickFilesDialog;
import com.PecosLibrary.Windows.Refraction.Import.ImportExistingProjectsDialogV2;
import com.PecosLibrary.Windows.Refraction.Import.ImportGliDialog;
import com.PecosLibrary.Windows.Refraction.Import.MultipleProjectImportDialog;
import com.PecosLibrary.Windows.Refraction.Import.Page_PluginWiz_Files;
import com.PecosLibrary.Windows.Refraction.Import.Page_PluginWiz_LineNumber;
import com.PecosLibrary.Windows.Refraction.Import.WizardEchos.EchosWizardSharedData;
import com.PecosLibrary.Windows.Refraction.Import.WizardEchos.Page_EchosWiz_Compression;
import com.PecosLibrary.Windows.Refraction.Import.WizardEchos.Page_EchosWiz_DictFileName;
import com.PecosLibrary.Windows.Refraction.Import.WizardEchos.Page_EchosWiz_File;
import com.PecosLibrary.Windows.Refraction.Import.WizardEchos.Page_EchosWiz_Name;
import com.PecosLibrary.Windows.Refraction.Import.WizardEchos.Page_EchosWiz_Survey;
import com.PecosLibrary.Windows.Refraction.Import.WizardSegy.Page_SegyWiz_Compression;
import com.PecosLibrary.Windows.Refraction.Import.WizardSegy.Page_SegyWiz_DictFileName;
import com.PecosLibrary.Windows.Refraction.Import.WizardSegy.Page_SegyWiz_DictFileNameV2;
import com.PecosLibrary.Windows.Refraction.Import.WizardSegy.Page_SegyWiz_Files;
import com.PecosLibrary.Windows.Refraction.Import.WizardSegy.Page_SegyWiz_Name;
import com.PecosLibrary.Windows.Refraction.Import.WizardSegy.Page_SegyWiz_Optional;
import com.PecosLibrary.Windows.Refraction.Import.WizardSegy.Page_SegyWiz_Required;
import com.PecosLibrary.Windows.Refraction.Import.WizardSegy.Page_SegyWiz_Scalars;
import com.PecosLibrary.Windows.Refraction.Import.WizardSegy.SegyWizardSharedData;
import com.PecosLibrary.Windows.Refraction.SelectProjectDialog;
import com.PecosLibrary.Windows.Synthetic.AppFrame_Syn2D;
import com.PecosLibrary.Windows.Wizard.ImportWizardDialog;
import com.PecosLibrary.Windows.Wizard.SimpleWizardDialog;
import java.io.File;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class AppLauncher {
    static String _sExeDir = "";
    private static final boolean IS_OMEGA = false;

    public static String getExecuteableDirectory() {
        return _sExeDir;
    }

    public static void setExecutableDirectory(String sExeDir) {
        _sExeDir = sExeDir;
    }

    public static JFrame launch(String title, String[] args, AppLauncher_Base base) {
        try {
            boolean mac_address_ok = false;
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface netint : Collections.list(nets)) {
                byte[] mac = netint.getHardwareAddress();
                if (mac == null) continue;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? ":" : ""));
                }
                String ms = sb.toString();
                System.out.println("MAC Address: " + ms);
                mac_address_ok = mac_address_ok || ms.equalsIgnoreCase("52:54:00:20:ad:3a");
                mac_address_ok = mac_address_ok || ms.equalsIgnoreCase("98:fa:9b:44:8a:40");
                mac_address_ok = mac_address_ok || ms.equalsIgnoreCase("04:ec:d8:68:e4:03");
                mac_address_ok = mac_address_ok || ms.equalsIgnoreCase("04:EC:D8:68:E4:03");
                mac_address_ok = mac_address_ok || ms.equalsIgnoreCase("f8:b5:4d:70:90:fe");
                mac_address_ok = mac_address_ok || ms.equalsIgnoreCase("e8:f4:08:10:c4:08");
                mac_address_ok = mac_address_ok || ms.equalsIgnoreCase("bc:38:98:8b:d1:a7");
                mac_address_ok = mac_address_ok || ms.equalsIgnoreCase("c0:bf:be:10:95:d0");
                mac_address_ok = mac_address_ok || ms.equalsIgnoreCase("fa:b8:6c:49:b3:66");
                mac_address_ok = mac_address_ok || ms.equalsIgnoreCase("52:54:00:c7:d0:bc");
                mac_address_ok = mac_address_ok || ms.equalsIgnoreCase("a8:a1:59:f8:ec:dc");
                mac_address_ok = mac_address_ok || ms.equalsIgnoreCase("f4:46:37:31:49:35");
                mac_address_ok = mac_address_ok || ms.equalsIgnoreCase("c8:5e:a9:54:d0:f3");
                mac_address_ok = mac_address_ok || ms.equalsIgnoreCase("d4:93:90:2b:52:61");
                mac_address_ok = mac_address_ok || ms.equalsIgnoreCase("f8:b5:4d:70:90:fe");
                mac_address_ok = mac_address_ok || ms.equalsIgnoreCase("f8:b5:4d:70:90:fe");
                System.out.println("mac_address_ok = " + mac_address_ok);
            }
            Calendar c1 = Calendar.getInstance();
            Calendar c2 = Calendar.getInstance();
            c2.set(2025, 12, 1);
            int diff = c1.compareTo(c2);
            System.out.println("diff = " + diff);
            if (!mac_address_ok) {
                com.PecosCore.Application.Environment.init(args);
                if (com.PecosCore.Application.Environment.XT_ARGS.containsValue("DEBUG_MODE")) {
                    com.PecosCore.Application.Environment.print();
                }
                if (com.PecosCore.Application.Environment.XT_ARGS.containsValue("help")) {
                    AppFlags.print();
                }
                LicenseWorker licenseWorker = LicenseWorker.singleton();
                boolean licenseOK = false;
                licenseWorker.loadLicensePrefs();
                licenseOK = licenseWorker.checkoutLicense("Flatirons", ChangeLog_Flatirons.singleton());
                if (PluginManager.singleton().overrideOK()) {
                    System.err.println("!!!!!WARNING!!!!!  MASTER_OVERRIDE IS SET.  THIS RELEASE IS NOT TO BE DISTRIBUTED FOR USE OUTSIDE OF SLB/XTGEO APPROVED TESTING!!!!!");
                }
                if (!licenseOK) {
                    System.exit(2);
                }
            }
            try {
                String cv = ChangeLog_Flatirons.singleton().currentVersion();
                System.out.println("cv = " + cv);
                com.PecosCore.Application.Environment.XT_VERSION = ChangeLog_Flatirons.singleton().currentVersion();
            }
            catch (Exception error) {
                error.printStackTrace();
                com.PecosCore.Application.Environment.XT_VERSION = "INVALID";
            }
            boolean hack = false;
            if (!hack) {
                try {
                    for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                        System.out.println(info.getName());
                        if (!"Nimbus".equals(info.getName())) continue;
                        UIManager.setLookAndFeel(info.getClassName());
                        break;
                    }
                }
                catch (Exception uiex) {
                    uiex.printStackTrace();
                }
            }
            SharedApplicationData gd = base == null ? SharedApplicationData.singleton() : base.initSharedApplicationData(base.getAppDataOverride());
            String canonHome = gd.homeDirectory();
            try {
                SharedApplicationData.ProcessorCount = Runtime.getRuntime().availableProcessors();
                System.out.println("Processors: " + SharedApplicationData.ProcessorCount);
            }
            catch (Exception uiex) {
                uiex.printStackTrace();
            }
            SharedApplicationData.ProcessorCount = Math.max(SharedApplicationData.ProcessorCount, 1);
            HashMap map = new HashMap();
            SharedApplicationData.singleton().LaunchCodes = map;
            title = (String)title + String.format(", v%s", com.PecosCore.Application.Environment.XT_VERSION);
            PluginManager pluginManager = PluginManager.singleton();
            pluginManager.loadList();
            if (base == null) {
                WhichWizardDialog whichDlg = new WhichWizardDialog((String)title);
                if (whichDlg.WhichFunction == WhichWizardDialog.Function.Cancel) {
                    System.exit(0);
                }
                if (whichDlg.WhichFunction == WhichWizardDialog.Function.ImportMultiple) {
                    return AppLauncher.importMultipleSegy(base);
                }
                if (whichDlg.WhichFunction == WhichWizardDialog.Function.OpenProject) {
                    return AppLauncher.openProject(null, base);
                }
                if (whichDlg.WhichFunction == WhichWizardDialog.Function.Synthetic2D) {
                    return AppLauncher.syn2D();
                }
                if (whichDlg.WhichFunction == WhichWizardDialog.Function.Merge) {
                    return AppLauncher.merge(base);
                }
                if (whichDlg.WhichFunction == WhichWizardDialog.Function.ImportMarine2D) {
                    return AppLauncher.importSegyMarine2D(base);
                }
                if (whichDlg.WhichFunction == WhichWizardDialog.Function.ImportSegyExp) {
                    return AppLauncher.importSegy(true, base);
                }
                if (whichDlg.WhichFunction == WhichWizardDialog.Function.ImportECHOS) {
                    return AppLauncher.importECHOS(base);
                }
                if (whichDlg.WhichFunction == WhichWizardDialog.Function.ImportGLI) {
                    return AppLauncher.importGLI(base);
                }
                if (whichDlg.WhichFunction == WhichWizardDialog.Function.ImportBinaryPickFiles) {
                    return AppLauncher.importBinaryPickFiles(base);
                }
                if (whichDlg.WhichFunction == WhichWizardDialog.Function.ImportSei2D) {
                    return AppLauncher.importSei2D(base);
                }
                if (whichDlg.WhichFunction == WhichWizardDialog.Function.ImportPlugin) {
                    return AppLauncher.importPlugin(base);
                }
            } else {
                base.whichWizard((String)title, args);
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected static void testBitLogic() {
        try {
            int test = 0;
            System.err.println("test = " + (test |= 1));
            System.err.println("test = " + (test |= 2));
            int polarity = test & 1;
            System.err.println("polarity = " + polarity);
            int dead = test & 2;
            System.err.println("dead = " + dead);
            polarity = test & 1;
            test = polarity == 0 ? (test |= 1) : (test &= 0xFFFFFFFE);
            polarity = test & 1;
            System.err.println("test, polarity after flip = " + test + " " + polarity);
            polarity = test & 1;
            test = polarity == 0 ? (test |= 1) : (test &= 0xFFFFFFFE);
            polarity = test & 1;
            System.err.println("test, polarity after flip = " + test + " " + polarity);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected static JFrame merge(AppLauncher_Base base) {
        try {
            ImportExistingProjectsDialogV2 dlg = new ImportExistingProjectsDialogV2();
            Action_Sequence sequence = dlg.sequence();
            if (sequence == null) {
                return null;
            }
            Dialog_ActionSequence dlg3 = new Dialog_ActionSequence(sequence);
            return AppLauncher.openProject(dlg.projectName(), base);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected static JFrame syn2D() {
        try {
            AppFrame_Syn2D frame = new AppFrame_Syn2D();
            SharedApplicationData.singleton().setAppFrame(frame);
            return frame;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected static JFrame importBinaryPickFiles(AppLauncher_Base base) {
        try {
            ImportBinaryPickFilesDialog dlg = new ImportBinaryPickFilesDialog();
            if (dlg.ActionImport == null) {
                return null;
            }
            Action_Sequence sequence = new Action_Sequence();
            sequence.addAction(dlg.ActionImport);
            Dialog_ActionSequence dlg3 = new Dialog_ActionSequence(sequence);
            dlg.ActionImport = null;
            System.gc();
            return AppLauncher.openProject(dlg.projectName(), base);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected static JFrame importGLI(AppLauncher_Base base) {
        try {
            ImportGliDialog dlg = new ImportGliDialog();
            if (dlg.ActionGLI == null) {
                return null;
            }
            Action_Sequence sequence = new Action_Sequence();
            sequence.addAction(dlg.ActionGLI);
            Dialog_ActionSequence dlg3 = new Dialog_ActionSequence(sequence);
            dlg.ActionGLI = null;
            System.gc();
            return AppLauncher.openProject(dlg.projectName(), base);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected static JFrame importSei2D(AppLauncher_Base base) {
        try {
            JFileChooser fileChooser = new JFileChooser();
            String currPath = Tools_Chooser.prepareCurrentPath(fileChooser);
            fileChooser.setFileSelectionMode(0);
            if (fileChooser.showOpenDialog(null) != 0) {
                return null;
            }
            Tools_Chooser.saveCurrentPath(fileChooser);
            Object fileName = fileChooser.getSelectedFile().getName();
            String fullPath = fileChooser.getSelectedFile().getAbsolutePath();
            Segy segytest = new Segy();
            segytest.setFileName(fullPath);
            if (!segytest.isFileOK()) {
                JOptionPane.showMessageDialog(null, "Not a valid SEG-Y file", "Not a valid SEG-Y file", 0);
                return null;
            }
            Object projectNameRoot = fileName = "SEI2D" + Tools_Strings.removeCrap((String)fileName);
            int index = 1;
            String projectName = (String)projectNameRoot + "Version" + Integer.toString(index);
            String path = SharedApplicationData.staticsProjectPath() + "/" + projectName;
            while (Tools_FileSystem.exists_path(path)) {
                projectName = (String)projectNameRoot + "Version" + Integer.toString(++index);
                path = SharedApplicationData.staticsProjectPath() + "/" + projectName;
            }
            ArrayList<String> files = new ArrayList<String>();
            files.add(fullPath);
            Action_ImportPreStackSegy segy = new Action_ImportPreStackSegy();
            String parentPath = SharedApplicationData.staticsProjectPath();
            segy.Hasher.string_put("ParentPath", parentPath);
            segy.Hasher.string_put("ProjectName", projectName);
            segy.Hasher.string_put("Dimension", "2D");
            segy.Hasher.string_put("Units", "Feet");
            segy.Hasher.stringList_put("FileList", files);
            segy.CreateCompressed = false;
            segy.MaxTime = 22222.0f;
            segy.SeiDictionary = new Segy_Dictionary();
            segy.SeiDictionary.addDefaultEntries_SEI2D();
            Action_Sequence sequence = new Action_Sequence();
            sequence.addAction(segy);
            Dialog_ActionSequence dlg3 = new Dialog_ActionSequence(sequence);
            SharedApplicationData.SEI2D = true;
            RefractionStaticsProject.singleton().setName(projectName);
            AppFrame_RefractionStatics frame = new AppFrame_RefractionStatics(false, false);
            if (base != null) {
                base.modifyFlatironsAppFrame(null);
            }
            SharedApplicationData.singleton().setAppFrame(frame);
            return frame;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected static JFrame importMultipleSegy(AppLauncher_Base base) {
        try {
            MultipleProjectImportDialog dlg = new MultipleProjectImportDialog();
            if (!dlg.OK) {
                return null;
            }
            Table_Abstract table = dlg.table();
            int indexName = table.column_indexOfColumn("Project name");
            int indexFile = table.column_indexOfColumn("File name");
            Action_Sequence sequence = new Action_Sequence();
            for (int n = 0; n < table.row_count(); ++n) {
                String name = table.getString(n, indexName);
                String file = table.getString(n, indexFile);
                ArrayList<String> list = new ArrayList<String>();
                list.add(file);
                Action_ImportPreStackSegy segy = new Action_ImportPreStackSegy();
                String parentPath = SharedApplicationData.staticsProjectPath();
                segy.Hasher.string_put("ParentPath", parentPath);
                segy.Hasher.string_put("ProjectName", name);
                segy.Hasher.string_put("Dimension", dlg.dimWidget().dimension());
                segy.Hasher.string_put("Units", dlg.unitsWidget().units());
                segy.Hasher.string_put("DictionaryFile", dlg.dictFileName());
                segy.Hasher.stringList_put("FileList", list);
                segy.CreateCompressed = dlg.compressed();
                segy.MaxTime = dlg.compressionLength();
                segy.CreateSparse = false;
                segy.SparseSpacing = 100.0f;
                segy.SparseRadius = 100.0f;
                segy.KillNoisy = false;
                segy.NoiseWindow = 1111.0f;
                segy.NoiseCutoff = 1111.0f;
                sequence.addAction(segy);
            }
            Dialog_ActionSequence dlg3 = new Dialog_ActionSequence(sequence);
            return AppLauncher.openProject(null, base);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected static JFrame importSegy(boolean experimental, AppLauncher_Base base) {
        try {
            SegyWizardSharedData data = new SegyWizardSharedData();
            ArrayList<SimpleWizardDialog.Page> pageList = new ArrayList<SimpleWizardDialog.Page>();
            if (experimental) {
                pageFiles = new Page_SegyWiz_Files(data);
                pageName = new Page_SegyWiz_Name(data);
                Page_SegyWiz_DictFileNameV2 pageDictFileV2 = new Page_SegyWiz_DictFileNameV2(data);
                pageCompression = new Page_SegyWiz_Compression(data);
                pageList.add(new SimpleWizardDialog.Page(pageName, "Project name, units, dimension", "name"));
                pageList.add(new SimpleWizardDialog.Page((JComponent)pageCompression, "Compression options", "comp"));
                pageList.add(new SimpleWizardDialog.Page(pageFiles, "Select SEG-Y files", "files"));
                pageList.add(new SimpleWizardDialog.Page(pageDictFileV2, "SEG-Y header dictionary file name", "dict"));
            } else {
                pageFiles = new Page_SegyWiz_Files(data);
                pageName = new Page_SegyWiz_Name(data);
                Page_SegyWiz_DictFileName pageDictFile = new Page_SegyWiz_DictFileName(data);
                pageCompression = new Page_SegyWiz_Compression(data);
                Page_SegyWiz_Required pageShotReq = new Page_SegyWiz_Required("Shot", data);
                Page_SegyWiz_Optional pageShotOpt = new Page_SegyWiz_Optional("Shot", data);
                Page_SegyWiz_Required pageRecReq = new Page_SegyWiz_Required("Receiver", data);
                Page_SegyWiz_Optional pageRecOpt = new Page_SegyWiz_Optional("Receiver", data);
                Page_SegyWiz_Optional pageTraceOpt = new Page_SegyWiz_Optional("Trace", data);
                Page_SegyWiz_Scalars pageScalars = new Page_SegyWiz_Scalars(data);
                pageList.add(new SimpleWizardDialog.Page(pageName, "Project name, units, dimension", "name"));
                pageList.add(new SimpleWizardDialog.Page((JComponent)pageCompression, "Compression options", "comp"));
                pageList.add(new SimpleWizardDialog.Page(pageFiles, "Select SEG-Y files", "files"));
                pageList.add(new SimpleWizardDialog.Page(pageDictFile, "SEG-Y header dictionary file name", "dict"));
                pageList.add(new SimpleWizardDialog.Page(pageScalars, "Scalar conversion entries", "scalars"));
                pageList.add(new SimpleWizardDialog.Page(pageShotReq, "Shot table: required entries", "shotreq"));
                pageList.add(new SimpleWizardDialog.Page(pageShotOpt, "Shot table: optional entries", "shotopt"));
                pageList.add(new SimpleWizardDialog.Page(pageRecReq, "Receiver table: required entries", "recreq"));
                pageList.add(new SimpleWizardDialog.Page(pageRecOpt, "Receiver table: optional entries", "recopt"));
                pageList.add(new SimpleWizardDialog.Page(pageTraceOpt, "Trace table: optional entries", "trcopt"));
            }
            ImportWizardDialog dlg = new ImportWizardDialog(pageList, "SEG-Y import", 1000, 800);
            dlg.showDialog();
            if (!dlg.Finish) {
                return null;
            }
            data.Dictionary.save();
            Action_ImportPreStackSegy segy = new Action_ImportPreStackSegy();
            String parentPath = SharedApplicationData.staticsProjectPath();
            segy.Hasher.string_put("ParentPath", parentPath);
            segy.Hasher.string_put("ProjectName", data.ProjectName);
            segy.Hasher.string_put("Dimension", data.Dimension);
            segy.Hasher.string_put("Units", data.Units);
            segy.Hasher.string_put("DictionaryFile", data.Dictionary.getFileName());
            segy.Hasher.stringList_put("FileList", data.Files);
            segy.DecimateInput_ReceiverFold = data.DecimateInput_ReceiverFold;
            segy.DecimateInput = data.DecimateInput;
            segy.Decimation = data.Decimation;
            segy.CreateCompressed = data.CreateCompressed;
            segy.MaxTime = data.MaxTime;
            segy.OutputSampleInterval = data.OutputSampleInterval;
            segy.KillSensor = data.KillSensor;
            segy.MaxSensor = data.MaxSensor;
            segy.MinSensor = data.MinSensor;
            segy.KillOffsets = data.KillOffsets;
            segy.MaxOffset = data.MaxOffset;
            segy.MinOffset = data.MinOffset;
            segy.CreateSparse = data.CreateSparse;
            segy.SparseSpacing = data.SparseSpacing;
            segy.SparseRadius = data.SparseRadius;
            segy.KillNoisy = data.KillNoisy;
            segy.NoiseWindow = data.NoiseWindow;
            segy.NoiseCutoff = data.NoiseCutoff;
            segy.IsMarine = data.IsMarine;
            segy.RecBinSize = data.RecBinSize;
            segy.MarineDecimation = data.MarineDecimation;
            segy.MarineShotLineIncrement = data.MarineShotLineIncrement;
            try {
                for (SegyWizardSharedData.CompressedImportLimit lim : data.ImportLimitList) {
                    segy.addImportLimit(lim.Header, lim.Type, lim.Min, lim.Max);
                }
            }
            catch (Exception pageCompression) {
                // empty catch block
            }
            Action_Sequence sequence = new Action_Sequence();
            sequence.addAction(segy);
            Dialog_ActionSequence dlg3 = new Dialog_ActionSequence(sequence, data.ProjectName);
            return AppLauncher.openProject(data.ProjectName, base);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected static JFrame importSegyMarine2D(AppLauncher_Base base) {
        try {
            SegyWizardSharedData data = new SegyWizardSharedData();
            ArrayList<SimpleWizardDialog.Page> pageList = new ArrayList<SimpleWizardDialog.Page>();
            Page_SegyWiz_Files pageFiles = new Page_SegyWiz_Files(data);
            Page_SegyWiz_Name pageName = new Page_SegyWiz_Name(data);
            Page_SegyWiz_DictFileNameV2 pageDictFileV2 = new Page_SegyWiz_DictFileNameV2(data);
            pageList.add(new SimpleWizardDialog.Page(pageName, "Project name, units, dimension", "name"));
            pageList.add(new SimpleWizardDialog.Page(pageFiles, "Select SEG-Y files", "files"));
            pageList.add(new SimpleWizardDialog.Page(pageDictFileV2, "SEG-Y header dictionary file name", "dict"));
            ImportWizardDialog dlg = new ImportWizardDialog(pageList, "SEG-Y import", 1000, 800);
            dlg.showDialog();
            if (!dlg.Finish) {
                return null;
            }
            data.Dictionary.save();
            Action_ImportPreStackSegy_Marine2D segy = new Action_ImportPreStackSegy_Marine2D();
            String parentPath = SharedApplicationData.staticsProjectPath();
            segy.Hasher.string_put("ParentPath", parentPath);
            segy.Hasher.string_put("ProjectName", data.ProjectName);
            segy.Hasher.string_put("Dimension", data.Dimension);
            segy.Hasher.string_put("Units", data.Units);
            segy.Hasher.string_put("DictionaryFile", data.Dictionary.getFileName());
            segy.Hasher.stringList_put("FileList", data.Files);
            Action_Sequence sequence = new Action_Sequence();
            sequence.addAction(segy);
            Dialog_ActionSequence dlg3 = new Dialog_ActionSequence(sequence);
            return AppLauncher.openProject(data.ProjectName, base);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static JFrame importPlugin(AppLauncher_Base base) {
        try {
            PluginManager.singleton().loadCurrentPlugin();
            SegyWizardSharedData data = new SegyWizardSharedData();
            Page_SegyWiz_Name pageName = new Page_SegyWiz_Name(data);
            Page_PluginWiz_Files pageFiles = new Page_PluginWiz_Files(data, PluginManager.singleton().currentPlugin());
            Page_SegyWiz_Compression pageCompression = new Page_SegyWiz_Compression(data);
            Page_PluginWiz_LineNumber pageLine = new Page_PluginWiz_LineNumber(data);
            ArrayList<SimpleWizardDialog.Page> pageList = new ArrayList<SimpleWizardDialog.Page>();
            String fileType = PluginManager.singleton().currentPlugin().getImportFileLabel();
            String fileSelectString = String.format("Select %s files", fileType);
            pageList.add(new SimpleWizardDialog.Page(pageName, "Project name, units, dimension", "name"));
            pageList.add(new SimpleWizardDialog.Page(pageCompression, "Compression options", "comp"));
            pageList.add(new SimpleWizardDialog.Page(pageFiles, fileSelectString, "files"));
            pageList.add(new SimpleWizardDialog.Page(pageLine, "Line numbers/Scan files", "line"));
            ImportWizardDialog dialog = new ImportWizardDialog(pageList, "DIO/Omega import", 1000, 800);
            dialog.showDialog();
            if (!dialog.Finish) {
                return null;
            }
            Action_ImportPreStackPlugin importAction = new Action_ImportPreStackPlugin(PluginManager.singleton().currentPlugin());
            String parentPath = SharedApplicationData.staticsProjectPath();
            importAction.Hasher.string_put("ParentPath", parentPath);
            importAction.Hasher.string_put("ProjectName", data.ProjectName);
            importAction.Hasher.string_put("Dimension", data.Dimension);
            importAction.Hasher.string_put("Units", data.Units);
            importAction.Hasher.stringList_put("FileList", data.Files);
            importAction.DecimateInput = data.DecimateInput;
            importAction.Decimation = data.Decimation;
            importAction.CreateCompressed = data.CreateCompressed;
            importAction.MaxTime = data.MaxTime;
            importAction.OutputSampleInterval = data.OutputSampleInterval;
            importAction.KillOffsets = data.KillOffsets;
            importAction.MaxOffset = data.MaxOffset;
            importAction.MinOffset = data.MinOffset;
            importAction.CreateSparse = data.CreateSparse;
            importAction.SparseSpacing = data.SparseSpacing;
            importAction.SparseRadius = data.SparseRadius;
            importAction.KillNoisy = data.KillNoisy;
            importAction.NoiseWindow = data.NoiseWindow;
            importAction.NoiseCutoff = data.NoiseCutoff;
            importAction.IsMarine = data.IsMarine;
            importAction.RecBinSize = data.RecBinSize;
            importAction.MarineDecimation = data.MarineDecimation;
            importAction.MarineShotLineIncrement = data.MarineShotLineIncrement;
            Action_Sequence sequence = new Action_Sequence();
            sequence.addAction(importAction);
            Dialog_ActionSequence dlg = new Dialog_ActionSequence(sequence);
            return AppLauncher.openProject(data.ProjectName, base);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static JFrame openProject(String projectName, AppLauncher_Base base) {
        try {
            boolean load = false;
            if (base == null) {
                if (projectName == null) {
                    SelectProjectDialog dlg = new SelectProjectDialog(false, false);
                    if (!dlg.OK) {
                        System.exit(0);
                    }
                    load = dlg.loadSaved;
                    HashMap<String, String> map = SharedApplicationData.singleton().LaunchCodes;
                    projectName = map.get("ProjectName");
                }
            } else if (projectName == null) {
                projectName = base.setProjectName();
            }
            RefractionStaticsProject.singleton().setName(projectName);
            AppLauncher.autoBackupRefractionDatabase();
            AppFrame_RefractionStatics frame = new AppFrame_RefractionStatics(load, false);
            if (base != null) {
                base.modifyFlatironsAppFrame(frame);
            }
            SharedApplicationData.singleton().setAppFrame(frame);
            frame.setVisible(true);
            return frame;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void autoBackupRefractionDatabase() {
        try {
            String versionsPath = RefractionStaticsProject.singleton().versionContainerPath();
            String backupsPath = Tools_FileSystem.confirmSubDirectoryExists(RefractionStaticsProject.singleton().projectPath(), "Backups");
            String backupContainer = Tools_FileSystem.confirmSubDirectoryExists(backupsPath, "Auto");
            ArrayList<String> versions = Tools_FileSystem.subdirectories(versionsPath, false);
            for (String version : versions) {
                String fullVersionPath = versionsPath + "/" + version;
                String geomDBScriptPath = fullVersionPath + "/geometry.db.script";
                if (!Tools_FileSystem.exists_file(geomDBScriptPath)) continue;
                File DBFile = new File(geomDBScriptPath);
                long DBSize = DBFile.length();
                if (DBSize > 65000000L) {
                    System.out.println("Geometry DB file size too large (" + DBSize + "), skipping automatic backup.");
                    continue;
                }
                Tools_FileSystem.copySubdirectory(versionsPath, backupContainer, version);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected static JFrame importECHOS(AppLauncher_Base base) {
        try {
            boolean bEchosSetupOK = Environment.getIsEchosEnvironmentSetupOK("Pecos");
            if (!bEchosSetupOK) {
                return null;
            }
            boolean bEchosInitializedOk = XtEchos.initialize();
            if (!bEchosInitializedOk) {
                Exception lastError = XtEchos.getLastInitializeError();
                boolean bLoadLibraryOK = XtEchos.getLoadEposLibraryOK();
                boolean initializeParadigmOK = XtEchos.getInitializeParadigmEnvironmentOK();
                String sError = "Error connecting to Echos";
                if (!bLoadLibraryOK) {
                    sError = "Error loading Echos library";
                }
                if (!initializeParadigmOK) {
                    sError = "Error calling PG_InitializeApplication";
                }
                String sErrorDetails = "";
                if (lastError != null) {
                    sErrorDetails = lastError.getMessage();
                }
                JOptionPane.showMessageDialog(null, sErrorDetails, sError, 0);
                return null;
            }
            EchosWizardSharedData data = new EchosWizardSharedData();
            ArrayList<SimpleWizardDialog.Page> pageList = new ArrayList<SimpleWizardDialog.Page>();
            Page_EchosWiz_Survey surveyPage = new Page_EchosWiz_Survey(data);
            Page_EchosWiz_File filePage = new Page_EchosWiz_File(data);
            Page_EchosWiz_Name namePage = new Page_EchosWiz_Name(data);
            Page_EchosWiz_Compression compressionPage = new Page_EchosWiz_Compression(data);
            Page_EchosWiz_DictFileName dictionaryPage = new Page_EchosWiz_DictFileName(data);
            pageList.add(new SimpleWizardDialog.Page(surveyPage, "Echos Survey", "Survey"));
            pageList.add(new SimpleWizardDialog.Page(filePage, "Echos File", "File"));
            pageList.add(new SimpleWizardDialog.Page(namePage, "Project name, units, dimension", "Project name, units, dimension"));
            pageList.add(new SimpleWizardDialog.Page(compressionPage, "Compression Options", "Compression Options"));
            pageList.add(new SimpleWizardDialog.Page(dictionaryPage, "Header Dictionary", "Header Dictionary"));
            ImportWizardDialog dlg = new ImportWizardDialog(pageList, "Echos import", 1000, 800);
            dlg.showDialog();
            if (!dlg.Finish) {
                return null;
            }
            data.EchosDictionary.save();
            int iLineID = -1;
            if (data.Echos_SeismicFile != null) {
                iLineID = data.Echos_SeismicFile.getLineID();
            }
            Action_ImportPreStackEchosV2 importEchosAction = new Action_ImportPreStackEchosV2(data.EchosSurveyName, data.EchosSurveyHost, iLineID);
            String parentPath = SharedApplicationData.staticsProjectPath();
            importEchosAction.Hasher.string_put("Origin", "ECHOS");
            importEchosAction.Hasher.string_put("EchosSurvey", data.EchosSurveyName);
            importEchosAction.Hasher.string_put("EchosHost", data.EchosSurveyHost);
            importEchosAction.Hasher.int_put("EchosLineID", iLineID);
            importEchosAction.Hasher.string_put("ParentPath", parentPath);
            importEchosAction.Hasher.string_put("ProjectName", data.ProjectName);
            importEchosAction.Hasher.string_put("Dimension", data.Dimension);
            importEchosAction.Hasher.string_put("Units", data.Units);
            importEchosAction.Hasher.string_put("DictionaryFile", data.EchosDictionary.getFileName());
            importEchosAction.Hasher.stringList_put("FileList", data.Files);
            importEchosAction.DecimateInput = data.DecimateInput;
            importEchosAction.Decimation = data.Decimation;
            importEchosAction.CreateCompressed = data.CreateCompressed;
            importEchosAction.MaxTime = data.MaxTime;
            importEchosAction.OutputSampleInterval = data.OutputSampleInterval;
            importEchosAction.KillOffsets = data.KillOffsets;
            importEchosAction.MaxOffset = data.MaxOffset;
            importEchosAction.MinOffset = data.MinOffset;
            importEchosAction.CreateSparse = data.CreateSparse;
            importEchosAction.SparseSpacing = data.SparseSpacing;
            importEchosAction.SparseRadius = data.SparseRadius;
            importEchosAction.KillNoisy = data.KillNoisy;
            importEchosAction.NoiseWindow = data.NoiseWindow;
            importEchosAction.NoiseCutoff = data.NoiseCutoff;
            importEchosAction.IsMarine = data.IsMarine;
            importEchosAction.RecBinSize = data.RecBinSize;
            importEchosAction.MarineDecimation = data.MarineDecimation;
            importEchosAction.MarineShotLineIncrement = data.MarineShotLineIncrement;
            try {
                for (SegyWizardSharedData.CompressedImportLimit lim : data.ImportLimitList) {
                    ImportLimit il = new ImportLimit();
                    il.Table = lim.Table;
                    il.Column = lim.Column;
                    il.Min = lim.Min;
                    il.Max = lim.Max;
                    il.HeaderName = lim.HeaderName;
                    importEchosAction.addImportLimit(il);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Action_Sequence sequence = new Action_Sequence();
            sequence.addAction(importEchosAction);
            Dialog_ActionSequence dlg3 = new Dialog_ActionSequence(sequence, data.ProjectName);
            return AppLauncher.openProject(data.ProjectName, base);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }
}

