/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Tomography;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Math.AzimuthSelector;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tomography.TomoEikonal3D;
import com.PecosLibrary.Refraction.Tomography.TomoEikonal3DProfile;
import java.util.ArrayList;
import java.util.Arrays;

public class Action_Eikonal3D_NewThreadModel
extends Action_Base {
    public int NumThreads = 2;
    public int NumIter = 10;
    public double MaxOffset = 12000.0;
    public double MinOffset = 0.0;
    public double OffsetCorner = 1000.0;
    public int SmoothRadius = 3;
    public boolean SaveAfterEachIter = false;
    public String PickVersion = "FBP_User";
    public double PickShift = 0.0;
    public TomoEikonal3D Model;
    public boolean ApplyAzimuthLimits = false;
    public double AzimuthCenter = 0.0;
    public double AzimuthRadius = 0.7853981633974483;
    public boolean ComputeHybridTimeShifts = false;
    public double HybridLMOVelocity = 20000.0;
    public double HybridTimeShifts = 200.0;
    public boolean ApplyDecimation = false;
    public int Decimation = 1;
    public boolean Uphole_LockShallow = false;
    public String Uphole_Table = "";
    public String Uphole_X = "";
    public String Uphole_Y = "";
    public String Uphole_Z = "";
    public String Uphole_V = "";

    public Action_Eikonal3D_NewThreadModel() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "3D Eikonal model update";
        this.RequiresDelayTimeData = false;
        this.MemoryRequired = 512;
        this.RequiresCompleteTraceTable = true;
        this.DelayTimeDataModified = false;
    }

    protected HashMap_Integers<TomoEikonal3D.Element> finishMap(Table_Abstract table, String colNameID, HashMap_Integers<TomoEikonal3D.Element> map) {
        try {
            HashMap_Integers<TomoEikonal3D.Element> newMap = new HashMap_Integers<TomoEikonal3D.Element>();
            int index = table.column_indexOfColumn(colNameID);
            for (TomoEikonal3D.Element e : map.getValues()) {
                e.ID = table.getInt(e.ID, index);
                e.Residual /= e.Count;
                e.Error /= e.Count;
                e.ComputedResidual = e.Residual;
                newMap.put(e, e.ID);
            }
            return newMap;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            long startTime = System.currentTimeMillis();
            if (this.Uphole_LockShallow) {
                try {
                    IDatabaseConnection dc = project.importDatabase();
                    String sql = String.format("SELECT * FROM %s", this.Uphole_Table);
                    Table_Abstract table = dc.extractTableDataUsingQuery(this.Uphole_Table, sql, 1000000);
                    this.Model.createInterpolatedGrid("UpholeVelocity", table, this.Uphole_X, this.Uphole_Y, this.Uphole_V);
                    this.Model.createInterpolatedGrid("UpholeElevation", table, this.Uphole_X, this.Uphole_Y, this.Uphole_Z);
                }
                catch (Exception uex) {
                    uex.printStackTrace();
                    this.Uphole_LockShallow = false;
                }
            }
            ++this.NumIter;
            ITraceTable traceTable = project.traceTableWrapper().traceTable();
            int indexShotID = traceTable.column_indexOfColumn("ShotID");
            int indexRecID = traceTable.column_indexOfColumn("ReceiverID");
            int indexPick = traceTable.column_indexOfColumn(this.PickVersion);
            int indexKilled = traceTable.column_indexOfColumn("Killed");
            double totalTraces = (long)this.NumIter * traceTable.rowCount();
            double traceCount = 0.0;
            Table_Abstract shotTable = project.shotTable();
            HashMap_Integer shotMap = project.shotMap();
            int indexShotX = shotTable.column_indexOfColumn("Easting");
            int indexShotY = shotTable.column_indexOfColumn("Northing");
            int indexShotZ = shotTable.column_indexOfColumn("Elevation");
            int indexShotDead = shotTable.column_indexOfColumn("Killed");
            int indexShotDepth = -9999;
            if (shotTable.column_exists("PointDepth")) {
                indexShotDepth = shotTable.column_indexOfColumn("PointDepth");
            }
            Table_Abstract recTable = project.receiverTable();
            HashMap_Integer recMap = project.receiverMap();
            int indexRecX = recTable.column_indexOfColumn("Easting");
            int indexRecY = recTable.column_indexOfColumn("Northing");
            int indexRecZ = recTable.column_indexOfColumn("Elevation");
            int indexRecDead = recTable.column_indexOfColumn("Killed");
            AzimuthSelector azimuthSelector = new AzimuthSelector();
            azimuthSelector.setLimits(this.AzimuthCenter, this.AzimuthRadius, true);
            this.ComputeHybridTimeShifts = this.ComputeHybridTimeShifts && traceTable.column_exists("FBP_Back3");
            this.HybridLMOVelocity = Math.max(this.HybridLMOVelocity, 100.0);
            this.HybridTimeShifts = Math.max(this.HybridTimeShifts, 100.0);
            int indexHybrid = -9999;
            if (this.ComputeHybridTimeShifts) {
                indexHybrid = traceTable.column_indexOfColumn("FBP_Back3");
            }
            ArrayList<ThreadData> threadDataList = new ArrayList<ThreadData>();
            this.ApplyDecimation = this.ApplyDecimation && this.Decimation >= 2;
            long twobillion = 2000000000L;
            int numValid = 0;
            int numOkay = 0;
            int currentThreadIndex = 0;
            ThreadData currentThread = null;
            for (int pass = 0; pass <= 1; ++pass) {
                numValid = 0;
                numOkay = 0;
                if (pass == 0) {
                    messageServer.setMessage_Level1(String.format("Counting valid picks...", new Object[0]));
                }
                if (pass == 1) {
                    messageServer.setMessage_Level1(String.format("Preparing thread data...", new Object[0]));
                }
                for (long row = 0L; row < traceTable.rowCount() && !this.Halt; ++row) {
                    if (indexHybrid >= 0 && pass == 0) {
                        traceTable.putFloat(row, indexHybrid, -9999.0f);
                    }
                    int killed = traceTable.getInt(row, indexKilled);
                    int shotID = traceTable.getInt(row, indexShotID);
                    int shotRow = shotMap.get(shotID);
                    int recID = traceTable.getInt(row, indexRecID);
                    int recRow = recMap.get(recID);
                    float pick = traceTable.getFloat(row, indexPick) + (float)this.PickShift;
                    if (!(pick >= 10.0f) || killed != 0 || shotTable.getBool(shotRow, indexShotDead) || recTable.getBool(recRow, indexRecDead)) continue;
                    double sx = shotTable.getDouble(shotRow, indexShotX);
                    double sy = shotTable.getDouble(shotRow, indexShotY);
                    double sz = shotTable.getDouble(shotRow, indexShotZ);
                    double sd = 0.0;
                    if (indexShotDepth >= 0) {
                        sd = shotTable.getDouble(shotRow, indexShotDepth);
                    }
                    double rx = recTable.getDouble(recRow, indexRecX);
                    double ry = recTable.getDouble(recRow, indexRecY);
                    double rz = recTable.getDouble(recRow, indexRecZ);
                    double dx = sx - rx;
                    double dy = sy - ry;
                    double off = Math.sqrt(dx * dx + dy * dy + 0.01);
                    boolean azimuthOkay = true;
                    if (this.ApplyAzimuthLimits && off > 0.0) {
                        double az = Math.atan2(dy, dx);
                        azimuthOkay = azimuthSelector.accept(az);
                    }
                    if (!azimuthOkay || !(off > this.MinOffset) || !(off < this.MaxOffset)) continue;
                    boolean addToThread = false;
                    if (!this.ApplyDecimation) {
                        boolean bl = addToThread = pass == 1;
                        if (pass == 0) {
                            ++numValid;
                        }
                    } else {
                        if (numOkay % this.Decimation == 0) {
                            boolean bl = addToThread = pass == 1;
                            if (pass == 0) {
                                ++numValid;
                            }
                        }
                        ++numOkay;
                    }
                    if (!addToThread) continue;
                    currentThread.addPick(pick, shotRow, recRow, row);
                    if (currentThread.NumPicks >= currentThread.ShotRow.length && ++currentThreadIndex < this.NumThreads) {
                        currentThread = (ThreadData)threadDataList.get(currentThreadIndex);
                    }
                    ++numValid;
                }
                if (pass != 0) continue;
                int numPicksperThread = 20 + numValid / this.NumThreads;
                for (int n = 0; n < this.NumThreads; ++n) {
                    ThreadData td = new ThreadData(n, this.Model, numPicksperThread);
                    threadDataList.add(td);
                }
                currentThreadIndex = 0;
                currentThread = (ThreadData)threadDataList.get(currentThreadIndex);
            }
            if (this.Halt) {
                return false;
            }
            System.gc();
            System.gc();
            if (this.Halt) {
                return false;
            }
            long totalValidTraces = 1L + (long)numValid * (long)this.NumIter;
            if (this.Model.getHistory() != null) {
                this.Model.getHistory().addWithTime("Begin batch update");
                this.Model.getHistory().add("Minimum offset = " + Double.toString(this.MinOffset));
                this.Model.getHistory().add("Maximum offset = " + Double.toString(this.MaxOffset));
                this.Model.getHistory().add("Offset corner = " + Double.toString(this.OffsetCorner));
                this.Model.getHistory().add("Num threads = " + Integer.toString(this.NumThreads));
                this.Model.getHistory().add("Smooth radius = " + Integer.toString(this.SmoothRadius));
                this.Model.getHistory().add("Pick version = " + this.PickVersion);
                if (!this.ApplyDecimation || this.Decimation <= 1) {
                    this.Model.getHistory().add("Picks not decimated");
                } else {
                    this.Model.getHistory().add("Decimation = " + Integer.toString(this.Decimation));
                }
            }
            HashMap_Integers<TomoEikonal3D.Element> srcHash = new HashMap_Integers<TomoEikonal3D.Element>();
            HashMap_Integers<TomoEikonal3D.Element> recHash = new HashMap_Integers<TomoEikonal3D.Element>();
            for (int iter = 1; iter <= this.NumIter && !this.Halt; ++iter) {
                messageServer.setMessage_Level1(String.format("Working on iteration %d of %d", iter, this.NumIter));
                if (iter == this.NumIter) {
                    messageServer.setMessage_Level1(String.format("Compute residuals: iteration %d of %d", iter, this.NumIter));
                }
                long currTime = System.currentTimeMillis();
                for (ThreadData threadData : threadDataList) {
                    threadData.Iteration = iter;
                    threadData.NumIter = this.NumIter;
                }
                if (iter < this.NumIter) {
                    this.Model.prepUpdate();
                    this.Model.WeightTime = 100.0f - 10.0f * (float)iter;
                    this.Model.WeightTime = Math.max(this.Model.WeightTime, 10.0f);
                    if (this.Uphole_LockShallow) {
                        this.Model.applyUpholeVelocityLayer("UpholeElevation", "UpholeVelocity");
                    }
                }
                ArrayList<LocalThread> threads = new ArrayList<LocalThread>();
                for (ThreadData threadData : threadDataList) {
                    threads.add(new LocalThread(threadData));
                }
                for (LocalThread lt : threads) {
                    lt.start();
                }
                System.out.println("Threads started...");
                for (LocalThread lt : threads) {
                    if (lt.isAlive()) continue;
                    System.out.println("THREAD NOT ALIVE!?!?!?");
                }
                boolean keepLooping = true;
                while (keepLooping) {
                    long checkTime;
                    keepLooping = false;
                    for (LocalThread lt : threads) {
                        keepLooping = keepLooping || lt.isAlive();
                    }
                    if (keepLooping) {
                        Thread.sleep(100L);
                    }
                    if ((checkTime = System.currentTimeMillis()) - currTime <= 1000L) continue;
                    long total = 0L;
                    for (ThreadData threadData : threadDataList) {
                        total += threadData.TotalTraces;
                    }
                    double percent = 100.0 * (double)total / (double)totalValidTraces;
                    messageServer.setPercentDone(percent);
                    currTime = checkTime;
                }
                System.out.println("Threads finished");
                if (iter < this.NumIter) {
                    if (!this.Halt) {
                        float extrapolateDown = 1.04f;
                        float extrapolateUp = 0.96f;
                        float fractionCoarse = 0.5f;
                        int smoothH = 10;
                        int smoothZ = 1;
                        float maxPercentChange = 10.0f;
                        if (iter >= 2) {
                            extrapolateDown = 1.015f;
                            extrapolateUp = 0.985f;
                            smoothH = 8;
                        }
                        if (iter >= 4) {
                            fractionCoarse = 0.25f;
                            extrapolateDown = 1.005f;
                            extrapolateUp = 0.995f;
                            smoothH = this.SmoothRadius;
                            smoothZ = 0;
                        }
                        if (iter < this.NumIter) {
                            this.Model.finishUpdate(smoothH, smoothZ, extrapolateDown, extrapolateUp, fractionCoarse, this.NumIter, iter, maxPercentChange);
                        }
                        if (this.SaveAfterEachIter) {
                            this.Model.save(this.Model.name());
                        }
                    }
                    if (iter <= 2) {
                        this.Model.forceIncreasingVelocity(1.01f);
                    }
                    if (this.Uphole_LockShallow) {
                        this.Model.applyUpholeVelocityLayer("UpholeElevation", "UpholeVelocity");
                    }
                    this.Model.prepWaterVelocity();
                }
                double sumAvgError = 0.0;
                for (ThreadData threadData : threadDataList) {
                    sumAvgError += threadData.AverageError;
                }
                if (this.Model.getHistory() != null) {
                    String s = String.format("Iter %d, error = %f", iter, sumAvgError / (double)threadDataList.size());
                    this.Model.getHistory().addWithTimeNoSpace(s);
                }
                this.Model.prepWaterVelocity();
            }
            this.Model.freeInterpolator();
            if (!this.Halt) {
                for (ThreadData threadData : threadDataList) {
                    threadData.updateParentHash(recHash, threadData.RecHash);
                    threadData.updateParentHash(srcHash, threadData.SrcHash);
                }
                this.Model.SourceHash = this.finishMap(shotTable, "ShotID", srcHash);
                this.Model.ReceiverHash = this.finishMap(recTable, "ReceiverID", recHash);
                this.Model.save(this.Model.name());
                this.Model.writeResidualsToDatabase();
            }
            if (!this.Halt && this.ComputeHybridTimeShifts) {
                try {
                    for (int t = 0; t < threadDataList.size(); ++t) {
                        ThreadData threadData = (ThreadData)threadDataList.get(t);
                        for (int n = 0; n < threadData.NumPicks; ++n) {
                            traceTable.putFloat(threadData.TraceRow[n], indexHybrid, threadData.Hybrid[n]);
                        }
                    }
                    traceTable.saveCurrentSection();
                }
                catch (Exception errr) {
                    errr.printStackTrace();
                }
            }
            if (this.Model.getHistory() != null) {
                if (!this.Halt) {
                    this.Model.getHistory().add("End batch update");
                    long totalTime = System.currentTimeMillis() - startTime;
                    String timeMessage = Tools_Strings.runTimeMessage((int)totalTime / 1000);
                    this.Model.getHistory().add("Total time = " + timeMessage);
                } else {
                    this.Model.getHistory().add("Batch update HALTED");
                }
                this.Model.getHistory().save();
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected class ThreadData {
        public TomoEikonal3D ThreadModel;
        public TomoEikonal3DProfile Profile;
        public int ID;
        public long TotalTraces = 0L;
        public double[] ShotX;
        public double[] ShotY;
        public double[] ShotZ;
        public double[] ShotDepth;
        public double[] RecX;
        public double[] RecY;
        public double[] RecZ;
        public double[] RecDepth;
        public HashMap_Integers<TomoEikonal3D.Element> SrcHash = new HashMap_Integers();
        public HashMap_Integers<TomoEikonal3D.Element> RecHash = new HashMap_Integers();
        public long[] TraceRow;
        public short[] Hybrid;
        public int[] ShotRow;
        public int[] ReceiverRow;
        public float[] Pick;
        public int NumPicks = 0;
        public int Iteration;
        public int NumIter;
        public double SumError;
        public double AverageError;
        public double ErrorCount;

        public ThreadData(int id, TomoEikonal3D parentModel, int maxPickCount) {
            try {
                this.ID = id;
                this.ThreadModel = parentModel;
                this.Profile = this.ThreadModel.createNewProfile();
                maxPickCount = 100 + Math.max(maxPickCount, 1000);
                this.ShotRow = new int[maxPickCount];
                this.ReceiverRow = new int[maxPickCount];
                this.TraceRow = new long[maxPickCount];
                this.Hybrid = new short[maxPickCount];
                this.Pick = new float[maxPickCount];
                RefractionStaticsProject project = RefractionStaticsProject.singleton();
                Table_Abstract ReceiverTable = project.receiverTable();
                Table_Abstract ShotTable = project.shotTable();
                this.ShotX = this.getColArray(ShotTable, "Easting", 0.0);
                this.ShotY = this.getColArray(ShotTable, "Northing", 0.0);
                this.ShotZ = this.getColArray(ShotTable, "Elevation", 0.0);
                this.ShotDepth = this.getColArray(ShotTable, "PointDepth", 0.0);
                this.RecX = this.getColArray(ReceiverTable, "Easting", 0.0);
                this.RecY = this.getColArray(ReceiverTable, "Northing", 0.0);
                this.RecZ = this.getColArray(ReceiverTable, "Elevation", 0.0);
                this.RecDepth = this.getColArray(ReceiverTable, "PointDepth", 0.0);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        protected double[] getColArray(Table_Abstract table, String column, double defVal) {
            try {
                int num = table.row_count();
                double[] arr = new double[num];
                Arrays.fill(arr, defVal);
                if (table.column_exists(column)) {
                    int index = table.column_indexOfColumn(column);
                    for (int r = 0; r < num; ++r) {
                        arr[r] = table.getDouble(r, index);
                    }
                }
                return arr;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                return null;
            }
        }

        public void addPick(float pick, int shotRow, int recRow, long traceRow) {
            try {
                if (this.NumPicks >= this.ShotRow.length) {
                    return;
                }
                this.TraceRow[this.NumPicks] = traceRow;
                this.Pick[this.NumPicks] = pick;
                this.ReceiverRow[this.NumPicks] = recRow;
                this.ShotRow[this.NumPicks] = shotRow;
                ++this.NumPicks;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        protected void updateElement(HashMap_Integers<TomoEikonal3D.Element> map, int row, float error) {
            try {
                if (!map.containsKey(row)) {
                    map.put(new TomoEikonal3D.Element(row), row);
                }
                TomoEikonal3D.Element element = map.get(row);
                element.addError(error);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void updateParentHash(HashMap_Integers<TomoEikonal3D.Element> parent, HashMap_Integers<TomoEikonal3D.Element> map) {
            try {
                for (TomoEikonal3D.Element childElement : map.getValues()) {
                    int row = childElement.ID;
                    if (!parent.containsKey(row)) {
                        parent.put(new TomoEikonal3D.Element(row), row);
                    }
                    TomoEikonal3D.Element parentElement = parent.get(row);
                    parentElement.Count += childElement.Count;
                    parentElement.Error += childElement.Error;
                    parentElement.Residual += childElement.Residual;
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void run() {
            try {
                this.SrcHash.clear();
                this.RecHash.clear();
                System.out.println("run started for ID = " + this.ID);
                int zSpray = 3;
                if (this.Iteration >= 4) {
                    zSpray = 2;
                }
                float scalarSprayZ = 0.5f;
                if (this.Iteration >= 4) {
                    scalarSprayZ = 0.3f;
                }
                this.AverageError = 0.0;
                this.SumError = 0.0;
                this.ErrorCount = 1.0E-10;
                double straightLineTransition = 3.0 * Math.max(this.ThreadModel.binSizeHorz(), this.ThreadModel.binSizeVert());
                for (int n = 0; n < this.NumPicks && !Action_Eikonal3D_NewThreadModel.this.Halt; ++n) {
                    ++this.TotalTraces;
                    int shotRow = this.ShotRow[n];
                    int recRow = this.ReceiverRow[n];
                    float pick = this.Pick[n];
                    double sx = this.ShotX[shotRow];
                    double sy = this.ShotY[shotRow];
                    double sz = this.ShotZ[shotRow];
                    double sd = this.ShotDepth[shotRow];
                    double rx = this.RecX[recRow];
                    double ry = this.RecY[recRow];
                    double rz = this.RecZ[recRow];
                    double rd = this.RecDepth[recRow];
                    double dx = sx - rx;
                    double dy = sy - ry;
                    double off = Math.sqrt(dx * dx + dy * dy + 0.01);
                    double offsetWeight = Action_Eikonal3D_NewThreadModel.this.OffsetCorner / (Action_Eikonal3D_NewThreadModel.this.OffsetCorner + off);
                    offsetWeight = 100.0 * offsetWeight * offsetWeight;
                    offsetWeight = Math.max(offsetWeight, 0.01);
                    if (off < straightLineTransition) {
                        this.ThreadModel.fireStraightLine(sx, sy, sz - sd, rx, ry, rz - rd);
                        if (this.Iteration < this.NumIter) {
                            this.ThreadModel.updateStatisticsFromStraightLine(pick, (float)offsetWeight);
                        }
                    } else {
                        this.ThreadModel.populateProfile(this.Profile, sx, sy, rx, ry);
                        this.Profile.fireShot((float)(sz - sd));
                        this.Profile.setReceiver((float)(rz - rd), pick);
                        if (this.Iteration < this.NumIter && this.Profile.NumPathPoints > 0) {
                            this.ThreadModel.updateStatisticsFromProfile(this.Profile, pick, (float)offsetWeight, zSpray, scalarSprayZ);
                        }
                    }
                    double error = this.Profile.ReceiverTime - (double)pick;
                    if (this.Iteration == this.NumIter) {
                        this.updateElement(this.SrcHash, shotRow, (float)error);
                        this.updateElement(this.RecHash, recRow, (float)error);
                    }
                    if (Action_Eikonal3D_NewThreadModel.this.ComputeHybridTimeShifts) {
                        double hybrid = Action_Eikonal3D_NewThreadModel.this.HybridTimeShifts + 1000.0 * off / Action_Eikonal3D_NewThreadModel.this.HybridLMOVelocity + error;
                        this.Hybrid[n] = (short)hybrid;
                    }
                    error = Math.abs(error);
                    this.SumError += error;
                    this.ErrorCount += 1.0;
                    this.AverageError = this.SumError / this.ErrorCount;
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
            System.out.println("run finished for ID = " + this.ID);
        }
    }

    protected class LocalThread
    extends Thread {
        protected ThreadData m_td;

        public LocalThread(ThreadData td) {
            this.m_td = td;
        }

        @Override
        public void run() {
            try {
                this.m_td.run();
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }
    }
}

