/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Stack;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Stack.CrudeNMO;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

public class Action_ConstantVelocityStack
extends Action_Base {
    public EnsembleWorker_Sequence Sequence;
    public String StackName;
    public boolean ApplyStatics;
    public String VersionName;
    public String StaticsName;
    public int Radius = 1;
    public float Digi = 4.0f;
    public float MinTime = 0.0f;
    public float MaxTime = 1000.0f;
    public int SamplesPerTrace;
    public double Velocity = 12000.0;
    public double Mute = 33.0;
    public double MinOffset = 1200.0;
    public double MaxOffset = 7000.0;
    public int HeaderCount = 5;
    public String Path;
    public Grid3D m_countGrid;
    public Grid3D m_weightGrid;
    public int InlineMin;
    public int InlineMax;
    public int InlineCount;
    public int CrosslineMin;
    public int CrosslineMax;
    public int CrosslineCount;
    public float[][][] StackVolumn;
    public float[][] Amplitude;
    public float[][] Scalar;
    public CrudeNMO m_nmo = new CrudeNMO();
    public Table_Abstract m_shotTable = null;
    public HashMap_Integer m_shotHash = null;
    public int m_colIndexShot = 0;
    public Table_Abstract m_recTable = null;
    public HashMap_Integer m_recHash = null;
    public int m_colIndexRec = 0;
    public ParameterTree Parameters = new ParameterTree();
    public String ParamFileName;

    public Action_ConstantVelocityStack() {
        try {
            this.RequiresRefractionStaticsProject = true;
            this.Description = "Create const vel stack";
            this.RequiresDelayTimeData = false;
            this.MemoryRequired = 1024;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void prepStatics() {
        try {
            if (!this.ApplyStatics) {
                return;
            }
            IDatabaseConnection database = RefractionStaticsProject.singleton().getVersionDatabase(this.VersionName);
            String sql = String.format("SELECT ShotID, %s FROM Shot", this.StaticsName);
            this.m_shotTable = database.extractTableDataUsingQuery("Shot", sql, Pecos.MaxQueryRowCount);
            this.m_shotHash = this.m_shotTable.createMapID();
            this.m_colIndexShot = this.m_shotTable.column_indexOfColumn(this.StaticsName);
            sql = String.format("SELECT ReceiverID, %s FROM Receiver", this.StaticsName);
            this.m_recTable = database.extractTableDataUsingQuery("Receiver", sql, Pecos.MaxQueryRowCount);
            this.m_recHash = this.m_recTable.createMapID();
            this.m_colIndexRec = this.m_recTable.column_indexOfColumn(this.StaticsName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void applyStatics(Ensemble ensemble) {
        try {
            if (!this.ApplyStatics) {
                return;
            }
            int indexShotID = ensemble.dictionary().getEntryIndex("Trace", "ShotID");
            int indexRecID = ensemble.dictionary().getEntryIndex("Trace", "ReceiverID");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                float statics = 0.0f;
                EnsembleTrace trace = ensemble.trace(n);
                int shotID = trace.header().getInt(indexShotID);
                int shotRow = this.m_shotHash.get(shotID);
                statics += this.m_shotTable.getFloat(shotRow, this.m_colIndexShot);
                int recID = trace.header().getInt(indexRecID);
                int recRow = this.m_recHash.get(recID);
                trace.data().addShiftToFirstSampleCoord(statics += this.m_recTable.getFloat(recRow, this.m_colIndexRec));
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public float stackAmplitude(float[] stack) {
        try {
            float sum = 0.0f;
            for (int n = 0; n < stack.length; ++n) {
                sum += Math.abs(stack[n]);
            }
            return sum / (float)stack.length;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0f;
        }
    }

    protected void handleEnsemble(Ensemble inputEnsemble) {
        try {
            int numOkay = inputEnsemble.traceCount_Okay();
            if (numOkay < 1) {
                return;
            }
            Ensemble ensemble = this.Sequence.work(inputEnsemble);
            this.applyStatics(ensemble);
            int indexMidX = ensemble.dictionary().getEntryIndex("Trace", "CdpX");
            int indexMidY = ensemble.dictionary().getEntryIndex("Trace", "CdpY");
            int indexOffset = ensemble.dictionary().getEntryIndex("Trace", "Offset");
            int indexAzimuth = ensemble.dictionary().getEntryIndex("Trace", "Azimuth");
            float[] data = new float[10];
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                boolean offsetOkay;
                EnsembleTrace trace = ensemble.trace(n);
                double offset = trace.header().getDouble(indexOffset);
                boolean bl = offsetOkay = offset >= this.MinOffset && offset <= this.MaxOffset;
                if (!offsetOkay || !trace.traceOkay() || !trace.hasData()) continue;
                if (data.length != trace.data().length()) {
                    data = new float[trace.data().length()];
                }
                trace.data().copyToArray(data);
                float inputTime0 = trace.data().getFirstSampleCoord_WithShifts();
                float inputDigi = trace.data().getSampleInterval();
                this.m_nmo.applyConstantMoveout((float)this.Velocity, data, inputTime0, inputDigi, (float)offset, (float)this.Mute);
                float[] nmo = this.m_nmo.outputArray();
                float amp = this.stackAmplitude(nmo);
                if (Float.isNaN(amp)) continue;
                double midx = trace.header().getDouble(indexMidX);
                double midy = trace.header().getDouble(indexMidY);
                this.m_countGrid.setWorldLocation(midx, midy);
                int inline = this.m_countGrid.Inline;
                int crossline = this.m_countGrid.Crossline;
                for (int i = inline - this.Radius; i <= inline + this.Radius; ++i) {
                    for (int c = crossline - this.Radius; c <= crossline + this.Radius; ++c) {
                        if (i < this.InlineMin || i > this.InlineMax || c < this.CrosslineMin || c > this.CrosslineMax) continue;
                        this.Amplitude[i - this.InlineMin][c - this.CrosslineMin] = this.Amplitude[i - this.InlineMin][c - this.CrosslineMin] + amp;
                        float[] stack = this.StackVolumn[i - this.InlineMin][c - this.CrosslineMin];
                        for (int s = 0; s < stack.length; ++s) {
                            stack[s] = stack[s] + nmo[s];
                        }
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void preparePaths() {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            String parentPath = Tools_FileSystem.confirmSubDirectoryExists(project.projectPath(), "VolumeStacks");
            this.Path = Tools_FileSystem.confirmSubDirectoryExists(parentPath, this.StackName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void saveStacks() {
        try {
            int dataByteCount = 2 * this.CrosslineCount * this.InlineCount * this.SamplesPerTrace;
            int headerByteCount = 4 * this.CrosslineCount * this.InlineCount * this.HeaderCount;
            ByteBuffer bufferData = ByteBuffer_Shared.buffer(0, dataByteCount);
            ByteBuffer bufferHeader = ByteBuffer_Shared.buffer(1, headerByteCount);
            bufferData.rewind();
            bufferHeader.rewind();
            for (int i = 0; i < this.InlineCount; ++i) {
                for (int c = 0; c < this.CrosslineCount; ++c) {
                    float[] stack = this.StackVolumn[i][c];
                    float max = 1.0E-30f;
                    for (int s = 0; s < this.SamplesPerTrace; ++s) {
                        max = Math.max(max, Math.abs(stack[s]));
                    }
                    float scalar = 30000.0f / max;
                    for (int s = 0; s < this.SamplesPerTrace; ++s) {
                        short samp = (short)(scalar * stack[s]);
                        bufferData.putShort(samp);
                    }
                    this.Scalar[i][c] = scalar;
                    bufferHeader.putFloat(this.Amplitude[i][c]);
                    bufferHeader.putFloat(this.Scalar[i][c]);
                    for (int h = 2; h < this.HeaderCount; ++h) {
                        bufferHeader.putFloat(-9999.0f);
                    }
                }
            }
            String dataFileName = this.Path + "/stack.data";
            String hdrFileName = this.Path + "/stack.hdr";
            RandomAccessFile file = new RandomAccessFile(dataFileName, "rw");
            file.write(bufferData.array(), 0, dataByteCount);
            file.close();
            file = new RandomAccessFile(hdrFileName, "rw");
            file.write(bufferHeader.array(), 0, headerByteCount);
            file.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            this.m_countGrid = project.getEmptyGrid3D();
            this.m_weightGrid = project.getEmptyGrid3D();
            this.SamplesPerTrace = (int)(0.5 + (double)((this.MaxTime - this.MinTime) / this.Digi));
            this.m_nmo.prepare(this.SamplesPerTrace, this.MinTime, this.Digi);
            this.InlineMin = this.m_countGrid.inlineMin();
            this.InlineMax = this.m_countGrid.inlineMax();
            this.InlineCount = this.InlineMax - this.InlineMin + 1;
            this.CrosslineMin = this.m_countGrid.crosslineMin();
            this.CrosslineMax = this.m_countGrid.crosslineMax();
            this.CrosslineCount = this.CrosslineMax - this.CrosslineMin + 1;
            this.StackVolumn = new float[this.InlineCount][this.CrosslineCount][this.SamplesPerTrace];
            this.Amplitude = new float[this.InlineCount][this.CrosslineCount];
            this.Scalar = new float[this.InlineCount][this.CrosslineCount];
            for (int inline = this.InlineMin; inline <= this.InlineMax; ++inline) {
                for (int crossline = this.CrosslineMin; crossline <= this.CrosslineMax; ++crossline) {
                    this.Amplitude[inline - this.InlineMin][crossline - this.CrosslineMin] = 0.0f;
                    float[] stack = this.StackVolumn[inline - this.InlineMin][crossline - this.CrosslineMin];
                    for (int s = 0; s < this.SamplesPerTrace; ++s) {
                        stack[s] = 0.0f;
                    }
                }
            }
            this.prepStatics();
            Ensemble ensemble = new Ensemble();
            boolean crap = false;
            ITraceTable traceTable = project.traceTableWrapper().traceTable();
            long traceCount = traceTable.rowCount();
            int chunkSize = 1000;
            for (long currentIndex = 0L; !this.Halt && currentIndex < traceTable.rowCount(); currentIndex += (long)chunkSize) {
                messageServer.setPercentDone(100.0 * (double)currentIndex / (double)traceTable.rowCount());
                ensemble.clearTraces(false);
                System.gc();
                System.gc();
                project.ensemble_Sequence(ensemble, currentIndex, chunkSize, true);
                this.handleEnsemble(ensemble);
            }
            if (this.Halt) {
                return false;
            }
            this.preparePaths();
            this.saveStacks();
            String countGridName = this.Path + "/count.grid3d";
            this.m_countGrid.save(countGridName);
            String weightGridName = this.Path + "/weight.grid3d";
            this.m_weightGrid.save(weightGridName);
            this.ParamFileName = this.Path + "/params.xml";
            this.Parameters.double_put("Velocity", this.Velocity);
            this.Parameters.double_put("MaxOffset", this.MaxOffset);
            this.Parameters.double_put("MinOffset", this.MinOffset);
            this.Parameters.double_put("Mute", this.Mute);
            this.Parameters.double_put("MinTime", this.MinTime);
            this.Parameters.double_put("MaxTime", this.MaxTime);
            this.Parameters.double_put("Digi", this.Digi);
            this.Parameters.int_put("Radius", this.Radius);
            this.Parameters.int_put("SamplesPerTrace", this.SamplesPerTrace);
            this.Parameters.int_put("InlineCount", this.InlineCount);
            this.Parameters.int_put("CrosslineCount", this.CrosslineCount);
            this.Parameters.int_put("HeaderCount", this.HeaderCount);
            this.Parameters.save(this.ParamFileName);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }
}

