/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Sort;

import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Data.Sort.SortEntry;
import com.PecosLibrary.Data.Sort.SortTrace;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;

public class Action_ExternalMergeSort
extends Action_Base {
    public int KeyCount = 2;
    public String KeyName1 = null;
    public String KeyName2 = null;
    protected String m_sortPath = "";
    protected String m_fileName_Data = "";
    protected String m_fileName_Dictionary = "";
    protected String m_tempPath = "";
    protected int m_maxSamplesPerTrace = 0;
    protected int m_bytesPerTrace = 0;
    protected int m_bigBufferLength;
    protected ArrayList<SortTrace> m_traceList = new ArrayList();
    protected ByteBuffer m_bigBuffer;
    protected long m_traceCount;
    protected long m_totalMergeTraces;
    protected long m_numTracesMerged = 0L;
    protected int m_targetBufferLength;
    protected int m_tracesInTargetBuffer;
    protected TargetFile m_targetFile = new TargetFile();
    protected int m_sourceBufferLength;
    protected int m_tracesInSourceBuffer;
    protected ArrayList<SourceFile> m_sourceFileList = new ArrayList();
    protected ArrayList<InternalSortFile> m_prelimList = new ArrayList();

    public Action_ExternalMergeSort(String keyName1, String keyName2) {
        try {
            this.KeyName1 = keyName1;
            if (keyName2 == null) {
                this.KeyCount = 1;
                this.KeyName2 = null;
            } else {
                this.KeyCount = 2;
                this.KeyName2 = keyName2;
            }
            this.RequiresRefractionStaticsProject = true;
            this.Description = "Sort";
            this.RequiresDelayTimeData = false;
            this.MemoryRequired = 1024;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void maxSamplesPerTrace(IProgressMonitor messageServer) throws Exception {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            ArrayList<RefractionStaticsProject.FileInfo> files = project.getFileInfoList();
            this.m_maxSamplesPerTrace = 0;
            for (RefractionStaticsProject.FileInfo file : files) {
                int samplesPerTrace = file.SeismicFile.samplesPerTrace();
                this.m_maxSamplesPerTrace = Math.max(samplesPerTrace, this.m_maxSamplesPerTrace);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void createInitialFiles(IProgressMonitor messageServer) throws Exception {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            ITraceTable traceTable = project.traceTableWrapper().traceTable();
            this.m_traceCount = traceTable.rowCount();
            Ensemble ensemble = new Ensemble();
            messageServer.setMessage_Level1("Create initial sorts....");
            int chunkSize = 1000;
            int numAddedToTraceList = 0;
            int nextFileID = 1;
            long totalSaved = 0L;
            for (long currentIndex = 0L; !this.Halt && currentIndex < traceTable.rowCount(); currentIndex += (long)chunkSize) {
                messageServer.setPercentDone(100.0 * (double)currentIndex / (double)traceTable.rowCount());
                ensemble.clearTraces(false);
                System.gc();
                System.gc();
                project.ensemble_Sequence(ensemble, currentIndex, chunkSize, true);
                int indexKey1 = ensemble.dictionary().getEntryIndex("Trace", this.KeyName1);
                int indexKey2 = -9999;
                if (this.KeyCount == 2) {
                    indexKey2 = ensemble.dictionary().getEntryIndex("Trace", this.KeyName2);
                }
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    EnsembleTrace trace = ensemble.trace(n);
                    long traceTableRow = (long)n + currentIndex;
                    int key1 = trace.header().getInt(indexKey1);
                    int key2 = 0;
                    if (indexKey2 >= 0) {
                        key2 = trace.header().getInt(indexKey2);
                    }
                    SortTrace sortTrace = this.m_traceList.get(numAddedToTraceList);
                    sortTrace.setValues(key1, key2, traceTableRow, trace.data());
                    if (++numAddedToTraceList < this.m_traceList.size()) continue;
                    totalSaved += (long)numAddedToTraceList;
                    InternalSortFile sortFile = new InternalSortFile("Initial", nextFileID, numAddedToTraceList);
                    this.m_prelimList.add(sortFile);
                    numAddedToTraceList = 0;
                    ++nextFileID;
                }
            }
            if (numAddedToTraceList > 0) {
                totalSaved += (long)numAddedToTraceList;
                InternalSortFile sortFile = new InternalSortFile("Initial", nextFileID, numAddedToTraceList);
                this.m_prelimList.add(sortFile);
                numAddedToTraceList = 0;
                ++nextFileID;
            }
            System.out.println("totalSaved = " + totalSaved);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void createTarget(ArrayList<SourceFile> sourceList, IProgressMonitor messageServer) throws Exception {
        try {
            SourceFile sourceFile;
            int totalInSource = 0;
            int totalInTarget = 0;
            for (SourceFile sourceFile2 : sourceList) {
                sourceFile2.RAF = new RandomAccessFile(sourceFile2.FileName, "rw");
                sourceFile2.FileCount = (int)(sourceFile2.RAF.length() / (long)this.m_bytesPerTrace);
                sourceFile2.RAF.close();
                sourceFile2.TraceIndex = 0;
                sourceFile2.readNextChunk();
                totalInSource += sourceFile2.FileCount;
            }
            this.m_targetFile.NumInBuffer = 0;
            this.m_targetFile.RAF = new RandomAccessFile(this.m_targetFile.FileName, "rw");
            for (int n = sourceList.size() - 1; n >= 0; --n) {
                sourceFile = sourceList.get(n);
                if (sourceFile.NumInChunk >= 1) continue;
                sourceList.remove(n);
            }
            while (sourceList.size() > 0) {
                int minIndex = -9999;
                int minKey1 = Integer.MAX_VALUE;
                int minKey2 = Integer.MAX_VALUE;
                for (int n = sourceList.size() - 1; n >= 0; --n) {
                    sourceFile = sourceList.get(n);
                    if (sourceFile.NumInChunk <= 0 || sourceFile.ChunkIndex >= sourceFile.NumInChunk) continue;
                    int off = sourceFile.ChunkIndex * this.m_bytesPerTrace;
                    int key1 = sourceFile.Buff.getInt(off + 0);
                    int key2 = sourceFile.Buff.getInt(off + 4);
                    if (key1 < minKey1) {
                        minKey1 = key1;
                        minKey2 = key2;
                        minIndex = n;
                        continue;
                    }
                    if (key1 != minKey1 || key2 >= minKey2) continue;
                    minKey2 = key2;
                    minIndex = n;
                }
                if (minIndex < 0) {
                    throw new Exception("minIndex < 0");
                }
                sourceFile = sourceList.get(minIndex);
                int sourceOff = sourceFile.ChunkIndex * this.m_bytesPerTrace;
                int targetOff = this.m_targetFile.NumInBuffer * this.m_bytesPerTrace;
                byte[] src = sourceFile.Buff.array();
                byte[] trg = this.m_targetFile.Buff.array();
                for (int b = 0; b < this.m_bytesPerTrace; ++b) {
                    trg[b + targetOff] = src[b + sourceOff];
                }
                ++this.m_targetFile.NumInBuffer;
                if (this.m_targetFile.NumInBuffer >= this.m_tracesInTargetBuffer) {
                    if (this.Halt) {
                        return;
                    }
                    totalInTarget += this.m_targetFile.NumInBuffer;
                    this.m_targetFile.RAF.write(this.m_targetFile.Buff.array(), 0, this.m_targetBufferLength);
                    this.m_numTracesMerged += (long)this.m_targetFile.NumInBuffer;
                    double percent = 100.0 * (double)this.m_numTracesMerged / (double)this.m_totalMergeTraces;
                    messageServer.setPercentDone(percent);
                    this.m_targetFile.NumInBuffer = 0;
                }
                ++sourceFile.ChunkIndex;
                for (int n = sourceList.size() - 1; n >= 0; --n) {
                    sourceFile = sourceList.get(n);
                    if (sourceFile.ChunkIndex >= sourceFile.NumInChunk) {
                        sourceFile.readNextChunk();
                    }
                    if (sourceFile.NumInChunk >= 1) continue;
                    sourceList.remove(n);
                }
            }
            if (this.m_targetFile.NumInBuffer > 0) {
                totalInTarget += this.m_targetFile.NumInBuffer;
                this.m_targetFile.RAF.write(this.m_targetFile.Buff.array(), 0, this.m_targetFile.NumInBuffer * this.m_bytesPerTrace);
                this.m_numTracesMerged += (long)this.m_targetFile.NumInBuffer;
                double percent = 100.0 * (double)this.m_numTracesMerged / (double)this.m_totalMergeTraces;
                messageServer.setPercentDone(percent);
                this.m_targetFile.NumInBuffer = 0;
            }
            this.m_targetFile.RAF.close();
            if (totalInTarget != totalInSource) {
                throw new Exception("totalInTarget != totalInSource");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected SourceFile getSourceFile(int index) throws Exception {
        try {
            while (index >= this.m_sourceFileList.size()) {
                SourceFile sourceFile = new SourceFile();
                sourceFile.Buff = ByteBuffer.allocate(this.m_sourceBufferLength);
                this.m_sourceFileList.add(sourceFile);
            }
            return this.m_sourceFileList.get(index);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void merge_OnePass(IProgressMonitor messageServer) throws Exception {
        try {
            this.m_totalMergeTraces = this.m_traceCount;
            ArrayList<SourceFile> sourceList = new ArrayList<SourceFile>();
            for (int n = 0; n < this.m_prelimList.size(); ++n) {
                SourceFile sourceFile = this.getSourceFile(n);
                sourceFile.FileName = this.m_prelimList.get((int)n).FileName;
                sourceList.add(sourceFile);
            }
            this.m_targetFile.FileName = this.m_fileName_Data;
            this.createTarget(sourceList, messageServer);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void merge_TwoPass(IProgressMonitor messageServer) throws Exception {
        try {
            int n;
            this.m_totalMergeTraces = 2L * this.m_traceCount;
            int filesPerPass = (int)Math.sqrt(this.m_prelimList.size());
            ArrayList<SourceFile> sourceList = new ArrayList<SourceFile>();
            ArrayList<String> intermediateFileNames = new ArrayList<String>();
            for (int fileIndex = 0; fileIndex < this.m_prelimList.size(); fileIndex += sourceList.size()) {
                sourceList.clear();
                for (n = 0; n < filesPerPass; ++n) {
                    int index = fileIndex + n;
                    if (index >= this.m_prelimList.size()) continue;
                    SourceFile sourceFile = this.getSourceFile(n);
                    sourceFile.FileName = this.m_prelimList.get((int)index).FileName;
                    sourceList.add(sourceFile);
                }
                this.m_targetFile.FileName = this.m_tempPath + "/Intermediate" + Integer.toString(fileIndex);
                intermediateFileNames.add(this.m_targetFile.FileName);
                this.createTarget(sourceList, messageServer);
            }
            for (n = 0; n < intermediateFileNames.size(); ++n) {
                SourceFile sourceFile = this.getSourceFile(n);
                sourceFile.FileName = (String)intermediateFileNames.get(n);
                sourceList.add(sourceFile);
            }
            this.m_targetFile.FileName = this.m_fileName_Data;
            this.createTarget(sourceList, messageServer);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void scanOutputFile(IProgressMonitor messageServer) throws Exception {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            RandomAccessFile file = new RandomAccessFile(this.m_fileName_Data, "rw");
            long len = file.length();
            long numTraces = len / (long)this.m_bytesPerTrace;
            if (this.m_traceCount != numTraces) {
                System.out.println("m_traceCount != (long)numTraces");
            }
            int numPerChunk = this.m_bigBufferLength / this.m_bytesPerTrace;
            int chunkLength = numPerChunk * this.m_bytesPerTrace;
            boolean first = true;
            SortEntry entry = null;
            int currentIndex = 0;
            HashMap_Integers<SortEntry> hash = new HashMap_Integers<SortEntry>();
            while (!this.Halt && (long)currentIndex < numTraces) {
                long numInChunkLong = numTraces - (long)currentIndex;
                if ((numInChunkLong = Math.min(numInChunkLong, (long)numPerChunk)) >= Integer.MAX_VALUE) {
                    throw new Exception("scanOutputFile(): chunk size too large!");
                }
                int numInChunk = (int)numInChunkLong;
                file.read(this.m_bigBuffer.array(), 0, numInChunk * this.m_bytesPerTrace);
                for (int n = 0; n < numInChunk; ++n) {
                    int off = n * this.m_bytesPerTrace;
                    int key1 = this.m_bigBuffer.getInt(off + 0);
                    int key2 = this.m_bigBuffer.getInt(off + 4);
                    if (first) {
                        first = false;
                        entry = new SortEntry(key1, key2);
                        entry.Count = 1;
                        entry.FilePosition = n + currentIndex;
                        hash.put(entry, key1, key2);
                        continue;
                    }
                    if (key1 != entry.Key1 || key2 != entry.Key2) {
                        if (hash.containsKey(key1, key2)) {
                            throw new Exception("hash.containsKey(key1, key2)");
                        }
                        entry = new SortEntry(key1, key2);
                        entry.Count = 1;
                        entry.FilePosition = n + currentIndex;
                        hash.put(entry, key1, key2);
                        continue;
                    }
                    ++entry.Count;
                }
                double percent = 100.0 * (double)(currentIndex += numInChunk) / (double)numTraces;
                messageServer.setPercentDone(percent);
            }
            file.close();
            ArrayList list = hash.getValues();
            RandomAccessFile dictFile = new RandomAccessFile(this.m_fileName_Dictionary, "rw");
            int version = 1000;
            dictFile.writeInt(version);
            if (version == 1000) {
                dictFile.writeInt(this.m_maxSamplesPerTrace);
                dictFile.writeInt(this.m_bytesPerTrace);
                dictFile.writeInt(list.size());
                for (SortEntry e : list) {
                    e.save(dictFile);
                }
            }
            dictFile.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            Object temp = "";
            temp = this.KeyCount == 1 ? "Sort_" + this.KeyName1 : "Sort_" + this.KeyName1 + "_" + this.KeyName2;
            this.m_sortPath = Tools_FileSystem.confirmSubDirectoryExists(project.projectPath(), (String)temp);
            this.m_tempPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_sortPath, "Temp");
            this.m_fileName_Data = this.m_sortPath + "/sort.data";
            this.m_fileName_Dictionary = this.m_sortPath + "/sort.map";
            this.maxSamplesPerTrace(messageServer);
            if (this.m_maxSamplesPerTrace < 1) {
                this.FailureReason = "No seismic data";
                this.Failed = true;
                return false;
            }
            messageServer.setMessage_Level1("Allocate internal data");
            this.m_bytesPerTrace = 40 + 2 * this.m_maxSamplesPerTrace;
            this.m_bigBufferLength = 300000000;
            int numTracesInMemory = this.m_bigBufferLength / this.m_bytesPerTrace;
            this.m_bigBufferLength = numTracesInMemory * this.m_bytesPerTrace;
            this.m_bigBuffer = ByteBuffer.allocate(this.m_bigBufferLength);
            for (int n = 0; n < numTracesInMemory; ++n) {
                this.m_traceList.add(new SortTrace(this.m_maxSamplesPerTrace));
            }
            if (!this.Halt) {
                this.createInitialFiles(messageServer);
            }
            this.m_sourceBufferLength = 100000000;
            this.m_tracesInSourceBuffer = this.m_sourceBufferLength / this.m_bytesPerTrace;
            this.m_sourceBufferLength = this.m_bytesPerTrace * this.m_tracesInSourceBuffer;
            this.m_targetBufferLength = 400000000;
            this.m_tracesInTargetBuffer = this.m_targetBufferLength / this.m_bytesPerTrace;
            this.m_targetBufferLength = this.m_bytesPerTrace * this.m_tracesInTargetBuffer;
            this.m_targetFile.Buff = ByteBuffer.allocate(this.m_targetBufferLength);
            messageServer.setMessage_Level1("Merge preliminary files");
            if (this.m_prelimList.size() <= 1) {
                String sourceFileName = this.m_prelimList.get((int)0).FileName;
                Tools_FileSystem.copyFile(sourceFileName, this.m_fileName_Data);
            } else if (this.m_prelimList.size() <= 12) {
                if (!this.Halt) {
                    this.merge_OnePass(messageServer);
                }
            } else if (!this.Halt) {
                this.merge_TwoPass(messageServer);
            }
            messageServer.setMessage_Level1("Scan file, create dictionary");
            if (!this.Halt) {
                this.scanOutputFile(messageServer);
            }
            if (this.Halt) {
                Tools_FileSystem.deletePathIfExists(this.m_sortPath);
            }
            Tools_FileSystem.deletePathIfExists(this.m_tempPath);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected class TargetFile {
        public String FileName;
        public RandomAccessFile RAF;
        public int FileCount;
        public ByteBuffer Buff;
        public int NumInBuffer;

        protected TargetFile() {
        }
    }

    protected class InternalSortFile {
        public String FileName;
        public int Count;

        public InternalSortFile(String prefix, int id, int numInList) {
            try {
                int n;
                this.Count = numInList;
                ArrayList<SortTrace> tempList = new ArrayList<SortTrace>();
                for (n = 0; n < this.Count; ++n) {
                    tempList.add(Action_ExternalMergeSort.this.m_traceList.get(n));
                }
                Collections.sort(tempList, new SortTrace.Sorter());
                for (n = 0; n < this.Count; ++n) {
                    ((SortTrace)tempList.get(n)).writeToBuffer(Action_ExternalMergeSort.this.m_bigBuffer, n * Action_ExternalMergeSort.this.m_bytesPerTrace);
                }
                this.FileName = Action_ExternalMergeSort.this.m_tempPath + "/" + prefix + Integer.toString(id);
                RandomAccessFile file = new RandomAccessFile(this.FileName, "rw");
                file.write(Action_ExternalMergeSort.this.m_bigBuffer.array(), 0, Action_ExternalMergeSort.this.m_bytesPerTrace * this.Count);
                file.close();
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    }

    protected class SourceFile {
        public String FileName;
        public RandomAccessFile RAF;
        public int FileCount;
        public ByteBuffer Buff;
        public int NumInChunk;
        public int ChunkIndex;
        public int TraceIndex;

        protected SourceFile() {
        }

        public void readNextChunk() {
            try {
                this.ChunkIndex = 0;
                this.NumInChunk = this.FileCount - this.TraceIndex;
                this.NumInChunk = Math.min(this.NumInChunk, Action_ExternalMergeSort.this.m_tracesInSourceBuffer);
                if (this.NumInChunk < 1) {
                    return;
                }
                this.RAF = new RandomAccessFile(this.FileName, "rw");
                this.RAF.seek(this.TraceIndex * Action_ExternalMergeSort.this.m_bytesPerTrace);
                this.RAF.read(this.Buff.array(), 0, this.NumInChunk * Action_ExternalMergeSort.this.m_bytesPerTrace);
                this.RAF.close();
                this.TraceIndex += this.NumInChunk;
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                this.NumInChunk = 0;
            }
        }
    }
}

