/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Refraction.DelayTime;

import com.PecosCore.Data.History;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.PolygonUsage;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.DelayTime.UpholeCorrection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.util.Hashtable;

public class Action_DelayTime_VelocityGradient
extends Action_Base {
    public boolean ComputeSmoothRadius = true;
    public int SmoothRadiusBins = 1;
    public double SmoothRadiusWorld = 1000.0;
    public float MaxPercentVariation = 30.0f;
    public boolean UseErrorCornerFromUser = false;
    public double UserErrorCorner = 200.0;
    public Hashtable<Integer, Boolean> hash_vel_apply = new Hashtable();
    public Hashtable<Integer, Double> hash_vel_min = new Hashtable();
    public Hashtable<Integer, Double> hash_vel_max = new Hashtable();

    public Action_DelayTime_VelocityGradient() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "Refractor velocity gradient analysis ";
        this.RequiresDelayTimeData = true;
        this.MemoryRequired = 512;
        this.RequiresCompleteTraceTable = false;
        this.DelayTimeDataModified = true;
        for (int b = 1; b < 10; ++b) {
            this.hash_vel_apply.put(b, false);
            this.hash_vel_min.put(b, 11.0);
            this.hash_vel_max.put(b, 111111.0);
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            TraceTable_Huge sharedTraceTable = this.DelayTimeData.SharedTraceTable;
            int iterCount = this.Hasher.int_get("IterationCount", 1);
            iterCount = Math.max(iterCount, 1);
            iterCount = Math.min(iterCount, 10);
            boolean includeAnisotropy = this.Hasher.bool_get("IncludeAnisotropy", false);
            boolean includeDip = this.Hasher.bool_get("IncludeDip", false);
            boolean allowFlipFlop = this.Hasher.bool_get("AllowFlipFlop", false);
            this.SmoothRadiusBins = (int)(this.SmoothRadiusWorld / (0.1 + this.DelayTimeData.Grid.crosslineBinSize()));
            this.SmoothRadiusBins = Math.max(this.SmoothRadiusBins, 1);
            this.SmoothRadiusBins = Math.min(this.SmoothRadiusBins, 300);
            float weightScalarMax = 20.0f;
            float weightScalarMin = 5.0f;
            float scale = (weightScalarMax - weightScalarMin) / (float)(1 - iterCount);
            float shift = weightScalarMax - scale;
            double totalRows = 1.0 * (double)iterCount * (double)sharedTraceTable.rowCount();
            double totalRowsViewed = 0.0;
            float weightScalar = 100.0f;
            float averageError = 0.0f;
            this.DelayTimeData.Receiver.clearSummationArrays(false);
            this.DelayTimeData.Shot.clearSummationArrays(false);
            for (int iteration = 1; iteration <= iterCount; ++iteration) {
                UpholeCorrection.Method method = project.getUpholeCorrectionMethod();
                this.DelayTimeData.Shot.computeUpholeCorrections(method);
                this.DelayTimeData.Shot.computeWaterBottomCorrections(project.getWaterDepthCorrectionMethod());
                this.DelayTimeData.Receiver.computeWaterBottomCorrections(project.getWaterDepthCorrectionMethod());
                messageServer.setMessage_Level1(String.format("Iteration %d of %d", iteration, iterCount));
                double numValid = 1.0E-10;
                double sumError = 0.0;
                this.DelayTimeData.Receiver.clearSummationArrays(false);
                this.DelayTimeData.Shot.clearSummationArrays(false);
                if (this.UseErrorCornerFromUser) {
                    weightScalar = (float)this.UserErrorCorner;
                }
                for (long row = 0L; row < sharedTraceTable.rowCount(); ++row) {
                    totalRowsViewed += 1.0;
                    float offset = sharedTraceTable.getFloat(row, this.DelayTimeData.IndexOffset);
                    float azimuth = sharedTraceTable.getFloat(row, this.DelayTimeData.IndexAzimuth);
                    float pick = sharedTraceTable.getFloat(row, this.DelayTimeData.IndexUserPick);
                    int branch = sharedTraceTable.getInt(row, this.DelayTimeData.IndexBranchUser);
                    int killed = sharedTraceTable.getInt(row, this.DelayTimeData.IndexKilled);
                    if (killed == 0 && branch >= 1 && branch <= this.DelayTimeData.MaxBranch && pick < 6000.0f && pick >= 1.0f) {
                        int shotRow = sharedTraceTable.getInt(row, this.DelayTimeData.IndexShotRow);
                        int recRow = sharedTraceTable.getInt(row, this.DelayTimeData.IndexRecRow);
                        float shotVel = this.DelayTimeData.Shot.getVelocity(branch, shotRow);
                        float recVel = this.DelayTimeData.Receiver.getVelocity(branch, recRow);
                        float averageVel = 0.5f * (shotVel + recVel);
                        float predictedTravelTime = 1000.0f * offset / averageVel;
                        float shotDT = this.DelayTimeData.Shot.getDelayTime(branch, shotRow, azimuth, includeAnisotropy, includeDip);
                        shotDT = Math.max(shotDT, 0.0f);
                        float recDT = this.DelayTimeData.Receiver.getDelayTime(branch, recRow, azimuth, includeAnisotropy, includeDip);
                        recDT = Math.max(recDT, 0.0f);
                        float upholeCorrection = this.DelayTimeData.Shot.UpholeCorrectionTime[shotRow][branch];
                        float shotWbCorrection = this.DelayTimeData.Shot.WaterBottomCorrectionTime[shotRow][branch];
                        float recWbCorrection = this.DelayTimeData.Receiver.WaterBottomCorrectionTime[recRow][branch];
                        pick = pick + upholeCorrection + shotWbCorrection + recWbCorrection;
                        float error = Math.abs(pick - recDT - shotDT - predictedTravelTime);
                        float weight = weightScalar / (weightScalar + error);
                        weight *= weight;
                        float pickedTravelTime = pick - shotDT - recDT;
                        if (pickedTravelTime > 20.0f) {
                            float delta = 0.001f * (predictedTravelTime - pickedTravelTime);
                            float[] fArray = this.DelayTimeData.Shot.SlopeSumV[shotRow];
                            int n = branch;
                            fArray[n] = fArray[n] + weight * delta;
                            float[] fArray2 = this.DelayTimeData.Shot.SlopeSumXV[shotRow];
                            int n2 = branch;
                            fArray2[n2] = fArray2[n2] + weight * offset * delta;
                            float[] fArray3 = this.DelayTimeData.Shot.SlopeSumXX[shotRow];
                            int n3 = branch;
                            fArray3[n3] = fArray3[n3] + weight * offset * offset;
                            float[] fArray4 = this.DelayTimeData.Shot.SlopeSumX[shotRow];
                            int n4 = branch;
                            fArray4[n4] = fArray4[n4] + weight * offset;
                            float[] fArray5 = this.DelayTimeData.Shot.SlopeSumW[shotRow];
                            int n5 = branch;
                            fArray5[n5] = fArray5[n5] + weight;
                            float[] fArray6 = this.DelayTimeData.Shot.ErrorSum[shotRow];
                            int n6 = branch;
                            fArray6[n6] = fArray6[n6] + error;
                            float[] fArray7 = this.DelayTimeData.Shot.Count[shotRow];
                            int n7 = branch;
                            fArray7[n7] = fArray7[n7] + 1.0f;
                            float[] fArray8 = this.DelayTimeData.Receiver.SlopeSumV[recRow];
                            int n8 = branch;
                            fArray8[n8] = fArray8[n8] + weight * delta;
                            float[] fArray9 = this.DelayTimeData.Receiver.SlopeSumXV[recRow];
                            int n9 = branch;
                            fArray9[n9] = fArray9[n9] + weight * offset * delta;
                            float[] fArray10 = this.DelayTimeData.Receiver.SlopeSumXX[recRow];
                            int n10 = branch;
                            fArray10[n10] = fArray10[n10] + weight * offset * offset;
                            float[] fArray11 = this.DelayTimeData.Receiver.SlopeSumX[recRow];
                            int n11 = branch;
                            fArray11[n11] = fArray11[n11] + weight * offset;
                            float[] fArray12 = this.DelayTimeData.Receiver.SlopeSumW[recRow];
                            int n12 = branch;
                            fArray12[n12] = fArray12[n12] + weight;
                            float[] fArray13 = this.DelayTimeData.Receiver.ErrorSum[recRow];
                            int n13 = branch;
                            fArray13[n13] = fArray13[n13] + error;
                            float[] fArray14 = this.DelayTimeData.Receiver.Count[recRow];
                            int n14 = branch;
                            fArray14[n14] = fArray14[n14] + 1.0f;
                        }
                        numValid += 1.0;
                        sumError += (double)error;
                    }
                    if (row % 50000L != 0L) continue;
                    String s = String.format("Trace %d of %d, average error = %f", row, sharedTraceTable.rowCount(), Float.valueOf((float)(sumError / numValid)));
                    messageServer.setMessage_Level2(s);
                    messageServer.setPercentDone(100.0 * totalRowsViewed / totalRows);
                }
                this.DelayTimeData.Shot.computeVelocityUsingLinearFit();
                this.DelayTimeData.Receiver.computeVelocityUsingLinearFit();
                for (int branch = 1; branch <= this.DelayTimeData.MaxBranch; ++branch) {
                    Grid3D grid = this.DelayTimeData.Grid;
                    grid.interp_Prep();
                    grid.interp_ZeroArrays();
                    this.DelayTimeData.Shot.updateVelocityGrid_SlopeValid(grid, branch);
                    this.DelayTimeData.Receiver.updateVelocityGrid_SlopeValid(grid, branch);
                    int radius = this.SmoothRadiusBins;
                    if (this.ComputeSmoothRadius) {
                        radius = 2 + 2 * (int)(this.DelayTimeData.BranchMaxOffset[branch] / grid.inlineBinSize());
                        radius = Math.max(4, radius);
                        radius = Math.min(40, radius);
                        grid.interp_Finish(2);
                    } else {
                        grid.interp_Finish(1);
                    }
                    if (this.hash_vel_apply.get(branch).booleanValue()) {
                        double v1 = this.hash_vel_min.get(branch);
                        double v2 = this.hash_vel_max.get(branch);
                        grid.clip((float)v1, (float)v2, PolygonUsage.NotUsed, null);
                    }
                    grid.despike(this.MaxPercentVariation);
                    System.out.println("Action_DelayTime_VelocityGradient radius = " + Integer.toString(radius));
                    grid.smooth(radius);
                    this.DelayTimeData.Shot.getVelocityFromGrid(grid, branch);
                    this.DelayTimeData.Receiver.getVelocityFromGrid(grid, branch);
                }
                averageError = (float)(sumError / numValid);
                weightScalar = 3.0f * averageError;
                weightScalar = Math.max(weightScalar, 10.0f);
                weightScalar = Math.min(weightScalar, 150.0f);
                this.DelayTimeData.Shot.ensureVelocityIncrease();
                this.DelayTimeData.Receiver.ensureVelocityIncrease();
            }
            this.DelayTimeData.Shot.Modified_Velocity = true;
            this.DelayTimeData.Receiver.Modified_Velocity = true;
            this.DelayTimeData.Shot.Modified_Count = true;
            this.DelayTimeData.Receiver.Modified_Count = true;
            this.DelayTimeData.Shot.Modified_Error = true;
            this.DelayTimeData.Receiver.Modified_Error = true;
            History hist = project.getDelayTimeData().getHistory();
            hist.addWithTime("Refractor velocity update error gradient method");
            hist.add(String.format("Average pick error = %f", Float.valueOf(averageError)));
            hist.save();
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }
}

