/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Refraction.DelayTime;

import com.PecosCore.Data.DataType;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Seismic.Segy.Segy_Dictionary;
import com.PecosCore.Seismic.Segy.Segy_Exporter;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import java.util.ArrayList;

public class Action_DelayTime_SegyModelExport
extends Action_Base {
    protected double GridSize = 100.0;
    protected double Buffer = 100.0;
    protected int NumSamples = 100;
    protected float SampleInterval = 10.0f;
    protected double RepVel = 10000.0;
    protected double MinWeathering = Double.MAX_VALUE;
    protected double MaxDatum = Double.MIN_VALUE;
    protected double SmoothRadius = 200.0;
    protected boolean ApplySmoother = true;
    protected int SmoothCount = 1;
    protected float[] UnsmoothedVelocity;
    protected float[] SmoothedVelocity;
    protected Grid3D FinalDatumGrid;
    protected float[][] FinalDatumArray;
    protected Grid3D SurfaceGrid;
    protected float[][] SurfaceArray;
    protected Grid3D WeatheringBaseGrid;
    protected float[][] WeatheringBaseArray;
    protected Grid3D WeatheringVelGrid;
    protected float[][] WeatheringVelArray;
    protected Grid3D RefractorVelGrid;
    protected float[][] RefractorVelArray;

    public Action_DelayTime_SegyModelExport() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "Export segy model";
        this.RequiresDelayTimeData = false;
        this.MemoryRequired = 512;
    }

    @Override
    protected void justReadFromNode() {
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            int b;
            Grid3D g;
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            Grid3D_Conversion project_grid = project.getGrid3D_Conversion().clone();
            Tools_RefractionStaticsProject.gridRange3D(project_grid);
            this.SampleInterval = 10.0f;
            if (!project.units_feet()) {
                this.SampleInterval = 2.5f;
            }
            int maxBranch = project.getDelayTimeData().branchAssignment().maxBranch();
            ArrayList<float[][]> list_z = new ArrayList<float[][]>();
            ArrayList<float[][]> list_v = new ArrayList<float[][]>();
            Grid3D grid_elev = g = new Grid3D(project_grid);
            Tools_RefractionStaticsProject.interpolateGrid(g, "Elevation", 2);
            list_z.add(g.data());
            for (b = 1; b <= maxBranch; ++b) {
                g = new Grid3D(project_grid);
                Tools_RefractionStaticsProject.interpolateGrid(g, Pecos.getColNameElev(b), 2);
                list_z.add(g.data());
            }
            for (b = 0; b <= maxBranch; ++b) {
                g = new Grid3D(project_grid);
                Tools_RefractionStaticsProject.interpolateGrid(g, Pecos.getColNameVel(b), 2);
                list_v.add(g.data());
            }
            float[][] surface = (float[][])list_z.get(0);
            float[][] bottom = (float[][])list_z.get(maxBranch);
            int numi = surface.length;
            int numc = surface[0].length;
            float max_z = -1.0E20f;
            float min_z = 1.0E20f;
            for (int i = 0; i < numi; ++i) {
                for (int c = 0; c < numc; ++c) {
                    if (surface[i][c] > max_z) {
                        max_z = surface[i][c];
                    }
                    if (!(bottom[i][c] < min_z)) continue;
                    min_z = bottom[i][c];
                }
            }
            int k1 = (int)((max_z += 10.0f * this.SampleInterval) / this.SampleInterval);
            max_z = (float)k1 * this.SampleInterval;
            int k2 = (int)((min_z -= 100.0f * this.SampleInterval) / this.SampleInterval);
            min_z = (float)k2 * this.SampleInterval;
            this.NumSamples = k1 - k2 + 1;
            this.UnsmoothedVelocity = new float[this.NumSamples];
            this.SmoothedVelocity = new float[this.NumSamples];
            Segy_Exporter exporter = new Segy_Exporter();
            exporter.FileName = project.projectPath() + "/DelayTimeVelocity.segy";
            exporter.OutputDigi = this.SampleInterval;
            exporter.OutputSampleCount = this.NumSamples;
            exporter.Dictionary = new Segy_Dictionary();
            exporter.Dictionary.addEntry("Trace", "CdpX", DataType.Int, DataType.Int, 200, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "CdpY", DataType.Int, DataType.Int, 204, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "Inline", DataType.Int, DataType.Int, 208, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "Crossline", DataType.Int, DataType.Int, 212, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "Elevation", DataType.Int, DataType.Int, 216, Segy_Dictionary.Modification.None, 1);
            exporter.ExtraList.add("Maximum elevation = " + max_z);
            exporter.ExtraList.add("Sample interval = " + this.SampleInterval);
            exporter.prepareFile();
            for (int i = 0; i < numi; ++i) {
                this.setPercentDone(100.0 * (double)i / (double)numi);
                Ensemble ensemble = new Ensemble();
                int indexX = ensemble.dictionary().addEntry("Trace", "CdpX", DataType.Int);
                int indexY = ensemble.dictionary().addEntry("Trace", "CdpY", DataType.Int);
                int indexI = ensemble.dictionary().addEntry("Trace", "Inline", DataType.Int);
                int indexC = ensemble.dictionary().addEntry("Trace", "Crossline", DataType.Int);
                int indexZ = ensemble.dictionary().addEntry("Trace", "Elevation", DataType.Int);
                for (int c = 0; c < numc; ++c) {
                    double x = grid_elev.getWorldX_Indices(i, c);
                    double y = grid_elev.getWorldY_Indices(i, c);
                    double v0 = ((float[][])list_v.get(0))[i][c];
                    double z0 = ((float[][])list_z.get(0))[i][c];
                    double z1 = ((float[][])list_z.get(1))[i][c];
                    double zb = ((float[][])list_z.get(maxBranch))[i][c];
                    double vb = ((float[][])list_v.get(maxBranch))[i][c];
                    for (int iz = 0; iz < this.NumSamples; ++iz) {
                        double z = max_z - (float)iz * this.SampleInterval;
                        double v = v0;
                        if (z <= zb) {
                            v = vb;
                        }
                        for (int b2 = 1; b2 <= maxBranch; ++b2) {
                            double e1 = ((float[][])list_z.get(b2 - 1))[i][c];
                            double e2 = ((float[][])list_z.get(b2))[i][c];
                            if (!(z <= e1) || !(z >= e2)) continue;
                            double v1 = ((float[][])list_v.get(b2 - 1))[i][c];
                            double v2 = ((float[][])list_v.get(b2))[i][c];
                            v = v1;
                        }
                        this.UnsmoothedVelocity[iz] = (float)v;
                    }
                    EnsembleTrace trace = ensemble.addTrace();
                    trace.header().putDouble(indexZ, z0);
                    trace.header().putInt(indexI, i);
                    trace.header().putInt(indexC, c);
                    trace.header().putDouble(indexX, x);
                    trace.header().putDouble(indexY, y);
                    trace.data().insertArray(this.UnsmoothedVelocity, this.NumSamples);
                }
                exporter.appendEnsemble(ensemble, false);
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }
}

