/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Refraction.DelayTime;

import com.PecosCore.Data.History;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeData;
import com.PecosLibrary.Refraction.DelayTime.UpholeCorrection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;

public class Action_DelayTime_GridVelocity
extends Action_Base {
    public boolean ComputeSmoothRadius = true;
    public int SmoothRadius = 1;
    public boolean ApplyRangeCompression = false;
    public double RangeCompression = 2.0;
    public boolean ApplyVelocityLimits = false;
    public double VelocityMin = 30.0;
    public double VelocityMax = 30000.0;

    public Action_DelayTime_GridVelocity() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "Gridded refractor velocity analysis";
        this.RequiresDelayTimeData = true;
        this.MemoryRequired = 512;
        this.RequiresCompleteTraceTable = false;
        this.DelayTimeDataModified = true;
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            TraceTable_Huge sharedTraceTable = this.DelayTimeData.SharedTraceTable;
            DelayTimeData dtd = project.getDelayTimeData();
            dtd.set_is_gridded_velocity(true);
            int iterCount = this.Hasher.int_get("IterationCount", 2);
            iterCount = Math.max(iterCount, 1);
            iterCount = Math.min(iterCount, 5);
            double totalRows = 1.0 * (double)iterCount * (double)sharedTraceTable.rowCount();
            double totalRowsViewed = 0.0;
            for (int iteration = 1; iteration <= iterCount; ++iteration) {
                for (int b = 1; b <= this.DelayTimeData.MaxBranch; ++b) {
                    dtd.grid_prep_velocity_update(b);
                }
                double numValid = 1.0E-10;
                double sumError = 0.0;
                UpholeCorrection.Method method = project.getUpholeCorrectionMethod();
                this.DelayTimeData.Shot.computeUpholeCorrections(method);
                this.DelayTimeData.Shot.computeWaterBottomCorrections(project.getWaterDepthCorrectionMethod());
                this.DelayTimeData.Receiver.computeWaterBottomCorrections(project.getWaterDepthCorrectionMethod());
                for (long row = 0L; row < sharedTraceTable.rowCount(); ++row) {
                    totalRowsViewed += 1.0;
                    float pick = sharedTraceTable.getFloat(row, this.DelayTimeData.IndexUserPick);
                    int branch = sharedTraceTable.getInt(row, this.DelayTimeData.IndexBranchUser);
                    int killed = sharedTraceTable.getInt(row, this.DelayTimeData.IndexKilled);
                    if (killed == 0 && branch >= 1 && branch <= this.DelayTimeData.MaxBranch && pick < 4000.0f && pick >= 0.1f) {
                        int shotRow = sharedTraceTable.getInt(row, this.DelayTimeData.IndexShotRow);
                        int recRow = sharedTraceTable.getInt(row, this.DelayTimeData.IndexRecRow);
                        double sx = this.DelayTimeData.Shot.X[shotRow];
                        double sy = this.DelayTimeData.Shot.Y[shotRow];
                        double rx = this.DelayTimeData.Receiver.X[recRow];
                        double ry = this.DelayTimeData.Receiver.Y[recRow];
                        float shotDT = this.DelayTimeData.Shot.getDelayTime(branch, shotRow, 0.0, false, false);
                        shotDT = Math.max(shotDT, 0.0f);
                        float recDT = this.DelayTimeData.Receiver.getDelayTime(branch, recRow, 0.0, false, false);
                        recDT = Math.max(recDT, 0.0f);
                        float upholeCorrection = this.DelayTimeData.Shot.UpholeCorrectionTime[shotRow][branch];
                        float shotWbCorrection = this.DelayTimeData.Shot.WaterBottomCorrectionTime[shotRow][branch];
                        float recWbCorrection = this.DelayTimeData.Receiver.WaterBottomCorrectionTime[recRow][branch];
                        pick = pick + upholeCorrection + shotWbCorrection + recWbCorrection;
                        float picked_travel_time = pick - shotDT - recDT;
                        float error = dtd.grid_velocity_update(branch, sx, sy, rx, ry, picked_travel_time, 50.0f);
                        numValid += 1.0;
                        sumError += (double)error;
                    }
                    if (row % 50000L != 0L) continue;
                    String s = String.format("Trace %d of %d, average error = %f", row, sharedTraceTable.rowCount(), Float.valueOf((float)(sumError / numValid)));
                    messageServer.setMessage_Level2(s);
                    messageServer.setPercentDone(100.0 * totalRowsViewed / totalRows);
                }
                for (int b = 1; b <= this.DelayTimeData.MaxBranch; ++b) {
                    dtd.grid_velocity_update_finish(b, 40.0f, 20.0f);
                    if (this.ApplyRangeCompression) {
                        dtd.grid(b, "Velocity").range_compression(this.RangeCompression);
                    }
                    dtd.grid_update_velocity_in_tables();
                }
            }
            History hist = project.getDelayTimeData().getHistory();
            hist.addWithTime("Grid-based refractor velocity computation  ");
            hist.save();
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }
}

