/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Refraction.DelayTime;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Action.Action_TableDataV2;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeData;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.util.ArrayList;

public class Action_DelayTime_GeometryError
extends Action_Base {
    protected ArrayList<Element> m_shotList = new ArrayList();
    protected ArrayList<Element> m_recList = new ArrayList();

    public Action_DelayTime_GeometryError() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "Geometry error prediction";
        this.RequiresDelayTimeData = true;
        this.MemoryRequired = 512;
        this.RequiresCompleteTraceTable = false;
    }

    protected boolean prepArrays() {
        try {
            Element e;
            int row;
            for (row = 0; row < this.DelayTimeData.Shot.Table.row_count(); ++row) {
                e = new Element();
                e.Row = row;
                e.SumError = new double[this.DelayTimeData.MaxBranch + 1];
                e.BranchCount = new double[this.DelayTimeData.MaxBranch + 1];
                e.X = this.DelayTimeData.Shot.X[row];
                e.Y = this.DelayTimeData.Shot.Y[row];
                e.CurrentX = e.X;
                e.CurrentY = e.Y;
                this.m_shotList.add(e);
            }
            for (row = 0; row < this.DelayTimeData.Receiver.Table.row_count(); ++row) {
                e = new Element();
                e.Row = row;
                e.SumError = new double[this.DelayTimeData.MaxBranch + 1];
                e.BranchCount = new double[this.DelayTimeData.MaxBranch + 1];
                e.X = this.DelayTimeData.Receiver.X[row];
                e.Y = this.DelayTimeData.Receiver.Y[row];
                e.CurrentX = e.X;
                e.CurrentY = e.Y;
                this.m_recList.add(e);
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            TraceTable_Huge sharedTraceTable = this.DelayTimeData.SharedTraceTable;
            DelayTimeData dtd = project.getDelayTimeData();
            boolean includeAnisotropy = this.Hasher.bool_get("IncludeAnisotropy", false);
            boolean includeDip = this.Hasher.bool_get("IncludeDip", false);
            this.prepArrays();
            int numIter = 5;
            double totalRows = (double)numIter * (double)sharedTraceTable.rowCount();
            long numScanned = 0L;
            for (int iter = 0; iter < numIter; ++iter) {
                for (Element e : this.m_recList) {
                    e.resetCount();
                }
                for (Element e : this.m_shotList) {
                    e.resetCount();
                }
                int numBigErrors = 0;
                for (long row = 0L; row < sharedTraceTable.rowCount(); ++row) {
                    float pick = sharedTraceTable.getFloat(row, this.DelayTimeData.IndexUserPick);
                    int branch = sharedTraceTable.getInt(row, this.DelayTimeData.IndexBranchUser);
                    if (branch >= 1 && branch <= this.DelayTimeData.MaxBranch && pick >= 5.1f && pick < 6000.0f) {
                        int shotRow = sharedTraceTable.getInt(row, this.DelayTimeData.IndexShotRow);
                        int recRow = sharedTraceTable.getInt(row, this.DelayTimeData.IndexRecRow);
                        Element shotElem = this.m_shotList.get(shotRow);
                        Element recElem = this.m_recList.get(recRow);
                        double sx = shotElem.CurrentX;
                        double sy = shotElem.CurrentY;
                        double rx = recElem.CurrentX;
                        double ry = recElem.CurrentY;
                        double dx = rx - sx;
                        double dy = ry - sy;
                        double offset = Math.sqrt(1.0E-10 + dx * dx + dy * dy);
                        double azimuth = Math.atan2(dy, dx);
                        float shotVel = this.DelayTimeData.Shot.getVelocity(branch, shotRow);
                        float recVel = this.DelayTimeData.Receiver.getVelocity(branch, recRow);
                        float averageVel = 0.5f * (shotVel + recVel);
                        float travelTime = 1000.0f * (float)offset / averageVel;
                        if (this.UseGriddedVelocity) {
                            travelTime = dtd.grid_time_noanisotropy(branch, sx, sy, rx, ry);
                        }
                        float shotDT = this.DelayTimeData.Shot.getDelayTime(branch, shotRow, azimuth, includeAnisotropy, includeDip);
                        shotDT = Math.max(shotDT, 0.0f);
                        float recDT = this.DelayTimeData.Receiver.getDelayTime(branch, recRow, azimuth, includeAnisotropy, includeDip);
                        float upholeCorrection = this.DelayTimeData.Shot.UpholeCorrectionTime[shotRow][branch];
                        float error = (pick += upholeCorrection) - (recDT = Math.max(recDT, 0.0f)) - shotDT - travelTime;
                        if (error > 20.0f) {
                            ++shotElem.BadPickCount;
                            ++recElem.BadPickCount;
                        }
                        if (Math.abs(error) < 3000.0f) {
                            int n = branch;
                            shotElem.SumError[n] = shotElem.SumError[n] + (double)Math.abs(error);
                            int n2 = branch;
                            shotElem.BranchCount[n2] = shotElem.BranchCount[n2] + 1.0;
                            int n3 = branch;
                            recElem.SumError[n3] = recElem.SumError[n3] + (double)Math.abs(error);
                            int n4 = branch;
                            recElem.BranchCount[n4] = recElem.BranchCount[n4] + 1.0;
                            double shotDist = 0.001 * (double)error * (double)shotVel;
                            shotElem.SumX -= shotDist * Math.cos(azimuth);
                            shotElem.SumY -= shotDist * Math.sin(azimuth);
                            shotElem.Count += 1.0;
                            double recDist = 0.001 * (double)error * (double)recVel;
                            recElem.SumX += recDist * Math.cos(azimuth);
                            recElem.SumY += recDist * Math.sin(azimuth);
                            recElem.Count += 1.0;
                        } else {
                            ++numBigErrors;
                        }
                    }
                    if (++numScanned % 50000L != 0L) continue;
                    messageServer.setPercentDone(100.0 * (double)numScanned / totalRows);
                }
                for (Element e : this.m_shotList) {
                    e.updateCurrent();
                }
                for (Element e : this.m_recList) {
                    e.updateCurrent();
                }
                System.out.println("numBigErrors = " + numBigErrors);
            }
            messageServer.setPercentDone(0.0);
            int numBad = 0;
            for (Element e : this.m_shotList) {
                numBad += e.computeErrors(this.DelayTimeData.Shot);
            }
            project.geometryDatabase().writeColumnContentsToDatabase(this.DelayTimeData.Shot.Table, "GeomErr_Dist");
            project.geometryDatabase().writeColumnContentsToDatabase(this.DelayTimeData.Shot.Table, "GeomErr_Az");
            project.geometryDatabase().writeColumnContentsToDatabase(this.DelayTimeData.Shot.Table, "DTA_BadPickCount");
            for (Element e : this.m_recList) {
                numBad += e.computeErrors(this.DelayTimeData.Receiver);
            }
            project.geometryDatabase().writeColumnContentsToDatabase(this.DelayTimeData.Receiver.Table, "GeomErr_Dist");
            project.geometryDatabase().writeColumnContentsToDatabase(this.DelayTimeData.Receiver.Table, "GeomErr_Az");
            project.geometryDatabase().writeColumnContentsToDatabase(this.DelayTimeData.Receiver.Table, "DTA_BadPickCount");
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected class Element {
        public int Row;
        public double X;
        public double Y;
        public double CurrentX;
        public double CurrentY;
        public boolean BadUpdate;
        public boolean BadErrorUpdate = false;
        public double SumX = 0.0;
        public double SumY = 0.0;
        public double Count = 1.0E-10;
        public double[] SumError;
        public double[] BranchCount;
        public int BadPickCount = 0;

        protected Element() {
        }

        public int computeErrors(Action_TableDataV2 table) {
            try {
                boolean bad;
                this.BadErrorUpdate = false;
                int indexDist = table.Table.column_append("GeomErr_Dist", DataType.Float);
                int indexAz = table.Table.column_append("GeomErr_Az", DataType.Float);
                int indexBadPickCount = table.Table.column_append("DTA_BadPickCount", DataType.Int);
                double dx = this.CurrentX - this.X;
                double dy = this.CurrentY - this.Y;
                double dist = Math.sqrt(dx * dx + dy * dy + 1.0E-20);
                double az = 0.0;
                if (dist > 1.0) {
                    az = Math.atan2(dy, dx);
                }
                table.Table.putInt(this.Row, indexBadPickCount, this.BadPickCount);
                table.Table.putDouble(this.Row, indexDist, 0.0);
                table.Table.putDouble(this.Row, indexAz, 0.0);
                for (int b = 1; b <= Action_DelayTime_GeometryError.this.DelayTimeData.MaxBranch; ++b) {
                    table.Table.putDouble(this.Row, table.IndexError[b], 0.0);
                    table.Table.putDouble(this.Row, table.IndexCount[b], (int)this.BranchCount[b]);
                }
                boolean bl = bad = Double.isInfinite(dist) || Double.isNaN(dist) || Double.isInfinite(dx) || Double.isNaN(dx) || Double.isInfinite(dy) || Double.isNaN(dy);
                if (!bad) {
                    table.Table.putDouble(this.Row, indexDist, dist);
                    table.Table.putDouble(this.Row, indexAz, az);
                    for (int b = 1; b <= Action_DelayTime_GeometryError.this.DelayTimeData.MaxBranch; ++b) {
                        table.Table.putDouble(this.Row, table.IndexError[b], 0.0);
                        table.Table.putDouble(this.Row, table.IndexCount[b], 0.0);
                        boolean bl2 = bad = Double.isInfinite(this.SumError[b]) || Double.isNaN(this.SumError[b]) || Double.isInfinite(this.BranchCount[b]) || Double.isNaN(this.BranchCount[b]);
                        if (bad) continue;
                        double error = this.SumError[b] / this.BranchCount[b];
                        if (error >= 0.0 && error < 10000.0) {
                            table.Table.putDouble(this.Row, table.IndexError[b], error);
                            table.Table.putDouble(this.Row, table.IndexCount[b], (int)this.BranchCount[b]);
                            continue;
                        }
                        this.BadErrorUpdate = true;
                    }
                    return 0;
                }
                this.BadErrorUpdate = true;
                return 1;
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return 1;
            }
        }

        public void resetCount() {
            try {
                this.BadPickCount = 0;
                this.SumX = 0.0;
                this.SumY = 0.0;
                this.Count = 1.0E-10;
                for (int b = 0; b < this.SumError.length; ++b) {
                    this.SumError[b] = 0.0;
                    this.BranchCount[b] = 1.0E-10;
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public void updateCurrent() {
            try {
                if (this.Count > 4.5) {
                    double dx = this.SumX / this.Count;
                    double dy = this.SumY / this.Count;
                    boolean bl = this.BadUpdate = Double.isInfinite(dy) || Double.isNaN(dy) || Double.isInfinite(dx) || Double.isNaN(dx);
                    if (!this.BadUpdate) {
                        dx = Math.max(dx, -1000.0);
                        dx = Math.min(dx, 1000.0);
                        dy = Math.max(dy, -1000.0);
                        dy = Math.min(dy, 1000.0);
                        this.CurrentX += 0.5 * dx;
                        this.CurrentY += 0.5 * dy;
                    } else {
                        this.CurrentX = this.X;
                        this.CurrentY = this.Y;
                    }
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    }
}

