/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.QC;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Ensemble.Worker.QC.EnsembleWorker_NoiseTrace;
import com.PecosLibrary.Refraction.RefractionStaticsProject;

public class Action_NoiseComputation
extends Action_Base {
    public boolean KillDC = false;
    public double MaxDC = 150.0;

    public Action_NoiseComputation() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "Compute noise levels";
        this.RequiresDelayTimeData = false;
        this.MemoryRequired = 512;
    }

    @Override
    protected void justReadFromNode() {
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            int id;
            int row;
            Element elem;
            HashMap_Integers<Element> shotHash = new HashMap_Integers<Element>();
            HashMap_Integers<Element> recHash = new HashMap_Integers<Element>();
            EnsembleWorker_NoiseTrace worker = new EnsembleWorker_NoiseTrace();
            float noiseWindow = (float)this.Hasher.double_get("Window", 100.0);
            noiseWindow = Math.max(40.0f, noiseWindow);
            noiseWindow = Math.min(2000.0f, noiseWindow);
            float killThreshold = (float)this.Hasher.double_get("Threshold", 5.0);
            killThreshold = Math.max(1.0f, killThreshold);
            killThreshold = Math.min(50.0f, killThreshold);
            boolean killNoisy = this.Hasher.bool_get("Kill", false);
            worker.setWindow(noiseWindow);
            worker.setCutoff(killThreshold);
            worker.setKill(killNoisy);
            worker.setKillDC(false);
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            ITraceTable traceTable = project.traceTableWrapper().traceTable();
            long numTraces = traceTable.rowCount();
            killNoisy = killNoisy && traceTable.column_exists("Killed");
            this.KillDC = this.KillDC && traceTable.column_exists("Killed");
            int colTraceKilled = -9999;
            if (traceTable.column_exists("Killed")) {
                colTraceKilled = traceTable.column_indexOfColumn("Killed");
            }
            Ensemble ensemble = new Ensemble();
            long numBiased = 0L;
            Tools_Ensemble tools = new Tools_Ensemble();
            for (long currentIndex = 0L; !this.Halt && currentIndex < numTraces; currentIndex += 1000L) {
                this.PercentDone = 100.0 * (double)currentIndex / (double)numTraces;
                messageServer.setPercentDone(this.PercentDone);
                messageServer.setMessage_Level1(String.format("Trace %d of %d", currentIndex, numTraces));
                project.ensemble_Sequence(ensemble, currentIndex, 1000, true);
                worker.performWork(ensemble);
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    EnsembleTrace trace = ensemble.trace(n);
                    trace.DC_Biased = false;
                }
                int indexShotID = ensemble.dictionary().getEntryIndex("Trace", "ShotID");
                int indexRecID = ensemble.dictionary().getEntryIndex("Trace", "ReceiverID");
                int indexNoise = ensemble.dictionary().getEntryIndex("Trace", "NoiseLevel");
                int indexTraceIndex = ensemble.dictionary().getEntryIndex("Trace", "TraceIndex");
                if (this.KillDC) {
                    tools.computeDCBias(ensemble, true, this.MaxDC);
                }
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    EnsembleTrace trace = ensemble.trace(n);
                    double noise = trace.header().getDouble(indexNoise);
                    int shotID = trace.header().getInt(indexShotID);
                    int recID = trace.header().getInt(indexRecID);
                    if (!shotHash.containsKey(shotID)) {
                        shotHash.put(new Element(shotID), shotID);
                    }
                    elem = (Element)shotHash.get(shotID);
                    ++elem.Count;
                    elem.Sum += noise;
                    if (!recHash.containsKey(recID)) {
                        recHash.put(new Element(recID), recID);
                    }
                    elem = (Element)recHash.get(recID);
                    ++elem.Count;
                    elem.Sum += noise;
                    int killed = 0;
                    if (killNoisy && trace.TooNoisy) {
                        killed = 1;
                    }
                    if (this.KillDC && trace.DC_Biased) {
                        killed = 1;
                        ++numBiased;
                    }
                    long tableIndex = trace.header().getInt(indexTraceIndex);
                    traceTable.putInt(tableIndex, colTraceKilled, killed);
                }
            }
            traceTable.saveCurrentSection();
            if (this.Halt) {
                return true;
            }
            System.out.println("Num DC killed = " + numBiased);
            Table_Abstract table = project.receiverTable();
            int colIndex = table.column_append("NoiseLevel", DataType.Double);
            int colID = table.column_indexOfColumn("ReceiverID");
            for (row = 0; row < table.row_count(); ++row) {
                id = table.getInt(row, colID);
                float noise = 0.0f;
                if (recHash.containsKey(id)) {
                    elem = (Element)recHash.get(id);
                    if (elem.Count >= 1) {
                        noise = (float)elem.Sum / (float)elem.Count;
                    }
                }
                table.putFloat(row, colIndex, noise);
            }
            project.geometryDatabase().confirmColumn("Receiver", "NoiseLevel", DataType.Double);
            project.geometryDatabase().writeColumnContentsToDatabase(table, "NoiseLevel");
            table = project.shotTable();
            colIndex = table.column_append("NoiseLevel", DataType.Double);
            colID = table.column_indexOfColumn("ShotID");
            for (row = 0; row < table.row_count(); ++row) {
                id = table.getInt(row, colID);
                float noise = 0.0f;
                if (shotHash.containsKey(id)) {
                    elem = (Element)shotHash.get(id);
                    if (elem.Count >= 1) {
                        noise = (float)elem.Sum / (float)elem.Count;
                    }
                }
                table.putFloat(row, colIndex, noise);
            }
            project.geometryDatabase().confirmColumn("Shot", "NoiseLevel", DataType.Double);
            project.geometryDatabase().writeColumnContentsToDatabase(table, "NoiseLevel");
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected class Element {
        public int Row;
        public int ID;
        public double Sum = 0.0;
        public int Count = 0;

        public Element(int id) {
            this.ID = id;
        }
    }
}

