/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Import;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge_Wrapper;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.JDBC.Tools_JDBC;
import com.PecosLibrary.Refraction.DelayTime.BranchAssignment;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.table.AbstractTableModel;

public class Action_MergeProjects
extends Action_Base {
    public MergedProjectList ProjectList;
    protected String m_parentPath = "";
    protected String m_projectName = "";
    protected String m_projectPath = "";
    protected String m_traceTablePath = "";
    protected String m_units = "";
    protected String m_dimension = "";
    protected boolean m_hasSeismic = true;
    protected int m_nextMergeID = 1000;
    protected int m_nextShotID = 1000;
    protected int m_nextRecID = 1000;
    protected int m_nextFileID = 1000;
    protected boolean m_mergeTraceTable = false;
    protected boolean m_hasData = true;
    protected Grid3D_Conversion m_grid3D = new Grid3D_Conversion();
    protected Table_Abstract m_shotTable = new Table_Memory();
    protected HashMap_Integers<Integer> m_shotMapLPI = new HashMap_Integers();
    protected HashMap_Integer m_shotMapID = new HashMap_Integer();
    protected Table_Abstract m_receiverTable = new Table_Memory();
    protected HashMap_Integers<Integer> m_receiverMapLPI = new HashMap_Integers();
    protected HashMap_Integer m_receiverMapID = new HashMap_Integer();
    protected Table_Abstract m_fileTable = new Table_Memory();
    protected int m_fileIndex_FileID;
    protected int m_fileIndex_Name;
    protected int m_fileIndex_Path;
    protected Table_Abstract m_traceTable = new Table_Memory();
    protected long m_traceCount = 0L;
    protected TraceTable_Huge m_diskTable;
    protected int m_indexTraceTableProjectID;
    protected Table_Abstract m_projectTable = new Table_Memory();
    protected int m_indexProjectID;
    protected int m_indexProjectName;
    protected int m_indexProjectIncFFID;
    protected int m_indexProjectIncRecLine;
    protected int m_indexProjectIncRecPoint;
    protected int m_indexProjectIncShotLine;
    protected int m_indexProjectIncShotPoint;
    protected int m_currentProjectID = 999;
    protected int m_idIncrementTracker = 1000;
    protected ArrayList<Integer> m_projectIDList = new ArrayList();
    protected int m_currentShotID;
    protected double m_currentShotX;
    protected double m_currentShotY;
    protected int m_fileID = 999;
    protected int m_traceID = 999;
    protected BranchAssignment m_branchAssignment = null;

    public Action_MergeProjects() {
        this.Description = "Merge existing projects";
        this.MemoryRequired = 1024;
    }

    @Override
    protected void justReadFromNode() {
    }

    protected boolean prepareTraceTable() {
        try {
            this.m_shotTable.setName("Shot");
            this.m_receiverTable.setName("Receiver");
            this.m_fileTable.setName("FileList");
            this.m_indexTraceTableProjectID = this.m_traceTable.column_append("ProjectID", DataType.Int);
            this.m_traceTable.column_append("IndexInFile", DataType.Long);
            this.m_traceTable.column_append("Flags", DataType.Int);
            this.m_traceTable.column_append("FBP_Back1", DataType.Float);
            this.m_traceTable.column_append("FBP_Back2", DataType.Float);
            this.m_traceTable.column_append("FBP_Back3", DataType.Float);
            this.m_traceTable.column_append("FBP_TAP", DataType.Float);
            this.m_traceTable.column_append("FBP_AMP", DataType.Float);
            this.m_traceTable.column_append("FBP_PickT", DataType.Float);
            for (Entry e : this.ProjectList.ProjectList) {
                String projectName = e.ProjectName;
                String projectPath = SharedApplicationData.staticsProjectPath() + "/" + projectName;
                if (!Tools_FileSystem.exists_path(projectPath)) {
                    projectPath = projectPath + ".xtref";
                }
                String path = projectPath + "/TraceTable";
                TraceTable_Huge table = new TraceTable_Huge(path, "Trace");
                for (int n = 0; n < table.column_count(); ++n) {
                    String colName = table.column_name(n);
                    DataType dt = table.column_type(n);
                    if (this.m_traceTable.column_exists(colName)) continue;
                    this.m_traceTable.column_append(colName, dt);
                }
            }
            this.m_traceTablePath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "TraceTable");
            this.m_diskTable = new TraceTable_Huge(this.m_traceTablePath, "Trace", this.m_traceTable, 8);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected boolean checkProjects() {
        try {
            if (this.ProjectList.ProjectList.size() < 1) {
                this.FailureReason = "No projects specified";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkParentPath() {
        try {
            if (!this.Hasher.string_exists("ParentPath")) {
                this.FailureReason = "Parent path not specified";
                this.Failed = true;
                return false;
            }
            this.m_parentPath = this.Hasher.string_get("ParentPath");
            if (!Tools_FileSystem.exists_path(this.m_parentPath)) {
                this.FailureReason = "Parent path not valid";
                this.Failed = true;
                return false;
            }
            String projectPath = this.m_parentPath + "/" + this.m_projectName;
            this.m_projectPath = this.m_parentPath + "/" + this.m_projectName + ".xtref";
            if (Tools_FileSystem.exists_path(projectPath)) {
                this.FailureReason = "Project path already exists";
                this.Failed = true;
                return false;
            }
            if (Tools_FileSystem.exists_path(this.m_projectPath)) {
                this.FailureReason = "Project path already exists";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkName() {
        try {
            if (!this.Hasher.string_exists("ProjectName")) {
                this.FailureReason = "ProjectName not specified";
                this.Failed = true;
                return false;
            }
            this.m_projectName = this.Hasher.string_get("ProjectName");
            if (this.m_projectName.length() <= 1) {
                this.FailureReason = "m_projectName name not valid";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected int[] tableConn(Table_Abstract projectTable, Table_Abstract mergeTable, HashMap_Integers<Integer> mergeMapLPI, HashMap_Integer mergeMapID, int lineIncrement, int pointIncrement, int ffidIncrement) {
        try {
            String tableName = projectTable.name();
            int[] columnIndex = new int[projectTable.column_count()];
            DataType[] columnType = new DataType[projectTable.column_count()];
            for (int col = 0; col < projectTable.column_count(); ++col) {
                boolean connectOK = true;
                String colName = projectTable.column_name(col);
                if (colName.toUpperCase().startsWith("STATICS_".toUpperCase())) {
                    connectOK = false;
                }
                if (colName.toUpperCase().startsWith("DatumInt_".toUpperCase())) {
                    connectOK = false;
                }
                if (colName.toUpperCase().startsWith("DatumFinal_".toUpperCase())) {
                    connectOK = false;
                }
                if (!connectOK) continue;
                columnType[col] = projectTable.column_type(col);
                columnIndex[col] = mergeTable.column_append(colName, columnType[col]);
            }
            int[] connector = new int[projectTable.row_count()];
            int indexProjectElementID = projectTable.column_indexOfColumn(tableName + "ID");
            int indexProjectLine = projectTable.column_indexOfColumn("LineNumber");
            int indexProjectPoint = projectTable.column_indexOfColumn("PointNumber");
            int indexProjectIndex = projectTable.column_indexOfColumn("PointIndex");
            int indexProjectFFID = -9999;
            if (ffidIncrement != 0 && projectTable.column_exists("FFID")) {
                indexProjectFFID = projectTable.column_indexOfColumn("FFID");
            }
            int indexMergeProjectID = mergeTable.column_append("ProjectID", DataType.Int);
            int indexMergeElementID = mergeTable.column_append(tableName + "ID", DataType.Int);
            int indexMergeLine = mergeTable.column_append("LineNumber", DataType.Int);
            int indexMergePoint = mergeTable.column_append("PointNumber", DataType.Int);
            int indexMergeIndex = mergeTable.column_append("PointIndex", DataType.Int);
            int indexMergeFFID = -9999;
            if (indexProjectFFID >= 0) {
                indexMergeFFID = mergeTable.column_append("FFID", DataType.Int);
            }
            for (int projectRow = 0; projectRow < projectTable.row_count(); ++projectRow) {
                int mergeID;
                int projectElementID = projectTable.getInt(projectRow, indexProjectElementID);
                int projectLine = projectTable.getInt(projectRow, indexProjectLine) + lineIncrement;
                int projectPoint = projectTable.getInt(projectRow, indexProjectPoint) + pointIncrement;
                int projectIndex = projectTable.getInt(projectRow, indexProjectIndex);
                int projectFFID = -9999;
                if (indexProjectFFID >= 0) {
                    projectFFID = projectTable.getInt(projectRow, indexProjectFFID) + ffidIncrement;
                }
                if (!mergeMapLPI.containsKey(projectLine, projectPoint, projectIndex)) {
                    int mergeRow = mergeTable.row_increment();
                    mergeTable.putInt(mergeRow, indexMergeProjectID, this.m_currentProjectID);
                    for (int col = 0; col < projectTable.column_count(); ++col) {
                        boolean connectOK = true;
                        String colName = projectTable.column_name(col);
                        if (colName.toUpperCase().startsWith("STATICS_".toUpperCase())) {
                            connectOK = false;
                        }
                        if (colName.toUpperCase().startsWith("DatumInt_".toUpperCase())) {
                            connectOK = false;
                        }
                        if (colName.toUpperCase().startsWith("DatumFinal_".toUpperCase())) {
                            connectOK = false;
                        }
                        if (!connectOK) continue;
                        if (columnType[col] == DataType.Bool) {
                            mergeTable.putBool(mergeRow, columnIndex[col], projectTable.getBool(projectRow, col));
                            continue;
                        }
                        if (columnType[col] == DataType.Double) {
                            mergeTable.putDouble(mergeRow, columnIndex[col], projectTable.getDouble(projectRow, col));
                            continue;
                        }
                        if (columnType[col] == DataType.Float) {
                            mergeTable.putFloat(mergeRow, columnIndex[col], projectTable.getFloat(projectRow, col));
                            continue;
                        }
                        if (columnType[col] == DataType.Long) {
                            mergeTable.putLong(mergeRow, columnIndex[col], projectTable.getLong(projectRow, col));
                            continue;
                        }
                        mergeTable.putInt(mergeRow, columnIndex[col], projectTable.getInt(projectRow, col));
                    }
                    mergeTable.putInt(mergeRow, indexMergeLine, projectLine);
                    mergeTable.putInt(mergeRow, indexMergePoint, projectPoint);
                    if (indexMergeFFID >= 0) {
                        mergeTable.putInt(mergeRow, indexMergeFFID, projectFFID);
                    }
                    mergeTable.putInt(mergeRow, indexMergeElementID, this.m_nextMergeID);
                    mergeMapLPI.put(new Integer(this.m_nextMergeID), projectLine, projectPoint, projectIndex);
                    mergeMapID.put(this.m_nextMergeID, mergeRow);
                    connector[projectRow] = this.m_nextMergeID++;
                    continue;
                }
                connector[projectRow] = mergeID = mergeMapLPI.get(projectLine, projectPoint, projectIndex).intValue();
            }
            return connector;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected void addProject(Entry entry) {
        try {
            ++this.m_currentProjectID;
            int projectTableRow = this.m_projectTable.row_increment();
            this.m_projectTable.putInt(projectTableRow, this.m_indexProjectID, this.m_currentProjectID);
            this.m_projectTable.putString(projectTableRow, this.m_indexProjectName, entry.ProjectName);
            this.m_projectTable.putInt(projectTableRow, this.m_indexProjectIncFFID, entry.FFIDIncrement);
            this.m_projectTable.putInt(projectTableRow, this.m_indexProjectIncRecLine, entry.RecLineIncrement);
            this.m_projectTable.putInt(projectTableRow, this.m_indexProjectIncRecPoint, entry.RecPointIncrement);
            this.m_projectTable.putInt(projectTableRow, this.m_indexProjectIncShotLine, entry.ShotLineIncrement);
            this.m_projectTable.putInt(projectTableRow, this.m_indexProjectIncShotPoint, entry.ShotPointIncrement);
            RefractionStaticsProject project = new RefractionStaticsProject(entry.ProjectName);
            if (this.m_branchAssignment == null) {
                dtd = project.getDelayTimeData();
                this.m_branchAssignment = dtd.branchAssignment();
            } else {
                dtd = project.getDelayTimeData();
                this.m_branchAssignment.mergeOtherLocationList(dtd.branchAssignment().LocationList);
            }
            this.m_units = project.units_feet() ? "Feet" : "Meters";
            this.m_dimension = "3D";
            this.m_hasSeismic = this.m_hasSeismic && project.hasSeismic();
            ITraceTable projectTraceTable = project.traceTableWrapper().traceTable();
            this.m_hasData = true;
            HashMap_Integer fileMap = new HashMap_Integer();
            ArrayList<RefractionStaticsProject.FileInfo> projectFileList = project.getFileInfoList();
            if (projectFileList == null || projectFileList.size() < 1) {
                this.m_hasData = false;
            }
            for (RefractionStaticsProject.FileInfo fileInfo : projectFileList) {
                int fileRow = this.m_fileTable.row_increment();
                this.m_fileTable.putString(fileRow, this.m_fileIndex_Name, fileInfo.Name);
                this.m_fileTable.putString(fileRow, this.m_fileIndex_Path, fileInfo.Path);
                this.m_fileTable.putInt(fileRow, this.m_fileIndex_FileID, this.m_nextFileID);
                fileMap.put(fileInfo.FileID, this.m_nextFileID);
                ++this.m_nextFileID;
            }
            HashMap_Integer tempidmap = new HashMap_Integer();
            if (project.isOrigin("MERGE")) {
                project.prepMergeProjectTable();
                Table_Abstract projTable = project.mergeProjectTable();
                int indexID = projTable.column_indexOfColumn("ProjectID");
                for (int n = 0; n < projTable.row_count(); ++n) {
                    int projID;
                    int newID = projID = projTable.getInt(n, indexID);
                    while (this.m_projectIDList.contains(newID)) {
                        ++newID;
                    }
                    this.m_projectIDList.add(newID);
                    tempidmap.put(projID, newID);
                }
            } else {
                while (this.m_projectIDList.contains(this.m_idIncrementTracker)) {
                    ++this.m_idIncrementTracker;
                }
                this.m_projectIDList.add(this.m_idIncrementTracker);
            }
            Table_Abstract shotTable = project.shotTable();
            HashMap_Integer shotMap = project.shotMap();
            this.m_nextMergeID = this.m_nextShotID;
            int[] connShot = this.tableConn(shotTable, this.m_shotTable, this.m_shotMapLPI, this.m_shotMapID, entry.ShotLineIncrement, entry.ShotPointIncrement, entry.FFIDIncrement);
            this.m_nextShotID = this.m_nextMergeID;
            Table_Abstract recTable = project.receiverTable();
            HashMap_Integer recMap = project.receiverMap();
            this.m_nextMergeID = this.m_nextRecID;
            int[] connRec = this.tableConn(recTable, this.m_receiverTable, this.m_receiverMapLPI, this.m_receiverMapID, entry.RecLineIncrement, entry.RecPointIncrement, -9999);
            this.m_nextRecID = this.m_nextMergeID;
            int[] connTableIndex = new int[200];
            DataType[] connTableType = new DataType[200];
            for (int n = 0; n < projectTraceTable.column_count(); ++n) {
                String colName = projectTraceTable.column_name(n);
                connTableIndex[n] = this.m_traceTable.column_indexOfColumn(colName);
                connTableType[n] = this.m_traceTable.column_type(connTableIndex[n]);
                if (!colName.equalsIgnoreCase("Inline") || connTableType[n] == DataType.Int) continue;
                System.out.println("ERROR connTableType[n] != DataType.Int");
            }
            int indexShotID = this.m_traceTable.column_indexOfColumn("ShotID");
            int indexRecID = this.m_traceTable.column_indexOfColumn("ReceiverID");
            int indexFileID = this.m_traceTable.column_indexOfColumn("FileID");
            int indexProjectID = this.m_traceTable.column_indexOfColumn("ProjectID");
            int indexFlags = this.m_traceTable.column_indexOfColumn("Flags");
            if (!this.m_mergeTraceTable) {
                return;
            }
            int numPerChunks = 5000;
            long currentRow = 0L;
            while (currentRow < projectTraceTable.rowCount()) {
                this.m_traceTable.row_clear(false);
                long maxRowIndex = currentRow + (long)numPerChunks - 1L;
                maxRowIndex = Math.min(maxRowIndex, projectTraceTable.rowCount() - 1L);
                while (currentRow <= maxRowIndex) {
                    int oldprojid;
                    int row = this.m_traceTable.row_increment();
                    this.m_traceTable.row_clearRowValues(row);
                    this.m_traceTable.putInt(row, indexFlags, 0);
                    for (int col = 0; col < projectTraceTable.column_count(); ++col) {
                        int colIndex = connTableIndex[col];
                        if (connTableType[col] == DataType.Float) {
                            float v = projectTraceTable.getFloat(currentRow, col);
                            this.m_traceTable.putFloat(row, colIndex, v);
                            continue;
                        }
                        if (connTableType[col] == DataType.Double) {
                            double v = projectTraceTable.getFloat(currentRow, col);
                            this.m_traceTable.putDouble(row, colIndex, v);
                            continue;
                        }
                        if (connTableType[col] == DataType.Long) {
                            long v = projectTraceTable.getLong(currentRow, col);
                            this.m_traceTable.putLong(row, colIndex, v);
                            continue;
                        }
                        int v = projectTraceTable.getInt(currentRow, col);
                        this.m_traceTable.putInt(row, colIndex, v);
                    }
                    int projid = project.isOrigin("MERGE") ? (tempidmap.containsKey(oldprojid = this.m_traceTable.getInt(row, indexProjectID)) ? tempidmap.get(oldprojid) : oldprojid) : this.m_idIncrementTracker;
                    this.m_traceTable.putInt(row, indexProjectID, projid);
                    int projectFileID = this.m_traceTable.getInt(row, indexFileID);
                    int mergeFileID = this.m_hasData ? fileMap.get(projectFileID) : projectFileID;
                    this.m_traceTable.putInt(row, indexFileID, mergeFileID);
                    int projectShotID = this.m_traceTable.getInt(row, indexShotID);
                    int projectShotRow = shotMap.get(projectShotID);
                    int mergeShotID = connShot[projectShotRow];
                    this.m_traceTable.putInt(row, indexShotID, mergeShotID);
                    int projectRecID = this.m_traceTable.getInt(row, indexRecID);
                    int projectRecRow = recMap.get(projectRecID);
                    int mergeRecID = connRec[projectRecRow];
                    this.m_traceTable.putInt(row, indexRecID, mergeRecID);
                    ++currentRow;
                }
                this.m_diskTable.appendTable(this.m_traceTable);
                this.m_traceCount += (long)this.m_traceTable.row_count();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void checkDuplicateTraces() {
        try {
            String fileName = this.m_projectPath + "/TraceDuplixates.txt";
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            int count = 0;
            int dup = 10;
            int indexFileID = this.m_diskTable.column_indexOfColumn("FileID");
            int indexIndexInFile = this.m_diskTable.column_indexOfColumn("IndexInFile");
            int indexShotID = this.m_diskTable.column_indexOfColumn("ShotID");
            int indexRecID = this.m_diskTable.column_indexOfColumn("ReceiverID");
            int indexProjID = this.m_diskTable.column_indexOfColumn("ProjectID");
            for (long row = (long)dup; row < this.m_diskTable.rowCount(); ++row) {
                int f1 = this.m_diskTable.getInt(row, indexFileID);
                long i1 = this.m_diskTable.getLong(row, indexIndexInFile);
                for (long r = row - (long)dup; r < row; ++r) {
                    int f2 = this.m_diskTable.getInt(r, indexFileID);
                    long i2 = this.m_diskTable.getLong(r, indexIndexInFile);
                    if (f1 != f2 || i1 != i2 || ++count >= 100) continue;
                    int s1 = this.m_diskTable.getInt(row, indexShotID);
                    int s2 = this.m_diskTable.getInt(r, indexShotID);
                    int r1 = this.m_diskTable.getInt(row, indexRecID);
                    int r2 = this.m_diskTable.getInt(r, indexRecID);
                    int p1 = this.m_diskTable.getInt(row, indexProjID);
                    int p2 = this.m_diskTable.getInt(r, indexProjID);
                    String s = String.format("row = %d:  file = %d,%d  shot =  %d,%d  %d,%d  rec = %d,%d", row, f1, i1, s1, s2, r1, r2, p1, p2);
                    System.err.println(s);
                    writer.write(s);
                    writer.newLine();
                }
            }
            System.out.println("Duplicate count = " + count);
            writer.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            String driverName = "HSQLDB";
            SharedApplicationData.singleton().setDatabaseDriver(driverName);
            if (!this.checkProjects()) {
                return false;
            }
            if (!this.checkName()) {
                return false;
            }
            if (!this.checkParentPath()) {
                return false;
            }
            this.m_mergeTraceTable = this.Hasher.bool_get("MergeTraceTable", true);
            String projectFolder = this.m_projectName + ".xtref";
            this.m_projectPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_parentPath, projectFolder);
            messageServer.setMessage_Level1("Creating new trace table...");
            this.prepareTraceTable();
            this.m_projectTable.setName("Project");
            this.m_indexProjectID = this.m_projectTable.column_append("ProjectID", DataType.Int);
            this.m_indexProjectName = this.m_projectTable.column_append("ProjectName", DataType.Text);
            this.m_indexProjectIncFFID = this.m_projectTable.column_append("FFIDIncrement", DataType.Int);
            this.m_indexProjectIncRecLine = this.m_projectTable.column_append("RecLineIncrement", DataType.Int);
            this.m_indexProjectIncRecPoint = this.m_projectTable.column_append("RecPointIncrement", DataType.Int);
            this.m_indexProjectIncShotLine = this.m_projectTable.column_append("ShotLineIncrement", DataType.Int);
            this.m_indexProjectIncShotPoint = this.m_projectTable.column_append("ShotPointIncrement", DataType.Int);
            this.m_fileTable.setName("FileList");
            this.m_fileIndex_FileID = this.m_fileTable.column_append("FileID", DataType.Int);
            this.m_fileIndex_Name = this.m_fileTable.column_append("Name", DataType.Text);
            this.m_fileIndex_Path = this.m_fileTable.column_append("Directory", DataType.Text);
            for (Entry e : this.ProjectList.ProjectList) {
                messageServer.setMessage_Level1("Add project " + e.ProjectName);
                this.addProject(e);
            }
            this.m_diskTable.finishedAppending(null);
            this.checkDuplicateTraces();
            this.m_diskTable = null;
            messageServer.setMessage_Level1("Creating trace table indices");
            messageServer.setMessage_Level2("(This may take some time...)");
            TraceTable_Huge_Wrapper wrapper = new TraceTable_Huge_Wrapper(this.m_traceTablePath);
            messageServer.setMessage_Level1("Save tables");
            messageServer.setMessage_Level2(" ");
            String versionsPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "Versions");
            String currentPath = Tools_FileSystem.confirmSubDirectoryExists(versionsPath, "Default");
            this.m_fileTable.saveToPath(this.m_projectPath);
            this.m_projectTable.saveToPath(this.m_projectPath);
            String delayTimePath = Tools_FileSystem.confirmSubDirectoryExists(currentPath, "DelayTime");
            String branchFileName = delayTimePath + "/Branch.xml";
            this.m_branchAssignment.save(branchFileName);
            String fileNameDB = currentPath + "/geometry.db";
            IDatabaseConnection db = Tools_JDBC.getConnection(false, fileNameDB);
            long start = System.currentTimeMillis();
            db.createDatabaseTable(this.m_shotTable);
            db.appendTable(this.m_shotTable, 0);
            db.createDatabaseTable(this.m_receiverTable);
            db.appendTable(this.m_receiverTable, 0);
            db.createDatabaseTable(this.m_fileTable);
            db.appendTable(this.m_fileTable, 0);
            long end = System.currentTimeMillis();
            System.out.println("stuff into disk database = " + Long.toString(end - start));
            String gridFile = this.m_projectPath + "/GridDefinition3D.xml";
            this.m_grid3D.save(gridFile);
            ParameterTree p = new ParameterTree();
            Date date = new Date();
            String dateCreated = date.toString();
            p.string_put("DriverName", driverName);
            p.string_put("Units", this.m_units);
            p.string_put("Dimension", this.m_dimension);
            p.bool_put("HasSeismic", this.m_hasSeismic);
            p.bool_put("HasShots", true);
            p.bool_put("HasReceivers", true);
            p.int_put("ShotCount", this.m_shotTable.row_count());
            p.int_put("ReceiverCount", this.m_receiverTable.row_count());
            p.long_put("TraceCount", this.m_traceCount);
            p.string_put("Origin", "MERGE");
            p.string_put("DateCreated", dateCreated);
            String paramFileName = this.m_projectPath + "/ProjectDescription.xml";
            p.save(paramFileName);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    public static class MergedProjectList
    extends AbstractTableModel {
        public ArrayList<Entry> ProjectList = new ArrayList();

        public boolean columnLocked(String colName) {
            try {
                boolean locked = colName.equalsIgnoreCase("ProjectName");
                return locked;
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return true;
            }
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            try {
                if (obj == null) {
                    return;
                }
                if (!(obj instanceof String)) {
                    return;
                }
                String s = (String)obj;
                Entry e = this.ProjectList.get(row);
                if (col == 0) {
                    return;
                }
                int v = Integer.parseInt(s);
                if (col == 1) {
                    e.FFIDIncrement = v;
                }
                if (col == 2) {
                    e.RecLineIncrement = v;
                }
                if (col == 3) {
                    e.RecPointIncrement = v;
                }
                if (col == 4) {
                    e.ShotLineIncrement = v;
                }
                if (col == 5) {
                    e.ShotPointIncrement = v;
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            try {
                boolean locked = col == 0;
                return !locked;
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return false;
            }
        }

        @Override
        public String getColumnName(int column) {
            try {
                if (column == 0) {
                    return "Project Name";
                }
                if (column == 1) {
                    return "FFID increment";
                }
                if (column == 2) {
                    return "Rec line increment";
                }
                if (column == 3) {
                    return "Rec point increment";
                }
                if (column == 4) {
                    return "Shot line increment";
                }
                if (column == 5) {
                    return "Shot point increment";
                }
                return "ERROR";
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return "Error";
            }
        }

        @Override
        public int getRowCount() {
            return this.ProjectList.size();
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public Object getValueAt(int row, int column) {
            try {
                Entry e = this.ProjectList.get(row);
                if (column == 0) {
                    return e.ProjectName;
                }
                if (column == 1) {
                    return Integer.toString(e.FFIDIncrement);
                }
                if (column == 2) {
                    return Integer.toString(e.RecLineIncrement);
                }
                if (column == 3) {
                    return Integer.toString(e.RecPointIncrement);
                }
                if (column == 4) {
                    return Integer.toString(e.ShotLineIncrement);
                }
                if (column == 5) {
                    return Integer.toString(e.ShotPointIncrement);
                }
                return "Error";
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return "Error";
            }
        }
    }

    public static class Entry {
        public String ProjectName = "";
        public int FFIDIncrement = 0;
        public int RecLineIncrement = 0;
        public int RecPointIncrement = 0;
        public int ShotLineIncrement = 0;
        public int ShotPointIncrement = 0;
    }
}

