/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Import;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Seismic.Segy.Segy_Dictionary;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Geometry.PromaxGrid;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.JDBC.Tools_JDBC;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Date;

public class Action_ImportSegyStack
extends Action_Base {
    protected String m_parentPath = "";
    protected String m_stackName = "";
    protected String m_stackPath = "";
    protected String m_traceTablePath = "";
    protected String m_dimension = "3D";
    protected boolean m_is3D = true;
    protected String m_segyFileName;
    protected Segy m_segy = new Segy();
    protected long m_totalTraces = 0L;
    protected long m_numRead = 0L;
    protected Segy_Dictionary m_dict = new Segy_Dictionary();
    protected PromaxGrid m_grid = new PromaxGrid();
    protected long m_traceCount = 0L;
    protected String m_hyperPath;
    protected String m_hyperFileName;
    protected IDatabaseConnection m_db;
    protected Table_Abstract m_sqlTraceTable;
    protected long m_traceID = 1L;

    public Action_ImportSegyStack() {
        this.Description = "Import stack from SEG-Y files";
        this.MemoryRequired = 1024;
    }

    @Override
    protected void justReadFromNode() {
    }

    protected boolean prepareTables() {
        try {
            this.m_traceTablePath = Tools_FileSystem.confirmSubDirectoryExists(this.m_stackPath, "TraceTable");
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkFiles() {
        try {
            if (!this.Hasher.string_exists("SEGY")) {
                this.FailureReason = "SEG-Y file not specified";
                this.Failed = true;
                return false;
            }
            this.m_segyFileName = this.Hasher.string_get("SEGY");
            this.m_segy.setFileName(this.m_segyFileName);
            if (!this.m_segy.isFileOK()) {
                this.FailureReason = "SEG-Y file not valid";
                this.Failed = true;
                return false;
            }
            this.m_totalTraces = this.m_segy.traceCount();
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkParentPath() {
        try {
            if (!this.Hasher.string_exists("ParentPath")) {
                this.FailureReason = "Parent path not specified";
                this.Failed = true;
                return false;
            }
            this.m_parentPath = this.Hasher.string_get("ParentPath");
            if (!Tools_FileSystem.exists_path(this.m_parentPath)) {
                this.FailureReason = "Parent path not valid";
                this.Failed = true;
                return false;
            }
            this.m_stackPath = this.m_parentPath + "/" + this.m_stackName;
            if (Tools_FileSystem.exists_path(this.m_stackPath)) {
                this.FailureReason = "Project path already exists";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkDict() {
        try {
            if (!this.Hasher.string_exists("Dimension")) {
                this.FailureReason = "Dimension not specified";
                this.Failed = true;
                return false;
            }
            this.m_dimension = this.Hasher.string_get("Dimension");
            this.m_is3D = this.m_dimension.equalsIgnoreCase("3D");
            if (!this.Hasher.string_exists("DictionaryFile")) {
                this.FailureReason = "Dictionary file name not specified";
                this.Failed = true;
                return false;
            }
            String dictName = this.Hasher.string_get("DictionaryFile");
            this.m_dict.setOpenFileName(dictName);
            if (!this.m_dict.isFileNameValid()) {
                this.FailureReason = "Dictionary name not valid";
                this.Failed = true;
                return false;
            }
            if (!this.m_dict.isValidPostStack(this.m_is3D)) {
                this.FailureReason = "Not a valid post-stack dictionary";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkName() {
        try {
            if (!this.Hasher.string_exists("StackName")) {
                this.FailureReason = "ProjectName not specified";
                this.Failed = true;
                return false;
            }
            this.m_stackName = this.Hasher.string_get("StackName");
            if (this.m_stackName.length() <= 1) {
                this.FailureReason = "m_stackName name not valid";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            if (!this.checkDict()) {
                return false;
            }
            if (!this.checkFiles()) {
                return false;
            }
            if (!this.checkName()) {
                return false;
            }
            if (!this.checkParentPath()) {
                return false;
            }
            this.m_stackPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_parentPath, this.m_stackName);
            if (!this.prepareTables()) {
                return false;
            }
            this.m_grid.prepSegyScan(this.m_totalTraces);
            this.importFile(this.m_segy, messageServer);
            if (this.m_is3D) {
                this.m_grid.segyScanFinish();
            }
            if (this.Halt) {
                Tools_FileSystem.deletePathIfExists(this.m_stackPath);
                this.FailureReason = "Import halted";
                this.Failed = true;
                return false;
            }
            messageServer.setMessage_Level1("Save tables");
            if (this.m_is3D) {
                String gridFile = this.m_stackPath + "/PromaxGrid.xml";
                this.m_grid.save(gridFile);
            }
            String dictFileName = this.m_stackPath + "/ImportMap." + Segy_Dictionary.FileSuffix;
            this.m_dict.setFileName(dictFileName);
            ParameterTree p = new ParameterTree();
            Date date = new Date();
            String dateCreated = date.toString();
            p.long_put("TraceCount", this.m_traceCount);
            p.string_put("Origin", "SEGY");
            p.string_put("DictionaryFile", dictFileName);
            p.string_put("DateCreated", dateCreated);
            p.string_put("Dimension", this.m_dimension);
            p.string_put("SEGY", this.m_segyFileName);
            p.int_put("SampleCount", this.m_segy.samplesPerTrace());
            p.double_put("SampleInterval", this.m_segy.sampleInterval());
            String paramFileName = this.m_stackPath + "/ProjectDescription.xml";
            p.save(paramFileName);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected void mergeEnsemble(long startIndexInFile, Ensemble ensemble) {
        try {
            Tools_Ensemble.setHeaderLong(ensemble, "Trace", "IndexInFile", 0, startIndexInFile, 1L);
            Tools_Ensemble.setHeaderLong(ensemble, "Trace", "TraceID", 0, this.m_traceID, 1L);
            this.m_traceID += (long)ensemble.traceCount();
            if (this.m_db == null) {
                this.m_sqlTraceTable = Tools_Ensemble.createEmptyTable(ensemble, "Trace");
                this.m_hyperPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_stackPath, "StackTraceTable");
                this.m_hyperFileName = this.m_hyperPath + "/TraceTable.db";
                this.m_db = Tools_JDBC.getConnection(false, this.m_hyperFileName);
                this.m_db.createDatabaseTable(this.m_sqlTraceTable);
                if (this.m_is3D) {
                    this.m_db.createIndex_OneColumn("Trace", "Inline");
                    this.m_db.createIndex_OneColumn("Trace", "Crossline");
                } else {
                    this.m_db.createIndex_OneColumn("Trace", "CDP");
                }
            }
            this.m_sqlTraceTable.populateFromEnsemble(ensemble);
            this.m_db.appendTable(this.m_sqlTraceTable, 0);
            if (this.m_is3D) {
                int indexCdpX = ensemble.dictionary().getEntryIndex("Trace", "CdpX");
                int indexCdpY = ensemble.dictionary().getEntryIndex("Trace", "CdpY");
                int indexInline = ensemble.dictionary().getEntryIndex("Trace", "Inline");
                int indexCrossline = ensemble.dictionary().getEntryIndex("Trace", "Crossline");
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    Column_Abstract header = ensemble.trace(n).header();
                    double x = header.getDouble(indexCdpX);
                    double y = header.getDouble(indexCdpY);
                    int inline = header.getInt(indexInline);
                    int crossline = header.getInt(indexCrossline);
                    this.m_grid.segyScanAppend(inline, crossline, x, y);
                }
            }
            this.m_traceCount += (long)ensemble.traceCount();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void importFile(Segy segy, IProgressMonitor messageServer) {
        try {
            if (this.Halt) {
                return;
            }
            this.m_segy.setSegyDictionary(this.m_dict);
            Ensemble ensemble = new Ensemble();
            this.m_dict.prepareSeismicHeaderDictionary(ensemble.dictionary());
            int headerIndexFileID = ensemble.dictionary().addEntry("Trace", "FileID", DataType.Int);
            int startIndex = 0;
            int tracesPerChunk = 2000;
            long[] indices = new long[tracesPerChunk];
            int bytesPerTrace = segy.bytesPerTrace();
            int bytesPerChunk = bytesPerTrace * tracesPerChunk;
            ByteBuffer buff = ByteBuffer_Shared.buffer(0, bytesPerChunk);
            buff.order(segy.binaryHeader().FileByteOrder);
            RandomAccessFile reader = new RandomAccessFile(segy.fileName(), "r");
            while ((long)startIndex < segy.traceCount() && !this.Halt) {
                for (int n = 0; n < tracesPerChunk; ++n) {
                    indices[n] = n + startIndex;
                }
                ensemble.clearTraces(false);
                segy.populateEnsemble(ensemble, indices, tracesPerChunk, true, true);
                Tools_Ensemble.computeMaximumAmplitude(ensemble, "MAXAMP");
                Tools_Ensemble.computeAverageAmplitude(ensemble, "AVGAMP");
                this.mergeEnsemble(startIndex, ensemble);
                this.m_numRead += (long)ensemble.traceCount();
                String s = String.format("%d traces ", this.m_numRead);
                messageServer.setMessage_Level1(s);
                messageServer.setPercentDone(100.0 * (double)this.m_numRead / (double)this.m_totalTraces);
                startIndex += tracesPerChunk;
            }
            reader.close();
            System.out.println(String.format("%d traces ", this.m_numRead));
            System.gc();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

