/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Import;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge_Wrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Geometry.TableParser;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Project.ProjectCreator;
import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Seismic.Segy.Segy_Dictionary;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.JDBC.Tools_JDBC;
import com.PecosLibrary.Math.LineFit;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;

public class Action_ImportPreStackSegy_Marine2D
extends Action_Base {
    protected String m_parentPath = "";
    protected String m_projectName = "";
    protected String m_projectPath = "";
    protected String m_traceTablePath = "";
    protected ArrayList<String> m_segyFileList = null;
    protected ArrayList<Segy> m_segyList = new ArrayList();
    protected String m_units = "";
    protected String m_dimension = "";
    protected long m_totalTraces = 0L;
    protected long m_numRead = 0L;
    protected Segy_Dictionary m_dict = new Segy_Dictionary();
    public Segy_Dictionary SeiDictionary = null;
    protected Grid3D_Conversion m_grid3D = new Grid3D_Conversion();
    protected Table_Abstract m_shotTable = new Table_Memory();
    protected TableParser m_shotParser;
    protected Table_Abstract m_receiverTable = new Table_Memory();
    protected TableParser m_receiverParser;
    protected Table_Abstract m_fileTable = new Table_Memory();
    protected int m_fileIndex_FileID;
    protected int m_fileIndex_Name;
    protected int m_fileIndex_Path;
    protected TraceTable_Huge m_diskTable;
    protected long m_traceCount = 0L;
    protected int m_channelMax = Integer.MIN_VALUE;
    protected int m_channelMin = Integer.MAX_VALUE;
    protected int m_fileID = 999;
    protected long m_traceID = 999L;
    double m_binSize = 20.0;
    protected ProjectCreator m_pc = null;
    protected LineFit m_lineFit = new LineFit();

    public Action_ImportPreStackSegy_Marine2D() {
        this.Description = "Import Pre-stack SEG-Y files";
        this.MemoryRequired = 1024;
    }

    @Override
    protected void justReadFromNode() {
    }

    protected boolean prepareTables() {
        try {
            this.m_fileTable.setName("FileList");
            this.m_fileIndex_FileID = this.m_fileTable.column_append("FileID", DataType.Int);
            this.m_fileIndex_Name = this.m_fileTable.column_append("Name", DataType.Text);
            this.m_fileIndex_Path = this.m_fileTable.column_append("Directory", DataType.Text);
            this.m_traceTablePath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "TraceTable");
            this.m_receiverTable.setName("Receiver");
            this.m_receiverParser = new TableParser(this.m_receiverTable);
            this.m_shotTable.setName("Shot");
            this.m_shotParser = new TableParser(this.m_shotTable);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkDimension() {
        try {
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkUnits() {
        try {
            if (!this.Hasher.string_exists("Units")) {
                this.FailureReason = "Units not specified";
                this.Failed = true;
                return false;
            }
            this.m_units = this.Hasher.string_get("Units");
            if (!this.m_units.equalsIgnoreCase("Feet")) {
                this.m_units = "Meters";
            }
            double gridSize = Pecos.gridSize(this.m_units);
            this.m_grid3D.setBinSize(gridSize, gridSize);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkFiles() {
        try {
            if (!this.Hasher.stringList_exists("FileList")) {
                this.FailureReason = "SEG-Y file list not specified";
                this.Failed = true;
                return false;
            }
            this.m_segyFileList = this.Hasher.stringList_get("FileList");
            for (String fileName : this.m_segyFileList) {
                Segy segy = new Segy();
                segy.setFileName(fileName);
                if (!segy.isFileOK()) continue;
                segy.setSegyDictionary(this.m_dict);
                this.m_segyList.add(segy);
                this.m_totalTraces += segy.traceCount();
            }
            if (this.m_totalTraces < 1L) {
                this.FailureReason = "No valid SEG-Y files specified";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkParentPath() {
        try {
            if (!this.Hasher.string_exists("ParentPath")) {
                this.FailureReason = "Parent path not specified";
                this.Failed = true;
                return false;
            }
            this.m_parentPath = this.Hasher.string_get("ParentPath");
            if (!Tools_FileSystem.exists_path(this.m_parentPath)) {
                this.FailureReason = "Parent path not valid";
                this.Failed = true;
                return false;
            }
            this.m_projectPath = this.m_parentPath + "/" + this.m_projectName;
            if (Tools_FileSystem.exists_path(this.m_projectPath)) {
                this.FailureReason = "Project path already exists";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkDict() {
        try {
            if (this.SeiDictionary != null) {
                this.m_dict = this.SeiDictionary;
            } else {
                if (!this.Hasher.string_exists("DictionaryFile")) {
                    this.FailureReason = "Dictionary file name not specified";
                    this.Failed = true;
                    return false;
                }
                String dictName = this.Hasher.string_get("DictionaryFile");
                this.m_dict.setOpenFileName(dictName);
                if (!this.m_dict.isFileNameValid()) {
                    this.FailureReason = "Dictionary name not valid";
                    this.Failed = true;
                    return false;
                }
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkName() {
        try {
            if (!this.Hasher.string_exists("ProjectName")) {
                this.FailureReason = "ProjectName not specified";
                this.Failed = true;
                return false;
            }
            this.m_projectName = this.Hasher.string_get("ProjectName");
            if (this.m_projectName.length() <= 1) {
                this.FailureReason = "m_projectName name not valid";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            String driverName = "HSQLDB";
            SharedApplicationData.singleton().setDatabaseDriver(driverName);
            if (!this.checkUnits()) {
                return false;
            }
            if (!this.checkDimension()) {
                return false;
            }
            if (!this.checkDict()) {
                return false;
            }
            if (!this.checkFiles()) {
                return false;
            }
            if (!this.checkName()) {
                return false;
            }
            if (!this.checkParentPath()) {
                return false;
            }
            this.m_projectPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_parentPath, this.m_projectName);
            if (!this.prepareTables()) {
                return false;
            }
            for (Segy segy : this.m_segyList) {
                if (this.Halt) continue;
                this.importFile_Marine2D_ComputeLine(segy, messageServer);
            }
            this.m_lineFit.compute();
            for (Segy segy : this.m_segyList) {
                if (this.Halt) continue;
                this.importFile(segy, messageServer);
            }
            this.m_diskTable.finishedAppending(null);
            if (this.Halt) {
                Tools_FileSystem.deletePathIfExists(this.m_projectPath);
                this.FailureReason = "Import halted";
                this.Failed = true;
                return false;
            }
            this.m_diskTable = null;
            messageServer.setMessage_Level1("Creating trace table indices");
            TraceTable_Huge_Wrapper wrapper = new TraceTable_Huge_Wrapper(this.m_traceTablePath);
            messageServer.setMessage_Level1("Save tables");
            String versionsPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "Versions");
            String currentPath = Tools_FileSystem.confirmSubDirectoryExists(versionsPath, "Default");
            this.m_fileTable.saveToPath(this.m_projectPath);
            String fileNameDB = currentPath + "/geometry.db";
            IDatabaseConnection db = Tools_JDBC.getConnection(false, fileNameDB);
            long start = System.currentTimeMillis();
            db.createDatabaseTable(this.m_shotTable);
            db.appendTable(this.m_shotTable, 0);
            db.createDatabaseTable(this.m_receiverTable);
            db.appendTable(this.m_receiverTable, 0);
            db.createDatabaseTable(this.m_fileTable);
            db.appendTable(this.m_fileTable, 0);
            long end = System.currentTimeMillis();
            System.out.println("stuff into disk database = " + Long.toString(end - start));
            db.addColumn("Shot", "Killed", DataType.Bool);
            db.executeUpdateStatement(String.format("UPDATE Shot Set %s = FALSE", "Killed"));
            db.addColumn("Receiver", "Killed", DataType.Bool);
            db.executeUpdateStatement(String.format("UPDATE Receiver Set %s = FALSE", "Killed"));
            db.addColumn("Shot", "InitialElevation", DataType.Double);
            db.executeUpdateStatement(String.format("UPDATE Shot Set %s = %s", "InitialElevation", "Elevation"));
            db.addColumn("Shot", "InitialEasting", DataType.Double);
            db.executeUpdateStatement(String.format("UPDATE Shot Set %s = %s", "InitialEasting", "Easting"));
            db.addColumn("Shot", "InitialNorthing", DataType.Double);
            db.executeUpdateStatement(String.format("UPDATE Shot Set %s = %s", "InitialNorthing", "Northing"));
            db.addColumn("Receiver", "InitialElevation", DataType.Double);
            db.executeUpdateStatement(String.format("UPDATE Receiver Set %s = %s", "InitialElevation", "Elevation"));
            db.addColumn("Receiver", "InitialEasting", DataType.Double);
            db.executeUpdateStatement(String.format("UPDATE Receiver Set %s = %s", "InitialEasting", "Easting"));
            db.addColumn("Receiver", "InitialNorthing", DataType.Double);
            db.executeUpdateStatement(String.format("UPDATE Receiver Set %s = %s", "InitialNorthing", "Northing"));
            String dictFileName = this.m_projectPath + "/ImportMap." + Segy_Dictionary.FileSuffix;
            this.m_dict.setFileName(dictFileName);
            String gridFile = this.m_projectPath + "/GridDefinition3D.xml";
            this.m_grid3D.save(gridFile);
            ParameterTree p = new ParameterTree();
            Date date = new Date();
            String dateCreated = date.toString();
            p.string_put("DriverName", driverName);
            p.string_put("Units", this.m_units);
            p.string_put("Dimension", this.m_dimension);
            p.bool_put("HasSeismic", true);
            p.bool_put("HasShots", true);
            p.bool_put("HasReceivers", true);
            p.int_put("ShotCount", this.m_shotTable.row_count());
            p.int_put("ReceiverCount", this.m_receiverTable.row_count());
            p.long_put("TraceCount", this.m_traceCount);
            p.string_put("Origin", "SEGY");
            p.string_put("DictionaryFile", dictFileName);
            p.string_put("DateCreated", dateCreated);
            p.string_put("DateLastOpened", dateCreated);
            p.string_put("DateCreated", dateCreated);
            p.int_put("ChannelMax", this.m_channelMax);
            p.int_put("ChannelMin", this.m_channelMin);
            String paramFileName = this.m_projectPath + "/ProjectDescription.xml";
            p.save(paramFileName);
            String shotConFile = this.m_projectPath + "/ShotConflicts.xml";
            this.m_shotParser.saveConflicts(shotConFile);
            String recConFile = this.m_projectPath + "/ReceiverConflicts.xml";
            this.m_receiverParser.saveConflicts(recConFile);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected void updateChannelRange(Ensemble ensemble) {
        try {
            if (!ensemble.dictionary().containsEntry("Trace", "Channel")) {
                return;
            }
            int index = ensemble.dictionary().getEntryIndex("Trace", "Channel");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                int chan = ensemble.trace(n).header().getInt(index);
                this.m_channelMax = Math.max(this.m_channelMax, chan);
                this.m_channelMin = Math.min(this.m_channelMin, chan);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void mergeEnsemble(long startIndexInFile, Ensemble ensemble) {
        try {
            this.updateChannelRange(ensemble);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "Flags", 0, 0, 0);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FileID", 0, this.m_fileID, 0);
            Tools_Ensemble.setHeaderLong(ensemble, "Trace", "IndexInFile", 0, startIndexInFile, 1L);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "Killed", 0, 0, 0);
            this.m_shotParser.handleEnsemble(ensemble);
            this.m_receiverParser.handleEnsemble(ensemble);
            if (!this.m_dict.hasEntry("Trace", "FBP_User")) {
                Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_User", 0, -9999, 0);
            }
            if (!ensemble.dictionary().containsEntry("Trace", "FBP_User")) {
                Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_User", 0, -9999, 0);
            }
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_Back1", 0, -9999, 0);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_Back2", 0, -9999, 0);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_Back3", 0, -9999, 0);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_AMP", 0, -9999, 0);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_PickT", 0, -9999, 0);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_TAP", 0, -9999, 0);
            Tools_Ensemble.computeInlineCrossline(ensemble, this.m_grid3D);
            if (this.m_diskTable == null) {
                this.m_diskTable = new TraceTable_Huge(this.m_traceTablePath, "Trace", ensemble, 6);
            }
            long numAdded = this.m_diskTable.appendEnsemble(ensemble);
            this.m_traceCount += numAdded;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void importFile(Segy segy, IProgressMonitor messageServer) {
        try {
            if (this.Halt) {
                return;
            }
            String tempFileName = Tools_FileSystem.convertToUnixFileName(segy.fileName());
            File file = new File(tempFileName);
            ++this.m_fileID;
            int fileRow = this.m_fileTable.row_increment();
            this.m_fileTable.putInt(fileRow, this.m_fileIndex_FileID, this.m_fileID);
            this.m_fileTable.putString(fileRow, this.m_fileIndex_Name, file.getName());
            this.m_fileTable.putString(fileRow, this.m_fileIndex_Path, file.getParent());
            Ensemble ensemble = new Ensemble();
            this.m_dict.prepareSeismicHeaderDictionary(ensemble.dictionary());
            int headerIndexFileID = ensemble.dictionary().addEntry("Trace", "FileID", DataType.Int);
            int tracesPerChunk = 2000;
            int bytesPerTrace = segy.bytesPerTrace();
            int bytesPerChunk = bytesPerTrace * tracesPerChunk;
            ByteBuffer buff = ByteBuffer_Shared.buffer(0, bytesPerChunk);
            buff.order(segy.binaryHeader().FileByteOrder);
            RandomAccessFile reader = new RandomAccessFile(segy.fileName(), "r");
            for (long startIndex = 0L; startIndex < segy.traceCount() && !this.Halt; startIndex += (long)tracesPerChunk) {
                long lastIndex = startIndex + (long)tracesPerChunk - 1L;
                long numLong = (lastIndex = Math.min(lastIndex, segy.traceCount() - 1L)) - startIndex + 1L;
                if (numLong > Integer.MAX_VALUE) {
                    throw new Exception("importFile(): trace import: chunk size too large!");
                }
                int num = (int)numLong;
                ensemble.clearTraces(false);
                if (num >= 1) {
                    long offset = 3600L + startIndex * (long)bytesPerTrace;
                    reader.seek(offset);
                    int numBytes = num * segy.bytesPerTrace();
                    reader.read(buff.array(), 0, numBytes);
                    for (int n = 0; n < num; ++n) {
                        EnsembleTrace trace = ensemble.addTrace();
                        int buffOffset = n * segy.bytesPerTrace();
                        this.m_dict.fillTraceHeader(buff, buffOffset, trace.header());
                    }
                    int indexRX = ensemble.dictionary().getEntryIndex("Receiver", "Easting");
                    int indexRY = ensemble.dictionary().getEntryIndex("Receiver", "Northing");
                    int indexRP = ensemble.dictionary().addEntry("Receiver", "PointNumber", DataType.Int);
                    for (int t = 0; t < ensemble.traceCount(); ++t) {
                        EnsembleTrace trace = ensemble.trace(t);
                        double rx = trace.header().getDouble(indexRX);
                        double ry = trace.header().getDouble(indexRY);
                        this.m_lineFit.findNearestPoint(rx, ry);
                        int bin = (int)(0.5 + this.m_lineFit.DistanceFromX0 / this.m_binSize);
                        double dist = (double)bin * this.m_binSize;
                        double x = dist / Math.sqrt(1.0 + this.m_lineFit.A * this.m_lineFit.A);
                        double y = x * this.m_lineFit.A + this.m_lineFit.B;
                        trace.header().putInt(indexRP, bin);
                        trace.header().putDouble(indexRX, x);
                        trace.header().putDouble(indexRY, y);
                    }
                    int indexSX = ensemble.dictionary().getEntryIndex("Shot", "Easting");
                    int indexSY = ensemble.dictionary().getEntryIndex("Shot", "Northing");
                    for (int t = 0; t < ensemble.traceCount(); ++t) {
                        EnsembleTrace trace = ensemble.trace(t);
                        double sx = trace.header().getDouble(indexSX);
                        double sy = trace.header().getDouble(indexSY);
                        this.m_lineFit.findNearestPoint(sx, sy);
                        trace.header().putDouble(indexSX, this.m_lineFit.NearestX);
                        trace.header().putDouble(indexSY, this.m_lineFit.NearestY);
                    }
                    this.mergeEnsemble(startIndex, ensemble);
                }
                this.m_numRead += (long)ensemble.traceCount();
                String s = String.format("%d traces, %d shots, %d receivers", this.m_numRead, this.m_shotTable.row_count(), this.m_receiverTable.row_count());
                messageServer.setMessage_Level1(s);
                s = String.format("Number of geometry conflicts: %d shot, %d receiver", this.m_shotParser.totalConflicts(), this.m_receiverParser.totalConflicts());
                messageServer.setMessage_Level2(s);
                messageServer.setPercentDone(100.0 * (double)this.m_numRead / (double)this.m_totalTraces);
            }
            reader.close();
            System.out.println(String.format("%d traces, %d shots, %d receivers", this.m_numRead, this.m_shotTable.row_count(), this.m_receiverTable.row_count()));
            System.gc();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void importFile_Marine2D_ComputeLine(Segy segy, IProgressMonitor messageServer) {
        try {
            if (this.Halt) {
                return;
            }
            String tempFileName = Tools_FileSystem.convertToUnixFileName(segy.fileName());
            File file = new File(tempFileName);
            Ensemble ensemble = new Ensemble();
            this.m_dict.prepareSeismicHeaderDictionary(ensemble.dictionary());
            int tracesPerChunk = 2000;
            int bytesPerTrace = segy.bytesPerTrace();
            int bytesPerChunk = bytesPerTrace * tracesPerChunk;
            ByteBuffer buff = ByteBuffer_Shared.buffer(0, bytesPerChunk);
            buff.order(segy.binaryHeader().FileByteOrder);
            RandomAccessFile reader = new RandomAccessFile(segy.fileName(), "r");
            for (long startIndex = 0L; startIndex < segy.traceCount() && !this.Halt; startIndex += (long)tracesPerChunk) {
                long lastIndex = startIndex + (long)tracesPerChunk - 1L;
                long numLong = (lastIndex = Math.min(lastIndex, segy.traceCount() - 1L)) - startIndex + 1L;
                if (numLong > Integer.MAX_VALUE) {
                    throw new Exception("importFile(): trace import: chunk size too large!");
                }
                int num = (int)numLong;
                ensemble.clearTraces(false);
                if (num >= 1) {
                    long offset = 3600L + startIndex * (long)bytesPerTrace;
                    reader.seek(offset);
                    int numBytes = num * segy.bytesPerTrace();
                    reader.read(buff.array(), 0, numBytes);
                    for (int n = 0; n < num; ++n) {
                        EnsembleTrace trace = ensemble.addTrace();
                        int buffOffset = n * segy.bytesPerTrace();
                        this.m_dict.fillTraceHeader(buff, buffOffset, trace.header());
                    }
                }
                if (ensemble.traceCount() < 1) continue;
                int indexSX = ensemble.dictionary().getEntryIndex("Shot", "Easting");
                int indexSY = ensemble.dictionary().getEntryIndex("Shot", "Northing");
                for (int t = 0; t < ensemble.traceCount(); ++t) {
                    EnsembleTrace trace = ensemble.trace(t);
                    double sx = trace.header().getDouble(indexSX);
                    double sy = trace.header().getDouble(indexSY);
                    this.m_lineFit.add(sx, sy);
                }
            }
            reader.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

