/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Import;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge_Wrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Geometry.TableParser;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Project.ProjectCreator;
import com.PecosCore.Seismic.ISeismicFile;
import com.PecosCore.Seismic.ImportLimit;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Echos.EchosSeismicFile;
import com.PecosLibrary.Echos.XtParadigmTraceFileTools;
import com.PecosLibrary.Ensemble.Worker.Filter.EnsembleWorker_ButterworthLowPass;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.JDBC.Tools_JDBC;
import com.PecosLibrary.Seismic.Echos.Echos_Dictionary;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Logger;

public class Action_ImportPreStackEchosV2
extends Action_Base {
    private ArrayList<ImportLimit> ImportLimitList = new ArrayList();
    protected String m_parentPath = "";
    protected String m_projectName = "";
    protected String m_projectPath = "";
    protected String m_traceTablePath = "";
    protected ArrayList<String> m_seismicFilePathList = null;
    protected ArrayList<ISeismicFile> m_seismicFileList = new ArrayList();
    protected String m_units = "";
    protected String m_dimension = "";
    protected long m_totalTraces = 0L;
    protected long m_numRead = 0L;
    protected Echos_Dictionary m_dict = new Echos_Dictionary("Flatirons", true);
    public Echos_Dictionary SeiDictionary = null;
    protected Grid3D_Conversion m_grid3D = new Grid3D_Conversion();
    protected Table_Abstract m_shotTable = new Table_Memory();
    protected TableParser m_shotParser;
    protected Table_Abstract m_receiverTable = new Table_Memory();
    protected TableParser m_receiverParser;
    protected Table_Abstract m_fileTable = new Table_Memory();
    protected int m_fileIndex_FileID;
    protected int m_fileIndex_Name;
    protected int m_fileIndex_Path;
    protected int m_fileIndex_Type;
    protected int m_segyIndex_Type;
    protected Table_Abstract m_segyTable = new Table_Memory();
    protected int m_segyIndex_Name;
    protected TraceTable_Huge m_diskTable;
    protected long m_traceCount = 0L;
    protected int m_channelMax = Integer.MIN_VALUE;
    protected int m_channelMin = Integer.MAX_VALUE;
    protected int m_fileID = 999;
    protected long m_traceID = 999L;
    public boolean DecimateInput = false;
    public int Decimation = 2;
    public boolean CreateCompressed = false;
    public boolean Resample = false;
    public float MaxTime = 2000.0f;
    public float OutputSampleInterval = 4.0f;
    protected boolean RequireFilter = false;
    public boolean KillOffsets = false;
    public double MinOffset = 0.0;
    public double MaxOffset = 100000.0;
    public boolean IsMarine = false;
    public float RecBinSize = 25.0f;
    public int MarineDecimation = 0;
    public int MarineShotLineIncrement = 0;
    public int MarineShotLineNumber = 0;
    public boolean CreateSparse = false;
    public float SparseSpacing = 5000.0f;
    public float SparseRadius = 200.0f;
    public boolean KillNoisy = false;
    public float NoiseWindow = 100.0f;
    public float NoiseCutoff = 10.0f;
    String _sEchosSurvey;
    String _sEchosHost;
    int _iEchosLineID;
    protected ProjectCreator m_pc = null;
    public boolean TestUL = false;
    protected EnsembleWorker_ButterworthLowPass m_filterLP = new EnsembleWorker_ButterworthLowPass();
    protected ArrayList<MarineFileInfo> MarineFileList = new ArrayList();

    public void addImportLimit(ImportLimit il) {
        this.ImportLimitList.add(il);
    }

    public Action_ImportPreStackEchosV2(String sEchosSurvey, String sEchosHost, int iEchosLineID) {
        this._sEchosSurvey = sEchosSurvey;
        this._sEchosHost = sEchosHost;
        this._iEchosLineID = iEchosLineID;
        this.Description = "Import Pre-stack Echos files";
        this.MemoryRequired = 1024;
    }

    @Override
    protected void justReadFromNode() {
    }

    protected boolean prepareTables() {
        try {
            this.m_fileTable.setName("FileList");
            this.m_fileIndex_FileID = this.m_fileTable.column_append("FileID", DataType.Int);
            this.m_fileIndex_Name = this.m_fileTable.column_append("Name", DataType.Text);
            this.m_fileIndex_Path = this.m_fileTable.column_append("Directory", DataType.Text);
            this.m_fileIndex_Type = this.m_fileTable.column_append("FileType", DataType.Int);
            this.m_segyTable.setName("SegyList");
            this.m_segyIndex_Name = this.m_segyTable.column_append("Name", DataType.Text);
            this.m_segyIndex_Type = this.m_segyTable.column_append("FileType", DataType.Int);
            this.m_traceTablePath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "TraceTable");
            this.m_receiverTable.setName("Receiver");
            this.m_receiverParser = new TableParser(this.m_receiverTable);
            this.m_receiverParser.IsMarine = this.IsMarine;
            this.m_receiverParser.RecBinSize = this.RecBinSize;
            this.m_shotTable.setName("Shot");
            this.m_shotParser = new TableParser(this.m_shotTable);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkDimension() {
        try {
            if (!this.Hasher.string_exists("Dimension")) {
                this.FailureReason = "Dimension not specified";
                this.Failed = true;
                return false;
            }
            this.m_dimension = this.Hasher.string_get("Dimension");
            if (!this.m_dimension.equalsIgnoreCase("3D")) {
                this.m_dimension = "2D";
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkUnits() {
        try {
            if (!this.Hasher.string_exists("Units")) {
                this.FailureReason = "Units not specified";
                this.Failed = true;
                return false;
            }
            this.m_units = this.Hasher.string_get("Units");
            if (!this.m_units.equalsIgnoreCase("Feet")) {
                this.m_units = "Meters";
            }
            double gridSize = Pecos.gridSize(this.m_units);
            this.m_grid3D.setBinSize(gridSize, gridSize);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkFiles() {
        try {
            if (!this.Hasher.stringList_exists("FileList")) {
                this.FailureReason = "Echos file list not specified";
                this.Failed = true;
                return false;
            }
            this.m_seismicFilePathList = this.Hasher.stringList_get("FileList");
            for (String fileName : this.m_seismicFilePathList) {
                EchosSeismicFile seismicFile = XtParadigmTraceFileTools.createNewSeismicTraceFile(fileName, this.m_dict);
                if (!seismicFile.isFileOK()) continue;
                this.m_seismicFileList.add(seismicFile);
                seismicFile.openPecosRAF();
                this.m_totalTraces += seismicFile.traceCount();
                seismicFile.closePecosRAF();
            }
            if (this.m_totalTraces < 1L) {
                this.FailureReason = "No valid Echos files specified";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkParentPath() {
        try {
            if (!this.Hasher.string_exists("ParentPath")) {
                this.FailureReason = "Parent path not specified";
                this.Failed = true;
                return false;
            }
            this.m_parentPath = this.Hasher.string_get("ParentPath");
            if (!Tools_FileSystem.exists_path(this.m_parentPath)) {
                this.FailureReason = "Parent path not valid";
                this.Failed = true;
                return false;
            }
            String projectPath = this.m_parentPath + "/" + this.m_projectName;
            this.m_projectPath = this.m_parentPath + "/" + this.m_projectName + ".xtref";
            if (Tools_FileSystem.exists_path(projectPath)) {
                this.FailureReason = "Project path already exists";
                this.Failed = true;
                return false;
            }
            if (Tools_FileSystem.exists_path(this.m_projectPath)) {
                this.FailureReason = "Project path already exists";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkDict() {
        try {
            if (this.SeiDictionary != null) {
                this.m_dict = this.SeiDictionary;
            } else {
                if (!this.Hasher.string_exists("DictionaryFile")) {
                    this.FailureReason = "Dictionary file name not specified";
                    this.Failed = true;
                    return false;
                }
                String dictName = this.Hasher.string_get("DictionaryFile");
                this.m_dict.setOpenFileName(dictName);
                if (!this.m_dict.isFileNameValid()) {
                    this.FailureReason = "Dictionary name not valid";
                    this.Failed = true;
                    return false;
                }
            }
            if (!this.m_dict.isValidPreStack()) {
                this.FailureReason = "Not a valid pre-stack dictionary";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkName() {
        try {
            if (!this.Hasher.string_exists("ProjectName")) {
                this.FailureReason = "ProjectName not specified";
                this.Failed = true;
                return false;
            }
            this.m_projectName = this.Hasher.string_get("ProjectName");
            if (this.m_projectName.length() <= 1) {
                this.FailureReason = "m_projectName name not valid";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    public boolean work_compressed(IProgressMonitor messageServer) {
        try {
            this.m_segyTable.setName("SegyList");
            this.m_segyIndex_Name = this.m_segyTable.column_append("Name", DataType.Text);
            for (ISeismicFile seismicFile : this.m_seismicFileList) {
                if (this.Halt) continue;
                this.importFile_Compressed(seismicFile, messageServer);
            }
            this.m_segyTable.saveToPath(this.m_projectPath);
            this.m_pc.done();
            if (this.IsMarine && this.MarineShotLineIncrement > 0) {
                this.saveMarineFileList();
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            String driverName = "HSQLDB";
            SharedApplicationData.singleton().setDatabaseDriver(driverName);
            if (!this.checkUnits()) {
                return false;
            }
            if (!this.checkDimension()) {
                return false;
            }
            if (!this.checkDict()) {
                return false;
            }
            if (!this.checkFiles()) {
                return false;
            }
            if (!this.checkName()) {
                return false;
            }
            if (!this.checkParentPath()) {
                return false;
            }
            if (this.CreateCompressed) {
                return this.work_compressed(messageServer);
            }
            String projectFolder = this.m_projectName + ".xtref";
            this.m_projectPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_parentPath, projectFolder);
            if (!this.prepareTables()) {
                return false;
            }
            for (ISeismicFile seismicFile : this.m_seismicFileList) {
                if (this.Halt) continue;
                this.importFile(seismicFile, messageServer);
            }
            this.m_diskTable.finishedAppending(null);
            if (this.Halt) {
                Tools_FileSystem.deletePathIfExists(this.m_projectPath);
                this.FailureReason = "Import halted";
                this.Failed = true;
                return false;
            }
            this.m_diskTable = null;
            messageServer.setMessage_Level1("Creating trace table indices");
            TraceTable_Huge_Wrapper wrapper = new TraceTable_Huge_Wrapper(this.m_traceTablePath);
            messageServer.setMessage_Level1("Save tables");
            String versionsPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "Versions");
            String currentPath = Tools_FileSystem.confirmSubDirectoryExists(versionsPath, "Default");
            this.m_fileTable.saveToPath(this.m_projectPath);
            this.m_segyTable.saveToPath(this.m_projectPath);
            String fileNameDB = currentPath + "/geometry.db";
            IDatabaseConnection db = Tools_JDBC.getConnection(false, fileNameDB);
            long start = System.currentTimeMillis();
            db.createDatabaseTable(this.m_shotTable);
            db.appendTable(this.m_shotTable, 0);
            db.createDatabaseTable(this.m_receiverTable);
            db.appendTable(this.m_receiverTable, 0);
            db.createDatabaseTable(this.m_fileTable);
            db.appendTable(this.m_fileTable, 0);
            long end = System.currentTimeMillis();
            System.out.println("stuff into disk database = " + Long.toString(end - start));
            db.addColumn("Shot", "Killed", DataType.Bool);
            db.executeUpdateStatement(String.format("UPDATE Shot Set %s = FALSE", "Killed"));
            db.addColumn("Receiver", "Killed", DataType.Bool);
            db.executeUpdateStatement(String.format("UPDATE Receiver Set %s = FALSE", "Killed"));
            db.addColumn("Shot", "InitialElevation", DataType.Double);
            db.executeUpdateStatement(String.format("UPDATE Shot Set %s = %s", "InitialElevation", "Elevation"));
            db.addColumn("Shot", "InitialEasting", DataType.Double);
            db.executeUpdateStatement(String.format("UPDATE Shot Set %s = %s", "InitialEasting", "Easting"));
            db.addColumn("Shot", "InitialNorthing", DataType.Double);
            db.executeUpdateStatement(String.format("UPDATE Shot Set %s = %s", "InitialNorthing", "Northing"));
            db.addColumn("Receiver", "InitialElevation", DataType.Double);
            db.executeUpdateStatement(String.format("UPDATE Receiver Set %s = %s", "InitialElevation", "Elevation"));
            db.addColumn("Receiver", "InitialEasting", DataType.Double);
            db.executeUpdateStatement(String.format("UPDATE Receiver Set %s = %s", "InitialEasting", "Easting"));
            db.addColumn("Receiver", "InitialNorthing", DataType.Double);
            db.executeUpdateStatement(String.format("UPDATE Receiver Set %s = %s", "InitialNorthing", "Northing"));
            String dictFileName = this.m_projectPath + "/ImportMap." + Echos_Dictionary.FileSuffix;
            this.m_dict.setFileName(dictFileName);
            String gridFile = this.m_projectPath + "/GridDefinition3D.xml";
            this.m_grid3D.save(gridFile);
            ParameterTree p = new ParameterTree();
            Date date = new Date();
            String dateCreated = date.toString();
            p.string_put("DriverName", driverName);
            p.string_put("Units", this.m_units);
            p.string_put("Dimension", this.m_dimension);
            p.bool_put("HasSeismic", true);
            p.bool_put("HasShots", true);
            p.bool_put("HasReceivers", true);
            p.int_put("ShotCount", this.m_shotTable.row_count());
            p.int_put("ReceiverCount", this.m_receiverTable.row_count());
            p.long_put("TraceCount", this.m_traceCount);
            p.string_put("Origin", "ECHOS");
            p.string_put("EchosSurvey", this._sEchosSurvey);
            p.string_put("EchosHost", this._sEchosHost);
            p.int_put("EchosLineID", this._iEchosLineID);
            p.string_put("DictionaryFile", dictFileName);
            p.string_put("DateCreated", dateCreated);
            p.string_put("DateLastOpened", dateCreated);
            p.string_put("DateCreated", dateCreated);
            p.int_put("ChannelMax", this.m_channelMax);
            p.int_put("ChannelMin", this.m_channelMin);
            String paramFileName = this.m_projectPath + "/ProjectDescription.xml";
            p.save(paramFileName);
            String shotConFile = this.m_projectPath + "/ShotConflicts.xml";
            this.m_shotParser.saveConflicts(shotConFile);
            String recConFile = this.m_projectPath + "/ReceiverConflicts.xml";
            this.m_receiverParser.saveConflicts(recConFile);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected void updateChannelRange(Ensemble ensemble) {
        try {
            if (!ensemble.dictionary().containsEntry("Trace", "Channel")) {
                return;
            }
            int index = ensemble.dictionary().getEntryIndex("Trace", "Channel");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                int chan = ensemble.trace(n).header().getInt(index);
                this.m_channelMax = Math.max(this.m_channelMax, chan);
                this.m_channelMin = Math.min(this.m_channelMin, chan);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void testUL(Ensemble ensemble, long startIndexInFile) {
        try {
            if (!ensemble.dictionary().containsEntry("Shot", "FFID")) {
                return;
            }
            int indexFFID = ensemble.dictionary().getEntryIndex("Shot", "FFID");
            int indexFileID = ensemble.dictionary().getEntryIndex("Trace", "FileID");
            int indexIndexInFile = ensemble.dictionary().getEntryIndex("Trace", "IndexInFile");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                int ffid = ensemble.trace(n).header().getInt(indexFFID);
                int fileID = ensemble.trace(n).header().getInt(indexFileID);
                long fileIndex = ensemble.trace(n).header().getLong(indexIndexInFile);
                if (ffid != 2) continue;
                String s = String.format("FFID = %d, FileID = %d,  IndexInFile = %d", ffid, fileID, fileIndex);
                System.out.println(s);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void mergeEnsemble(long startIndexInFile, Ensemble ensemble) {
        try {
            this.updateChannelRange(ensemble);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "Flags", 0, 0, 0);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FileID", 0, this.m_fileID, 0);
            Tools_Ensemble.setHeaderLong(ensemble, "Trace", "IndexInFile", 0, startIndexInFile, 1L);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "Killed", 0, 0, 0);
            this.m_shotParser.handleEnsemble(ensemble);
            this.m_receiverParser.handleEnsemble(ensemble);
            if (!this.m_dict.hasEntry("Trace", "FBP_User")) {
                Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_User", 0, -9999, 0);
            }
            if (!ensemble.dictionary().containsEntry("Trace", "FBP_User")) {
                Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_User", 0, -9999, 0);
            }
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_Back1", 0, -9999, 0);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_Back2", 0, -9999, 0);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_Back3", 0, -9999, 0);
            Tools_Ensemble.setHeaderFloat(ensemble, "Trace", "FBP_PickPredDT", -9999.0f);
            Tools_Ensemble.setHeaderFloat(ensemble, "Trace", "FBP_PickPredVNS", -9999.0f);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_AMP", 0, -9999, 0);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_PickT", 0, -9999, 0);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_TAP", 0, -9999, 0);
            Tools_Ensemble.computeInlineCrossline(ensemble, this.m_grid3D);
            if (this.m_diskTable == null) {
                this.m_diskTable = new TraceTable_Huge(this.m_traceTablePath, "Trace", ensemble, 6);
            }
            int numAdded = this.m_diskTable.appendEnsemble(ensemble);
            this.m_traceCount += (long)numAdded;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importFile(ISeismicFile seismicFile, IProgressMonitor messageServer) {
        try {
            if (this.Halt) {
                return;
            }
            ++this.m_fileID;
            int fileRow = this.m_fileTable.row_increment();
            this.m_fileTable.putInt(fileRow, this.m_fileIndex_FileID, this.m_fileID);
            String sName = seismicFile.getName();
            String sDirectory = seismicFile.getDirectory();
            int iFileType = seismicFile.getFileType().toInt();
            this.m_fileTable.putString(fileRow, this.m_fileIndex_Name, sName);
            this.m_fileTable.putString(fileRow, this.m_fileIndex_Path, sDirectory);
            this.m_fileTable.putInt(fileRow, this.m_fileIndex_Type, iFileType);
            int segyRow = this.m_segyTable.row_increment();
            this.m_segyTable.putString(segyRow, this.m_segyIndex_Name, sName);
            this.m_segyTable.putInt(segyRow, this.m_segyIndex_Type, iFileType);
            Ensemble ensemble = new Ensemble();
            this.m_dict.prepareSeismicHeaderDictionary(ensemble.dictionary());
            int startIndex = 0;
            int tracesPerChunk = 2000;
            seismicFile.openPecosRAF();
            long nTraces = seismicFile.traceCount();
            int iHeaderFileID = ensemble.dictionary().addEntry("Trace", "FileID", DataType.Int);
            int iHeaderIndexInFile = ensemble.dictionary().addEntry("Trace", "IndexInFile", DataType.Long);
            while ((long)startIndex < nTraces && !this.Halt) {
                long lastIndex = startIndex + tracesPerChunk - 1;
                long numLong = (lastIndex = Math.min(lastIndex, nTraces - 1L)) - (long)startIndex + 1L;
                if (numLong > Integer.MAX_VALUE) {
                    throw new Exception("importFile(): trace import: chunk size too large!");
                }
                int num = (int)numLong;
                ensemble.clearTraces(false);
                if (num >= 1) {
                    for (int n = 0; n < num; ++n) {
                        long index = startIndex + n;
                        EnsembleTrace trace = ensemble.addTrace();
                        trace.header().putInt(iHeaderFileID, this.m_fileID);
                        trace.header().putLong(iHeaderIndexInFile, index);
                    }
                    seismicFile.populateEnsembleWithData(ensemble, this.m_fileID, true, false);
                    this.mergeEnsemble(startIndex, ensemble);
                    if (this.TestUL) {
                        this.testUL(ensemble, startIndex);
                    }
                }
                this.m_numRead += (long)ensemble.traceCount();
                String s = String.format("%d traces, %d shots, %d receivers", this.m_numRead, this.m_shotTable.row_count(), this.m_receiverTable.row_count());
                messageServer.setMessage_Level1(s);
                s = String.format("Number of geometry conflicts: %d shot, %d receiver", this.m_shotParser.totalConflicts(), this.m_receiverParser.totalConflicts());
                messageServer.setMessage_Level2(s);
                messageServer.setPercentDone(100.0 * (double)this.m_numRead / (double)this.m_totalTraces);
                startIndex += tracesPerChunk;
            }
            System.out.println(String.format("%d traces, %d shots, %d receivers", this.m_numRead, this.m_shotTable.row_count(), this.m_receiverTable.row_count()));
            System.gc();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        finally {
            try {
                seismicFile.closePecosRAF();
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }
    }

    public void filterEnsemble(Ensemble ensemble) {
        try {
            boolean okay;
            boolean bl = okay = ensemble.dictionary().containsEntry("Shot", "Easting") && ensemble.dictionary().containsEntry("Shot", "Northing") && ensemble.dictionary().containsEntry("Receiver", "Easting") && ensemble.dictionary().containsEntry("Receiver", "Northing");
            if (!okay) {
                return;
            }
            int indexSX = ensemble.dictionary().getEntryIndex("Shot", "Easting");
            int indexSY = ensemble.dictionary().getEntryIndex("Shot", "Northing");
            int indexRX = ensemble.dictionary().getEntryIndex("Receiver", "Easting");
            int indexRY = ensemble.dictionary().getEntryIndex("Receiver", "Northing");
            for (int n = ensemble.traceCount() - 1; n >= 0; --n) {
                boolean ok;
                double ry;
                double dy;
                EnsembleTrace trace = ensemble.trace(n);
                double sx = trace.header().getDouble(indexSX);
                double sy = trace.header().getDouble(indexSY);
                double rx = trace.header().getDouble(indexRX);
                double dx = rx - sx;
                double off = Math.sqrt(1.0E-30 + dx * dx + (dy = (ry = trace.header().getDouble(indexRY)) - sy) * dy);
                boolean bl2 = ok = off >= this.MinOffset && off <= this.MaxOffset;
                if (ok) continue;
                ensemble.removeTrace(n);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void addMarineFileInfo(int shotLine, String fileName) {
        this.MarineFileList.add(new MarineFileInfo(shotLine, fileName));
    }

    protected void saveMarineFileList() {
        try {
            if (this.MarineFileList.size() < 1) {
                return;
            }
            String fileName = this.m_projectPath + "/MarineShotFile.txt";
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            for (MarineFileInfo m : this.MarineFileList) {
                String s = String.format("%d    %s", m.ShotLineNumber, m.FileName);
                writer.write(s);
                writer.newLine();
            }
            writer.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importFile_Compressed(ISeismicFile seismicFile, IProgressMonitor messageServer) {
        try {
            if (this.Halt) {
                return;
            }
            int segyRow = this.m_segyTable.row_increment();
            String sFilePath = seismicFile.getName();
            this.m_segyTable.putString(segyRow, this.m_segyIndex_Name, sFilePath);
            seismicFile.setDictionary(this.m_dict);
            seismicFile.clearImportLimitList();
            for (ImportLimit lim : this.ImportLimitList) {
                seismicFile.addImportLimit(lim);
            }
            Ensemble ensemble = new Ensemble();
            int startIndex = 0;
            int tracesPerChunk = 2000;
            long[] indices = new long[tracesPerChunk];
            Logger logger = Logger.getLogger("test");
            if (this.m_pc != null && this.IsMarine && this.MarineShotLineIncrement > 0) {
                this.addMarineFileInfo(this.MarineShotLineNumber, seismicFile.getName());
                this.m_pc.shotParser().DefaultLineNumber = this.MarineShotLineNumber;
                this.MarineShotLineNumber += this.MarineShotLineIncrement;
            }
            seismicFile.openPecosRAF();
            long nTraces = seismicFile.traceCount();
            while ((long)startIndex < nTraces && !this.Halt) {
                int numValidIndices = 0;
                for (int i = 0; i < indices.length; ++i) {
                    indices[i] = i + startIndex;
                    if (indices[i] >= nTraces) continue;
                    ++numValidIndices;
                }
                ensemble.clearTraces(false);
                seismicFile.populateEnsemble(ensemble, indices, indices.length, true, true);
                if (ensemble.traceCount() >= 1) {
                    int numRead = ensemble.traceCount();
                    if (this.m_pc == null) {
                        int inputSampleCount = ensemble.trace(0).data().length();
                        float inputSampleRate = ensemble.trace(0).data().getSampleInterval();
                        double diff = Math.abs(inputSampleRate - this.OutputSampleInterval);
                        this.RequireFilter = diff > (double)0.1f;
                        double nyquist = 500.0 / (double)this.OutputSampleInterval;
                        double cutoff = 0.6 * nyquist;
                        cutoff = Math.max(cutoff, 25.0);
                        cutoff = Math.min(cutoff, 80.0);
                        this.m_filterLP.parameterTree().int_put("Length", 41);
                        this.m_filterLP.parameterTree().int_put("PoleCount", 4);
                        this.m_filterLP.parameterTree().double_put("Frequency", cutoff);
                        String canonHome = SharedApplicationData.singleton().homeDirectory();
                        this.m_pc = new ProjectCreator(logger, canonHome, this.m_projectName, "SEGY", true, this.MaxTime, inputSampleCount, inputSampleRate, ensemble.dictionary(), this.m_units.equalsIgnoreCase("Meters"), this.m_dimension.equalsIgnoreCase("3D"), this.Resample, this.OutputSampleInterval);
                        if (this.IsMarine) {
                            this.m_pc.prepareReceiverMarineOptions(this.RecBinSize, this.MarineDecimation);
                            if (this.MarineShotLineIncrement > 0) {
                                this.MarineShotLineNumber = this.MarineShotLineIncrement;
                                this.m_pc.shotParser().ForceLineToBeDefault = true;
                                this.m_pc.shotParser().DefaultLineNumber = this.MarineShotLineNumber;
                                this.addMarineFileInfo(this.MarineShotLineNumber, seismicFile.getName());
                                this.MarineShotLineNumber += this.MarineShotLineIncrement;
                            }
                        }
                        if (this.CreateSparse) {
                            this.m_pc.prepareSparseCmpOptions(this.SparseSpacing, this.SparseRadius);
                        }
                        if (this.KillNoisy) {
                            this.m_pc.killNoisyTraces(this.NoiseWindow, this.NoiseCutoff);
                        }
                    }
                    if (this.KillOffsets) {
                        this.filterEnsemble(ensemble);
                    }
                    if (this.RequireFilter) {
                        this.m_filterLP.performWork(ensemble);
                    }
                    if (this.DecimateInput) {
                        ensemble.decimate(this.Decimation);
                    }
                    this.m_pc.mergeEnsemble(ensemble);
                }
                this.m_numRead += (long)numValidIndices;
                if (this.m_pc != null) {
                    String s = String.format("%d traces, %d shots, %d receivers", this.m_numRead, this.m_pc.shotTable().row_count(), this.m_pc.receiverTable().row_count());
                    messageServer.setMessage_Level1(s);
                    s = String.format("Number of geometry conflicts: %d shot, %d receiver", this.m_pc.shotParser().totalConflicts(), this.m_pc.receiverParser().totalConflicts());
                    messageServer.setMessage_Level2(s);
                }
                messageServer.setPercentDone(100.0 * (double)this.m_numRead / (double)this.m_totalTraces);
                startIndex += tracesPerChunk;
            }
            System.gc();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        finally {
            try {
                seismicFile.closePecosRAF();
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }
    }

    protected class MarineFileInfo {
        public int ShotLineNumber = 0;
        public String FileName = "";

        public MarineFileInfo(int shotLine, String fileName) {
            this.ShotLineNumber = shotLine;
            this.FileName = fileName;
        }
    }
}

